/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.servlet;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.TreeMap;
import net.reyadeyat.api.library.json.JsonUtil;

public abstract class TransactionServlet {
    protected final TreeMap<String, TreeMap<String, String>> i18n = new TreeMap();
    protected String server_name;
    protected boolean successfully_initialized = true;
    protected Throwable initialization_exception;

    public TransactionServlet(String server_name) {
        try {
            this.server_name = server_name;
            this.i18n.put("ar", new TreeMap());
            this.i18n.put("en", new TreeMap());
            this.initI18N();
        }
        catch (Exception ex) {
            this.successfully_initialized = false;
            this.initialization_exception = ex;
        }
    }

    protected void initI18N() {
    }

    protected boolean isValid(String[] parameter_list, HttpServletRequest req, JsonArray error_list) throws Exception {
        Boolean test = true;
        for (String parameter : parameter_list) {
            Part part_value;
            String paramerer_value = req.getParameter(parameter);
            if (paramerer_value != null || (part_value = req.getPart(parameter)) != null) continue;
            error_list.add("parameter '" + parameter + "' is null");
            test = false;
        }
        return test;
    }

    protected JsonObject createJsonResponseObject(Boolean success, Integer http_response_code, Integer service_response_code, String message) {
        return this.createJsonResponseObject(success, http_response_code, service_response_code, message, null);
    }

    protected JsonObject createJsonResponseObject(Boolean success, Integer http_response_code, Integer service_response_code, String message, JsonArray error_list) {
        JsonObject response = new JsonObject();
        response.addProperty("status", success == true ? "success" : "error");
        response.addProperty("http_response_code", (Number)http_response_code);
        response.addProperty("service_response_code", (Number)(service_response_code != 0 ? service_response_code : http_response_code));
        response.addProperty("message", message);
        if (error_list != null) {
            response.add("error_list", (JsonElement)error_list);
        }
        return response;
    }

    protected void sendReponse(HttpServletRequest req, HttpServletResponse resp, JsonObject response) throws Exception {
        Integer http_response_code = response.get("http_response_code").getAsInt();
        resp.setStatus(http_response_code.intValue());
        PrintWriter writer = resp.getWriter();
        Gson gson = JsonUtil.gson();
        gson.toJson((JsonElement)response, (Appendable)writer);
    }

    protected void saveUploadedFile(HttpServletRequest req, String file_parameter, String temp_file_path, String temp_file_name, StringBuilder uploadPath) throws Exception {
        String savePath = temp_file_path + temp_file_name;
        Part file_part = req.getPart(file_parameter);
        String fileName = Paths.get(file_part.getSubmittedFileName(), new String[0]).getFileName().toString();
        uploadPath.append("/").append(fileName);
        Files.copy(Paths.get(uploadPath.toString(), new String[0]), Paths.get(savePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    protected void uploadBinaryFile(HttpServletRequest resp, Part file_part, String save_file_path) throws Exception {
        int read = 0;
        byte[] bytes = new byte[1024];
        try (InputStream fileInputStream = file_part.getInputStream();
             BufferedOutputStream fbos = new BufferedOutputStream(new FileOutputStream(save_file_path));){
            while ((read = fileInputStream.read(bytes)) != -1) {
                fbos.write(bytes, 0, read);
            }
            fbos.close();
        }
    }

    protected File getUploadedFile(HttpServletRequest req, String file_parameter, StringBuilder uploadPath) throws Exception {
        Part file_part = req.getPart(file_parameter);
        String fileName = Paths.get(file_part.getSubmittedFileName(), new String[0]).getFileName().toString();
        uploadPath.append("/").append(fileName);
        return new File(uploadPath.toString());
    }

    protected Part getUploadedFilePart(HttpServletRequest req, String file_parameter) throws Exception {
        Part file_part = req.getPart(file_parameter);
        if (file_part == null) {
            return null;
        }
        return file_part;
    }

    protected InputStream getUploadedFilePartInputStream(HttpServletRequest req, String file_parameter_name) throws Exception {
        Part file_part = req.getPart(file_parameter_name);
        if (file_part == null) {
            return null;
        }
        return file_part.getInputStream();
    }

    protected byte[] getUploadedFileBuffer(HttpServletRequest req, String file_parameter) throws Exception {
        Part file_part = req.getPart(file_parameter);
        if (file_part == null) {
            return null;
        }
        int read = 0;
        byte[] bytes = null;
        try (InputStream ins = file_part.getInputStream();
             ByteArrayOutputStream baos = new ByteArrayOutputStream(0x100000);){
            bytes = new byte[1024];
            while ((read = ins.read(bytes)) != -1) {
                baos.write(bytes, 0, read);
            }
            bytes = baos.toByteArray();
        }
        return bytes;
    }

    protected String getUploadedFileString(HttpServletRequest req, String file_parameter) throws Exception {
        return new String(this.getUploadedFileBuffer(req, file_parameter), StandardCharsets.UTF_8);
    }

    protected ArrayList<Part> getUploadedPartFileList(HttpServletRequest req, String file_parameter) throws Exception {
        ArrayList<Part> file_part_list = new ArrayList<Part>();
        file_part_list.addAll(req.getParts());
        for (int i = file_part_list.size() - 1; i >= 0; --i) {
            Part part = file_part_list.get(i);
            if (part.getName().equalsIgnoreCase(file_parameter)) continue;
            file_part_list.remove(i);
        }
        return file_part_list;
    }

    protected void downloadTextFile(HttpServletResponse resp, String fileName, String fileContentType, String file_content) throws Exception {
        byte[] file_content_bytes = file_content.getBytes(StandardCharsets.UTF_8);
        resp.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        resp.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        resp.setContentType(fileContentType);
        resp.setContentLength(file_content_bytes.length);
        ServletOutputStream outStream = resp.getOutputStream();
        outStream.write(file_content_bytes);
    }

    protected void downloadBinaryFile(HttpServletResponse resp, String fileName, String fileContentType, ByteArrayOutputStream file_content) throws Exception {
        byte[] file_content_bytes = file_content.toByteArray();
        resp.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        resp.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        resp.setContentType(fileContentType);
        resp.setContentLength(file_content_bytes.length);
        ServletOutputStream outStream = resp.getOutputStream();
        outStream.write(file_content_bytes);
    }

    protected void downloadBinaryFileInline(HttpServletResponse resp, String fileName, String fileContentType, File download_file) throws Exception {
        this.downloadBinaryFile(resp, fileName, fileContentType, download_file, 1024, false, "inline");
    }

    protected void downloadBinaryFileAttachment(HttpServletResponse resp, String fileName, String fileContentType, File download_file) throws Exception {
        this.downloadBinaryFile(resp, fileName, fileContentType, download_file, 1024, false, "attachment");
    }

    protected void downloadBinaryFile(HttpServletResponse resp, String fileName, String fileContentType, File download_file, Integer buffer_size, Boolean stream, String download_type) throws Exception {
        if (!stream.booleanValue()) {
            resp.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            resp.setHeader("Content-Disposition", download_type + "; filename=\"" + fileName + "\";");
        }
        resp.setContentType(fileContentType);
        resp.setContentLengthLong(download_file.length());
        int read = 0;
        byte[] bytes = new byte[buffer_size.intValue()];
        try (BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(download_file));
             BufferedOutputStream fbos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
            while ((read = ((InputStream)fileInputStream).read(bytes)) != -1) {
                fbos.write(bytes, 0, read);
            }
            fbos.close();
        }
    }

    protected String readSFileIntoString(File file) throws Exception {
        return Files.readString(file.toPath());
    }

    protected String encodeFileIntoBase64(File file) throws Exception {
        byte[] file_content = Files.readAllBytes(file.toPath());
        return Base64.getEncoder().encodeToString(file_content);
    }

    protected void streamBinaryFileInline(HttpServletResponse resp, String fileName, String fileContentType, File download_file) throws Exception {
        this.downloadBinaryFile(resp, fileName, fileContentType, download_file, 1024, true, "inline");
    }

    protected void streamBinaryFileAttachment(HttpServletResponse resp, String fileName, String fileContentType, File download_file) throws Exception {
        this.downloadBinaryFile(resp, fileName, fileContentType, download_file, 1024, true, "attachment");
    }

    protected void streamBinaryFileInline(HttpServletResponse resp, String fileName, String fileContentType, File download_file, Integer buffer_size) throws Exception {
        this.downloadBinaryFile(resp, fileName, fileContentType, download_file, buffer_size, true, "inline");
    }

    protected void streamBinaryFileAttachment(HttpServletResponse resp, String fileName, String fileContentType, File download_file, Integer buffer_size) throws Exception {
        this.downloadBinaryFile(resp, fileName, fileContentType, download_file, buffer_size, true, "attachment");
    }

    protected String readFileUploadContent(HttpServletRequest req, String filePartName, StringBuilder file_content) throws Exception {
        return this.readFileUploadContent(req, filePartName, file_content, 1024);
    }

    protected String readFileUploadContent(HttpServletRequest req, String filePartName, StringBuilder file_content, Integer buffer_size) throws Exception {
        Part file_part = req.getPart(filePartName);
        String fileName = file_part.getSubmittedFileName();
        InputStream fileInputStream = file_part.getInputStream();
        int read = 0;
        byte[] bytes = new byte[buffer_size.intValue()];
        while ((read = fileInputStream.read(bytes)) != -1) {
            file_content.append(new String(bytes, 0, read, StandardCharsets.UTF_8));
        }
        return fileName;
    }
}

