/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.time;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class TimeChecker {
    private LocalDateTime currentDateTime;
    public String from_time;
    public String to_time;

    public TimeChecker(LocalDateTime currentDateTime, String from_time, String to_time) {
        this.currentDateTime = currentDateTime;
        this.from_time = from_time;
        this.to_time = to_time;
    }

    public int intime() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
        LocalDateTime fromTime = LocalDateTime.parse(String.valueOf(this.currentDateTime.toLocalDate()) + "T" + this.from_time, formatter);
        LocalDateTime toTime = LocalDateTime.parse(String.valueOf(this.currentDateTime.toLocalDate()) + "T" + this.to_time, formatter);
        Duration durationFrom = Duration.between(fromTime, this.currentDateTime);
        Duration durationTo = Duration.between(this.currentDateTime, toTime);
        if (durationFrom.isNegative()) {
            return -1;
        }
        if (durationTo.isPositive()) {
            return 0;
        }
        return 1;
    }

    public static void main(String[] args) {
        try {
            LocalDateTime now = LocalDateTime.now();
            TimeChecker timeChecker = new TimeChecker(now, "20:00", "20:30");
            int result = timeChecker.intime();
            System.out.println("Result: " + result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

