/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.tree;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericTreeModel {
    public JsonArray treeBalancer(Connection connection, String database_name, String database_table_name, String database_table_id_field_name, String database_table_parent_id_field_name, String selected_tree_key, JsonArray tree, JsonArray errors, Boolean update) throws Exception {
        return this.treeBalancer(connection, database_name, database_table_name, database_table_id_field_name, database_table_parent_id_field_name, selected_tree_key, tree, errors, update, null, null, false);
    }

    public JsonArray treeBalancer(Connection connection, String database_name, String database_table_name, String database_table_id_field_name, String database_table_parent_id_field_name, String selected_tree_key, JsonArray tree, JsonArray errors, Boolean update, JsonArray where) throws Exception {
        return this.treeBalancer(connection, database_name, database_table_name, database_table_id_field_name, database_table_parent_id_field_name, selected_tree_key, tree, errors, update, null, where, false);
    }

    public JsonArray treeBalancer(Connection connection, String database_name, String database_table_name, String database_table_id_field_name, String database_table_parent_id_field_name, String selected_tree_key, JsonArray tree, JsonArray errors, Boolean update, String[] extra_select_field_name_list) throws Exception {
        return this.treeBalancer(connection, database_name, database_table_name, database_table_id_field_name, database_table_parent_id_field_name, selected_tree_key, tree, errors, update, extra_select_field_name_list, null, false);
    }

    public JsonArray treeBalancer(Connection connection, String database_name, String database_table_name, String database_table_id_field_name, String database_table_parent_id_field_name, String selected_tree_key, JsonArray tree, JsonArray errors, Boolean update, String[] extra_select_field_name_list, JsonArray where, Boolean create_tree) throws Exception {
        JsonArray jsonArray;
        block45: {
            JsonObject tree_node_x = new JsonObject();
            JsonArray flat_tree = new JsonArray();
            HashMap<Integer, JsonObject> tree_map = new HashMap<Integer, JsonObject>();
            int nodes = 0;
            int affected_rows = 0;
            StringBuilder extra_select_field_list_builder = new StringBuilder();
            for (int i = 0; extra_select_field_name_list != null && i < extra_select_field_name_list.length; ++i) {
                extra_select_field_list_builder.append(",").append(extra_select_field_name_list[i].trim());
            }
            StringBuilder where_builder = new StringBuilder();
            for (int i = 0; where != null && i < where.size(); ++i) {
                JsonObject clause = where.get(i).getAsJsonObject();
                where_builder.append(" ").append(clause.get("condition").getAsString()).append(" ").append(clause.get("field").getAsString().trim()).append(" ").append(clause.get("comparison").getAsString()).append(" ").append(clause.get("value").getAsString().trim());
            }
            String select_tree_sql = "SELECT `" + database_table_id_field_name + "` AS `node_id`, `" + database_table_parent_id_field_name + "` AS `node_parent_id`, `node_order`, `tree_key`, `node_is_parental_node` " + extra_select_field_list_builder.toString() + " FROM `" + database_name + "`.`" + database_table_name + "` WHERE `tree_key`=? " + where_builder.toString() + " ORDER BY `node_level`, `node_order`";
            PreparedStatement tree_statement = connection.prepareStatement(select_tree_sql);
            try {
                tree_statement.setString(1, selected_tree_key);
                JsonArray resultset = new JsonArray();
                try (ResultSet rs = tree_statement.executeQuery();){
                    while (rs.next()) {
                        JsonObject node = new JsonObject();
                        Integer node_id = rs.getInt("node_id");
                        Object node_parent_id = rs.getObject("node_parent_id");
                        Boolean node_is_parental_node = rs.getBoolean("node_is_parental_node");
                        Integer node_order = rs.getInt("node_order");
                        String tree_key = rs.getString("tree_key");
                        node.addProperty("node_id", (Number)node_id);
                        node.addProperty("node_parent_id", node_parent_id == null ? null : Integer.valueOf(node_parent_id.toString()));
                        node.addProperty("node_is_parental_node", node_is_parental_node);
                        node.addProperty("node_order", (Number)node_order);
                        node.addProperty("tree_key", tree_key);
                        for (int i = 0; i < extra_select_field_name_list.length; ++i) {
                            String field = extra_select_field_name_list[i].trim();
                            node.addProperty(field, rs.getString(field));
                        }
                        node.add("children", (JsonElement)new JsonArray());
                        tree_map.put(node_id, node);
                    }
                }
                tree_statement.close();
                if (create_tree.booleanValue()) {
                    while (nodes != tree_map.size()) {
                        for (Map.Entry map_node : tree_map.entrySet()) {
                            node = (JsonObject)map_node.getValue();
                            String node_id = node.get("node_id").getAsString();
                            Integer node_parent_id = node.get("node_parent_id").isJsonNull() ? null : Integer.valueOf(node.get("node_parent_id").getAsInt());
                            JsonObject parent_node = (JsonObject)tree_map.get(node_parent_id);
                            if (node_parent_id != null && parent_node == null) {
                                throw new Exception("Parent Node ID '" + node_parent_id + "' is not exist on this tree '" + selected_tree_key + "'");
                            }
                            if (node_parent_id == null && !node.has("node_level")) {
                                ++nodes;
                                node.add("node_parent_id", (JsonElement)JsonNull.INSTANCE);
                                node.addProperty("node_level", (Number)0);
                                tree.add((JsonElement)node);
                                continue;
                            }
                            if (node_parent_id == null || !parent_node.has("node_level") || node.has("node_level")) continue;
                            ++nodes;
                            JsonArray parent_children = parent_node.get("children").getAsJsonArray();
                            Integer parent_id = parent_node.get("node_id").getAsInt();
                            Integer parent_level = parent_node.get("node_level").getAsInt();
                            Integer parent_children_count = parent_children.size();
                            node.addProperty("node_parent_id", (Number)parent_id);
                            node.addProperty("node_level", (Number)(parent_level + 1));
                            parent_children.add((JsonElement)node);
                        }
                    }
                } else {
                    for (Map.Entry map_node : tree_map.entrySet()) {
                        node = (JsonObject)map_node.getValue();
                        tree.add((JsonElement)node);
                    }
                }
                flat_tree = new JsonArray();
                ArrayList<Object> stack_list = new ArrayList<Object>();
                int node_sort_sequence = 0;
                for (int i = 0; i < tree.size(); ++i) {
                    JsonElement tree_node = tree.get(i);
                    stack_list.add(tree_node);
                    while (stack_list.size() > 0) {
                        JsonObject child_tree_node = ((JsonElement)stack_list.remove(0)).getAsJsonObject();
                        child_tree_node.addProperty("node_sort", (Number)(++node_sort_sequence));
                        flat_tree.add((JsonElement)child_tree_node);
                        JsonArray children = child_tree_node.get("children").getAsJsonArray();
                        if (children != null && children.size() > 0) {
                            child_tree_node.addProperty("node_children_count", (Number)children.size());
                            for (int c = children.size() - 1; c > -1; --c) {
                                JsonObject child = children.get(c).getAsJsonObject();
                                stack_list.add(0, child);
                            }
                            continue;
                        }
                        child_tree_node.addProperty("node_children_count", (Number)0);
                    }
                }
                if (update.booleanValue()) {
                    StringBuilder update_tree_sql = new StringBuilder("UPDATE `").append(database_name).append("`.`").append(database_table_name).append("` SET `node_level`=?, `node_sort`=?, `node_is_parental_node`=?, `node_children_count`=?, `tree_key`=? WHERE `node_id`=?");
                    try (PreparedStatement update_tree_statement = connection.prepareStatement(update_tree_sql.toString());){
                        for (int i = 0; i < flat_tree.size(); ++i) {
                            JsonObject node = flat_tree.get(i).getAsJsonObject();
                            Integer node_level = node.get("node_level").getAsInt();
                            Integer node_sort = node.get("node_sort").getAsInt();
                            String tree_key = node.get("tree_key").getAsString();
                            Integer node_id = node.get("node_id").getAsInt();
                            Boolean node_is_parental_node = node.get("node_is_parental_node").getAsBoolean();
                            Integer node_children_count = node.get("node_children_count").getAsInt();
                            update_tree_statement.setInt(1, node_level);
                            update_tree_statement.setInt(2, node_sort);
                            update_tree_statement.setBoolean(3, node_is_parental_node);
                            update_tree_statement.setInt(4, node_children_count);
                            update_tree_statement.setString(5, tree_key);
                            update_tree_statement.setInt(6, node_id);
                            update_tree_statement.addBatch();
                        }
                        int[] rows = update_tree_statement.executeBatch();
                        for (int i = 0; i < rows.length; ++i) {
                            affected_rows += rows[i];
                        }
                    }
                }
                jsonArray = flat_tree;
                if (tree_statement == null) break block45;
            }
            catch (Throwable throwable) {
                try {
                    if (tree_statement != null) {
                        try {
                            tree_statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception sqlx) {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, tree_node_x.toString() + "\n" + sqlx.getMessage(), sqlx);
                    throw sqlx;
                }
            }
            tree_statement.close();
        }
        return jsonArray;
    }
}

