/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.api.library.sequence.SequenceNumber;
import net.reyadeyat.api.relational.annotation.DontJsonAnnotation;
import net.reyadeyat.api.relational.annotation.MetadataAnnotation;
import net.reyadeyat.api.relational.annotation.MetadataAnnotationDefault;
import net.reyadeyat.api.relational.data.DataInstance;
import net.reyadeyat.api.relational.data.DataLookup;

public class DataClass {
    DataClass parent_data_class;
    String package_name;
    Boolean isTable;
    String name;
    String declared_name;
    String class_name;
    String canonical_path;
    Field field;
    Class clas;
    Class<?> type;
    MetadataAnnotation metadata_annotation;
    List<DataClass> member_list;
    List<DataClass> table_list;
    List<DataClass> field_list;
    Map<String, DataClass> member_list_map;
    Map<String, DataClass> table_list_map;
    Map<String, DataClass> field_list_map;
    DataLookup data_lookup;
    Boolean has_interface_implementation;
    Map<String, Class> interface_implementation;
    Boolean foreing_key_must_link_to_primary_key;

    public DataClass(DataClass parent_data_class, Field field, DataLookup data_lookup, Map<String, Class> interface_implementation, Boolean foreing_key_must_link_to_primary_key) throws Exception {
        this.field = field;
        this.data_lookup = data_lookup;
        this.interface_implementation = interface_implementation;
        this.canonical_path = this.parent_data_class == null ? this.name : this.parent_data_class.canonical_path + "." + this.name;
        this.parent_data_class = parent_data_class;
        this.foreing_key_must_link_to_primary_key = foreing_key_must_link_to_primary_key;
        this.member_list = new ArrayList<DataClass>();
        this.table_list = new ArrayList<DataClass>();
        this.field_list = new ArrayList<DataClass>();
        this.member_list_map = new HashMap<String, DataClass>();
        this.table_list_map = new HashMap<String, DataClass>();
        this.field_list_map = new HashMap<String, DataClass>();
        this.type = this.field.getType();
        this.field.setAccessible(true);
        List<Class<?>> class_list = DataClass.getGenericClasses(this.field);
        if (class_list.size() > 1) {
            throw new Exception("Multi Generic Type is not implemented yet");
        }
        Class interface_implementation_class = interface_implementation.get(this.type.getName());
        if (interface_implementation_class != null) {
            this.type = interface_implementation_class;
            this.clas = interface_implementation_class;
        } else {
            this.clas = class_list.get(0);
        }
        this.package_name = parent_data_class == null ? this.clas.getPackage().getName() : parent_data_class.package_name;
        this.metadata_annotation = this.field.getAnnotation(MetadataAnnotation.class);
        this.metadata_annotation = this.metadata_annotation != null ? this.metadata_annotation : new MetadataAnnotationDefault(this.name, DataClass.getCompatibleType(this.clas), this.clas.getTypeName(), "");
        this.has_interface_implementation = false;
        this.interface_implementation.forEach(new BiConsumer<String, Class>(){

            @Override
            public void accept(String interface_name, Class class_implementation) {
                DataClass.this.has_interface_implementation = DataClass.this.has_interface_implementation != false || DataClass.this.clas.getSimpleName().equals(class_implementation.getSimpleName());
            }
        });
        if (this.clas.getPackage().getName().startsWith(this.package_name) || this.metadata_annotation.table() || this.has_interface_implementation.booleanValue()) {
            this.isTable = true;
            this.name = this.metadata_annotation.table() && !this.metadata_annotation.title().isEmpty() ? this.metadata_annotation.title() : this.clas.getSimpleName();
        } else if (this.isAllowedType().booleanValue()) {
            this.isTable = false;
            this.name = this.field.getName();
        } else {
            throw new Exception("Data Package is '" + this.package_name + "'; can not traverse class " + this.clas.getSimpleName());
        }
        this.declared_name = field.getName();
        this.class_name = this.name;
        if (this.clas.getPackage().getName().startsWith(this.package_name) || this.metadata_annotation.table() || this.has_interface_implementation.booleanValue()) {
            ArrayList<Field> field_list = new ArrayList<Field>();
            this.getFields(this.clas, field_list);
            for (Field newDatafield : field_list) {
                DataClass newDataClass = new DataClass(this, newDatafield, this.data_lookup, this.interface_implementation, this.foreing_key_must_link_to_primary_key);
                this.member_list.add(newDataClass);
                this.member_list_map.put(newDataClass.name, newDataClass);
                if (newDataClass.isTable.booleanValue()) {
                    this.table_list.add(newDataClass);
                    this.table_list_map.put(newDataClass.name, newDataClass);
                    continue;
                }
                this.field_list.add(newDataClass);
                this.field_list_map.put(newDataClass.name, newDataClass);
            }
        }
    }

    private void getFields(Class clas, List<Field> field_list) {
        Field[] declaredfields;
        if (clas.getSuperclass() != null && !clas.getSuperclass().getName().equalsIgnoreCase("java.lang.Object")) {
            this.getFields(clas.getSuperclass(), field_list);
        }
        for (Field field : declaredfields = clas.getDeclaredFields()) {
            if (field.isAnnotationPresent(DontJsonAnnotation.class) && !field.getAnnotation(DontJsonAnnotation.class).dontJson() && Modifier.isTransient(field.getModifiers()) || !field.isAnnotationPresent(DontJsonAnnotation.class) && Modifier.isTransient(field.getModifiers())) continue;
            field_list.add(field);
        }
    }

    private DataClass() {
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        try {
            this.toString(appendable, 0, this);
            return appendable.toString();
        }
        catch (Exception exception) {
            appendable.delete(0, appendable.length());
            appendable.append("toString '").append(this.name).append("' error").append(exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
            return appendable.toString();
        }
    }

    public void toString(Appendable appendable) {
        try {
            appendable.append("DataClass [").append(this.name).append("]");
            this.toString(appendable, 0, this);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
        }
    }

    private void toString(Appendable appendable, Integer indentation, DataClass data_class) throws Exception {
        int i;
        for (i = 0; i < indentation; ++i) {
            appendable.append(" ");
        }
        if (data_class.isTable.booleanValue()) {
            appendable.append("~T-[").append(data_class.name).append("]\n");
        } else if (!data_class.isTable.booleanValue()) {
            appendable.append("~F-[").append(data_class.name).append("]\n");
        }
        for (i = 0; i < this.field_list.size(); ++i) {
            this.toString(appendable, indentation + 6, this.field_list.get(i));
        }
        for (i = 0; i < this.table_list.size(); ++i) {
            this.toString(appendable, indentation + 6, this.table_list.get(i));
        }
    }

    public boolean isNotNull() {
        return this.metadata_annotation != null && !this.metadata_annotation.nullable();
    }

    public Boolean hasParent() {
        return this.parent_data_class != null;
    }

    public String getParentName() {
        return this.parent_data_class.name;
    }

    public String getFieldType() throws Exception {
        return DataClass.getCompatibleType(this.clas);
    }

    private Boolean isList(Field field) throws Exception {
        return Arrays.asList(field.getType().getInterfaces()).contains(List.class);
    }

    private Boolean isArray(Field field) throws Exception {
        return field.getType().isArray();
    }

    private Boolean isAllowedType() {
        if (this.clas.getTypeName().equalsIgnoreCase("java.lang.String") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Boolean") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Byte") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Short") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Integer") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Long") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Float") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Double") || this.clas.getTypeName().equalsIgnoreCase("java.util.Date") || this.clas.getTypeName().equalsIgnoreCase("java.sql.String") || this.clas.getTypeName().equalsIgnoreCase("java.sql.Date") || this.clas.getTypeName().equalsIgnoreCase("java.sql.Time") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Timestamp") || this.clas.getTypeName().equalsIgnoreCase("java.time.ZonedDateTime")) {
            return true;
        }
        return false;
    }

    public static List<Class<?>> getGenericClasses(Field field) {
        ArrayList class_list = new ArrayList();
        if (field.getGenericType() instanceof ParameterizedType) {
            Type[] types;
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            for (Type type : types = genericType.getActualTypeArguments()) {
                class_list.add((Class)type);
            }
        } else if (field.getType().isArray()) {
            class_list.add(field.getType().getComponentType());
        } else {
            class_list.add(field.getType());
        }
        return class_list;
    }

    public static String getCompatibleType(Class clas) {
        if (clas.getTypeName().equalsIgnoreCase("java.lang.String")) {
            return "VARCHAR(256)";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Boolean")) {
            return "TINYINT";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Byte")) {
            return "TINYINT";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Short")) {
            return "SMALLINT";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Integer")) {
            return "INTEGER";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Long")) {
            return "BIGINT";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Float")) {
            return "FLOAT";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Double")) {
            return "DOUBLE";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.util.Date")) {
            return "DATE";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.sql.Date")) {
            return "DATE";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.sql.Time")) {
            return "TIME";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.sql.Timestamp")) {
            return "TIMESTAMP";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.time.ZonedDateTime")) {
            return "TIMESTAMP";
        }
        return "VARCHAR(256)";
    }

    private DataInstance createDataInstance(Object instanceObject, String databaseName) throws Exception {
        if (this.clas.equals(instanceObject.getClass())) {
            throw new Exception("object class does not equals to data class");
        }
        SequenceNumber sequenceNumber = new SequenceNumber((Number)1, (Number)1, Boolean.valueOf(false));
        DataInstance data_instance = new DataInstance(DataInstance.State.NEW, databaseName, this, null, null, instanceObject, sequenceNumber, true, this.foreing_key_must_link_to_primary_key);
        return data_instance;
    }

    public void createDatabaseSchema(Connection connection, String databaseName, DataClass data_class, ArrayList<String> dataClasses, ArrayList<String> creates) throws Exception {
        if (dataClasses.contains(data_class.clas.getCanonicalName())) {
            throw new Exception("Error: Polymorphic Associations Detected with class '" + data_class.clas.getCanonicalName() + "', use one to one class composition relation; refactor this class '" + data_class.clas.getCanonicalName() + "' name into 2 distinct names");
        }
        if (!data_class.isTable.booleanValue()) {
            throw new Exception("createDatabaseSchema takes table element only");
        }
        dataClasses.add(data_class.clas.getCanonicalName());
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE IF NOT EXISTS `").append(databaseName).append("`.`").append(data_class.declared_name).append("` (\n");
        sql.append(" ").append("`model_id` SMALLINT UNSIGNED NOT NULL,\n");
        sql.append(" ").append("`model_instance_id` BIGINT UNSIGNED NOT NULL,\n");
        sql.append(" ").append("`child_id` SMALLINT UNSIGNED NOT NULL,\n");
        sql.append(" ").append("`parent_id` SMALLINT UNSIGNED").append(data_class.hasParent() != false ? " NOT" : "").append(" NULL,\n");
        sql.append(" ").append("`declared_field_name` VARCHAR(256) NOT NULL,\n");
        sql.append(" ").append("`class_name` VARCHAR(256) NOT NULL,\n");
        sql.append(" ").append("`json_object` LONGTEXT NOT NULL,\n");
        StringBuilder indexes = new StringBuilder();
        for (DataClass dbField : data_class.field_list) {
            sql.append(" `").append(dbField.declared_name).append("` ").append(dbField.getFieldType());
            if (dbField.isNotNull()) {
                sql.append(" NOT NULL");
                if (dbField.metadata_annotation.indexed()) {
                    if (!dbField.metadata_annotation.indexed_expresion().isEmpty()) {
                        indexes.append("  INDEX `").append(dbField.declared_name).append("` " + dbField.metadata_annotation.indexed_expresion() + ",\n");
                    } else {
                        indexes.append("  INDEX(`").append(dbField.declared_name).append("`),\n");
                    }
                }
            }
            sql.append(",\n");
        }
        sql.append((CharSequence)indexes);
        sql.append("  PRIMARY KEY (`model_id`,`model_instance_id`,`child_id`").append(data_class.hasParent() != false ? ",`parent_id`" : "").append(")");
        sql.append(data_class.hasParent() != false ? "," : "").append("\n");
        if (data_class.hasParent().booleanValue()) {
            sql.append("  FOREIGN KEY `fk_").append(data_class.parent_data_class.declared_name).append("` (`model_id`,`model_instance_id`,`parent_id`)\n");
            sql.append("    REFERENCES `").append(data_class.parent_data_class.declared_name).append("` (`model_id`,`model_instance_id`,`child_id`)\n");
            sql.append("    ON UPDATE CASCADE\n");
            sql.append("    ON DELETE RESTRICT\n");
        }
        sql.append(") ENGINE=InnoDB CHARACTER SET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;");
        creates.add(sql.toString());
        for (DataClass dbTable : data_class.table_list) {
            this.createDatabaseSchema(connection, databaseName, dbTable, dataClasses, creates);
        }
    }

    public Object loadFromDatabase(Connection modelConnection, Integer model_id, String databaseName, DataLookup dataLookup, Object model_instance_id, LoadMethod loadMethod, SequenceNumber sequence, ArrayList<String> selects) throws Exception {
        Object instanceObject = null;
        DataInstance data_instance = null;
        data_instance = this.loadFromDatabase(modelConnection, model_id, databaseName, dataLookup, model_instance_id, loadMethod, selects, data_instance, instanceObject, 1, sequence);
        return data_instance.instances.get(0);
    }

    private DataInstance loadFromDatabase(Connection connection, Integer model_id, String databaseName, DataLookup dataLookup, Object model_instance_id, LoadMethod loadMethod, ArrayList<String> selects, DataInstance parentDataInstance, Object parentInstanceObject, Integer parentID, SequenceNumber sequence) throws Exception {
        int i;
        HashMap record;
        if (loadMethod != LoadMethod.JSON && loadMethod != LoadMethod.REFLECTION) {
            throw new Exception("Load Method '" + String.valueOf((Object)loadMethod) + "' is not implemented");
        }
        if (!this.isTable.booleanValue()) {
            throw new Exception("Can't Load DataClass Field '~F-[" + this.name + "]', load only DataClass Table");
        }
        String sql = this.loadFromDatabase(model_id, databaseName, dataLookup, model_instance_id, loadMethod, parentID);
        selects.add(sql);
        ArrayList<HashMap> dataset = new ArrayList<HashMap>();
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                record = new HashMap();
                if (loadMethod == LoadMethod.JSON) {
                    record.put("model_instance_id", rs.getLong("model_instance_id"));
                    record.put("child_id", rs.getInt("child_id"));
                    record.put("parent_id", rs.getInt("parent_id"));
                    record.put("json_object", rs.getString("json_object").replaceAll("\"\"", "\""));
                } else if (loadMethod == LoadMethod.REFLECTION) {
                    record.put("model_instance_id", rs.getLong("model_instance_id"));
                    record.put("child_id", rs.getInt("child_id"));
                    record.put("parent_id", rs.getInt("parent_id"));
                    record.put("declared_field_name", rs.getString("declared_field_name"));
                    record.put("class_name", rs.getString("class_name"));
                    for (i = 0; i < this.field_list.size(); ++i) {
                        DataClass sc = this.field_list.get(i);
                        if (sc.clas.getCanonicalName().equalsIgnoreCase("java.lang.Boolean")) {
                            record.put(sc.declared_name, rs.getBoolean(sc.declared_name));
                            continue;
                        }
                        record.put(sc.declared_name, rs.getObject(sc.declared_name));
                    }
                }
                dataset.add(record);
            }
        }
        DataInstance newDataInstance = null;
        if (loadMethod == LoadMethod.JSON) {
            for (int i2 = 0; i2 < dataset.size(); ++i2) {
                record = (HashMap)dataset.get(i2);
                Long instance_id = (Long)record.get("model_instance_id");
                Integer child_id = (Integer)record.get("child_id");
                Integer parent_id = (Integer)record.get("parent_id");
                String json_object = (String)record.get("json_object");
                Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
                Object instanceObject = gson.fromJson(json_object, this.clas);
                newDataInstance = new DataInstance(DataInstance.State.LOADED, databaseName, this, parentDataInstance, parentInstanceObject, instanceObject, sequence, true, this.foreing_key_must_link_to_primary_key);
            }
        } else if (loadMethod == LoadMethod.REFLECTION) {
            Object instance_object = null;
            instance_object = this.type.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (parentInstanceObject != null) {
                this.field.set(parentInstanceObject, instance_object);
            }
            DataInstance recordDataInstance = null;
            recordDataInstance = parentInstanceObject == null ? new DataInstance(DataInstance.State.LOADED, databaseName, this, parentDataInstance, parentInstanceObject, this.clas.getConstructor(new Class[0]).newInstance(new Object[0]), sequence, false, this.foreing_key_must_link_to_primary_key) : new DataInstance(DataInstance.State.LOADED, databaseName, this, parentDataInstance, parentInstanceObject, instance_object, sequence, false, this.foreing_key_must_link_to_primary_key);
            recordDataInstance.parent_id = parentID;
            for (i = 0; i < dataset.size(); ++i) {
                HashMap record2 = (HashMap)dataset.get(i);
                Long instance_id = (Long)record2.get("model_instance_id");
                Integer child_id = (Integer)record2.get("child_id");
                Integer parent_id = (Integer)record2.get("parent_id");
                String declared_field_name = (String)record2.get("declared_field_name");
                String class_name = (String)record2.get("class_name");
                Object recordInstanceObject = null;
                if (parentInstanceObject == null) {
                    recordInstanceObject = recordDataInstance.getInstanceObject();
                } else if (instance_object instanceof ArrayList) {
                    recordInstanceObject = this.clas.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Method add = ArrayList.class.getDeclaredMethod("add", Object.class);
                    add.invoke(instance_object, recordInstanceObject);
                } else if (this.has_interface_implementation.booleanValue()) {
                    recordInstanceObject = this.clas.getConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    throw new Exception("Undefined Data Instance Load Behaviour.");
                }
                recordDataInstance.addInstanceObject(recordInstanceObject, child_id);
                for (int y = 0; y < this.field_list.size(); ++y) {
                    DataClass fieldDataClass = this.field_list.get(y);
                    Object fieldInstanceObject = null;
                    if (fieldDataClass.metadata_annotation.lookup()) {
                        fieldInstanceObject = this.data_lookup.lookupCode(Integer.valueOf((String)record2.get(fieldDataClass.declared_name)));
                        fieldDataClass.field.set(recordInstanceObject, fieldInstanceObject);
                    } else if (fieldDataClass.clas.getCanonicalName().equalsIgnoreCase("java.lang.Boolean")) {
                        fieldInstanceObject = (Boolean)record2.get(fieldDataClass.declared_name);
                        fieldDataClass.field.set(recordInstanceObject, fieldInstanceObject);
                    } else {
                        fieldInstanceObject = record2.get(fieldDataClass.declared_name);
                        fieldDataClass.field.set(recordInstanceObject, fieldInstanceObject);
                    }
                    recordDataInstance.addChildInstanceObject(DataInstance.State.LOADED, fieldDataClass, recordInstanceObject, fieldInstanceObject, sequence, false, this.foreing_key_must_link_to_primary_key);
                }
                for (int x = 0; x < this.table_list.size(); ++x) {
                    DataClass subRecordDataClass = this.table_list.get(x);
                    subRecordDataClass.loadFromDatabase(connection, model_id, databaseName, dataLookup, model_instance_id, loadMethod, selects, recordDataInstance, recordInstanceObject, child_id, sequence);
                }
            }
            newDataInstance = recordDataInstance;
        }
        return newDataInstance;
    }

    private String loadFromDatabase(Integer model_id, String databaseName, DataLookup dataLookup, Object model_instance_id, LoadMethod loadMethod, Integer parentID) throws Exception {
        if (!this.isTable.booleanValue()) {
            throw new Exception("toSQL takes table element only");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT");
        if (loadMethod == LoadMethod.JSON) {
            sql.append(" `").append(this.declared_name).append("`.`model_instance_id`,`").append(this.declared_name).append("`.`child_id`,`").append(this.declared_name).append("`.`parent_id`,`").append(this.declared_name).append("`.`declared_field_name`,`").append(this.declared_name).append("`.`class_name`,`").append(this.declared_name).append("`.`json_object`");
        } else if (loadMethod == LoadMethod.REFLECTION) {
            sql.append(" `").append(this.declared_name).append("`.`model_instance_id`,`").append(this.declared_name).append("`.`child_id`,`").append(this.declared_name).append("`.`parent_id`,`").append(this.declared_name).append("`.`declared_field_name`,`").append(this.declared_name).append("`.`class_name`,");
            for (int i = 0; i < this.field_list.size(); ++i) {
                DataClass fieldDataClass = this.field_list.get(i);
                sql.append("`").append(this.declared_name).append("`.`").append(fieldDataClass.declared_name).append("`,");
            }
            sql.delete(sql.length() - 1, sql.length());
        }
        sql.append(" FROM `").append(databaseName).append("`.`").append(this.declared_name).append("`");
        if (this.parent_data_class != null) {
            sql.append(" INNER JOIN `").append(databaseName).append("`.`").append(this.parent_data_class.declared_name).append("`");
            sql.append(" ON `").append(this.declared_name).append("`.`model_id`=`").append(this.parent_data_class.declared_name).append("`.`model_id`");
            sql.append(" AND `").append(this.declared_name).append("`.`model_instance_id`=`").append(this.parent_data_class.declared_name).append("`.`model_instance_id`");
            sql.append(" AND `").append(this.declared_name).append("`.`parent_id`=`").append(this.parent_data_class.declared_name).append("`.`child_id`");
        }
        sql.append(" WHERE `").append(this.declared_name).append("`.`model_id`=").append(model_id);
        sql.append(" AND `").append(this.declared_name).append("`.`model_instance_id`=");
        if (model_instance_id instanceof Number) {
            sql.append(model_instance_id);
        } else if (model_instance_id instanceof String) {
            sql.append("'").append(model_instance_id).append("'");
        }
        if (this.parent_data_class != null) {
            sql.append(" AND `").append(this.declared_name).append("`.`parent_id`=").append(parentID);
        }
        return sql.toString();
    }

    public static enum LoadMethod {
        JSON,
        REFLECTION;

    }
}

