/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.data;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.TreeMap;
import net.reyadeyat.api.relational.data.DataStructure;

public class DataLookup {
    private TreeMap<String, HashMap<String, DataStructure>> lookupCode = new TreeMap();
    private TreeMap<String, HashMap<Integer, DataStructure>> lookupID = new TreeMap();
    private String data_lookup_category;

    public DataLookup(ResultSet resultSet, String data_lookup_category, String categoryFieldName, String idFieldName, String codeFieldName, String javaFieldName, String typescriptFieldName) throws Exception {
        this.data_lookup_category = data_lookup_category;
        HashMap<String, DataStructure> codeMap = null;
        HashMap<Integer, DataStructure> idMap = null;
        String currentCategory = "";
        while (resultSet.next()) {
            String category = resultSet.getString(categoryFieldName);
            if (!currentCategory.equalsIgnoreCase(category)) {
                if (!currentCategory.isEmpty()) {
                    this.lookupCode.put(currentCategory, codeMap);
                    this.lookupID.put(currentCategory, idMap);
                }
                currentCategory = category;
                codeMap = new HashMap<String, DataStructure>();
                idMap = new HashMap<Integer, DataStructure>();
            }
            Integer id = resultSet.getInt(idFieldName);
            String code = resultSet.getString(codeFieldName);
            String java_datatype = resultSet.getString(javaFieldName);
            String typescript_datatype = resultSet.getString(typescriptFieldName);
            DataStructure data_type = new DataStructure(id, code, java_datatype, typescript_datatype);
            codeMap.put(code.toLowerCase(), data_type);
            idMap.put(id, data_type);
        }
        this.lookupCode.put(currentCategory, codeMap);
        this.lookupID.put(currentCategory, idMap);
    }

    public Integer lookupID(String code) throws Exception {
        if (this.lookupCode.get(this.data_lookup_category) == null) {
            throw new Exception("lookupID: Category '" + this.data_lookup_category + "' is not loaded in enum lookup for code '" + code + "'");
        }
        DataStructure data_structure = this.lookupCode.get(this.data_lookup_category).get(code.toLowerCase());
        if (data_structure == null) {
            throw new Exception("lookupJavaDataType: Category '" + this.data_lookup_category + "' doesn't have enum lookup code '" + code + "'");
        }
        return data_structure.getID();
    }

    public String lookupCode(Integer id) throws Exception {
        if (this.lookupCode.get(this.data_lookup_category) == null) {
            throw new Exception("lookupCode: Category '" + this.data_lookup_category + "' is not loaded in enum lookup for id '" + id + "'");
        }
        DataStructure data_structure = this.lookupID.get(this.data_lookup_category).get(id);
        if (data_structure == null) {
            throw new Exception("lookupCode: Category '" + this.data_lookup_category + "' doesn't have enum lookup id '" + id + "'");
        }
        return data_structure.getCode();
    }

    public String lookupJavaDataType(Integer id) throws Exception {
        if (this.lookupCode.get(this.data_lookup_category) == null) {
            throw new Exception("lookupJavaDataType: Category '" + this.data_lookup_category + "' is not loaded in enum lookup for id '" + id + "'");
        }
        DataStructure data_structure = this.lookupID.get(this.data_lookup_category).get(id);
        if (data_structure == null) {
            throw new Exception("lookupJavaDataType: Category '" + this.data_lookup_category + "' doesn't have enum lookup id '" + id + "'");
        }
        return data_structure.getJavaDataType();
    }

    public String lookupJavaDataType(String code) throws Exception {
        if (this.lookupCode.get(this.data_lookup_category) == null) {
            throw new Exception("lookupJavaDataType: Category '" + this.data_lookup_category + "' is not loaded in enum lookup for code '" + code + "'");
        }
        DataStructure data_structure = this.lookupCode.get(this.data_lookup_category).get(code.toLowerCase());
        if (data_structure == null) {
            throw new Exception("lookupJavaDataType: Category '" + this.data_lookup_category + "' doesn't have enum lookup code '" + code + "'");
        }
        return data_structure.getJavaDataType();
    }

    public String lookupTypescriptDataType(Integer id) throws Exception {
        if (this.lookupCode.get(this.data_lookup_category) == null) {
            throw new Exception("lookupTypescriptDataType: Category '" + this.data_lookup_category + "' is not loaded in enum lookup for id '" + id + "'");
        }
        DataStructure data_structure = this.lookupID.get(this.data_lookup_category).get(id);
        if (data_structure == null) {
            throw new Exception("lookupTypescriptDataType: Category '" + this.data_lookup_category + "' doesn't have enum lookup id '" + id + "'");
        }
        return data_structure.getTypescriptDataType();
    }

    public String lookupTypescriptDataType(String code) throws Exception {
        if (this.lookupCode.get(this.data_lookup_category) == null) {
            throw new Exception("lookupTypescriptDataType: Category '" + this.data_lookup_category + "' is not loaded in enum lookup for code '" + code + "'");
        }
        DataStructure data_structure = this.lookupCode.get(this.data_lookup_category).get(code.toLowerCase());
        if (data_structure == null) {
            throw new Exception("lookupTypescriptDataType: Category '" + this.data_lookup_category + "' doesn't have enum lookup code '" + code + "'");
        }
        return data_structure.getTypescriptDataType();
    }

    public String getDataLookupCategory() {
        return this.data_lookup_category;
    }
}

