/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.data;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.api.library.jdbc.JDBCSource;
import net.reyadeyat.api.library.json.JsonZonedDateTimeAdapter;
import net.reyadeyat.api.library.sequence.SequenceNumber;
import net.reyadeyat.api.relational.data.DataClass;
import net.reyadeyat.api.relational.data.DataInstance;
import net.reyadeyat.api.relational.data.DataLookup;
import net.reyadeyat.api.relational.data.DataModel;
import net.reyadeyat.api.relational.data.ModelDefinition;

public class DataProcessor<Model> {
    Class data_model_class;
    Class model_class;
    DataModel<Model> data_model;
    JDBCSource model_jdbc_source;
    ModelDefinition model_definition;
    DataLookup data_lookup;
    DataClass data_class;
    Map<DataModel<Model>, DataInstance> dataModelDataInstanceMap;
    Map<String, Class> interface_implementation;
    Boolean foreing_key_must_link_to_primary_key;
    public static final JsonZonedDateTimeAdapter zonedDateTimeAdapter = new JsonZonedDateTimeAdapter();

    public DataProcessor(Class data_model_class, Class model_class, JDBCSource model_jdbc_source, ModelDefinition model_definition, DataLookup data_lookup, Map<String, Class> interface_implementation, Boolean foreing_key_must_link_to_primary_key) throws Exception {
        this.data_model_class = data_model_class;
        this.model_class = model_class;
        this.model_jdbc_source = model_jdbc_source;
        this.model_definition = model_definition;
        this.data_lookup = data_lookup;
        this.interface_implementation = interface_implementation;
        this.foreing_key_must_link_to_primary_key = foreing_key_must_link_to_primary_key;
        Boolean foundDataModelInterface = false;
        for (Class<?> intrface : this.data_model_class.getInterfaces()) {
            if (!intrface.getCanonicalName().equalsIgnoreCase(DataModel.class.getCanonicalName())) continue;
            foundDataModelInterface = true;
        }
        if (!foundDataModelInterface.booleanValue()) {
            throw new Exception("data_model_class class must implement DataModel class");
        }
        this.data_model = (DataModel)this.data_model_class.getConstructor(model_class, ModelDefinition.class).newInstance(null, model_definition);
        Method methodGetDeclaredField = this.data_model_class.getDeclaredMethod("getDeclaredField", new Class[0]);
        Field modelDeclaredField = (Field)methodGetDeclaredField.invoke(this.data_model, new Object[0]);
        if (!model_class.getCanonicalName().equals(modelDeclaredField.getType().getCanonicalName())) {
            throw new Exception("data_model_class '" + data_model_class.getCanonicalName() + "' declared model field '" + modelDeclaredField.getName() + "' is of type class '" + modelDeclaredField.getType().getCanonicalName() + "' that is not same as model_class '" + model_class.getCanonicalName() + "'");
        }
        this.data_class = new DataClass(null, modelDeclaredField, this.data_lookup, this.interface_implementation, this.foreing_key_must_link_to_primary_key);
        this.dataModelDataInstanceMap = new HashMap<DataModel<Model>, DataInstance>();
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        try {
            this.toString(appendable);
            return appendable.toString();
        }
        catch (Exception exception) {
            appendable.delete(0, appendable.length());
            appendable.append("toString '").append(this.data_model.getModelDefinition().model_name).append("-").append(this.data_model.getModelDefinition().model_name).append("' error").append(exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
            return appendable.toString();
        }
    }

    public void toString(Appendable appendable) throws Exception {
        appendable.append("Model: ").append(this.data_model.getModelDefinition().model_name).append("\n");
        try {
            for (DataModel<Model> tempDataModel : this.dataModelDataInstanceMap.keySet()) {
                DataInstance data_instance = this.dataModelDataInstanceMap.get(tempDataModel);
                appendable.append(data_instance.toString());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void toString(Appendable appendable, DataModel<Model> data_model) throws Exception {
        if (!this.data_class.clas.getCanonicalName().equalsIgnoreCase(data_model.getInstance().getClass().getCanonicalName())) {
            throw new Exception("Required model of type '" + this.data_class.clas.getCanonicalName() + "' while found model of type '" + data_model.getInstance().getClass().getCanonicalName() + "'");
        }
        appendable.append("Model: ");
        appendable.append(this.data_model.getModelDefinition().model_name);
        appendable.append("\n");
        SequenceNumber sequenceNumber = new SequenceNumber((Number)0, (Number)1, Boolean.valueOf(false));
        DataInstance data_instance = new DataInstance(DataInstance.State.NEW, data_model.getModelDefinition().modeled_database_name, this.data_class, null, null, data_model.getInstance(), sequenceNumber, true, this.foreing_key_must_link_to_primary_key);
        data_instance.toString(appendable);
    }

    public Integer selectModelIdFromDatabase(String modeled_database_name) throws Exception {
        Integer modelId = -1;
        String select_model_sql = "SELECT `id` FROM `model`.`model` WHERE `model`.`version`=? AND `model`.`database_name`=? AND `model`.`name`=? AND `model`.`root_class_path`=?";
        try (Connection data_connection = this.model_jdbc_source.getConnection(Boolean.valueOf(false));
             PreparedStatement data_stmt = data_connection.prepareStatement(select_model_sql);){
            data_stmt.setString(1, this.model_definition.model_version);
            data_stmt.setString(2, modeled_database_name);
            data_stmt.setString(3, this.model_definition.model_name);
            data_stmt.setString(4, this.data_class.clas.getCanonicalName());
            try (ResultSet modelResultset = data_stmt.executeQuery();){
                if (modelResultset.next()) {
                    modelId = modelResultset.getInt("id");
                }
                data_stmt.close();
            }
        }
        return modelId;
    }

    public ArrayList<Integer> selectModelInstanceIDsFromDatabase(String modeled_database_name) throws Exception {
        return this.selectModelInstanceIDsFromDatabase(modeled_database_name, null, null);
    }

    public ArrayList<Integer> selectModelInstanceIDsFromDatabase(String modeled_database_name, Integer fromId, Integer toId) throws Exception {
        ArrayList<Integer> modelInstanceIds = new ArrayList<Integer>();
        String select_model_sql = "SELECT `model_instance_id`, `model_instance_extra_info` FROM `model`.`model` INNER JOIN `model`.`model_instance` ON `model`.`model`.`model_id`=`model`.`model_instance`.`model_id` WHERE `model`.`model_version`=? AND `model`.`modeled_database_name`=? AND `model`.`model_name`=? AND `model`.`model_class_path`=? " + (fromId == null || toId == null ? "" : " AND `model_instance`.`model_instance_id` BETWEEN ? AND ?");
        try (Connection data_connection = this.model_jdbc_source.getConnection(Boolean.valueOf(false));
             PreparedStatement data_stmt = data_connection.prepareStatement(select_model_sql);){
            data_stmt.setString(1, this.model_definition.model_version);
            data_stmt.setString(2, modeled_database_name);
            data_stmt.setString(3, this.model_definition.model_name);
            data_stmt.setString(4, this.data_class.clas.getCanonicalName());
            if (fromId != null && toId != null) {
                data_stmt.setInt(5, fromId);
                data_stmt.setInt(6, toId);
            }
            try (ResultSet modelResultset = data_stmt.executeQuery();){
                while (modelResultset.next()) {
                    modelInstanceIds.add(modelResultset.getInt("model_instance_id"));
                }
                data_stmt.close();
            }
        }
        return modelInstanceIds;
    }

    public Integer generateModel(JDBCSource model_jdbc_source, JDBCSource data_jdbc_source, Integer model_id, Integer instance_sequence_type_id, String instance_sequence_last_value, String secret_key, String modeled_table_data_structures_class) throws Exception {
        ArrayList<String> creates = new ArrayList<String>();
        ArrayList<String> dataClasses = new ArrayList<String>();
        try (Connection data_model_connection = model_jdbc_source.getConnection(Boolean.valueOf(false));){
            this.data_class.createDatabaseSchema(data_model_connection, model_jdbc_source.getDatabaseName(), this.data_class, dataClasses, creates);
            String insert_model_sql = "INSERT INTO `model`.`model`(`model_id`, `model_instance_sequence_type_id`, `model_instance_sequence_last_value`, `model_name`, `model_version`, `model_class_path`, `model_data_lookup_category`, `modeled_database_url`, `modeled_database_url_user_name`, `modeled_database_url_user_password`, `modeled_database_schem`, `modeled_database_name`, `modeled_database_field_open_quote`, `modeled_database_field_close_quote`, `modeled_table_data_structures_class`) VALUES (?,?,?,?,?,?,?,?,?,TO_BASE64(AES_ENCRYPT(?, '" + secret_key + "')),?,?,?,?,?)";
            try (PreparedStatement data_stmt = data_model_connection.prepareStatement(insert_model_sql, 1);){
                data_stmt.setObject(1, model_id == -1 || model_id == null ? null : model_id);
                data_stmt.setObject(2, instance_sequence_type_id);
                data_stmt.setObject(3, instance_sequence_last_value);
                data_stmt.setObject(4, this.model_definition.model_name);
                data_stmt.setObject(5, this.model_definition.model_version);
                data_stmt.setObject(6, this.data_class.clas.getCanonicalName());
                data_stmt.setObject(7, this.model_definition.model_data_lookup_category);
                data_stmt.setObject(8, data_jdbc_source.getURL());
                data_stmt.setObject(9, data_jdbc_source.getUserName());
                data_stmt.setObject(10, data_jdbc_source.getUserPassword());
                data_stmt.setObject(11, data_jdbc_source.getDatabaseSchema() == null ? "" : model_jdbc_source.getDatabaseSchema());
                data_stmt.setObject(12, data_jdbc_source.getDatabaseName());
                data_stmt.setObject(13, data_jdbc_source.getDatabaseOpenQuote());
                data_stmt.setObject(14, data_jdbc_source.getDatabaseCloseQuote());
                data_stmt.setObject(15, modeled_table_data_structures_class);
                data_stmt.executeUpdate();
                StringBuilder b = new StringBuilder();
                try (Statement modelStatement = data_model_connection.createStatement();){
                    for (int i = 0; i < creates.size(); ++i) {
                        modelStatement.addBatch(creates.get(i));
                        b.append(creates.get(i)).append("\n");
                    }
                    int[] rows = modelStatement.executeBatch();
                    if (rows == null || rows.length > 0) {
                        // empty if block
                    }
                    if (!data_model_connection.getAutoCommit()) {
                        data_model_connection.commit();
                    }
                    modelStatement.close();
                }
                catch (Exception sqlx) {
                    b.insert(0, "create database sql statements carshed :\n");
                    System.out.println(b.toString());
                    if (!data_model_connection.getAutoCommit()) {
                        data_model_connection.rollback();
                    }
                    throw sqlx;
                }
                if (!data_model_connection.isClosed() && !data_model_connection.getAutoCommit()) {
                    data_model_connection.commit();
                }
                if (!data_stmt.isClosed()) {
                    data_stmt.close();
                }
            }
            catch (Exception sqlx) {
                if (!data_model_connection.isClosed() && !data_model_connection.getAutoCommit()) {
                    data_model_connection.rollback();
                }
                throw sqlx;
            }
        }
        return model_id;
    }

    public synchronized DataModel<Model> saveModelToDatabase(Appendable appendable, JDBCSource data_jdbc_source, DataModel<Model> data_model, String database_field_open_quote, String database_field_close_quote) throws Exception {
        Integer instanceID = null;
        Exception exception = null;
        appendable = appendable == null ? new PrintWriter(Writer.nullWriter()) : appendable;
        try (Connection locked_data_model_connection = this.model_jdbc_source.getConnection(Boolean.valueOf(false));){
            String lockTables = "LOCK TABLE `model` WRITE, `sequence_type` WRITE, `model_sequence` WRITE, `model_instance` WRITE";
            try (Statement lockStatement = locked_data_model_connection.createStatement();){
                lockStatement.execute(lockTables);
            }
            String select_model_sql = "SELECT `model`.`model_id` AS `model_id`, `model_instance_sequence_type_id`, `model_instance_sequence_last_value`, `sequence_type`.`sequence_type_name`, `sequence_type`.`sequence_type`, `sequence_type`.`sequence_type_ordered_chars`, `sequence_type`.`sequence_type_chars_width`, `sequence_type`.`sequence_type_padding_char`, `sequence_type`.`sequence_type_rewind`, `sequence_type`.`sequence_type_initial_value`, `sequence_type`.`sequence_type_increment_value` FROM `model`.`model` INNER JOIN `model`.`sequence_type` ON `model`.`model_instance_sequence_type_id`=`sequence_type`.`sequence_type_id` WHERE `model`.`model_version`=? AND `model`.`modeled_database_name`=? AND `model`.`model_name`=? AND `model`.`model_class_path`=?";
            try (PreparedStatement data_stmt = locked_data_model_connection.prepareStatement(select_model_sql);){
                data_stmt.setString(1, this.model_definition.model_version);
                data_stmt.setString(2, data_jdbc_source.getDatabaseName());
                data_stmt.setString(3, this.model_definition.model_name);
                data_stmt.setString(4, this.data_class.clas.getCanonicalName());
                try (ResultSet data_model_resultset = data_stmt.executeQuery();){
                    if (!data_model_resultset.next()) {
                        throw new Exception("DataModel '" + this.data_model_class.getCanonicalName() + "' is not defined in Data.DataModel Table");
                    }
                    Integer dataModelId = data_model_resultset.getInt("model_id");
                    String sequence_type = data_model_resultset.getString("sequence_type");
                    Integer instance_last_value = data_model_resultset.getInt("model_instance_sequence_last_value");
                    Integer sequence_initial_value = data_model_resultset.getInt("sequence_type_initial_value");
                    Integer sequence_increment_value = data_model_resultset.getInt("sequence_type_increment_value");
                    if (!sequence_type.equalsIgnoreCase("Integer")) {
                        throw new Exception("Sequence Type must be 'Integer' type");
                    }
                    Model instanceObject = data_model.getInstance();
                    SequenceNumber sequenceNumber = new SequenceNumber((Number)sequence_initial_value, (Number)sequence_increment_value, Boolean.valueOf(false));
                    sequenceNumber.initSequence(this.data_class.clas, (Number)instance_last_value);
                    DataInstance data_instance = new DataInstance(DataInstance.State.NEW, this.model_jdbc_source.getDatabaseName(), this.data_class, null, null, instanceObject, sequenceNumber, true, this.foreing_key_must_link_to_primary_key);
                    instanceID = (Integer)sequenceNumber.getSequenceState(this.data_class.clas);
                    String update_model_sql = "UPDATE `model`.`model` SET `model_instance_sequence_last_value` = ? WHERE `model_id` = ?";
                    try (PreparedStatement modelUpdateStatement = locked_data_model_connection.prepareStatement(update_model_sql);){
                        modelUpdateStatement.setInt(1, instanceID);
                        modelUpdateStatement.setInt(2, dataModelId);
                        int rows = modelUpdateStatement.executeUpdate();
                        if (rows == 0) {
                            throw new Exception("Can not update data model record with last instance id value");
                        }
                    }
                    String instance_id_sql = "INSERT INTO `model`.`model_instance` (`model_instance_id`, `model_id`, `model_instance_extra_info`) VALUES (?,?,?)";
                    try (PreparedStatement instanceIdStatement = locked_data_model_connection.prepareStatement(instance_id_sql);){
                        instanceIdStatement.setInt(1, instanceID);
                        instanceIdStatement.setInt(2, dataModelId);
                        instanceIdStatement.setString(3, "model_instance_extra_info");
                        int modelInstanceIdRows = instanceIdStatement.executeUpdate();
                        if (modelInstanceIdRows > 0) {
                            ArrayList<String> sequenceInserts = new ArrayList<String>();
                            HashMap sequenceNumberState = sequenceNumber.getSequenceState();
                            Iterator iterator = sequenceNumberState.keySet().iterator();
                            StringBuilder inserts = new StringBuilder();
                            while (iterator.hasNext()) {
                                Class key = (Class)iterator.next();
                                Integer sequenceStateValue = (Integer)sequenceNumberState.get(key);
                                inserts.setLength(0);
                                inserts.append("INSERT INTO `model`.`model_sequence`(`model_id`, `model_instance_id`,`model_class_path`,`model_instance_sequence_last_value`)VALUES(").append(dataModelId).append(",").append(instanceID).append(",").append("'").append(key.getCanonicalName()).append("',").append(sequenceStateValue).append(") ON DUPLICATE KEY UPDATE `model_instance_sequence_last_value`=").append(sequenceStateValue);
                                sequenceInserts.add(inserts.toString());
                            }
                            try (Statement sequenceStatement = locked_data_model_connection.createStatement();){
                                appendable.append("Add Inert Batch").append("\n");
                                for (int i = 0; i < sequenceInserts.size(); ++i) {
                                    String batch = (String)sequenceInserts.get(i);
                                    appendable.append(batch).append("\n");
                                    sequenceStatement.addBatch(batch);
                                }
                                int[] sequenceRows = sequenceStatement.executeBatch();
                                if (sequenceRows != null && sequenceRows.length > 0) {
                                    ArrayList<String> modelInserts = new ArrayList<String>();
                                    data_instance.saveToDatabase(dataModelId, this.data_lookup, (Object)instanceID, data_instance, modelInserts, database_field_open_quote, database_field_close_quote);
                                    int modelRows = 0;
                                    try (Connection unlocked_data_model_connection = this.model_jdbc_source.getConnection(Boolean.valueOf(false));){
                                        try (Statement modelStatement = unlocked_data_model_connection.createStatement();){
                                            for (int i = 0; i < modelInserts.size(); ++i) {
                                                appendable.append("\n*sql*\n").append(modelInserts.get(i)).append("\n");
                                                try {
                                                    ++modelRows;
                                                    modelStatement.executeUpdate(modelInserts.get(i));
                                                    continue;
                                                }
                                                catch (Exception ex) {
                                                    throw new Exception("Crashed on Insert Statement \n" + modelInserts.get(i), ex);
                                                }
                                            }
                                            if (modelRows != modelInserts.size()) {
                                                modelRows += modelStatement.executeBatch().length;
                                            }
                                            if (modelRows != modelInserts.size()) {
                                                throw new Exception("Inserted Rows = " + modelRows + " while Total Rows = " + modelInserts.size());
                                            }
                                            if (!unlocked_data_model_connection.isClosed() && !unlocked_data_model_connection.getAutoCommit()) {
                                                unlocked_data_model_connection.commit();
                                            }
                                            modelStatement.close();
                                        }
                                        catch (Exception sqlx) {
                                            appendable.append("----------- insert instance data sql statments crashed -----------").append("\n");
                                            if (!unlocked_data_model_connection.isClosed() && !unlocked_data_model_connection.getAutoCommit()) {
                                                unlocked_data_model_connection.rollback();
                                            }
                                            throw sqlx;
                                        }
                                    }
                                }
                                sequenceStatement.close();
                            }
                            catch (Exception sqlx) {
                                if (!locked_data_model_connection.isClosed() && !locked_data_model_connection.getAutoCommit()) {
                                    locked_data_model_connection.rollback();
                                }
                                throw sqlx;
                            }
                            data_model_resultset.close();
                            data_stmt.close();
                            data_instance.changeState(DataInstance.State.LOADED, true);
                            this.dataModelDataInstanceMap.put(data_model, data_instance);
                        }
                        if (!locked_data_model_connection.isClosed() && !locked_data_model_connection.getAutoCommit()) {
                            locked_data_model_connection.commit();
                        }
                        instanceIdStatement.close();
                    }
                    catch (Exception sqlx) {
                        if (!locked_data_model_connection.isClosed() && !locked_data_model_connection.getAutoCommit()) {
                            locked_data_model_connection.rollback();
                        }
                        throw sqlx;
                    }
                }
            }
            catch (Exception sqlx) {
                exception = sqlx;
            }
            try (Statement lockStatement = locked_data_model_connection.createStatement();){
                String unlockTables = "UNLOCK TABLES";
                Boolean bl = lockStatement.execute(unlockTables);
            }
            catch (Exception sqlx) {
                exception = sqlx;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return data_model;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public DataModel<Model> loadModelFromDatabase(Integer model_id, Integer model_instance_id, DataClass.LoadMethod loadMethod) throws Exception {
        String select_model_sql = "SELECT `model`.`model_id` AS `model_id`, `model_instance_sequence_type_id`, `model_instance_sequence_last_value`, `sequence_type`.`sequence_type_name`, `sequence_type`.`sequence_type`, `sequence_type`.`sequence_type_ordered_chars`, `sequence_type`.`sequence_type_chars_width`, `sequence_type`.`sequence_type_padding_char`, `sequence_type`.`sequence_type_rewind`, `sequence_type`.`sequence_type_initial_value`, `sequence_type`.`sequence_type_increment_value` FROM `model`.`model` INNER JOIN `model`.`sequence_type` ON `model`.`model_instance_sequence_type_id`=`sequence_type`.`sequence_type_id` WHERE `model`.`model_id`=?";
        SequenceNumber sequenceNumber = null;
        try (Connection data_model_connection = this.model_jdbc_source.getConnection(Boolean.valueOf(false));){
            DataModel dataModel;
            block46: {
                PreparedStatement data_stmt = data_model_connection.prepareStatement(select_model_sql);
                try {
                    data_stmt.setInt(1, model_id);
                    try (ResultSet data_model_resultset = data_stmt.executeQuery();){
                        if (!data_model_resultset.next()) {
                            throw new Exception("DataModel '" + this.data_model_class.getCanonicalName() + "' is not defined in Data.DataModel Table");
                        }
                        String sequence_type = data_model_resultset.getString("sequence_type");
                        Integer sequence_initial_value = data_model_resultset.getInt("sequence_type_initial_value");
                        Integer sequence_increment_value = data_model_resultset.getInt("sequence_type_increment_value");
                        if (!sequence_type.equalsIgnoreCase("Integer")) {
                            throw new Exception("Sequence Type must be 'Integer' type");
                        }
                        sequenceNumber = new SequenceNumber((Number)sequence_initial_value, (Number)sequence_increment_value, Boolean.valueOf(false));
                        String select_model_sequences_sql = "SELECT `model_class_path`, `model_instance_sequence_last_value` FROM `model`.`model_sequence` WHERE `model_id`=? AND `model_instance_id`=?";
                        try (PreparedStatement modelSequenceStatement = data_model_connection.prepareStatement(select_model_sequences_sql, 1005, 1008);){
                            modelSequenceStatement.setInt(1, model_id);
                            modelSequenceStatement.setInt(2, model_instance_id);
                            try (ResultSet sequenceResultset = modelSequenceStatement.executeQuery();){
                                while (sequenceResultset.next()) {
                                    String classPath = sequenceResultset.getString("model_class_path");
                                    Integer value = Integer.parseInt(sequenceResultset.getString("model_instance_sequence_last_value"));
                                    sequenceNumber.initSequence(Class.forName(classPath), (Number)value);
                                }
                            }
                            modelSequenceStatement.close();
                        }
                    }
                    ArrayList<String> selects = new ArrayList<String>();
                    if (sequenceNumber == null) {
                        throw new Exception("Sequence is not initialized!");
                    }
                    Object instanceObject = this.data_class.loadFromDatabase(data_model_connection, model_id, this.model_jdbc_source.getDatabaseName(), this.data_lookup, model_instance_id, loadMethod, sequenceNumber, selects);
                    DataModel data_model = (DataModel)this.data_model_class.getConstructor(this.model_class, ModelDefinition.class).newInstance(null, this.model_definition);
                    Method methodGetDeclaredField = this.data_model_class.getDeclaredMethod("getDeclaredField", new Class[0]);
                    Field modelDeclaredField = (Field)methodGetDeclaredField.invoke(this.data_model, new Object[0]);
                    modelDeclaredField.setAccessible(true);
                    modelDeclaredField.set(data_model, instanceObject);
                    data_model.prepareInstance();
                    dataModel = data_model;
                    if (data_stmt == null) break block46;
                }
                catch (Throwable throwable) {
                    if (data_stmt != null) {
                        try {
                            data_stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                data_stmt.close();
            }
            return dataModel;
        }
    }

    public Boolean isDataModelInstanceRegistered(DataModel<Model> data_model) throws Exception {
        if (data_model == null) {
            throw new Exception("DataModel is null");
        }
        if (data_model.getInstance() == null) {
            throw new Exception("DataModel is null");
        }
        if (data_model.getInstance().getClass().getCanonicalName().equals(this.data_class.clas.getCanonicalName())) {
            throw new Exception("DataProcessor handles DataModel of type '" + this.data_class.clas.getCanonicalName() + "' while passed DataModel is of type '" + data_model.getInstance().getClass().getCanonicalName() + "'");
        }
        return this.dataModelDataInstanceMap.containsValue(data_model);
    }

    public DataModel<Model> updateDataModelInstance(DataModel<Model> data_model) throws Exception {
        if (data_model == null) {
            throw new Exception("DataModel is null");
        }
        if (!this.isDataModelInstanceRegistered(data_model).booleanValue()) {
            throw new Exception("DataModel '" + this.data_class.package_name + "' is not registered yer , first call either registerDataModelInstance or loadDataModelFromDatabase ");
        }
        throw new Exception("Method not completed yet");
    }
}

