/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.data;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

public class DataSet {
    String sql;
    String table_list_path;
    ArrayList<Table> table_list;
    ArrayList<HashMap<String, Object>> recordset;

    public DataSet(String table_list_path) {
        this.table_list_path = table_list_path;
        this.table_list = new ArrayList();
        this.recordset = new ArrayList();
    }

    public void addTable(String tableAlias, String tableName) {
        this.table_list.add(new Table(this, tableName, tableAlias));
    }

    public void addField(String tableAlias, String fieldAlias, String fieldName, String classPath) throws Exception {
        for (Table table : this.table_list) {
            if (!table.alias.equals(tableAlias)) continue;
            table.addField(fieldName, fieldAlias, classPath);
        }
    }

    public void setSQL(String sql) throws Exception {
        if (sql == null) {
            throw new Exception("SQL statement is null!");
        }
        this.sql = sql;
    }

    public void addRecords(Connection connection, String whereClause) throws Exception {
        String sqlStatement = this.sql + (whereClause == null ? "" : whereClause);
        try (PreparedStatement preparedStatement = connection.prepareStatement(sqlStatement);){
            try (ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    for (int i = 0; i < this.table_list.size(); ++i) {
                        Table table = this.table_list.get(i);
                        for (int x = 0; x < table.field_list.size(); ++x) {
                            Table.Field field = table.field_list.get(x);
                            record.put(field.alias, rs.getObject(field.alias));
                        }
                    }
                    this.recordset.add(record);
                }
                rs.close();
            }
            preparedStatement.close();
        }
    }

    class Table {
        String name;
        String alias;
        ArrayList<Field> field_list;

        public Table(DataSet this$0, String name, String alias) {
            this.name = name;
            this.alias = alias;
            this.field_list = new ArrayList();
        }

        public void addField(String fieldAlias, String fieldName, String classPath) {
            this.field_list.add(new Field(this, fieldAlias, fieldName, classPath));
        }

        class Field {
            String name;
            String alias;
            String class_path;

            public Field(Table this$1, String name, String alias, String class_path) {
                this.name = name;
                this.alias = alias;
                this.class_path = class_path;
            }
        }
    }
}

