/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.database;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.reyadeyat.api.library.util.BooleanParser;
import net.reyadeyat.api.relational.database.FieldDefaultValue;
import net.reyadeyat.api.relational.database.FieldProcessor;
import net.reyadeyat.api.relational.database.FieldType;
import net.reyadeyat.api.relational.database.PrimartKeyType;

public class Field
implements Cloneable,
Comparable<Field> {
    public static final ArrayList<Integer> operation_list = new ArrayList();
    public static final Integer SELECT = 1;
    public static final Integer UPDATE = 2;
    public static final Integer INSERT = 4;
    public static final Integer DELETE = 8;
    public static final Integer WHERE = 16;
    public static final Integer HAVING = 32;
    private Integer SQL_MASK;
    private Integer SQL_MANDATORY_MASK;
    private Integer SQL_IGNORED_MASK;
    private HashMap<Integer, FieldDefaultValue> default_value;
    private HashMap<Integer, FieldProcessor> processor;
    private final FieldType field_type;
    private PrimartKeyType pt;
    private String table_name;
    private String table_alias;
    private final Boolean nullable;
    private final Boolean group;
    private final Integer index;
    private final String name;
    private final String alias;
    private final String statementName;
    private final String statementAalias;
    private String select_formula;
    private String insert_formula;
    private String update_formula;
    private Integer mins;
    private Integer maxs;
    private Number minn;
    private Number maxn;
    private Timestamp mindts;
    private Timestamp maxdts;
    private String dtf_mindts;
    private String dtf_maxdts;
    private ArrayList<String> set;
    private String select;
    private Boolean unique_any;
    private Boolean unique_all;
    private Boolean is_variable;
    private String variable_id;
    private String variable_default_value;
    private String variable_formula;
    private Boolean orderby;
    private Integer orderbyOrder;
    private Boolean is_foreign_key;
    private Boolean is_inner_join;
    private ArrayList<String> formula_parts;
    private String overwriteWhereCondition;
    private static final JsonPrimitive FNIND = new JsonPrimitive("Field name is not defined");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat stf = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final SimpleDateFormat stsf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final SimpleDateFormat stzf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public Field(String table_name, String table_alias, Integer index, String name, String alias, Boolean nullable, Boolean group, FieldType field_type, JsonArray table_error_list) {
        if (operation_list.size() == 0) {
            operation_list.add(SELECT);
            operation_list.add(UPDATE);
            operation_list.add(INSERT);
            operation_list.add(DELETE);
            operation_list.add(WHERE);
            operation_list.add(HAVING);
        }
        this.field_type = field_type;
        this.index = index;
        this.pt = PrimartKeyType.NotPrimaryKey;
        this.table_name = table_name;
        this.table_alias = table_alias;
        this.nullable = nullable;
        this.group = group;
        this.name = name;
        this.alias = alias;
        this.statementName = this.name == null || this.name.isBlank() ? null : "`" + (this.table_alias == null ? this.table_name : this.table_alias) + "`.`" + this.name + "`";
        this.statementAalias = this.alias == null || this.alias.isBlank() ? null : "`" + this.alias + "`";
        this.insert_formula = null;
        this.select_formula = null;
        this.update_formula = null;
        this.set = null;
        this.mins = this.maxs = Integer.valueOf(0);
        this.maxn = null;
        this.minn = null;
        this.maxdts = null;
        this.mindts = null;
        this.is_variable = false;
        this.unique_any = this.unique_all = Boolean.valueOf(false);
        this.orderby = this.unique_all;
        this.is_foreign_key = this.is_inner_join = Boolean.valueOf(false);
        this.SQL_MASK = SELECT | UPDATE | INSERT;
        this.SQL_MANDATORY_MASK = 0;
        this.SQL_IGNORED_MASK = 0;
        this.default_value = new HashMap();
        this.processor = new HashMap();
        if (name == null) {
            table_error_list.add("Field name is null");
        }
        if (nullable == null) {
            table_error_list.add("Field '" + name + "' nullability is not defined");
        }
        if (group == null) {
            table_error_list.add("Field '" + name + "' grouping is not defined");
        }
        if (table_name == null || table_name.length() == 0) {
            table_error_list.add("Table name is null for Field '" + name + "'");
        }
        if (alias == null || alias.length() == 0) {
            table_error_list.add("Field '" + name + "' alias is not defined");
        }
        if (table_error_list != null && table_error_list.size() > 0) {
            return;
        }
        if (!(alias == null || name == null || table_name == null || alias.isBlank() || name.isBlank() || table_name.isBlank())) {
            this.select = this.statementName + " AS " + this.statementAalias;
        } else if (name != null && !name.isBlank()) {
            this.select = this.statementName;
        }
    }

    public Field defineSet(String ... set) {
        this.set = new ArrayList<String>(Arrays.asList(set));
        return this;
    }

    public Field defineSelectFormula(String select_formula, JsonArray error_list) {
        this.select_formula = select_formula;
        if (this.alias != null && select_formula != null && !select_formula.isBlank() && !this.alias.isBlank()) {
            this.select = this.select_formula + " AS " + this.statementAalias;
            if (error_list.contains((JsonElement)FNIND)) {
                error_list.remove((JsonElement)FNIND);
            }
        }
        return this;
    }

    public Field defineUpdateFormula(String update_formula) {
        this.update_formula = update_formula;
        return this;
    }

    public Field defineInsertFormula(String insert_formula) {
        this.insert_formula = insert_formula;
        return this;
    }

    public Boolean isVariable() {
        return this.is_variable;
    }

    public Field setAsVariable(String variable_id, String variable_default_value, String formula, JsonArray error_list) throws Exception {
        this.is_variable = true;
        this.variable_id = variable_id;
        this.variable_default_value = variable_default_value;
        this.variable_formula = formula;
        if (this.alias != null && !this.alias.isBlank()) {
            this.select = " AS " + this.statementAalias;
            if (error_list.contains((JsonElement)FNIND)) {
                error_list.remove((JsonElement)FNIND);
            }
        } else {
            throw new Exception("Variable '" + variable_id + "' doesn't has proper alias '" + this.alias + "'.");
        }
        return this;
    }

    public Boolean hasFormulaDefined() {
        return this.insert_formula != null || this.select_formula != null || this.update_formula != null;
    }

    public Boolean isInsertFormulaDefined() {
        return this.insert_formula != null;
    }

    public Boolean isSelectFormulaDefined() {
        return this.select_formula != null;
    }

    public Boolean isUpdateFormulaDefined() {
        return this.update_formula != null;
    }

    public String getInsertFormulaDefined() {
        return this.insert_formula;
    }

    public String getSelectFormulaDefined() {
        return this.select_formula;
    }

    public String getUpdateFormulaDefined() {
        return this.update_formula;
    }

    public String toString() {
        return this.select;
    }

    public Boolean isPrimaryKey() {
        return this.pt == PrimartKeyType.PrimaryKey || this.pt == PrimartKeyType.PrimaryKeyAI || this.pt == PrimartKeyType.PrimaryKeyMI;
    }

    public Boolean isPrimaryKeyNone() {
        return this.pt == PrimartKeyType.NotPrimaryKey;
    }

    public Boolean isPrimaryKeyAI() {
        return this.pt == PrimartKeyType.PrimaryKeyAI;
    }

    public Boolean isPrimaryKeyMI() {
        return this.pt == PrimartKeyType.PrimaryKeyMI;
    }

    public Field setPrimaryKey(JsonArray error_list) throws Exception {
        this.pt = PrimartKeyType.PrimaryKey;
        this.disallow(UPDATE, error_list);
        return this;
    }

    public Field setPrimaryKeyAI(JsonArray error_list) throws Exception {
        this.pt = PrimartKeyType.PrimaryKeyAI;
        this.disallow(INSERT, error_list);
        this.disallow(UPDATE, error_list);
        return this;
    }

    public Field setPrimaryKeyMI(JsonArray error_list) throws Exception {
        this.pt = PrimartKeyType.PrimaryKeyMI;
        this.disallow(UPDATE, error_list);
        return this;
    }

    public Field setUniqueAny() {
        this.unique_any = true;
        return this;
    }

    public Boolean isUniqueAny() {
        return this.unique_any;
    }

    public Field setUniqueAll() {
        this.unique_all = true;
        return this;
    }

    public Boolean isUniqueAll() {
        return this.unique_all;
    }

    public Field setOrderBy(Integer orderbyOrder) {
        this.orderby = true;
        this.orderbyOrder = orderbyOrder;
        return this;
    }

    public Integer getOrderByOrder() {
        return this.orderbyOrder;
    }

    public Boolean isOrderBy() {
        return this.orderby;
    }

    public Field allow(Integer operation, JsonArray error_list) {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'allow' passed a wrong operation code[" + operation + "]");
        }
        this.SQL_MASK = this.SQL_MASK | operation;
        return this;
    }

    public Field disallow(Integer operation, JsonArray error_list) {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'disallow' passed a wrong operation code[" + operation + "]");
        }
        this.SQL_MASK = this.SQL_MASK & ~operation.intValue();
        return this;
    }

    public Boolean isAllowedTo(Integer operation) {
        return (this.SQL_MASK & operation) != 0;
    }

    public Boolean isValidSqlOperation(Integer operation) {
        return (operation & (SELECT | UPDATE | INSERT | WHERE | HAVING)) != 0;
    }

    public ArrayList<Integer> getRequestedOperations(Integer operation_register) {
        ArrayList<Integer> requested_operation_list = new ArrayList<Integer>();
        for (Integer op : operation_list) {
            if ((operation_register & op) == 0) continue;
            requested_operation_list.add(op);
        }
        return requested_operation_list;
    }

    public Field setMandatoryFor(Integer operation, JsonArray error_list) {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'setMandatoryFor' passed a wrong operation code[" + operation + "]");
        }
        this.SQL_MANDATORY_MASK = this.SQL_MANDATORY_MASK | operation;
        return this;
    }

    public Boolean isMandatoryFor(Integer operation) {
        return (this.SQL_MANDATORY_MASK & operation) != 0;
    }

    public Field setIgnoredFor(Integer operation, JsonArray error_list) {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'setMandatoryFor' passed a wrong operation code[" + operation + "]");
        }
        this.SQL_IGNORED_MASK = this.SQL_IGNORED_MASK | operation;
        return this;
    }

    public Boolean isIgnoredFor(Integer operation) {
        return (this.SQL_IGNORED_MASK & operation) != 0;
    }

    public Boolean hasDefaultValueFor(Integer operation) {
        return this.default_value.containsKey(operation);
    }

    public Field setDefaultValueFor(Integer operation, Object value, JsonArray error_list) throws Exception {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'setDefaultValue' passed a wrong operation code[" + operation + "]");
        }
        this.default_value.put(operation, new FieldDefaultValue(this.field_type, value, false));
        return this;
    }

    public Field setDefaultExpressionFor(Integer operation, String expression, JsonArray error_list) throws Exception {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'setDefaultValue' passed a wrong operation code[" + operation + "]");
        }
        ArrayList<Integer> operation_list = this.getRequestedOperations(operation);
        for (Integer op : operation_list) {
            this.default_value.put(op, new FieldDefaultValue(this.field_type, expression, true));
        }
        return this;
    }

    public Object getDefaultValueFor(Integer operation, JsonArray error_list) throws Exception {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'setDefaultValue' passed a wrong operation code[" + operation + "]");
        }
        return this.default_value.get(operation).getValue();
    }

    public String getDefaultSQLValueFor(Integer operation, JsonArray error_list) throws Exception {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'setDefaultValue' passed a wrong operation code[" + operation + "]");
        }
        return this.default_value.get(operation).getSQLValue();
    }

    public Field setProcessor(Integer operation, FieldProcessor fieldProcessor, JsonArray error_list) throws Exception {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'setDefaultValue' passed a wrong operation code[" + operation + "]");
        }
        this.processor.put(operation, fieldProcessor);
        return this;
    }

    public String getPreProcessedValue(Integer operation, String value, JsonArray error_list) throws Exception {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'setDefaultValue' passed a wrong operation code[" + operation + "]");
        }
        if (this.processor.size() == 0 || this.processor.get(operation) == null) {
            return value;
        }
        return this.processor.get(operation).preProcessedValue(this, operation, value, error_list);
    }

    public Object getPostProcessedValue(Integer operation, Object value, JsonArray error_list) throws Exception {
        if (!this.isValidSqlOperation(operation).booleanValue()) {
            error_list.add("Field '" + this.alias + "' 'setDefaultValue' passed a wrong operation code[" + operation + "]");
        }
        if (this.processor.size() == 0 || this.processor.get(operation) == null) {
            return value;
        }
        return this.processor.get(operation).postProcessedValue(this, operation, value, error_list);
    }

    public Boolean is_foreign_key() {
        return this.is_foreign_key;
    }

    public Field setForeignKey() {
        this.is_foreign_key = true;
        return this;
    }

    public Field setInnerJoin() {
        this.is_inner_join = true;
        return this;
    }

    @Override
    public int compareTo(Field f) {
        if (this.index < f.index) {
            return -1;
        }
        if (this.index.intValue() == f.index.intValue()) {
            return 0;
        }
        return 1;
    }

    public String getSQLInsertName() {
        return this.name;
    }

    public String getSQLName() {
        if (this.select_formula != null && !this.select_formula.isBlank()) {
            return this.select_formula;
        }
        return this.statementName;
    }

    public String getSQLAlias() {
        return this.statementAalias;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public String getSelect() {
        return this.select;
    }

    public String getSelect(Map<String, String> variable_map) throws Exception {
        if (variable_map == null) {
            return this.select;
        }
        String variable_value = variable_map.get(this.alias);
        if (variable_value == null) {
            return this.getQuotable(this.getFieldString(this.getFieldObject(this.variable_default_value))) + this.select;
        }
        if (this.variable_formula != null && this.variable_formula.length() > 0) {
            return this.variable_formula.replace("?", this.getQuotable(this.getFieldString(this.getFieldObject(variable_value)))) + this.select;
        }
        return this.getQuotable(this.getFieldString(this.getFieldObject(variable_value))) + this.select;
    }

    public String getTable() {
        return this.table_name;
    }

    public String getHaving() {
        if (this.select_formula == null || this.select_formula.isBlank()) {
            return this.name;
        }
        return this.select_formula;
    }

    public String getGroupBy() {
        if (this.select_formula != null && !this.select_formula.isBlank()) {
            return this.select_formula;
        }
        return this.statementName;
    }

    public String getOrderBy() {
        if (this.select_formula != null && !this.select_formula.isBlank()) {
            return this.select_formula;
        }
        return this.statementName;
    }

    public void overwriteWhereCondition(String overwriteWhereCondition) {
        this.overwriteWhereCondition = overwriteWhereCondition;
    }

    public Boolean hasOverwriteWhereCondition() {
        return this.overwriteWhereCondition != null;
    }

    public String getOverwriteWhereCondition() {
        return this.overwriteWhereCondition;
    }

    public Field setTexLengthRange(Number minn, Number maxn) {
        this.mins = this.mins;
        this.maxs = this.maxs;
        return this;
    }

    public Field setNumberRange(Number minn, Number maxn) {
        this.minn = minn;
        this.maxn = maxn;
        return this;
    }

    public Field setDateTimeRange(Timestamp mindts, Timestamp maxdts) throws Exception {
        this.mindts = mindts;
        this.maxdts = maxdts;
        if (this.field_type == FieldType.Date) {
            this.dtf_mindts = Field.getSqlDate((Date)Date.from(this.mindts.toInstant()));
            this.dtf_maxdts = Field.getSqlDate((Date)Date.from(this.mindts.toInstant()));
        } else if (this.field_type == FieldType.Time) {
            this.dtf_mindts = Field.getSqlTime((Time)Time.from(this.mindts.toInstant()));
            this.dtf_maxdts = Field.getSqlTime((Time)Time.from(this.maxdts.toInstant()));
        } else if (this.field_type == FieldType.Timestamp) {
            this.dtf_mindts = Field.getSqlTimestamp(this.mindts);
            this.dtf_maxdts = Field.getSqlTimestamp(this.maxdts);
        }
        return this;
    }

    public String getFieldString(Object field_value) throws Exception {
        if (field_value == null) {
            return null;
        }
        if (field_value instanceof String) {
            if (this.field_type != FieldType.String && this.field_type != FieldType.Set) {
                throw new Exception("Field '" + this.alias + "' of type '" + this.field_type.toString() + "' can't accepts value '" + String.valueOf(field_value) + "' of type 'String'");
            }
            return String.valueOf(field_value);
        }
        if (field_value instanceof Long) {
            return String.valueOf(field_value);
        }
        if (field_value instanceof Integer) {
            return String.valueOf(field_value);
        }
        if (field_value instanceof Double) {
            return String.valueOf(field_value);
        }
        if (field_value instanceof Boolean) {
            return String.valueOf(field_value);
        }
        if (field_value instanceof Date) {
            return Field.getSqlDate((Date)field_value);
        }
        if (field_value instanceof Time) {
            return Field.getSqlTime((Time)field_value);
        }
        if (field_value instanceof Timestamp) {
            return Field.getSqlTimestamp((Timestamp)field_value);
        }
        if (field_value instanceof LocalDateTime) {
            return Field.getSqlTimestamp(Timestamp.valueOf((LocalDateTime)field_value));
        }
        throw new Exception("getFieldString passed unhandeled instance of type => " + field_value.getClass().getName());
    }

    public String getFieldString(String field_value) throws Exception {
        return field_value;
    }

    public String getFieldString(Boolean field_value) throws Exception {
        return String.valueOf(field_value);
    }

    public String getFieldString(Integer field_value) throws Exception {
        return String.valueOf(field_value);
    }

    public String getFieldString(Long field_value) throws Exception {
        return String.valueOf(field_value);
    }

    public String getFieldString(Double field_value) throws Exception {
        return String.valueOf(field_value);
    }

    public String getFieldString(Date field_value) throws Exception {
        return Field.getSqlDate(field_value);
    }

    public String getFieldString(Time field_value) throws Exception {
        return Field.getSqlTime(field_value);
    }

    public String getFieldString(Timestamp field_value) throws Exception {
        return Field.getSqlTimestamp(field_value);
    }

    public Object getFieldObject(String field_value) throws Exception {
        try {
            if (field_value == null) {
                return null;
            }
            if (this.field_type == FieldType.String) {
                return field_value;
            }
            if (this.field_type == FieldType.Set) {
                for (String entry : this.set) {
                    if (!entry.equals(entry)) continue;
                    return field_value;
                }
            } else {
                if (this.field_type == FieldType.Long) {
                    return Long.parseLong(field_value);
                }
                if (this.field_type == FieldType.Integer) {
                    return Integer.parseInt(field_value);
                }
                if (this.field_type == FieldType.Double || this.field_type == FieldType.BigDecimal) {
                    return Double.parseDouble(field_value);
                }
                if (this.field_type == FieldType.Boolean) {
                    return BooleanParser.parse((String)field_value);
                }
                if (this.field_type == FieldType.Date) {
                    return Field.getSqlDate(field_value);
                }
                if (this.field_type == FieldType.Time) {
                    return Field.getSqlTime(field_value);
                }
                if (this.field_type == FieldType.Timestamp) {
                    return Field.getSqlTimestamp(field_value);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("getFieldObject Formt Exception for field '" + this.name + " AS " + this.alias + "' passed unhandeled instance of type " + this.field_type.toString() + " => " + field_value);
        }
        throw new Exception("getFieldObject field '" + this.name + " AS " + this.alias + "' passed unhandeled instance of type " + this.field_type.toString() + " => " + field_value);
    }

    public static Object getFieldObject(String field_value, String dataType) throws Exception {
        if (field_value == null) {
            return null;
        }
        if (dataType.equalsIgnoreCase("String")) {
            return field_value;
        }
        if (dataType.equalsIgnoreCase("Long")) {
            return Long.parseLong(field_value);
        }
        if (dataType.equalsIgnoreCase("Integer")) {
            return Integer.parseInt(field_value);
        }
        if (dataType.equalsIgnoreCase("Double")) {
            return Double.parseDouble(field_value);
        }
        if (dataType.equalsIgnoreCase("Boolean")) {
            return BooleanParser.parse((String)field_value);
        }
        if (dataType.equalsIgnoreCase("Date")) {
            return Field.getSqlDate(field_value);
        }
        if (dataType.equalsIgnoreCase("Time")) {
            return Field.getSqlTime(field_value);
        }
        if (dataType.equalsIgnoreCase("Timestamp")) {
            return Field.getSqlTimestamp(field_value);
        }
        throw new Exception("getFieldObject(field_value, dataType) passed unhandeled instance of type '" + dataType + "' => '" + field_value + "'");
    }

    public static Date getSqlDate(String date) throws Exception {
        return new Date(sdf.parse(date).getTime());
    }

    public static String getSqlDate(java.util.Date date) throws Exception {
        return date == null ? null : sdf.format(date);
    }

    public static String getSqlDate(Date date) throws Exception {
        return date == null ? null : sdf.format(date);
    }

    public static String getSqlDate(Instant instant) throws Exception {
        return instant == null ? null : sdf.format(Date.from(instant));
    }

    public static Time getSqlTime(String time) throws Exception {
        return new Time(stf.parse(time).getTime());
    }

    public static String getSqlTime(java.util.Date time) throws Exception {
        return time == null ? null : stf.format(time);
    }

    public static String getSqlTime(Time time) throws Exception {
        return time == null ? null : stf.format(time);
    }

    public static String getSqlTime(Instant instant) throws Exception {
        return instant == null ? null : stf.format(Date.from(instant));
    }

    public static Timestamp getSqlTimestamp(String timestamp) throws Exception {
        return new Timestamp(stsf.parse(timestamp).getTime());
    }

    public static String getSqlTimestamp(java.util.Date timestamp) throws Exception {
        return timestamp == null ? null : stsf.format(timestamp);
    }

    public static String getSqlTimestamp(Timestamp timestamp) throws Exception {
        return timestamp == null ? null : stsf.format(timestamp);
    }

    public static String getSqlTimestamp(Instant instant) throws Exception {
        return instant == null ? null : stsf.format(Date.from(instant));
    }

    public static Timestamp getSqlTimeZone(String timezone) throws Exception {
        return new Timestamp(stzf.parse(timezone).getTime());
    }

    public static String getSqlTimeZone(java.util.Date timezone) throws Exception {
        return timezone == null ? null : stzf.format(timezone);
    }

    public static String getSqlTimeZone(Timestamp timezone) throws Exception {
        return timezone == null ? null : stzf.format(timezone);
    }

    public static String getSqlTimeZone(Instant instant) throws Exception {
        return instant == null ? null : stzf.format(instant);
    }

    public Boolean isNullable() {
        return this.nullable;
    }

    public Boolean isValid(Integer operation, String string, StringBuilder error) throws Exception {
        error.setLength(0);
        error.append("Field '" + this.alias + "' check value '" + string + "' againest [" + this.field_type.toString() + "] data type, result => ");
        if (string == null) {
            if (!this.nullable.booleanValue()) {
                error.append("Field '" + this.alias + "' can't be 'null' value");
            }
            return this.nullable;
        }
        if (this.field_type == FieldType.String) {
            if (string.length() < this.mins && string.length() > this.maxs) {
                error.append(" - [String] length out of range (" + this.mins + "," + this.maxs + ")");
                return false;
            }
            return true;
        }
        if (this.field_type == FieldType.Integer) {
            try {
                Integer i = Integer.valueOf(string);
                if (this.minn != null && this.maxn != null && (i < this.minn.intValue() || i > this.maxn.intValue())) {
                    error.append(" - [Integer] value out of range (" + String.valueOf(this.minn) + "," + String.valueOf(this.maxn) + ")");
                    return false;
                }
                return true;
            }
            catch (Exception x) {
                error.append(" - [Integer] value parsing exception ['" + x.getMessage() + "']");
                return false;
            }
        }
        if (this.field_type == FieldType.Long) {
            try {
                Long l = Long.valueOf(string);
                if (this.minn != null && this.maxn != null && (l < (long)this.minn.intValue() || l > (long)this.maxn.intValue())) {
                    error.append(" - [Long] value out of range (" + String.valueOf(this.minn) + "," + String.valueOf(this.maxn) + ")");
                    return false;
                }
                return true;
            }
            catch (Exception x) {
                error.append(" - [Long] value parsing exception ['" + x.getMessage() + "']");
                return false;
            }
        }
        if (this.field_type == FieldType.Double || this.field_type == FieldType.BigDecimal) {
            try {
                Double d = Double.valueOf(string);
                if (this.minn != null && this.maxn != null && (d < (double)this.minn.intValue() || d > (double)this.maxn.intValue())) {
                    error.append(" - [Double] value out of range (" + String.valueOf(this.minn) + "," + String.valueOf(this.maxn) + ")");
                    return false;
                }
                return true;
            }
            catch (Exception x) {
                error.append(" - [Double] value parsing exception ['" + x.getMessage() + "']");
                return false;
            }
        }
        if (this.field_type == FieldType.Boolean) {
            try {
                Boolean b = BooleanParser.parse((String)string);
                return true;
            }
            catch (Exception x) {
                error.append(" - [Boolean] value parsing exception ['" + x.getMessage() + "']");
                return false;
            }
        }
        if (this.field_type == FieldType.Date) {
            try {
                Date d = Field.getSqlDate(string);
                if (this.mindts != null && this.maxdts != null && (d.getTime() < this.mindts.getTime() || d.getTime() > this.maxdts.getTime())) {
                    error.append(" - [Date] value out of range (" + this.dtf_mindts + "," + this.dtf_maxdts + ")");
                    return false;
                }
                return true;
            }
            catch (Exception x) {
                error.append(" - [Date] value parsing exception ['" + x.getMessage() + "']");
                return false;
            }
        }
        if (this.field_type == FieldType.Time) {
            try {
                Time t = Field.getSqlTime(string);
                if (this.mindts != null && this.maxdts != null && (t.getTime() < this.mindts.getTime() || t.getTime() > this.maxdts.getTime())) {
                    error.append(" - [Time] value out of range (" + this.dtf_mindts + "," + this.dtf_maxdts + ")");
                    return false;
                }
                return true;
            }
            catch (Exception x) {
                error.append(" - [Time] value parsing exception ['" + x.getMessage() + "']");
                return false;
            }
        }
        if (this.field_type == FieldType.Timestamp) {
            try {
                Timestamp ts = Field.getSqlTimestamp(string);
                if (this.mindts != null && this.maxdts != null && (ts.getTime() < this.mindts.getTime() || ts.getTime() > this.maxdts.getTime())) {
                    error.append(" - [Timestamp] value out of range (" + this.dtf_mindts + "," + this.dtf_maxdts + ")");
                    return false;
                }
                return true;
            }
            catch (Exception x) {
                error.append(" - [Timestamp] value parsing exception ['" + x.getMessage() + "']");
                return false;
            }
        }
        if (this.field_type == FieldType.TimeZone) {
            try {
                Timestamp ts = Field.getSqlTimeZone(string);
                if (this.mindts != null && this.maxdts != null && (ts.getTime() < this.mindts.getTime() || ts.getTime() > this.maxdts.getTime())) {
                    error.append(" - [TimeZone] value out of range (" + this.dtf_mindts + "," + this.dtf_maxdts + ")");
                    return false;
                }
                return true;
            }
            catch (Exception x) {
                error.append(" - [TimeZone] value parsing exception ['" + x.getMessage() + "']");
                return false;
            }
        }
        if (this.field_type == FieldType.Set) {
            for (String entry : this.set) {
                if (!entry.equals(string)) continue;
                return true;
            }
            return false;
        }
        throw new Exception("Undefined field type '" + String.valueOf((Object)this.field_type) + "'");
    }

    public Boolean isBoolean() {
        return this.field_type.isBoolean();
    }

    public Boolean isNumeric() {
        return this.field_type.isNumeric();
    }

    public Boolean isText() {
        return this.field_type.isText();
    }

    public Boolean isQuotable() {
        return this.field_type.isQuotable();
    }

    public Boolean isDateTime() {
        return this.field_type.isDateTime();
    }

    public Boolean isGroup() {
        return this.group;
    }

    public String getQuotable(String value) {
        return this.field_type.isQuotable() == true ? "'" + value.replace("'", "''") + "'" : value;
    }

    public Boolean parseBoolean(Object value) throws Exception {
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            return BooleanParser.parse((String)((String)value));
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    private static Class getClassName(String className) throws Exception {
        if (className.equalsIgnoreCase("java.lang.String") || className.equalsIgnoreCase("String")) {
            return String.class;
        }
        if (className.equalsIgnoreCase("java.lang.Byte") || className.equalsIgnoreCase("Byte")) {
            return Byte.class;
        }
        if (className.equalsIgnoreCase("java.lang.Short") || className.equalsIgnoreCase("Short")) {
            return Short.class;
        }
        if (className.equalsIgnoreCase("java.lang.Long") || className.equalsIgnoreCase("Long")) {
            return Long.class;
        }
        if (className.equalsIgnoreCase("java.lang.Integer") || className.equalsIgnoreCase("int") || className.equalsIgnoreCase("Integer") || className.equalsIgnoreCase("Number")) {
            return Integer.class;
        }
        if (className.equalsIgnoreCase("java.lang.Float") || className.equalsIgnoreCase("Float")) {
            return Float.class;
        }
        if (className.equalsIgnoreCase("java.lang.Double") || className.equalsIgnoreCase("Decimal") || className.equalsIgnoreCase("Double")) {
            return Double.class;
        }
        if (className.equalsIgnoreCase("java.lang.Date") || className.equalsIgnoreCase("java.sql.Date") || className.equalsIgnoreCase("Date")) {
            return Date.class;
        }
        if (className.equalsIgnoreCase("java.sql.Time") || className.equalsIgnoreCase("Time")) {
            return Date.class;
        }
        if (className.equalsIgnoreCase("java.sql.Timestamp") || className.equalsIgnoreCase("DateTime") || className.equalsIgnoreCase("Timestamp")) {
            return Date.class;
        }
        if (className.equalsIgnoreCase("TINYINT") || className.equalsIgnoreCase("TINYINT UNSIGNED") || className.equalsIgnoreCase("BOOLEAN")) {
            return Boolean.class;
        }
        if (className.equalsIgnoreCase("TINYINT") || className.equalsIgnoreCase("TINYINT UNSIGNED")) {
            return Byte.class;
        }
        if (className.equalsIgnoreCase("SMALLINT") || className.equalsIgnoreCase("SMALLINT UNSIGNED")) {
            return Short.class;
        }
        if (className.equalsIgnoreCase("MEDIUMINT") || className.equalsIgnoreCase("INT") || className.equalsIgnoreCase("INTEGER") || className.equalsIgnoreCase("MEDIUMINT UNSIGNED") || className.equalsIgnoreCase("INT UNSIGNED") || className.equalsIgnoreCase("INTEGER UNSIGNED") || className.equalsIgnoreCase("BIT") || className.equalsIgnoreCase("BIT UNSIGNED") || className.equalsIgnoreCase("INT IDENTITY") || className.equalsIgnoreCase("SERIAL")) {
            return Integer.class;
        }
        if (className.equalsIgnoreCase("BIGINT") || className.equalsIgnoreCase("BIGINT UNSIGNED") || className.equalsIgnoreCase("BIGINT IDENTITY") || className.equalsIgnoreCase("SERIAL8") || className.equalsIgnoreCase("INT8") || className.equalsIgnoreCase("BIGSERIAL")) {
            return Long.class;
        }
        if (className.equalsIgnoreCase("FLOAT") || className.equalsIgnoreCase("FLOAT UNSIGNED")) {
            return Float.class;
        }
        if (className.equalsIgnoreCase("DOUBLE") || className.equalsIgnoreCase("DOUBLE UNSIGNED")) {
            return Double.class;
        }
        if (className.equalsIgnoreCase("NUMERIC") || className.equalsIgnoreCase("DECIMAL") || className.equalsIgnoreCase("NUMERIC UNSIGNED") || className.equalsIgnoreCase("DECIMAL UNSIGNED") || className.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
            return Long.class;
        }
        if (className.equalsIgnoreCase("YEAR") || className.equalsIgnoreCase("DATE")) {
            return Date.class;
        }
        if (className.equalsIgnoreCase("TIME")) {
            return Time.class;
        }
        if (className.equalsIgnoreCase("DATETIME") || className.equalsIgnoreCase("TIMESTAMP") || className.equalsIgnoreCase("SMALLDATETIME") || className.toLowerCase().startsWith("datetime")) {
            return Timestamp.class;
        }
        if (className.equalsIgnoreCase("CHAR") || className.equalsIgnoreCase("ENUM") || className.equalsIgnoreCase("SET") || className.equalsIgnoreCase("VARCHAR") || className.equalsIgnoreCase("TINYTEXT") || className.equalsIgnoreCase("TEXT") || className.equalsIgnoreCase("MEDIUMTEXT") || className.equalsIgnoreCase("LONGTEXT") || className.equalsIgnoreCase("NVARCHAR") || className.equalsIgnoreCase("NTEXT") || className.equalsIgnoreCase("NCHAR") || className.equalsIgnoreCase("SYSNAME") || className.equalsIgnoreCase("LVARCHAR")) {
            return String.class;
        }
        if (className.equalsIgnoreCase("BINARY") || className.equalsIgnoreCase("VARBINARY") || className.equalsIgnoreCase("TINYBLOB") || className.equalsIgnoreCase("BLOB") || className.equalsIgnoreCase("CLOB") || className.equalsIgnoreCase("MEDIUMBLOB") || className.equalsIgnoreCase("LONGBLOB") || className.equalsIgnoreCase("IMAGE")) {
            return Object.class;
        }
        throw new Exception("Undefined typeClass '" + className + "'");
    }

    public static Class getClassOfType(String className) throws Exception {
        if (className.equalsIgnoreCase("java.lang.String") || className.equalsIgnoreCase("String")) {
            return String.class;
        }
        if (className.equalsIgnoreCase("java.lang.Byte") || className.equalsIgnoreCase("Byte")) {
            return Byte.class;
        }
        if (className.equalsIgnoreCase("java.lang.Short") || className.equalsIgnoreCase("Short")) {
            return Short.class;
        }
        if (className.equalsIgnoreCase("java.lang.Long") || className.equalsIgnoreCase("Long")) {
            return Long.class;
        }
        if (className.equalsIgnoreCase("java.lang.Integer") || className.equalsIgnoreCase("int") || className.equalsIgnoreCase("Integer") || className.equalsIgnoreCase("Number")) {
            return Integer.class;
        }
        if (className.equalsIgnoreCase("java.lang.Float") || className.equalsIgnoreCase("Float")) {
            return Float.class;
        }
        if (className.equalsIgnoreCase("java.lang.Double") || className.equalsIgnoreCase("Decimal") || className.equalsIgnoreCase("Double")) {
            return Double.class;
        }
        if (className.equalsIgnoreCase("java.lang.Date") || className.equalsIgnoreCase("java.sql.Date") || className.equalsIgnoreCase("Date")) {
            return Date.class;
        }
        if (className.equalsIgnoreCase("java.sql.Time") || className.equalsIgnoreCase("Time")) {
            return Date.class;
        }
        if (className.equalsIgnoreCase("java.sql.Timestamp") || className.equalsIgnoreCase("DateTime") || className.equalsIgnoreCase("Timestamp")) {
            return Date.class;
        }
        if (className.equalsIgnoreCase("TINYINT") || className.equalsIgnoreCase("TINYINT UNSIGNED") || className.equalsIgnoreCase("BOOLEAN")) {
            return Boolean.class;
        }
        if (className.equalsIgnoreCase("TINYINT") || className.equalsIgnoreCase("TINYINT UNSIGNED")) {
            return Byte.class;
        }
        if (className.equalsIgnoreCase("SMALLINT") || className.equalsIgnoreCase("SMALLINT UNSIGNED")) {
            return Short.class;
        }
        if (className.equalsIgnoreCase("MEDIUMINT") || className.equalsIgnoreCase("INT") || className.equalsIgnoreCase("INTEGER") || className.equalsIgnoreCase("MEDIUMINT UNSIGNED") || className.equalsIgnoreCase("INT UNSIGNED") || className.equalsIgnoreCase("INTEGER UNSIGNED") || className.equalsIgnoreCase("BIT") || className.equalsIgnoreCase("BIT UNSIGNED") || className.equalsIgnoreCase("INT IDENTITY") || className.equalsIgnoreCase("SERIAL")) {
            return Integer.class;
        }
        if (className.equalsIgnoreCase("BIGINT") || className.equalsIgnoreCase("BIGINT UNSIGNED") || className.equalsIgnoreCase("BIGINT IDENTITY") || className.equalsIgnoreCase("SERIAL8") || className.equalsIgnoreCase("INT8") || className.equalsIgnoreCase("BIGSERIAL")) {
            return Long.class;
        }
        if (className.equalsIgnoreCase("FLOAT") || className.equalsIgnoreCase("FLOAT UNSIGNED")) {
            return Float.class;
        }
        if (className.equalsIgnoreCase("DOUBLE") || className.equalsIgnoreCase("DOUBLE UNSIGNED")) {
            return Double.class;
        }
        if (className.equalsIgnoreCase("NUMERIC") || className.equalsIgnoreCase("DECIMAL") || className.equalsIgnoreCase("NUMERIC UNSIGNED") || className.equalsIgnoreCase("DECIMAL UNSIGNED") || className.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
            return Long.class;
        }
        if (className.equalsIgnoreCase("YEAR") || className.equalsIgnoreCase("DATE")) {
            return Date.class;
        }
        if (className.equalsIgnoreCase("TIME")) {
            return Time.class;
        }
        if (className.equalsIgnoreCase("DATETIME") || className.equalsIgnoreCase("TIMESTAMP") || className.equalsIgnoreCase("SMALLDATETIME") || className.toLowerCase().startsWith("datetime")) {
            return Timestamp.class;
        }
        if (className.equalsIgnoreCase("CHAR") || className.equalsIgnoreCase("ENUM") || className.equalsIgnoreCase("SET") || className.equalsIgnoreCase("VARCHAR") || className.equalsIgnoreCase("TINYTEXT") || className.equalsIgnoreCase("TEXT") || className.equalsIgnoreCase("MEDIUMTEXT") || className.equalsIgnoreCase("LONGTEXT") || className.equalsIgnoreCase("NVARCHAR") || className.equalsIgnoreCase("NTEXT") || className.equalsIgnoreCase("NCHAR") || className.equalsIgnoreCase("SYSNAME") || className.equalsIgnoreCase("LVARCHAR")) {
            return String.class;
        }
        if (className.equalsIgnoreCase("BINARY") || className.equalsIgnoreCase("VARBINARY") || className.equalsIgnoreCase("TINYBLOB") || className.equalsIgnoreCase("BLOB") || className.equalsIgnoreCase("CLOB") || className.equalsIgnoreCase("MEDIUMBLOB") || className.equalsIgnoreCase("LONGBLOB") || className.equalsIgnoreCase("IMAGE")) {
            return Object.class;
        }
        throw new Exception("Undefined typeClass '" + className + "'");
    }
}

