/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.reyadeyat.api.relational.database.Field;

public class ForeignKey {
    private String key;
    private String database_name;
    private String foreign_table_name;
    private String foreign_table_alias;
    private ArrayList<Field> field_list;
    private HashMap<Field, String> foreignFields;
    private String foreiness_validation_statement;

    public ForeignKey(String key, String database_name, String foreign_table_name, String foreign_table_alias) {
        this.key = key;
        this.database_name = database_name;
        this.foreign_table_name = foreign_table_name;
        this.foreign_table_alias = foreign_table_alias;
        this.foreignFields = new HashMap();
    }

    public String getKey() {
        return this.key;
    }

    public void addForeignField(Field field, String foreignField) {
        this.foreignFields.put(field, foreignField);
    }

    public String getForeignField(Field field) {
        return this.foreignFields.get(field);
    }

    public String getForeignTableName() {
        return this.foreign_table_name;
    }

    public String getForeignTableAlias() {
        return this.foreign_table_alias;
    }

    public ArrayList<Field> getFields() {
        return this.field_list;
    }

    public void prepareForeinessValidationStatement() {
        if (this.foreignFields == null) {
            this.foreiness_validation_statement = "";
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.field_list = new ArrayList<Field>(this.foreignFields.keySet());
        Collections.sort(this.field_list);
        sb.append("SELECT * FROM ").append("`").append(this.database_name).append("`.`").append(this.foreign_table_name).append("` WHERE ");
        for (int i = 0; i < this.field_list.size(); ++i) {
            Field field = this.field_list.get(i);
            String foreignFieldName = this.foreignFields.get(field);
            sb.append("`").append(this.foreign_table_name).append("`.`").append(foreignFieldName).append("`<=>?").append(i + 1 == this.field_list.size() ? "" : " AND ");
        }
        this.foreiness_validation_statement = sb.toString();
    }

    public String getForeinessValidationStatement() {
        return this.foreiness_validation_statement;
    }
}

