/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.database;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.reyadeyat.api.library.util.Returns;
import net.reyadeyat.api.relational.database.Query;
import net.reyadeyat.api.relational.request.Request;
import net.reyadeyat.api.relational.request.Response;

public class RecordProcessor {
    public Request request;
    public String command;
    public JsonWriter response_output_writer;
    public JsonArray error_list;
    public int affected_rows;
    public Boolean is_empty_view;
    public Response response;
    public Returns returns;
    public RecordProcessor parent_record_processor;
    public Map<String, RecordProcessor> child_map;
    public List<RecordProcessor> child_list;
    public List<Map<String, Object>> record_stack_frame_list;
    public Query query;
    private Boolean debug = Boolean.TRUE;

    public RecordProcessor(Request request, JsonWriter response_output_writer) throws Exception {
        this(null, request, response_output_writer);
    }

    public RecordProcessor(RecordProcessor parent_record_processor, Request request, JsonWriter response_output_writer) throws Exception {
        this.parent_record_processor = parent_record_processor;
        this.request = request;
        String string = this.is_select() != false ? "Select" : (this.is_insert() != false ? "insert" : (this.is_update() != false ? "Update" : (this.command = this.is_delete() != false ? "Delete" : null)));
        if (this.command == null) {
            throw new Exception("Request has invalid command type");
        }
        this.query = new Query();
        this.response_output_writer = response_output_writer;
        this.error_list = new JsonArray();
        this.is_empty_view = true;
        this.affected_rows = 0;
        this.returns = new Returns();
        this.child_list = new ArrayList<RecordProcessor>();
        this.child_map = new TreeMap<String, RecordProcessor>();
        if (request.child_list != null && request.child_list.size() > 0) {
            this.record_stack_frame_list = new ArrayList<Map<String, Object>>();
            for (Request child_request : request.child_list) {
                RecordProcessor child_record_processor = new RecordProcessor(this, child_request, response_output_writer);
                this.child_list.add(child_record_processor);
                this.child_map.put(child_record_processor.request.table_alias, child_record_processor);
            }
        }
    }

    public void addRecordStackFrame(Map<String, Object> record_stack_frame) {
        this.record_stack_frame_list.add(record_stack_frame);
    }

    public List<Map<String, Object>> getTablePrimaryRecordList(Map<String, Object> table_parimary_record) {
        return this.record_stack_frame_list;
    }

    public String getResponseView() {
        return this.request.response;
    }

    public Request getTableRequest() {
        return this.request;
    }

    public RecordProcessor getChildTableRecordProcessor(String table_alias) {
        return this.child_map.get(table_alias);
    }

    public void addChildRecordProcessor(RecordProcessor child_record_processor) throws Exception {
        if (this.child_map.containsKey(child_record_processor.request.table_alias)) {
            throw new Exception("RecordProcessor Key '" + child_record_processor.request.table_alias + "' already exists!!");
        }
        this.child_map.put(child_record_processor.request.table_alias, child_record_processor);
    }

    public void deleteChildRecordProcessor(RecordProcessor child_record_processor) {
        this.child_map.remove(child_record_processor.request.table_alias);
    }

    public JsonWriter getResponseOutputWriter() {
        return this.response_output_writer;
    }

    public JsonArray addError(String error) {
        this.error_list.add(error);
        return this.error_list;
    }

    public JsonArray getErrors() {
        return this.error_list;
    }

    public void setAffectedRows(int affected_rows) {
        this.affected_rows = affected_rows;
    }

    public Integer getAffectedRows() {
        return this.affected_rows;
    }

    public <T> void addReturns(String key, T value) {
        this.returns.Returns(key, value);
    }

    public Returns getReturns() {
        return this.returns;
    }

    public Boolean is_select() {
        return this.request.select_list != null;
    }

    public Boolean is_update() {
        return this.request.update_field_map != null;
    }

    public Boolean is_insert() {
        return this.request.insert_field_map != null;
    }

    public Boolean is_delete() {
        return this.request.delete_field_map != null;
    }

    public String getCommand() throws Exception {
        return this.command;
    }

    public Boolean hasErrors() {
        Boolean has_errors = false;
        for (int i = 0; i < this.child_list.size(); ++i) {
            RecordProcessor child_record_processor = this.child_list.get(i);
            has_errors = has_errors != false || child_record_processor.hasErrors() != false;
        }
        return has_errors != false || this.error_list.size() > 0;
    }

    public void printErrors(Gson gson) throws Exception {
        this.name("Record Processing Errors");
        this.beginArray();
        this.printChildErrorList(gson);
        this.endArray();
        this.flush();
    }

    private void printChildErrorList(Gson gson) throws Exception {
        this.beginObject();
        this.name("table");
        this.value(this.request.table_alias);
        this.name("erorrs");
        this.writeJsonElement(gson, (JsonElement)this.error_list);
        this.endObject();
        if (this.child_list == null || this.child_list.size() == 0) {
            return;
        }
        this.beginObject();
        this.name("children");
        this.beginArray();
        for (int i = 0; i < this.child_list.size(); ++i) {
            RecordProcessor child_record_processor = this.child_list.get(i);
            child_record_processor.printChildErrorList(gson);
        }
        this.endArray();
        this.endObject();
    }

    public Boolean hasGroupBy() throws Exception {
        return this.request.group_by_list != null && this.request.group_by_list.size() > 0;
    }

    public void writeJsonElement(Gson gson, JsonElement json_element) throws Exception {
        gson.toJson(json_element, this.response_output_writer);
        this.system_out(json_element);
    }

    public JsonArray extractJsonObjectKeyList(JsonObject json_object) throws Exception {
        JsonArray json_array = new JsonArray();
        for (Map.Entry element : json_object.entrySet()) {
            json_array.add((String)element.getKey());
        }
        return json_array;
    }

    public JsonArray extractJsonObjectValueList(JsonObject json_object) throws Exception {
        JsonArray json_array = new JsonArray();
        for (Map.Entry element : json_object.entrySet()) {
            json_array.add((JsonElement)element.getValue());
        }
        return json_array;
    }

    public void mergeJsonElement(JsonElement json_element) throws Exception {
        this.mergeJsonElement(null, json_element);
    }

    public void mergeJsonElement(String name, JsonElement json_element) throws Exception {
        this.mergeJsonElement(name, json_element, false);
    }

    public void mergeJsonElement(String name, JsonElement json_element, Boolean keep_open) throws Exception {
        if (json_element.isJsonObject()) {
            if (name != null) {
                this.name(name);
            }
            this.beginObject();
            for (Map.Entry element : json_element.getAsJsonObject().entrySet()) {
                this.name((String)element.getKey());
                JsonElement json_object_element = (JsonElement)element.getValue();
                if (json_object_element.isJsonObject()) {
                    this.mergeJsonElement((JsonElement)json_object_element.getAsJsonObject());
                    continue;
                }
                if (json_object_element.isJsonPrimitive()) {
                    this.mergeJsonPrimitive(json_object_element.getAsJsonPrimitive());
                    continue;
                }
                if (!json_object_element.isJsonNull()) continue;
                this.nullValue();
            }
            if (!keep_open.booleanValue()) {
                this.endObject();
            }
        } else if (json_element.isJsonArray()) {
            JsonArray json_array = json_element.getAsJsonArray();
            if (name != null) {
                this.name(name);
            }
            this.beginArray();
            for (int i = 0; i < json_array.size(); ++i) {
                JsonElement json_array_element = json_array.get(i);
                this.mergeJsonElement(json_array_element);
            }
            if (!keep_open.booleanValue()) {
                this.endArray();
            }
        } else if (json_element.isJsonPrimitive()) {
            this.mergeJsonPrimitive(name, json_element.getAsJsonPrimitive());
        } else if (json_element.isJsonNull()) {
            this.nullValue();
        }
    }

    public void addJsonElement(JsonElement json_element) throws Exception {
        if (json_element.isJsonObject()) {
            for (Map.Entry element : json_element.getAsJsonObject().entrySet()) {
                this.name((String)element.getKey());
                JsonElement json_object_element = (JsonElement)element.getValue();
                if (json_object_element.isJsonObject()) {
                    this.mergeJsonElement((JsonElement)json_object_element.getAsJsonObject());
                    continue;
                }
                if (json_object_element.isJsonPrimitive()) {
                    this.mergeJsonPrimitive(json_object_element.getAsJsonPrimitive());
                    continue;
                }
                if (!json_object_element.isJsonNull()) continue;
                this.nullValue();
            }
        } else if (json_element.isJsonArray()) {
            JsonArray json_array = json_element.getAsJsonArray();
            for (int i = 0; i < json_array.size(); ++i) {
                JsonElement json_array_element = json_array.get(i);
                this.mergeJsonElement(json_array_element);
            }
        } else if (json_element.isJsonPrimitive()) {
            this.mergeJsonPrimitive(json_element.getAsJsonPrimitive());
        } else if (json_element.isJsonNull()) {
            this.nullValue();
        }
    }

    public void mergeJsonPrimitive(JsonPrimitive json_primitive) throws Exception {
        this.mergeJsonPrimitive(null, json_primitive);
    }

    public void mergeJsonPrimitive(String name, JsonPrimitive json_primitive) throws Exception {
        if (name != null) {
            this.name(name);
        }
        if (json_primitive.isBoolean()) {
            this.response_output_writer.value(json_primitive.getAsBoolean());
            this.system_out(json_primitive.getAsBoolean());
        } else if (json_primitive.isString()) {
            this.response_output_writer.value(json_primitive.getAsString());
            this.system_out(json_primitive.getAsString());
        } else if (json_primitive.isNumber()) {
            this.response_output_writer.value(json_primitive.getAsNumber());
            this.system_out(json_primitive.getAsNumber());
        }
    }

    public void writeJsonElement(Gson gson, String name, JsonElement json_element) throws Exception {
        this.name(name);
        gson.toJson(json_element, this.response_output_writer);
        this.system_out(gson.toJson(json_element));
    }

    public void beginObject() throws Exception {
        this.response_output_writer.beginObject();
        this.system_out("{");
    }

    public void name(String name) throws Exception {
        this.response_output_writer.name(name);
        this.system_out(name);
    }

    public void beginArray() throws Exception {
        this.response_output_writer.beginArray();
        this.system_out("[");
    }

    public void endArray() throws Exception {
        this.response_output_writer.endArray();
        this.system_out("]");
    }

    public void endObject() throws Exception {
        this.response_output_writer.endObject();
        this.system_out("}");
    }

    public void nullValue() throws Exception {
        this.nullValue(null);
    }

    public void nullValue(String name) throws Exception {
        if (name != null) {
            this.name(name);
        }
        this.response_output_writer.nullValue();
        this.system_out("null");
    }

    public void value(Boolean value) throws Exception {
        this.response_output_writer.value(value);
        this.system_out(value);
    }

    public void value(Number value) throws Exception {
        this.response_output_writer.value(value);
        this.system_out(value);
    }

    public void value(String value) throws Exception {
        this.response_output_writer.value(value);
        this.system_out(value);
    }

    public void value(boolean value) throws Exception {
        this.response_output_writer.value(value);
        this.system_out(value);
    }

    public void value(double value) throws Exception {
        this.response_output_writer.value(value);
        this.system_out(value);
    }

    public void value(float value) throws Exception {
        this.response_output_writer.value(value);
        this.system_out(Float.valueOf(value));
    }

    public void value(long value) throws Exception {
        this.response_output_writer.value(value);
        this.system_out(value);
    }

    public void flush() throws Exception {
        this.response_output_writer.flush();
    }

    private void system_out(Object text) {
        if (this.debug.booleanValue()) {
            System.out.println(text.toString());
        }
    }

    public void query_stats() throws Exception {
        this.name("prepare ");
        this.value((double)Duration.between(this.query.t1, this.query.t2).toNanos() / 1000000.0 + " ms");
        this.name("query ");
        this.value((double)Duration.between(this.query.t2, this.query.t3).toNanos() / 1000000.0 + " ms");
        this.name("process ");
        this.value((double)Duration.between(this.query.t3, this.query.t4).toNanos() / 1000000.0 + " ms");
    }
}

