/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.database;

import com.google.gson.JsonArray;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import net.reyadeyat.api.relational.database.Field;
import net.reyadeyat.api.relational.database.FieldType;

public class ServiceField {
    private String formula;
    private String type;
    private String alias;
    private FieldType fieldType;

    public ServiceField(String formula, String type, String alias, JsonArray errorList) {
        this.formula = formula;
        this.type = type;
        this.alias = alias;
        if (this.type.equalsIgnoreCase("String")) {
            this.fieldType = FieldType.String;
        } else if (this.type.equalsIgnoreCase("Boolean")) {
            this.fieldType = FieldType.Boolean;
        } else if (this.type.equalsIgnoreCase("Integer")) {
            this.fieldType = FieldType.Integer;
        } else if (this.type.equalsIgnoreCase("Long")) {
            this.fieldType = FieldType.Long;
        } else if (this.type.equalsIgnoreCase("Double")) {
            this.fieldType = FieldType.Double;
        } else if (this.type.equalsIgnoreCase("Date")) {
            this.fieldType = FieldType.Date;
        } else if (this.type.equalsIgnoreCase("Time")) {
            this.fieldType = FieldType.Time;
        } else if (this.type.equalsIgnoreCase("Timestamp")) {
            this.fieldType = FieldType.Timestamp;
        } else if (this.type.equalsIgnoreCase("TimeZone")) {
            this.fieldType = FieldType.TimeZone;
        } else {
            errorList.add("ServiceField passed unknown data type '" + this.type + "'");
        }
    }

    public FieldType getFieldDataType() {
        return this.fieldType;
    }

    public String getSelectStatement() {
        return this.formula + " AS " + this.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public Boolean isBoolean() {
        return this.fieldType.isBoolean();
    }

    public Boolean isNumeric() {
        return this.fieldType.isNumeric();
    }

    public Boolean isText() {
        return this.fieldType.isText();
    }

    public Boolean isQuotable() {
        return this.fieldType.isQuotable();
    }

    public Boolean isDateTime() {
        return this.fieldType.isDateTime();
    }

    public Boolean parseBoolean(Object value) throws Exception {
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public String getFieldString(Object field_value) throws Exception {
        if (field_value == null) {
            return null;
        }
        if (field_value instanceof String) {
            if (this.fieldType != FieldType.String && this.fieldType != FieldType.Set) {
                throw new Exception("Field '" + this.alias + "' of type '" + this.fieldType.toString() + "' can't accepts value '" + String.valueOf(field_value) + "' of type 'String'");
            }
            return String.valueOf(field_value);
        }
        if (field_value instanceof Long) {
            return String.valueOf(field_value);
        }
        if (field_value instanceof Integer) {
            return String.valueOf(field_value);
        }
        if (field_value instanceof Double) {
            return String.valueOf(field_value);
        }
        if (field_value instanceof Boolean) {
            return String.valueOf(field_value);
        }
        if (field_value instanceof Date) {
            return Field.getSqlDate((Date)field_value);
        }
        if (field_value instanceof Time) {
            return Field.getSqlTime((Time)field_value);
        }
        if (field_value instanceof Timestamp) {
            return Field.getSqlTimestamp((Timestamp)field_value);
        }
        throw new Exception("getFieldString passed unhandeled instance of type => " + field_value.getClass().getName());
    }
}

