/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.database;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.reyadeyat.api.library.jdbc.JDBCSource;
import net.reyadeyat.api.library.json.JsonResultset;
import net.reyadeyat.api.library.json.JsonUtil;
import net.reyadeyat.api.library.util.Returns;
import net.reyadeyat.api.relational.data.DataClass;
import net.reyadeyat.api.relational.data.DataLookup;
import net.reyadeyat.api.relational.data.DataProcessor;
import net.reyadeyat.api.relational.data.ModelDefinition;
import net.reyadeyat.api.relational.database.Argument;
import net.reyadeyat.api.relational.database.DependentKey;
import net.reyadeyat.api.relational.database.Field;
import net.reyadeyat.api.relational.database.FieldType;
import net.reyadeyat.api.relational.database.ForeignKey;
import net.reyadeyat.api.relational.database.JoinKey;
import net.reyadeyat.api.relational.database.RecordHandler;
import net.reyadeyat.api.relational.database.RecordProcessor;
import net.reyadeyat.api.relational.database.ServiceField;
import net.reyadeyat.api.relational.model.Enterprise;
import net.reyadeyat.api.relational.model.EnterpriseModel;
import net.reyadeyat.api.relational.model.ForeignKeyField;
import net.reyadeyat.api.relational.request.Request;
import net.reyadeyat.api.relational.request.RequestField;
import net.reyadeyat.api.relational.request.RequestTable;

public class Table {
    private String data_datasource_name;
    private String data_database_name;
    private RequestTable request_table;
    private HashMap<String, Field> field_name_map;
    private HashMap<String, Field> field_alias_map;
    private HashMap<String, String> field_name_alias;
    private HashMap<String, String> field_alias_name;
    private ArrayList<Field> field_list;
    private String select_where_condition;
    private ArrayList<Field> select_where_condition_field_list;
    private String updateWhereCondition;
    private ArrayList<Field> updateWhereConditionFields;
    private HashMap<String, ForeignKey> foreignKeys;
    private HashMap<String, DependentKey> dependentKeys;
    private HashMap<String, JoinKey> joinKeys;
    private ArrayList<String> join_sql_list;
    private Boolean hasPrimaryKeyAI;
    private Boolean hasPrimaryKeyMI;
    private Integer countPrimaryKeyAI;
    private Integer countPrimaryKeyMI;
    private ArrayList<ForeignKey> foreign_keys_list;
    private ArrayList<DependentKey> dependent_keys_list;
    private String inner_join_statement;
    protected ArrayList<Field> primary_keys;
    protected ArrayList<Field> primary_keys_manual_increment_fields;
    protected ArrayList<Field> primary_keys_auto_increment_fields;
    protected ArrayList<Field> uniqueness_fields_all;
    protected ArrayList<Field> uniqueness_fields_any;
    protected Boolean hasVariable;
    protected ArrayList<Field> insert_fields;
    protected String valid_insert_fields;
    protected String uniqueness_insert_statement;
    protected String insert_statement;
    protected String insert_set_statement;
    protected ArrayList<String> insert_set_statement_fields_name;
    protected ArrayList<String> insert_set_statement_fields_alias;
    protected String insert_statement_select;
    protected ArrayList<Field> select_fields;
    protected String valid_select_fields;
    protected String select_statement;
    protected String select_statement_from;
    protected ArrayList<Field> select_statement_groupby;
    protected ArrayList<Field> select_statement_orderby;
    protected Boolean safe_update;
    protected ArrayList<Field> update_fields;
    protected String valid_update_fields;
    protected String uniqueness_update_statement;
    protected String update_statement;
    protected String delete_statement;
    private transient Table parent_table;
    private ArrayList<Table> child_table_list;
    private HashMap<String, Table> child_table_map;
    private static HashMap<Integer, EnterpriseModel<Enterprise>> data_model_map = new HashMap();

    public Table(String data_database_name, String data_datasource_name, Integer model_id, Table parent_table, RequestTable request_table, JsonArray table_error_list) throws Exception {
        this.parent_table = parent_table;
        this.data_database_name = data_database_name;
        this.data_datasource_name = data_datasource_name;
        this.request_table = request_table;
        this.field_name_map = new HashMap();
        this.field_alias_map = new HashMap();
        this.field_name_alias = new HashMap();
        this.field_alias_name = new HashMap();
        this.hasPrimaryKeyAI = null;
        this.hasPrimaryKeyMI = null;
        this.field_list = new ArrayList();
        this.join_sql_list = new ArrayList();
        this.joinKeys = new HashMap();
        this.safe_update = true;
        this.initializeTable(model_id, table_error_list);
        this.init(table_error_list);
        if (table_error_list.size() > 0) {
            return;
        }
        this.child_table_map = new HashMap();
        this.child_table_list = new ArrayList();
        if (request_table.child_request_table_list != null && request_table.child_request_table_list.size() > 0) {
            for (int i = 0; i < request_table.child_request_table_list.size(); ++i) {
                RequestTable child_request_table = request_table.child_request_table_list.get(i);
                Table child_table = new Table(data_database_name, data_datasource_name, model_id, this, child_request_table, table_error_list);
                this.child_table_list.add(child_table);
                this.child_table_map.put(child_table.request_table.table_alias, child_table);
            }
        }
    }

    public Boolean init(JsonArray error_list) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (this.data_database_name == null) {
            error_list.add("Database name is not defined");
        }
        if (this.request_table.table_name == null) {
            error_list.add("Table name is not defined");
        }
        this.postInit(error_list);
        this.primary_keys = new ArrayList();
        this.primary_keys_manual_increment_fields = new ArrayList();
        this.primary_keys_auto_increment_fields = new ArrayList();
        this.uniqueness_fields_all = new ArrayList();
        this.uniqueness_fields_any = new ArrayList();
        this.insert_fields = new ArrayList();
        this.select_fields = new ArrayList();
        this.update_fields = new ArrayList();
        this.select_statement_groupby = new ArrayList();
        ArrayList<Field> tabel_field_list = this.getFields();
        HashMap<Integer, Field> order_by_list = new HashMap<Integer, Field>();
        for (Field f : tabel_field_list) {
            if (f.isPrimaryKey().booleanValue()) {
                this.primary_keys.add(f);
            }
            if (f.isPrimaryKeyMI().booleanValue()) {
                this.primary_keys_manual_increment_fields.add(f);
            }
            if (f.isPrimaryKeyAI().booleanValue()) {
                this.primary_keys_auto_increment_fields.add(f);
            }
            if (f.isOrderBy().booleanValue()) {
                order_by_list.put(f.getOrderByOrder(), f);
            }
            if (f.isAllowedTo(Field.INSERT).booleanValue()) {
                this.insert_fields.add(f);
            }
            if (f.isAllowedTo(Field.SELECT).booleanValue()) {
                this.select_fields.add(f);
            }
            if (f.isAllowedTo(Field.UPDATE).booleanValue()) {
                this.update_fields.add(f);
            }
            if (!f.isGroup().booleanValue()) continue;
            this.select_statement_groupby.add(f);
        }
        this.valid_insert_fields = this.insert_fields.size() == 0 ? null : this.fieldAliasToCsv(this.insert_fields);
        this.valid_select_fields = this.select_fields.size() == 0 ? null : this.fieldAliasToCsv(this.select_fields);
        String string = this.valid_update_fields = this.update_fields.size() == 0 ? null : this.fieldAliasToCsv(this.update_fields);
        if (order_by_list != null && order_by_list.size() > 0) {
            this.select_statement_orderby = new ArrayList(order_by_list.size());
            Set keys = order_by_list.keySet();
            ArrayList tkeys = new ArrayList(keys);
            Collections.sort(tkeys);
            for (Integer i : tkeys) {
                this.select_statement_orderby.add((Field)order_by_list.get(i));
            }
        }
        if (this.primary_keys == null) {
            error_list.add("Primary Keys are not defined field_list tableFields");
        }
        if (this.request_table.transaction_type_list.contains("insert")) {
            for (Field f : this.insert_fields) {
                if (f.isUniqueAll().booleanValue()) {
                    this.uniqueness_fields_all.add(f);
                }
                if (f.isUniqueAny().booleanValue()) {
                    this.uniqueness_fields_any.add(f);
                }
                if (!f.isVariable().booleanValue()) continue;
                this.hasVariable = true;
            }
            sb.setLength(0);
            if (this.request_table.transaction_type_list.contains("insert") && this.insert_fields.size() == 0) {
                error_list.add("no valid insert field_list defined");
            } else if (this.request_table.transaction_type_list.contains("insert")) {
                Field field;
                int i;
                sb.setLength(0);
                sb.append("INSERT INTO `").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("` (");
                for (i = 0; i < this.insert_fields.size(); ++i) {
                    field = this.insert_fields.get(i);
                    if (field.isPrimaryKeyAI().booleanValue()) continue;
                    sb.append(field.getSQLInsertName()).append(",");
                }
                sb.delete(sb.length() - 1, sb.length());
                if (!this.hasPrimaryKeyMI().booleanValue()) {
                    sb.append(") VALUES (");
                } else {
                    sb.append(") SELECT ");
                }
                for (i = 0; i < this.insert_fields.size(); ++i) {
                    field = this.insert_fields.get(i);
                    if (field.isPrimaryKeyMI().booleanValue()) {
                        sb.append("IFNULL(MAX(" + field.getSQLName() + "), 0) + 1,");
                        continue;
                    }
                    if (field.isInsertFormulaDefined().booleanValue()) {
                        sb.append(field.getInsertFormulaDefined()).append(",");
                        continue;
                    }
                    sb.append("?,");
                }
                sb.delete(sb.length() - 1, sb.length());
                if (!this.hasPrimaryKeyMI().booleanValue()) {
                    sb.append(")");
                }
                if (this.hasPrimaryKeyMI().booleanValue()) {
                    sb.append(" FROM `").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("`");
                    Integer counter = this.primary_keys.size() - this.countPrimaryKeyMI();
                    if (counter > 0) {
                        sb.append(" WHERE");
                    }
                    for (int i2 = 0; i2 < this.primary_keys.size(); ++i2) {
                        Field field2 = this.primary_keys.get(i2);
                        if (field2.isPrimaryKeyMI().booleanValue()) continue;
                        sb.append(" ").append(field2.getSQLName()).append("=?").append(" AND");
                    }
                    if (counter > 0) {
                        sb.delete(sb.length() - " AND".length(), sb.length());
                    }
                    sb.append(" FOR UPDATE");
                }
                this.insert_statement = sb.toString();
                if (this.insert_set_statement != null) {
                    sb.setLength(0);
                    sb.append("INSERT INTO `").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("` (");
                    for (int i3 = 0; i3 < this.insert_fields.size(); ++i3) {
                        Field f = this.insert_fields.get(i3);
                        if (f.isPrimaryKeyAI().booleanValue()) continue;
                        sb.append(f.getSQLName()).append(",");
                    }
                    sb.delete(sb.length() - 1, sb.length());
                    sb.append(") ");
                    sb.append(this.insert_set_statement);
                    this.insert_set_statement = sb.toString();
                }
                sb.setLength(0);
                if (this.primary_keys.size() > 0 && this.insert_fields.size() > 0) {
                    if (this.hasVariable.booleanValue()) {
                        this.insert_statement_select = null;
                    } else {
                        int i4;
                        sb.append("SELECT ");
                        for (i4 = 0; i4 < tabel_field_list.size(); ++i4) {
                            Field f = tabel_field_list.get(i4);
                            if (!f.getTable().equalsIgnoreCase(this.request_table.table_name)) continue;
                            sb.append(" ").append(f.getSelect(null)).append(",");
                        }
                        sb.replace(sb.length() - 1, sb.length(), " ");
                        sb.append("FROM `").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("` WHERE");
                        for (i4 = 0; i4 < this.insert_fields.size(); ++i4) {
                            Field f = this.insert_fields.get(i4);
                            if (f.isPrimaryKeyAI().booleanValue() || f.isPrimaryKeyMI().booleanValue()) continue;
                            sb.append(" ").append(f.getSQLName()).append(" ").append(f.isNullable() != false ? "<=>?" : "=?").append(i4 + 1 == this.insert_fields.size() ? "" : " AND");
                        }
                        this.insert_statement_select = sb.toString();
                    }
                }
                if (this.primary_keys.size() > 0 || this.uniqueness_fields_all.size() > 0 || this.uniqueness_fields_any.size() > 0) {
                    if (this.hasVariable.booleanValue()) {
                        error_list.add("Uniqueness Statement can't contain variable field");
                    }
                    Boolean hasUniqueness = false;
                    sb.setLength(0);
                    sb.append("SELECT ").append(this.getFieldsFor(Field.INSERT, true));
                    sb.append(" FROM `").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("` WHERE ");
                    Integer primaryKeyIncrement = 0;
                    if (this.primary_keys.size() > 0) {
                        for (int i5 = 0; i5 < this.primary_keys.size(); ++i5) {
                            Field field3 = this.primary_keys.get(i5);
                            if (field3.isPrimaryKeyAI().booleanValue() || field3.isPrimaryKeyMI().booleanValue()) {
                                Integer n = primaryKeyIncrement;
                                primaryKeyIncrement = primaryKeyIncrement + 1;
                                continue;
                            }
                            hasUniqueness = true;
                            sb.append(" ").append(this.primary_keys.get(i5).getSQLName()).append("=?").append(i5 + 1 == this.primary_keys.size() ? "" : " AND");
                        }
                    }
                    if (this.uniqueness_fields_all.size() > 0) {
                        hasUniqueness = true;
                        if (this.primary_keys.size() - primaryKeyIncrement > 0) {
                            sb.append(" AND ");
                        }
                        for (int i6 = 0; i6 < this.uniqueness_fields_all.size(); ++i6) {
                            sb.append(" ").append(this.uniqueness_fields_all.get(i6).getSQLName()).append("=?").append(i6 + 1 == this.uniqueness_fields_all.size() ? "" : " AND");
                        }
                    }
                    if (this.uniqueness_fields_any.size() > 0) {
                        hasUniqueness = true;
                        if (this.primary_keys.size() - primaryKeyIncrement > 0 || this.uniqueness_fields_all.size() > 0) {
                            sb.append(" AND ");
                        }
                        sb.append("(");
                        for (int i7 = 0; i7 < this.uniqueness_fields_any.size(); ++i7) {
                            sb.append(" ").append(this.uniqueness_fields_any.get(i7).getSQLName()).append("=?").append(i7 + 1 == this.uniqueness_fields_any.size() ? "" : " OR");
                        }
                        sb.append(")");
                    }
                    String string2 = this.uniqueness_insert_statement = hasUniqueness == false ? null : sb.toString();
                }
            }
        }
        if (this.request_table.transaction_type_list.contains("select")) {
            sb.setLength(0);
            if (this.request_table.transaction_type_list.contains("select") && this.select_fields.size() == 0) {
                error_list.add("no valid select field_list defined");
            } else if (this.request_table.transaction_type_list.contains("select")) {
                sb.setLength(0);
                if (this.select_statement_from == null) {
                    sb.append("`").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("`").append(" AS `").append(this.request_table.table_alias).append("`");
                    sb.append(this.getInnerJoin());
                    this.select_statement_from = sb.length() == 0 ? null : sb.toString();
                }
                sb.setLength(0);
                if (this.select_statement_from != null) {
                    sb.append("$SELECT$ FROM ").append(this.select_statement_from).append(" $WHERE$ $GROUPBY$ $HAVING$ $ORDERBY$");
                } else {
                    sb.append("$SELECT$ FROM `").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("` $WHERE$ $GROUPBY$ $HAVING$ $ORDERBY$");
                }
                this.select_statement = sb.toString();
            }
        }
        if (this.request_table.transaction_type_list.contains("update")) {
            sb.setLength(0);
            if (this.update_fields == null && this.request_table.transaction_type_list.contains("update")) {
                error_list.add("no valid update field_list defined");
            } else if (this.request_table.transaction_type_list.contains("update")) {
                sb.setLength(0);
                sb.append("UPDATE `").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("` SET $UPDATE$ $WHERE$");
                this.update_statement = sb.toString();
                if (this.uniqueness_fields_all.size() > 0 || this.uniqueness_fields_any.size() > 0) {
                    Boolean hasUniqueness = false;
                    sb.setLength(0);
                    sb.append("SELECT ").append(this.getFieldsFor(Field.UPDATE, true));
                    sb.append(" FROM `").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("` WHERE ");
                    if (this.primary_keys != null) {
                        hasUniqueness = true;
                        for (int i = 0; i < this.primary_keys.size(); ++i) {
                            Field f = this.primary_keys.get(i);
                            sb.append(" ");
                            if (f.isPrimaryKeyAI().booleanValue() || f.isPrimaryKeyMI().booleanValue()) {
                                sb.append(f.getSQLName()).append("<>?");
                            } else {
                                sb.append(f.getSQLName()).append("=?");
                            }
                            sb.append(i + 1 == this.primary_keys.size() ? "" : " AND");
                        }
                    }
                    if (this.uniqueness_fields_all.size() > 0) {
                        hasUniqueness = true;
                        if (this.primary_keys.size() > 0) {
                            sb.append(" AND ");
                        }
                        for (int i = 0; i < this.uniqueness_fields_all.size(); ++i) {
                            sb.append(" ").append(this.uniqueness_fields_all.get(i).getSQLName()).append("=?").append(i + 1 == this.uniqueness_fields_all.size() ? "" : " AND");
                        }
                    }
                    if (this.uniqueness_fields_any.size() > 0) {
                        hasUniqueness = true;
                        if (this.primary_keys.size() > 0 || this.uniqueness_fields_all.size() > 0) {
                            sb.append(" AND ");
                        }
                        sb.append("(");
                        for (int i = 0; i < this.uniqueness_fields_any.size(); ++i) {
                            sb.append(" ").append(this.uniqueness_fields_any.get(i).getSQLName()).append("=?").append(i + 1 == this.uniqueness_fields_any.size() ? "" : " OR");
                        }
                        sb.append(")");
                    }
                    String string3 = this.uniqueness_update_statement = hasUniqueness == false ? null : sb.toString();
                }
            }
        }
        if (this.request_table.transaction_type_list.contains("delete")) {
            sb.setLength(0);
            sb.append("DELETE FROM `").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("` $WHERE$");
            this.delete_statement = sb.toString();
        }
        return error_list.size() > 0;
    }

    public void postInit(JsonArray error_list) {
        this.field_list = new ArrayList<Field>(this.field_name_map.values());
        Collections.sort(this.field_list);
        if (this.joinKeys != null) {
            Set<String> joinKeysSet = this.joinKeys.keySet();
            for (String key : joinKeysSet) {
                JoinKey joinKey = this.joinKeys.get(key);
                joinKey.prepareJoinStatement();
            }
        }
        if (this.foreignKeys != null) {
            Set<String> foreignKeysSet = this.foreignKeys.keySet();
            for (String key : foreignKeysSet) {
                ForeignKey foreignKey = this.foreignKeys.get(key);
                foreignKey.prepareForeinessValidationStatement();
            }
        }
        if (this.dependentKeys != null) {
            Set<String> dependentKeysSet = this.dependentKeys.keySet();
            for (String key : dependentKeysSet) {
                DependentKey dependentKey = this.dependentKeys.get(key);
                dependentKey.prepareDependencyValidationStatement();
            }
        }
    }

    public String getTableName() {
        return this.request_table.table_name;
    }

    public Table getTableTree() {
        return this;
    }

    public Field getNamedField(String name) {
        return this.field_name_map.get(name);
    }

    public Field getAliasedField(String alias) {
        return this.field_alias_map.get(alias);
    }

    public ArrayList<Field> getFields() {
        return this.field_list;
    }

    public HashMap<String, Field> getNamedFieldMap() {
        return this.field_name_map;
    }

    public HashMap<String, Field> getAliasedFieldMap() {
        return this.field_alias_map;
    }

    private void checkDuplicity(Field field, JsonArray table_error_list) {
        for (Field f : this.field_list) {
            if (this.request_table.table_name.equalsIgnoreCase(f.getTable()) && !f.isVariable().booleanValue() && !f.hasFormulaDefined().booleanValue() && f.getName().equalsIgnoreCase(field.getName())) {
                table_error_list.add("Field name '" + f.getTable() + "'.'" + f.getName() + "' is duplicated");
            }
            if (!this.request_table.table_name.equalsIgnoreCase(f.getTable()) || f.isVariable().booleanValue() || f.hasFormulaDefined().booleanValue() || !f.getAlias().equalsIgnoreCase(field.getAlias())) continue;
            table_error_list.add("Field alias '" + f.getTable() + "'.'" + f.getAlias() + "' is duplicated");
        }
    }

    public Field addField(String table_name, String table_alias, String field_name, String field_alias, Boolean nullable, Boolean group_by, FieldType field_type, JsonArray table_error_list) {
        Field field = new Field(table_name, table_alias, this.field_list.size(), field_name, field_alias, nullable, group_by, field_type, table_error_list);
        if (table_error_list.size() > 0) {
            return field;
        }
        this.checkDuplicity(field, table_error_list);
        this.field_list.add(field);
        this.field_name_map.put(field_name, field);
        this.field_alias_map.put(field_alias, field);
        this.field_name_alias.put(field_name, field_alias);
        this.field_alias_name.put(field_alias, field_name);
        return field;
    }

    public Boolean hasSelectWhereCondition() {
        return this.select_where_condition != null;
    }

    public void addSelectWhereCondition(String[] field_list, String select_where_condition) {
        this.select_where_condition = select_where_condition;
        this.select_where_condition_field_list = new ArrayList();
        for (String fieldName : field_list) {
            Field field = this.field_name_map.get(fieldName);
            this.select_where_condition_field_list.add(field);
        }
    }

    public String getSelectWhereCondition() {
        return this.select_where_condition;
    }

    public ArrayList<Field> getSelectWhereConditionFields() {
        return this.select_where_condition_field_list;
    }

    public Boolean hasUpdateWhereCondition() {
        return this.updateWhereCondition != null;
    }

    public void addUpdateWhereCondition(String[] field_list, String updateWhereCondition) {
        this.updateWhereCondition = updateWhereCondition;
        this.updateWhereConditionFields = new ArrayList();
        for (String fieldName : field_list) {
            Field field = this.field_name_map.get(fieldName);
            this.updateWhereConditionFields.add(field);
        }
    }

    public String getUpdateWhereCondition() {
        return this.updateWhereCondition;
    }

    public ArrayList<Field> getUpdateWhereConditionFields() {
        return this.updateWhereConditionFields;
    }

    private void addForeignKey(String key, String foreign_table_name, String foreign_table_alias) {
        HashMap<Object, Object> hashMap = this.foreignKeys = this.foreignKeys != null ? this.foreignKeys : new HashMap();
        if (this.foreignKeys.get(key) == null) {
            this.foreignKeys.put(key, new ForeignKey(key, this.data_database_name, foreign_table_name, foreign_table_alias));
        }
    }

    public void addForeignField(String key, String table_field_alias, String foreign_table_name, String foreign_table_alias, String foreign_field_alias, JsonArray table_error_list) {
        if (this.field_alias_map.get(table_field_alias) == null) {
            table_error_list.add("Field alias '" + table_field_alias + "' is not exist in table '" + this.request_table.table_alias + "'");
            return;
        }
        Field field = this.field_alias_map.get(table_field_alias);
        this.addForeignKey(key, foreign_table_name, foreign_table_alias);
        ForeignKey foreignKey = this.foreignKeys.get(key);
        foreignKey.addForeignField(field, foreign_field_alias);
    }

    private void addDependentKey(String key, String dependent_table) {
        HashMap<Object, Object> hashMap = this.dependentKeys = this.dependentKeys != null ? this.dependentKeys : new HashMap();
        if (this.dependentKeys.get(key) == null) {
            this.dependentKeys.put(key, new DependentKey(key, this.data_database_name, dependent_table));
        }
    }

    public void addDependentField(String key, String dependent_table, String field_alias, String dependent_field_alias, JsonArray table_error_list) {
        if (this.field_alias_map.get(field_alias) == null) {
            table_error_list.add("Field alias '" + field_alias + "' is not exist in table '" + this.request_table.table_name + "'");
            return;
        }
        Field field = this.field_alias_map.get(field_alias);
        this.addDependentKey(key, dependent_table);
        DependentKey dependentKey = this.dependentKeys.get(key);
        dependentKey.addDependentField(field, dependent_field_alias);
    }

    public void addJoinSQL(String join_sql) {
        this.join_sql_list.add(join_sql);
    }

    private void addJoinKey(String key, String join_table, String join_table_alias, JoinKey.JoinType join_type) {
        if (this.joinKeys.get(key) == null) {
            this.joinKeys.put(key, new JoinKey(key, this.data_database_name, this.request_table.table_name, this.request_table.table_alias, join_table, join_table_alias, join_type));
        }
    }

    public void addJoinField(String key, String join_table_name, String join_table_alias, String field_alias, String join_field_name, JoinKey.JoinType join_type, JsonArray table_error_list) {
        if (this.field_name_map.get(field_alias) == null) {
            table_error_list.add("Field alias '" + field_alias + "' is not exist in table '" + this.request_table.table_name + "'");
            return;
        }
        Field field = this.field_name_map.get(field_alias);
        this.addJoinKey(key, join_table_name, join_table_alias, join_type);
        JoinKey joinKey = this.joinKeys.get(key);
        joinKey.addJoinField(field, join_field_name);
    }

    private void prepareJoin() {
        if (this.joinKeys == null) {
            this.inner_join_statement = "";
            return;
        }
        StringBuilder fks = new StringBuilder();
        ArrayList<String> joinKeySet = new ArrayList<String>(this.joinKeys.keySet());
        for (int i = 0; i < joinKeySet.size(); ++i) {
            String join_field = joinKeySet.get(i);
            JoinKey joinKey = this.joinKeys.get(join_field);
            fks.append(joinKey.getJoinStatement());
        }
        for (String free_join_sql : this.join_sql_list) {
            fks.append(" ").append(free_join_sql);
        }
        this.inner_join_statement = fks.toString();
    }

    public String getInnerJoin() {
        if (this.inner_join_statement == null) {
            this.prepareJoin();
        }
        return this.inner_join_statement;
    }

    public ArrayList<ForeignKey> getForeignKeys() {
        if (this.foreign_keys_list == null) {
            this.foreign_keys_list = this.foreignKeys == null ? new ArrayList() : new ArrayList<ForeignKey>(this.foreignKeys.values());
        }
        return this.foreign_keys_list;
    }

    public ArrayList<DependentKey> getDepenencyKeys() {
        if (this.dependent_keys_list == null) {
            this.dependent_keys_list = this.dependentKeys == null ? new ArrayList() : new ArrayList<DependentKey>(this.dependentKeys.values());
        }
        return this.dependent_keys_list;
    }

    public Boolean hasPrimaryKeyAI() {
        if (this.hasPrimaryKeyAI == null) {
            this.hasPrimaryKeyAI = false;
            for (Field field : this.field_list) {
                if (!field.isPrimaryKeyAI().booleanValue()) continue;
                this.hasPrimaryKeyAI = true;
                break;
            }
        }
        return this.hasPrimaryKeyAI;
    }

    public Integer countPrimaryKeyAI() {
        if (this.countPrimaryKeyAI == null) {
            this.countPrimaryKeyAI = 0;
            for (Field field : this.field_list) {
                if (!field.isPrimaryKeyMI().booleanValue()) continue;
                Integer n = this.countPrimaryKeyAI;
                this.countPrimaryKeyAI = this.countPrimaryKeyAI + 1;
            }
        }
        return this.countPrimaryKeyAI;
    }

    public Boolean hasPrimaryKeyMI() {
        if (this.hasPrimaryKeyMI == null) {
            this.hasPrimaryKeyMI = false;
            for (Field field : this.field_list) {
                if (!field.isPrimaryKeyMI().booleanValue()) continue;
                this.hasPrimaryKeyMI = true;
                break;
            }
        }
        return this.hasPrimaryKeyMI;
    }

    public Integer countPrimaryKeyMI() {
        if (this.countPrimaryKeyMI == null) {
            this.countPrimaryKeyMI = 0;
            for (Field field : this.field_list) {
                if (!field.isPrimaryKeyMI().booleanValue()) continue;
                Integer n = this.countPrimaryKeyMI;
                this.countPrimaryKeyMI = this.countPrimaryKeyMI + 1;
            }
        }
        return this.countPrimaryKeyMI;
    }

    private String createRuntimeInsertStatementSelect(Map<String, String> variables) throws Exception {
        Field f;
        int i;
        StringBuilder sb = new StringBuilder();
        ArrayList<Field> tabel_fields = this.getFields();
        sb.append("SELECT ");
        for (i = 0; i < tabel_fields.size(); ++i) {
            f = tabel_fields.get(i);
            if (!f.getTable().equalsIgnoreCase(this.request_table.table_name)) continue;
            if (!f.isVariable().booleanValue()) {
                sb.append(" ").append(f.getSelect()).append(",");
                continue;
            }
            sb.append(" ").append(f.getSelect(variables)).append(",");
        }
        sb.replace(sb.length() - 1, sb.length(), " ");
        sb.append("FROM `").append(this.data_database_name).append("`.`").append(this.request_table.table_name).append("` WHERE");
        for (i = 0; i < this.insert_fields.size(); ++i) {
            f = this.insert_fields.get(i);
            if (f.isPrimaryKeyAI().booleanValue() || f.isPrimaryKeyMI().booleanValue()) continue;
            sb.append(" ").append(f.getSQLName()).append(" ").append(f.isNullable() != false ? "<=>?" : "=?").append(i + 1 == this.insert_fields.size() ? "" : " AND");
        }
        this.insert_statement_select = null;
        return sb.toString();
    }

    public void validateInserFields(JsonArray error_list) {
        if (this.insert_fields == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'insert_fields' is null");
        } else if (this.valid_insert_fields == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'valid_insert_fields' is null");
        } else if (this.insert_statement == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'insert_statement' is null");
        }
    }

    public void validateSelectFields(JsonArray error_list) {
        if (this.select_fields == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'select_fields' is null");
        } else if (this.valid_select_fields == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'valid_select_fields' is null");
        } else if (this.select_statement == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'select_statement' is null");
        }
    }

    public void validateUpdateFields(JsonArray error_list) {
        if (this.update_fields == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'update_fields' is null");
        } else if (this.valid_update_fields == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'valid_update_fields' is null");
        } else if (this.update_statement == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'update_statement' is null");
        }
    }

    public void validateDeleteFields(JsonArray error_list) {
        if (this.delete_statement == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'delete_statement' is null");
        }
    }

    protected void defineInsertSet(String insert_set_statement) {
        this.insert_set_statement = insert_set_statement;
        this.insert_set_statement_fields_name = new ArrayList();
        this.insert_set_statement_fields_alias = new ArrayList();
        String b = insert_set_statement.substring(7, insert_set_statement.indexOf("FROM"));
        String[] ff = b.split(",");
        for (int i = 0; i < ff.length; ++i) {
            String[] fff = ff[i].split("AS");
            this.insert_set_statement_fields_name.add(fff[0].trim());
            this.insert_set_statement_fields_alias.add(fff[1].replace("`", "").replace(",", "").trim());
        }
    }

    protected void defineSafeUpdate(Boolean safe_update) {
        this.safe_update = safe_update;
    }

    public Boolean mustSafeUpdate() {
        return this.safe_update;
    }

    protected void addForeignKey(String key, String table_field_alias, String foreign_table_name, String foreign_table_alias, String foreign_field_alias, JsonArray table_error_list) {
        this.addForeignField(key, table_field_alias, foreign_table_name, foreign_table_alias, foreign_field_alias, table_error_list);
    }

    protected void addDependentKey(String key, String field_alias, String dependendTable, String dependendField, JsonArray table_error_list) {
        this.addDependentField(key, dependendTable, field_alias, dependendField, table_error_list);
    }

    protected Table getTable() {
        return this;
    }

    protected Object getNamedFieldObject(String field_name, String string) throws Exception {
        return this.getNamedField(field_name).getFieldObject(string);
    }

    protected Object getAliasedFieldObject(String field_name, String string) throws Exception {
        return this.getAliasedField(field_name).getFieldObject(string);
    }

    public Boolean validateInsertUniqueness(Connection con, JsonObject json, JsonArray error_list) throws Exception {
        if (this.uniqueness_insert_statement != null) {
            JsonArray values = json.get("values").getAsJsonArray();
            for (int oo = 0; oo < values.size(); ++oo) {
                JsonObject o = values.get(oo).getAsJsonObject();
                try (PreparedStatement preparedInsertedSelectStmt = con.prepareStatement(this.uniqueness_insert_statement);){
                    String fieldValue;
                    JsonElement fje;
                    Field f;
                    int i;
                    int idx = 0;
                    if (this.primary_keys.size() > 0) {
                        for (i = 0; i < this.primary_keys.size(); ++i) {
                            f = this.primary_keys.get(i);
                            if (f.isPrimaryKeyAI().booleanValue() || f.isPrimaryKeyMI().booleanValue()) continue;
                            fje = o.get(this.primary_keys.get(i).getAlias());
                            fieldValue = fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    if (this.uniqueness_fields_all.size() > 0) {
                        for (i = 0; i < this.uniqueness_fields_all.size(); ++i) {
                            f = this.uniqueness_fields_all.get(i);
                            fje = o.get(this.uniqueness_fields_all.get(i).getAlias());
                            fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    if (this.uniqueness_fields_any.size() > 0) {
                        for (i = 0; i < this.uniqueness_fields_any.size(); ++i) {
                            f = this.uniqueness_fields_any.get(i);
                            fje = o.get(this.uniqueness_fields_any.get(i).getAlias());
                            fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    try (ResultSet resultset = preparedInsertedSelectStmt.executeQuery();){
                        while (resultset.next()) {
                            Field f2;
                            int i2;
                            StringBuilder sb = new StringBuilder();
                            StringBuilder ssb = new StringBuilder();
                            for (i2 = 0; i2 < this.primary_keys.size(); ++i2) {
                                f2 = this.primary_keys.get(i2);
                                ssb.append("'").append(this.primary_keys.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(resultset.getString(this.primary_keys.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            if (ssb.length() > 0) {
                                ssb.delete(ssb.length() - 1, ssb.length());
                                error_list.add("Record with [Primary Keys] unique values {" + ssb.toString() + "," + sb.toString() + "} already exists");
                            }
                            ssb.setLength(0);
                            sb.setLength(0);
                            for (i2 = 0; i2 < this.uniqueness_fields_all.size(); ++i2) {
                                f2 = this.uniqueness_fields_all.get(i2);
                                sb.append("'").append(this.uniqueness_fields_all.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(resultset.getString(this.uniqueness_fields_all.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            if (sb.length() > 0) {
                                sb.delete(sb.length() - 1, sb.length());
                                error_list.add("Record with [all] unique values {" + sb.toString() + "} already exists");
                            }
                            sb.setLength(0);
                            for (i2 = 0; i2 < this.uniqueness_fields_any.size(); ++i2) {
                                f2 = this.uniqueness_fields_any.get(i2);
                                sb.append("'").append(this.uniqueness_fields_any.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(resultset.getString(this.uniqueness_fields_any.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            if (sb.length() <= 0) continue;
                            sb.delete(sb.length() - 1, sb.length());
                            error_list.add("Record with [any] unique values {" + sb.toString() + "} already exists");
                        }
                        resultset.close();
                    }
                    preparedInsertedSelectStmt.close();
                    continue;
                }
            }
        }
        return error_list.size() == 0;
    }

    public Boolean validateUpdateUniqueness(Connection con, JsonObject json, JsonArray error_list) throws Exception {
        if (this.uniqueness_update_statement != null) {
            JsonArray values = json.get("values").getAsJsonArray();
            for (int oo = 0; oo < values.size(); ++oo) {
                JsonObject o = values.get(oo).getAsJsonObject();
                StringBuilder mpk = null;
                JsonObject where = JsonUtil.getJsonObject((JsonObject)json, (String)"where", (Boolean)false);
                JsonArray where_value_list = JsonUtil.getJsonArray((JsonObject)where, (String)"values", (Boolean)true);
                JsonArray where_field_list = JsonUtil.getJsonArray((JsonObject)where, (String)"field_list", (Boolean)true);
                if (where_field_list != null) {
                    for (int i = 0; i < this.primary_keys.size(); ++i) {
                        Field field = this.primary_keys.get(i);
                        if (o.get(field.getAlias()) != null) continue;
                        if (mpk == null) {
                            mpk = new StringBuilder();
                            mpk.append("Safe Update can't continue, missing Primary Key {");
                        }
                        mpk.append(field.getAlias()).append(",");
                    }
                }
                if (mpk != null) {
                    mpk.delete(mpk.length() - 1, mpk.length());
                    mpk.append("}, check in group index[").append(oo + 1).append("]");
                    error_list.add(mpk.toString());
                    return false;
                }
                try (PreparedStatement preparedInsertedSelectStmt = con.prepareStatement(this.uniqueness_update_statement);){
                    String fieldValue;
                    JsonElement fje;
                    Field f;
                    int i;
                    int idx = 0;
                    if (this.primary_keys.size() > 0) {
                        for (i = 0; i < this.primary_keys.size(); ++i) {
                            f = this.primary_keys.get(i);
                            fje = o.get(this.primary_keys.get(i).getAlias());
                            fieldValue = fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    if (this.uniqueness_fields_all.size() > 0) {
                        for (i = 0; i < this.uniqueness_fields_all.size(); ++i) {
                            f = this.uniqueness_fields_all.get(i);
                            fje = o.get(this.uniqueness_fields_all.get(i).getAlias());
                            fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    if (this.uniqueness_fields_any.size() > 0) {
                        for (i = 0; i < this.uniqueness_fields_any.size(); ++i) {
                            f = this.uniqueness_fields_any.get(i);
                            fje = o.get(this.uniqueness_fields_any.get(i).getAlias());
                            fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    try (ResultSet resultset = preparedInsertedSelectStmt.executeQuery();){
                        while (resultset.next()) {
                            Field f2;
                            int i2;
                            StringBuilder sb = new StringBuilder();
                            StringBuilder ssb = new StringBuilder();
                            for (i2 = 0; i2 < this.primary_keys.size(); ++i2) {
                                f2 = this.primary_keys.get(i2);
                                ssb.append("'").append(this.primary_keys.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(resultset.getString(this.primary_keys.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            StringBuilder stringBuilder = ssb = ssb.length() > 1 ? ssb.delete(ssb.length() - 1, ssb.length()) : ssb;
                            if (ssb.length() > 0) {
                                ssb.delete(ssb.length() - 1, ssb.length());
                                error_list.add("Record with [Primary Keys] unique values {" + ssb.toString() + "," + sb.toString() + "} already exists");
                            }
                            ssb.setLength(0);
                            sb.setLength(0);
                            for (i2 = 0; i2 < this.uniqueness_fields_all.size(); ++i2) {
                                f2 = this.uniqueness_fields_all.get(i2);
                                sb.append("'").append(this.uniqueness_fields_all.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(resultset.getString(this.uniqueness_fields_all.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            if (sb.length() > 0) {
                                sb.delete(sb.length() - 1, sb.length());
                                error_list.add("Record with [all] unique values {" + sb.toString() + "} already exists");
                            }
                            sb.setLength(0);
                            for (i2 = 0; i2 < this.uniqueness_fields_any.size(); ++i2) {
                                f2 = this.uniqueness_fields_any.get(i2);
                                sb.append("'").append(this.uniqueness_fields_any.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(resultset.getString(this.uniqueness_fields_any.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            if (sb.length() <= 0) continue;
                            sb.delete(sb.length() - 1, sb.length());
                            error_list.add("Record with [any] unique values {" + sb.toString() + "} already exists");
                        }
                        resultset.close();
                    }
                    preparedInsertedSelectStmt.close();
                    continue;
                }
            }
        }
        return error_list.size() == 0;
    }

    public Boolean validateInsertForeignness(Connection con, JsonObject json, JsonArray error_list) throws Exception {
        ArrayList<ForeignKey> foreignKeys = this.getForeignKeys();
        if (foreignKeys.size() == 0) {
            return true;
        }
        JsonArray values = json.get("values").getAsJsonArray();
        for (ForeignKey foreignKey : foreignKeys) {
            JsonObject o;
            int oo;
            ArrayList<Field> field_list = foreignKey.getFields();
            ArrayList<Integer> nullableRecords = new ArrayList<Integer>();
            for (oo = 0; oo < values.size(); ++oo) {
                o = values.get(oo).getAsJsonObject();
                Integer nullables = 0;
                for (int i = 0; i < field_list.size(); ++i) {
                    String fieldValue;
                    Field f = field_list.get(i);
                    JsonElement fje = o.get(f.getAlias());
                    String string = fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                    if (!f.isNullable().booleanValue() || fieldValue != null) continue;
                    Integer n = nullables;
                    nullables = nullables + 1;
                }
                nullableRecords.add(nullables);
                if (nullables <= 0 || nullables.intValue() == field_list.size()) continue;
                error_list.add("Foreign Key '" + foreignKey.getKey() + "' for Table '" + foreignKey.getForeignTableName() + "' has mixed keys {null} values check index [" + oo + "], either or null or all non-null}");
            }
            for (oo = 0; error_list.size() == 0 && oo < values.size(); ++oo) {
                if ((Integer)nullableRecords.get(oo) > 0) continue;
                o = values.get(oo).getAsJsonObject();
                String foreignness_statement = foreignKey.getForeinessValidationStatement();
                try (PreparedStatement preparedInsertedSelectStmt = con.prepareStatement(foreignness_statement);){
                    int idx = 0;
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < field_list.size(); ++i) {
                        Field f = field_list.get(i);
                        JsonElement fje = o.get(f.getAlias());
                        String fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                        preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        sb.append("`").append(foreignKey.getForeignTableAlias()).append("`.`").append(foreignKey.getForeignField(f)).append("`=").append(fieldValue).append(",");
                    }
                    sb.delete(sb.length() - 1, sb.length());
                    String s = sb.toString();
                    try (ResultSet resultset = preparedInsertedSelectStmt.executeQuery();){
                        if (!resultset.next()) {
                            error_list.add("Table '" + foreignKey.getForeignTableAlias() + "' doesn't have record with {" + s + "}");
                        }
                        resultset.close();
                    }
                    preparedInsertedSelectStmt.close();
                    continue;
                }
            }
        }
        return error_list.size() == 0;
    }

    public Boolean validateUpdateForeignness(Connection con, JsonObject json, JsonArray error_list) throws Exception {
        ArrayList<ForeignKey> foreignKeys = this.getForeignKeys();
        if (foreignKeys.size() > 0) {
            JsonArray values = json.get("values").getAsJsonArray();
            for (ForeignKey foreignKey : foreignKeys) {
                JsonObject o;
                int oo;
                ArrayList<Field> field_list = foreignKey.getFields();
                Integer checkForeignKeyUpdate = field_list.size();
                StringBuilder sb = new StringBuilder();
                String foreignness_statement = foreignKey.getForeinessValidationStatement();
                Boolean skipForeignKeyCheck = false;
                for (oo = 0; oo < 1; ++oo) {
                    o = values.get(oo).getAsJsonObject();
                    for (int i = 0; i < field_list.size(); ++i) {
                        Field f = field_list.get(i);
                        JsonElement je = o.get(f.getAlias());
                        if (je == null) {
                            sb.append(f.getAlias()).append(",");
                        }
                        checkForeignKeyUpdate = checkForeignKeyUpdate + (je == null ? 0 : -1);
                    }
                    StringBuilder stringBuilder = sb = sb.length() == 0 ? sb : sb.delete(sb.length() - 1, sb.length());
                    if (checkForeignKeyUpdate.intValue() == field_list.size()) {
                        skipForeignKeyCheck = true;
                        continue;
                    }
                    if (checkForeignKeyUpdate == 0) continue;
                    error_list.add("Table '" + foreignKey.getForeignTableAlias() + "' missing '" + (field_list.size() - checkForeignKeyUpdate) + "' foreign keys '" + foreignKey.getKey() + "' keys {" + sb.toString() + "}");
                    return false;
                }
                if (skipForeignKeyCheck.booleanValue()) continue;
                for (oo = 0; oo < values.size(); ++oo) {
                    o = values.get(oo).getAsJsonObject();
                    try (PreparedStatement preparedInsertedSelectStmt = con.prepareStatement(foreignness_statement);){
                        int idx = 0;
                        sb.setLength(0);
                        for (int i = 0; i < field_list.size(); ++i) {
                            Field f = field_list.get(i);
                            JsonElement fje = o.get(f.getAlias());
                            String fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                            sb.append("`").append(foreignKey.getForeignTableAlias()).append("`.`").append(foreignKey.getForeignField(f)).append("`=").append(fieldValue).append(",");
                        }
                        sb.delete(sb.length() - 1, sb.length());
                        String s = sb.toString();
                        try (ResultSet resultset = preparedInsertedSelectStmt.executeQuery();){
                            if (!resultset.next()) {
                                error_list.add("Table '" + foreignKey.getForeignTableAlias() + "' doesn't have record with {" + s + "}");
                            }
                            resultset.close();
                        }
                        preparedInsertedSelectStmt.close();
                        continue;
                    }
                }
            }
        }
        return error_list.size() == 0;
    }

    protected Boolean getBoolean(ResultSet resultset, String field) throws Exception {
        return resultset.getObject(field) == null ? null : Boolean.valueOf(resultset.getBoolean(field));
    }

    protected Integer getInt(ResultSet resultset, String field) throws Exception {
        return resultset.getObject(field) == null ? null : Integer.valueOf(resultset.getInt(field));
    }

    protected Long getLong(ResultSet resultset, String field) throws Exception {
        return resultset.getObject(field) == null ? null : Long.valueOf(resultset.getLong(field));
    }

    protected Double getDouble(ResultSet resultset, String field) throws Exception {
        return resultset.getObject(field) == null ? null : Double.valueOf(resultset.getDouble(field));
    }

    protected Date getDate(ResultSet resultset, String field) throws Exception {
        return resultset.getObject(field) == null ? null : resultset.getDate(field);
    }

    protected Time getTime(ResultSet resultset, String field) throws Exception {
        return resultset.getObject(field) == null ? null : resultset.getTime(field);
    }

    protected Timestamp getTimestamp(ResultSet resultset, String field) throws Exception {
        return resultset.getObject(field) == null ? null : resultset.getTimestamp(field);
    }

    protected String getString(ResultSet resultset, String field) throws Exception {
        return resultset.getObject(field) == null ? null : resultset.getString(field);
    }

    private ServiceField isValidServiceField(RecordProcessor record_processor, String serviceField, Map<String, Field> record) {
        int pos1 = serviceField.indexOf(" AS ");
        if (pos1 == -1) {
            return null;
        }
        int pos2 = serviceField.indexOf(" ", pos1 + 5);
        if (pos2 == -1) {
            return null;
        }
        String formula = serviceField.substring(0, pos1);
        String type = serviceField.substring(pos1 + 4, pos2);
        String alias = serviceField.substring(pos2 + 1);
        if (record.containsKey(alias)) {
            record_processor.addError("Service Field '" + serviceField + "' has alias '" + alias + "' that is already defined as Table Field");
            return null;
        }
        return new ServiceField(formula, type, alias, record_processor.error_list);
    }

    protected boolean areValidSelectFields(RecordProcessor record_processor, List<ServiceField> serviceFields, Map<String, Field> record, List<Field> field_list) {
        List<String> field = record_processor.request.select_list;
        for (int i = 0; i < this.select_fields.size(); ++i) {
            Field f = this.select_fields.get(i);
            if (!f.isMandatoryFor(Field.SELECT).booleanValue()) continue;
            Boolean found = false;
            for (int x = 0; x < field.size(); ++x) {
                if (!f.getAlias().equalsIgnoreCase(field.get(x))) continue;
                found = true;
                break;
            }
            if (found.booleanValue()) continue;
            if (!f.hasDefaultValueFor(Field.SELECT).booleanValue()) {
                record_processor.addError("Field '" + f.getAlias() + "' is mandatory to be exist in select list");
                continue;
            }
            if (!f.hasDefaultValueFor(Field.SELECT).booleanValue()) continue;
        }
        return record_processor.hasErrors() == false;
    }

    protected boolean areValidUpdateFieldsValues(RecordProcessor record_processor, Map<String, Field> field_name_map, JsonArray recordset, List<String> conditional_field_list, ArrayList<Field> field_list, JsonArray error_list) throws Exception {
        StringBuilder error = new StringBuilder();
        for (int i = 0; i < recordset.size(); ++i) {
            JsonObject record = recordset.get(i).getAsJsonObject();
            for (String fieldName : record.keySet()) {
                Field f = field_name_map.get(fieldName);
                if (f != null && !f.isPrimaryKey().booleanValue() && !f.isAllowedTo(Field.UPDATE).booleanValue()) {
                    record_processor.addError("Field '" + fieldName + "' is not allowed in update operation");
                    continue;
                }
                if (f == null && conditional_field_list != null && !conditional_field_list.contains(fieldName)) {
                    record_processor.addError("Field '" + fieldName + "' is not a valid condition field name, check record[" + (i + 1) + "]");
                    continue;
                }
                if (conditional_field_list == null && f == null) {
                    record_processor.addError("Field '" + fieldName + "' is not a valid field name, check record[" + (i + 1) + "]");
                    continue;
                }
                if (conditional_field_list == null && !field_list.contains(f)) {
                    record_processor.addError("Field '" + fieldName + "' is not allowed field to be updated, check record[" + (i + 1) + "]");
                    continue;
                }
                if (conditional_field_list == null && record.get(fieldName) != null && f != null && !f.isNullable().booleanValue() && record.get(fieldName).isJsonNull()) {
                    record_processor.addError("Field '" + fieldName + "' doesn't accept null values, check record[" + (i + 1) + "]");
                    continue;
                }
                if (conditional_field_list != null || f.isValid(Field.UPDATE, record.get(fieldName) == null || record.get(fieldName).isJsonNull() ? null : record.get(fieldName).getAsString(), error).booleanValue()) continue;
                record_processor.addError(error.toString() + ", check record[" + (i + 1) + "]");
            }
            for (Field f : field_name_map.values()) {
                JsonElement fje;
                String field_alias = f.getAlias();
                if (record.has(field_alias) || !f.hasDefaultValueFor(Field.UPDATE).booleanValue() || (fje = record.get(f.getAlias())) != null && !fje.isJsonNull()) continue;
                record.addProperty(f.getAlias(), f.getDefaultSQLValueFor(Field.UPDATE, error_list));
            }
            for (int x = 0; conditional_field_list != null && x < conditional_field_list.size(); ++x) {
                String fieldName;
                fieldName = conditional_field_list.get(x);
                if (record.get(fieldName) != null) continue;
                record_processor.addError("Field '" + fieldName + "', in {where.field_list} doesn't exist in values record, check record[" + (i + 1) + "]");
            }
        }
        return record_processor.hasErrors() == false;
    }

    public static final Boolean isValidClause(RecordProcessor record_processor, Integer operation, String ii, Map<String, Field> r, List<Field> wf, List<String> vv, StringBuilder wc, StringBuilder hc, List<Argument> wa, List<Argument> ha) throws Exception {
        ArrayList<String> keyword = new ArrayList<String>(Arrays.asList("asc", "desc", "between", "in", "like", "and", "or", "is", "null"));
        String symbol = "/*-+(?)'[]|<=>,;:\\\r\n\t ";
        String ignore = "\r\n\t ";
        Character sc = Character.valueOf('\'');
        Character esc = Character.valueOf('\'');
        Object escr = null;
        StringBuilder b = new StringBuilder();
        StringBuilder e = new StringBuilder();
        ArrayList<String> mm = new ArrayList<String>();
        boolean s = false;
        boolean p = false;
        boolean h = false;
        char nc = '\u0000';
        char pc = '\u0000';
        char c = '\u0000';
        int l = ii.length();
        for (int x = 0; x < l; ++x) {
            c = ii.charAt(x);
            char c2 = nc = x == l - 1 ? (char)'\u0000' : ii.charAt(x + 1);
            if (!s && symbol.indexOf(c) > -1) {
                if (b.length() > 0) {
                    mm.add(b.toString());
                    b.delete(0, b.length());
                }
                if (ignore.indexOf(c) > -1) {
                    b.setLength(0);
                    continue;
                }
                if (symbol.indexOf(c) > -1) {
                    if (b.length() > 0) {
                        mm.add(b.toString());
                        b.setLength(0);
                    }
                    mm.add(String.valueOf(c));
                }
                if (!s && c == sc.charValue()) {
                    s = true;
                }
            } else if (s && c == esc.charValue() && nc == sc.charValue()) {
                if (escr == null) {
                    b.append(esc).append(sc);
                } else {
                    b.append((Object)escr);
                }
                ++x;
            } else if (s && c == sc.charValue()) {
                if (b.length() > 0) {
                    mm.add(b.toString());
                    b.setLength(0);
                }
                mm.add(String.valueOf(c));
                s = false;
            } else {
                b.append(c);
            }
            pc = c;
        }
        if (b.length() > 0) {
            mm.add(b.toString());
            b.delete(0, b.length());
        }
        b.setLength(0);
        int ml = mm.size();
        int vi = -1;
        String sm = "";
        for (int i = 0; i < ml; ++i) {
            sm = (String)mm.get(i);
            if (r.get(sm) != null) {
                Field f = r.get(sm);
                wf.add(f);
                h = f.isGroup();
                (h ? ha : wa).add(new Argument(f));
                (h ? hc : wc).append(h ? f.getHaving() : f.getSQLName()).append(" ");
                sm = (String)mm.get(++i);
                if (sm == null) {
                    record_processor.addError("Clause statement is incomplete");
                    return false;
                }
                if (sm.length() == 1 && "<=>".indexOf(sm) > -1) {
                    Field fl;
                    if (!((String)mm.get(i - 1)).equals("?") && r.get(mm.get(i - 1)) == null) {
                        record_processor.addError("Invalid Mathematical operator");
                        return false;
                    }
                    if (sm.equals("<") && "?=>".indexOf((String)mm.get(i + 1)) > -1) {
                        (h ? hc : wc).append(sm);
                        if (((String)mm.get(i + 1)).equals("?")) {
                            if (vv != null && ++vi >= vv.size()) {
                                record_processor.addError("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                            } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                                record_processor.addError(e.toString());
                                return false;
                            }
                            if (vv != null) {
                                (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                            }
                            sm = (String)mm.get(++i);
                            (h ? hc : wc).append(sm).append(i + 1 == ml ? "" : ("'(.".indexOf(sm) > -1 || "'.,()".indexOf((String)mm.get(i + 1)) > -1 ? "" : ("<>".indexOf(sm) > -1 && ">=".indexOf((String)mm.get(i + 1)) > -1 ? "" : " ")));
                            continue;
                        }
                        if ("=>".indexOf((String)mm.get(i + 1)) <= -1) continue;
                        if (((String)mm.get(++i + 1)).equals("?")) {
                            ++i;
                            if (vv != null && ++vi >= vv.size()) {
                                record_processor.addError("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                            } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                                record_processor.addError(e.toString());
                                return false;
                            }
                            if (vv != null) {
                                (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                            }
                            (h ? hc : wc).append((String)mm.get(i - 1)).append(" ? ");
                            continue;
                        }
                        if (r.get(mm.get(i + 1)) != null) {
                            fl = r.get(mm.get(i + 1));
                            wf.add(fl);
                            h = fl.isGroup();
                            (h ? hc : wc).append(sm).append((String)mm.get(i)).append(h ? fl.getHaving() : fl.getSQLName()).append(" ");
                            ++i;
                            continue;
                        }
                        record_processor.addError("Invalid Mathematical operator");
                        return false;
                    }
                    if (sm.equals(">") && "?=".indexOf((String)mm.get(i + 1)) > -1) {
                        (h ? hc : wc).append(sm);
                        if (((String)mm.get(i + 1)).equals("?")) {
                            if (vv != null && ++vi >= vv.size()) {
                                record_processor.addError("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                            } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                                record_processor.addError(e.toString());
                                return false;
                            }
                            if (vv != null) {
                                (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                            }
                            ++i;
                            (h ? hc : wc).append(f.hasOverwriteWhereCondition() == true ? f.getOverwriteWhereCondition() : "?");
                            continue;
                        }
                        if ("=".indexOf((String)mm.get(i + 1)) <= -1) continue;
                        if (((String)mm.get(++i + 1)).equals("?")) {
                            ++i;
                            if (vv != null && ++vi >= vv.size()) {
                                record_processor.addError("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                            } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                                record_processor.addError(e.toString());
                                return false;
                            }
                            if (vv != null) {
                                (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                            }
                            (h ? hc : wc).append("= ? ");
                            continue;
                        }
                        if (r.get(mm.get(i + 1)) != null) {
                            fl = r.get(mm.get(i + 1));
                            wf.add(fl);
                            h = fl.isGroup();
                            ++i;
                            (h ? hc : wc).append(sm).append("=").append(h ? fl.getHaving() : fl.getSQLName()).append(" ");
                            ++i;
                            continue;
                        }
                        record_processor.addError("Invalid Mathematical operator");
                        return false;
                    }
                    if (!sm.equals("=") || "?".indexOf((String)mm.get(i + 1)) <= -1) continue;
                    ++i;
                    if (vv != null && ++vi >= vv.size()) {
                        record_processor.addError("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                    } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                        record_processor.addError(e.toString());
                        return false;
                    }
                    if (vv != null) {
                        (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                    }
                    (h ? hc : wc).append("<=>").append(f.hasOverwriteWhereCondition() == true ? f.getOverwriteWhereCondition() : "?").append(" ");
                    continue;
                }
                if (sm.equalsIgnoreCase("in")) {
                    (h ? hc : wc).append(sm).append(i + 1 == ml ? "" : ("'(.".indexOf(sm) > -1 || "'.,()".indexOf((String)mm.get(i + 1)) > -1 ? "" : ("<>".indexOf(sm) > -1 && ">=".indexOf((String)mm.get(i + 1)) > -1 ? "" : " ")));
                    if (!((String)mm.get(i - 1)).equalsIgnoreCase("not") && r.get(mm.get(i - 1)) == null && !((String)mm.get(i + 1)).equals("(")) {
                        record_processor.addError("Invalid IN operator");
                        return false;
                    }
                    sm = (String)mm.get(++i);
                    (h ? hc : wc).append(sm).append(i + 1 == ml ? "" : ("'(.".indexOf(sm) > -1 || "'.,()".indexOf((String)mm.get(i + 1)) > -1 ? "" : ("<>".indexOf(sm) > -1 && ">=".indexOf((String)mm.get(i + 1)) > -1 ? "" : " ")));
                    while (!(sm = (String)mm.get(++i)).equals(")")) {
                        Object token = "?";
                        if (!((String)mm.get(i)).equalsIgnoreCase((String)token)) {
                            record_processor.addError("Invalid IN operator");
                            return false;
                        }
                        if (!((String)mm.get(i + 1)).equals(")")) {
                            token = (String)token + ",";
                        }
                        if (vv != null && ++vi >= vv.size()) {
                            record_processor.addError("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                        } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                            record_processor.addError(e.toString());
                            return false;
                        }
                        if (vv != null) {
                            (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                        }
                        (h ? hc : wc).append((String)token).append(i + 1 == ml ? "" : ("'(.".indexOf(sm) > -1 || "'.,()".indexOf((String)mm.get(i + 1)) > -1 ? "" : ("<>".indexOf(sm) > -1 && ">=".indexOf((String)mm.get(i + 1)) > -1 ? "" : " ")));
                        if (((String)mm.get(i + 1)).equals(")")) continue;
                        ++i;
                    }
                    (h ? hc : wc).append(sm).append(i + 1 == ml ? "" : ("'(.".indexOf(sm) > -1 || "'.,()".indexOf((String)mm.get(i + 1)) > -1 ? "" : ("<>".indexOf(sm) > -1 && ">=".indexOf((String)mm.get(i + 1)) > -1 ? "" : " ")));
                    continue;
                }
                if (sm.equalsIgnoreCase("like")) {
                    (h ? hc : wc).append(sm).append(" ");
                    if (((String)mm.get(i + 1)).equals("?")) {
                        ++i;
                        if (vv != null && ++vi >= vv.size()) {
                            record_processor.addError("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                        }
                        if (vv != null) {
                            (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                        }
                        (h ? hc : wc).append(" ? ");
                        continue;
                    }
                    record_processor.addError("Invalid Mathematical operator");
                    return false;
                }
                if (sm.equalsIgnoreCase("between")) {
                    (h ? hc : wc).append(sm).append(" ");
                    if (((String)mm.get(i + 1)).equals("?")) {
                        (h ? hc : wc).append(f.hasOverwriteWhereCondition() == true ? f.getOverwriteWhereCondition() : "?").append(" ");
                        ++i;
                        if (vv != null && ++vi >= vv.size()) {
                            record_processor.addError("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                        } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                            record_processor.addError(e.toString());
                            return false;
                        }
                        if (!((String)mm.get(i + 1)).equalsIgnoreCase("and") || !((String)mm.get(i + 2)).equals("?")) {
                            record_processor.addError("Invalid Between operator");
                            return false;
                        }
                        if (vv != null) {
                            (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                        }
                        ++i;
                        if (vv != null && ++vi >= vv.size()) {
                            record_processor.addError("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                        } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                            record_processor.addError(e.toString());
                            return false;
                        }
                        if (vv != null) {
                            (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                        }
                        ++i;
                        (h ? hc : wc).append("AND ? ");
                        continue;
                    }
                    record_processor.addError("Invalid Between operator");
                    return false;
                }
                if (sm.equalsIgnoreCase("is")) {
                    if (((String)mm.get(i + 1)).equalsIgnoreCase("null")) {
                        ++i;
                        (h ? hc : wc).append("IS NULL");
                        continue;
                    }
                    if (((String)mm.get(i + 1)).equalsIgnoreCase("not") && ((String)mm.get(i + 2)).equalsIgnoreCase("null")) {
                        ++i;
                        ++i;
                        (h ? hc : wc).append("IS NOT NULL");
                        continue;
                    }
                    record_processor.addError("Invalid IS Operator");
                    return false;
                }
                record_processor.addError("Invalid Where clause");
                return false;
            }
            if (sm.equalsIgnoreCase("and") || sm.equalsIgnoreCase("or") || sm.equals("(") || sm.equals(")") || sm.equalsIgnoreCase("not")) {
                (h ? hc : wc).append(" ").append(sm).append(" ");
                continue;
            }
            if (r.get(sm) == null) {
                record_processor.addError("Field '" + sm + "' is not a valid field name");
                continue;
            }
            record_processor.addError("Invalid Where clause '" + sm + "'");
            return false;
        }
        return record_processor.hasErrors() == false;
    }

    public boolean areValidInsertValueFields(RecordProcessor record_processor, HashMap<String, Field> record, JsonArray values, ArrayList<Field> field_list) throws Exception {
        String fieldValue;
        JsonElement fje;
        JsonObject o;
        int i;
        StringBuilder error = new StringBuilder();
        for (i = 0; i < values.size(); ++i) {
            o = values.get(i).getAsJsonObject();
            for (String fieldName : o.keySet()) {
                if (fieldName.equalsIgnoreCase("tuid")) continue;
                fje = o.get(fieldName);
                fieldValue = fje.isJsonNull() ? null : fje.getAsString();
                Field f = record.get(fieldName);
                if (f != null && !f.isAllowedTo(Field.INSERT).booleanValue()) {
                    record_processor.addError("Field '" + fieldName + "' is not allowed in insert operation");
                    continue;
                }
                if (f == null || !field_list.contains(f)) {
                    record_processor.addError("Field '" + fieldName + "' is not a valid field name for insert operation");
                    continue;
                }
                if (!f.isAllowedTo(Field.INSERT).booleanValue()) {
                    record_processor.addError("Field '" + fieldName + "' is not allowed to insert opertation");
                    continue;
                }
                if (f.isValid(Field.INSERT, fieldValue, error).booleanValue()) continue;
                record_processor.addError(error.toString());
            }
        }
        if (record_processor.hasErrors().booleanValue()) {
            return false;
        }
        for (i = 0; i < values.size(); ++i) {
            o = values.get(i).getAsJsonObject();
            for (int x = 0; x < field_list.size(); ++x) {
                Field f = field_list.get(x);
                fje = o.get(field_list.get(x).getAlias());
                String string = fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                if (!(f.isPrimaryKeyAI().booleanValue() || f.isPrimaryKeyMI().booleanValue() || !f.isAllowedTo(Field.INSERT).booleanValue() || f.isValid(Field.INSERT, fieldValue, error).booleanValue() || f.hasDefaultValueFor(Field.INSERT).booleanValue())) {
                    record_processor.addError(error.toString());
                    continue;
                }
                if (fieldValue != null || !f.hasDefaultValueFor(Field.INSERT).booleanValue()) continue;
                o.addProperty(f.getAlias(), f.getDefaultSQLValueFor(Field.INSERT, record_processor.error_list));
            }
        }
        return record_processor.hasErrors() == false;
    }

    protected boolean isValid(String[] parameters, JsonObject rcvd) throws Exception {
        for (String parameter : parameters) {
            JsonElement el = rcvd.get(parameter);
            if (el != null && !el.isJsonNull()) continue;
            return false;
        }
        return true;
    }

    protected String getFieldsFor(Integer operation, Boolean include_primary_keys) throws Exception {
        StringBuilder csv = new StringBuilder();
        ArrayList<Field> field_list = this.getFields();
        for (int i = 0; i < field_list.size(); ++i) {
            Field f = field_list.get(i);
            if (!f.isAllowedTo(operation).booleanValue() && (!include_primary_keys.booleanValue() || !f.isPrimaryKey().booleanValue())) continue;
            csv.append(f.getSelect()).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String getFieldsSelect(Map<String, String> variables) throws Exception {
        StringBuilder csv = new StringBuilder();
        for (int i = 0; i < this.select_fields.size(); ++i) {
            Field f = this.select_fields.get(i);
            if (!f.isVariable().booleanValue()) {
                csv.append(f.getSelect()).append(",");
                continue;
            }
            csv.append(f.getSelect(variables)).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String getFieldsSelect(RecordProcessor record_processor, List<Field> field_list, List<ServiceField> service_field_list) throws Exception {
        int i;
        StringBuilder csv = new StringBuilder();
        if (!record_processor.hasGroupBy().booleanValue() || field_list == null || field_list.size() == 0) {
            for (i = 0; i < this.select_fields.size(); ++i) {
                f = this.select_fields.get(i);
                if (f == null) {
                    record_processor.addError("Field '" + String.valueOf(field_list.get(i)) + "' is not a valid field name");
                    continue;
                }
                if (f.isVariable().booleanValue()) {
                    csv.append(f.getSelect(record_processor.request.variable_map)).append(",");
                    continue;
                }
                csv.append(f.getSelect()).append(",");
            }
        } else {
            for (i = 0; i < field_list.size(); ++i) {
                f = field_list.get(i);
                if (f == null) {
                    record_processor.addError("Field '" + String.valueOf(field_list.get(i)) + "' is not a valid field name");
                    continue;
                }
                if (f.isVariable().booleanValue()) {
                    csv.append(f.getSelect(record_processor.request.variable_map)).append(",");
                    continue;
                }
                csv.append(f.getSelect()).append(",");
            }
        }
        for (i = 0; service_field_list != null && i < service_field_list.size(); ++i) {
            csv.append(service_field_list.get(i).getSelectStatement()).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String fieldAliasToCsv(ArrayList<Field> field_list) {
        if (field_list.size() == 0) {
            return "";
        }
        StringBuilder csv = new StringBuilder();
        for (Field f : field_list) {
            csv.append(f.getAlias()).append(",");
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String getFieldsOrderBy(RecordProcessor record_processor) {
        StringBuilder csv = new StringBuilder();
        if (record_processor.request.order_by_list == null || record_processor.request.order_by_list.size() == 0) {
            for (int i = 0; this.select_statement_orderby != null && i < this.select_statement_orderby.size() && record_processor.request.response.equalsIgnoreCase("process"); ++i) {
                Field f = this.select_statement_orderby.get(i);
                csv.append(f.getOrderBy()).append(",");
            }
        } else {
            for (int i = 0; i < record_processor.request.order_by_list.size(); ++i) {
                String orderByFieldName = record_processor.request.order_by_list.get(i);
                int order = orderByFieldName.charAt(0);
                if (order == 43 || order == 45) {
                    orderByFieldName = orderByFieldName.substring(1);
                } else {
                    order = 43;
                }
                Field f = this.getAliasedField(orderByFieldName);
                if (f == null) {
                    record_processor.addError("Field '" + record_processor.request.order_by_list.get(i) + "' is not a valid field name");
                    continue;
                }
                csv.append(f.getOrderBy()).append(order == 43 ? " ASC," : " DESC,");
            }
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String getFieldsGroupBy(RecordProcessor record_processor) {
        StringBuilder csv = new StringBuilder();
        for (int i = 0; i < record_processor.request.group_by_list.size(); ++i) {
            Field f = this.getAliasedField(record_processor.request.group_by_list.get(i));
            if (f == null) {
                record_processor.addError("Field '" + record_processor.request.group_by_list.get(i) + "' is not a valid field name");
                continue;
            }
            if (!this.select_statement_groupby.contains(f)) {
                record_processor.addError("Field '" + record_processor.request.group_by_list.get(i) + "' is not a valid 'Group By' field name");
                continue;
            }
            csv.append(f.getGroupBy()).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.addError("Fields valid for 'Group By' are [" + csv.toString() + "] is not a valid GROUP BY field name");
        }
        return csv.toString();
    }

    protected String getJsonCSV(JsonArray jsonArray) {
        StringBuilder csv = new StringBuilder();
        for (int i = 0; i < jsonArray.size(); ++i) {
            csv.append(jsonArray.get(i).getAsString()).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String getJsonCSV(Map<String, String> variables, JsonArray csv_list, HashMap<String, Field> record) throws Exception {
        StringBuilder csv = new StringBuilder();
        for (int i = 0; i < csv_list.size(); ++i) {
            Field f = record.get(csv_list.get(i).getAsString());
            if (!f.isVariable().booleanValue()) {
                csv.append(f.getSelect()).append(",");
                continue;
            }
            csv.append(f.getSelect(variables)).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    public void validateSelectStatement(RecordProcessor record_processor) throws Exception {
        StringBuilder where_clause = new StringBuilder();
        StringBuilder having_clause = new StringBuilder();
        StringBuilder query = new StringBuilder(this.select_statement);
        if (!this.areValidSelectFields(record_processor, record_processor.query.service_field_list, this.getNamedFieldMap(), this.select_fields)) {
            record_processor.addError("ERROR: validateSelectStatement.areValidSelectFields");
            return;
        }
        if (record_processor.request.where.values != null && record_processor.request.where.clause.replaceAll("[^?]", "").length() != record_processor.request.where.values.size()) {
            record_processor.addError("ERROR: validateSelectStatement.escapement");
            return;
        }
        if (!Table.isValidClause(record_processor, Field.SELECT, record_processor.request.where.clause, this.getAliasedFieldMap(), record_processor.query.where_field_list, record_processor.request.where.values, where_clause, having_clause, record_processor.query.where_argument_list, record_processor.query.having_argument_list).booleanValue()) {
            record_processor.addError("ERROR: validateSelectStatement.isValidClause");
            return;
        }
        String order_by_list = null;
        if (record_processor.request.order_by_list != null) {
            order_by_list = this.getFieldsOrderBy(record_processor);
            if (record_processor.hasErrors().booleanValue()) {
                record_processor.addError("ERROR: validateSelectStatement.ORDER_BY_VALIDATION");
                return;
            }
        }
        String group_by_list = null;
        if (record_processor.request.group_by_list != null) {
            group_by_list = this.getFieldsGroupBy(record_processor);
            if (record_processor.hasErrors().booleanValue()) {
                record_processor.addError("ERROR: validateSelectStatement.GROUP_BY_VALIDATION");
                return;
            }
        }
        int idx = query.indexOf("$SELECT$");
        query.replace(idx, idx + 8, "");
        query.insert(idx, "SELECT ");
        query.insert(idx + 7, this.getFieldsSelect(record_processor, this.field_list, record_processor.query.service_field_list));
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.addError("ERROR: validateSelectStatement.SELECT");
            return;
        }
        idx = query.indexOf("$WHERE$");
        query.replace(idx, idx + 7, "");
        if (where_clause != null && where_clause.length() > 0) {
            if (where_clause.lastIndexOf(" AND ") == where_clause.length() - 5) {
                where_clause = where_clause.delete(where_clause.lastIndexOf(" AND "), where_clause.length());
            }
            if (where_clause.lastIndexOf(" OR ") == where_clause.length() - 4) {
                where_clause = where_clause.delete(where_clause.lastIndexOf(" OR "), where_clause.length());
            }
        }
        if (where_clause != null && where_clause.length() > 0) {
            query.insert(idx, " WHERE ");
            if (this.hasSelectWhereCondition().booleanValue()) {
                where_clause.insert(0, this.getSelectWhereCondition() + " AND ");
            }
            query.insert(idx + 7, where_clause);
        } else if (this.hasSelectWhereCondition().booleanValue()) {
            query.insert(idx, " WHERE ");
            where_clause.setLength(0);
            where_clause.append(this.getSelectWhereCondition());
            query.insert(idx + 7, where_clause);
        }
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.addError("ERROR: validateSelectStatement.WHERE");
            return;
        }
        idx = query.indexOf("$GROUPBY$");
        query.replace(idx, idx + 9, "");
        if (group_by_list != null && group_by_list.length() > 0) {
            query.insert(idx, "GROUP BY ");
            query.insert(idx + 9, group_by_list);
        }
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.addError("ERROR: validateSelectStatement.GROUP_BY");
            return;
        }
        idx = query.indexOf("$HAVING$");
        query.replace(idx, idx + 8, "");
        if (having_clause != null && having_clause.length() > 0) {
            if (having_clause.lastIndexOf(" AND ") == having_clause.length() - 5) {
                having_clause.delete(having_clause.lastIndexOf(" AND "), having_clause.length());
            }
            if (having_clause.lastIndexOf(" OR ") == having_clause.length() - 4) {
                having_clause.delete(having_clause.lastIndexOf(" OR "), having_clause.length());
            }
        }
        if (having_clause != null && having_clause.length() > 0) {
            query.insert(idx, " HAVING ");
            query.insert(idx + 8, having_clause);
        }
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.addError("ERROR: validateSelectStatement.HAVING");
            return;
        }
        idx = query.indexOf("$ORDERBY$");
        query.replace(idx, idx + 9, "");
        if (order_by_list != null && order_by_list.length() > 0) {
            query.insert(idx, "ORDER BY ");
            query.insert(idx + 9, order_by_list);
        }
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.addError("ERROR: validateSelectStatement.ORDER_BY");
            return;
        }
        record_processor.query.sql = query.toString();
    }

    public void processSelectedRecord(RecordProcessor record_processor, ResultSet resultset, JsonObject record_object) throws Exception {
        for (int i = 0; i < record_processor.request.select_list.size(); ++i) {
            String field_alias = record_processor.request.select_list.get(i);
            Field f = this.getAliasedField(field_alias);
            if (f.isIgnoredFor(Field.SELECT).booleanValue()) continue;
            Object fieldObject = resultset.getObject(f.getAlias());
            if (fieldObject == null) {
                record_object.add(field_alias, (JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (f.isNumeric().booleanValue()) {
                record_object.addProperty(field_alias, (Number)fieldObject);
                continue;
            }
            if (f.isBoolean().booleanValue()) {
                record_object.addProperty(field_alias, f.parseBoolean(fieldObject));
                continue;
            }
            record_object.addProperty(field_alias, f.getFieldString(resultset.getObject(f.getAlias())));
        }
    }

    public void processSelectedObjectRecord(RecordProcessor record_processor, ResultSet resultset, JsonObject record_object, List<ServiceField> service_field_list) throws Exception {
        int i;
        for (i = 0; i < record_processor.request.select_list.size(); ++i) {
            String field_alias = record_processor.request.select_list.get(i);
            Field f = this.getAliasedField(field_alias);
            if (f.isIgnoredFor(Field.SELECT).booleanValue()) continue;
            Object fieldObject = f.getPostProcessedValue(Field.SELECT, resultset.getObject(f.getAlias()), record_processor.error_list);
            if (fieldObject == null) {
                record_object.add(field_alias, (JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (f.isNumeric().booleanValue()) {
                record_object.addProperty(field_alias, (Number)fieldObject);
                continue;
            }
            if (f.isBoolean().booleanValue()) {
                record_object.addProperty(field_alias, f.parseBoolean(fieldObject));
                continue;
            }
            record_object.addProperty(field_alias, f.getFieldString(fieldObject));
        }
        for (i = 0; i < service_field_list.size(); ++i) {
            ServiceField sf = service_field_list.get(i);
            Object fieldObject = resultset.getObject(sf.getAlias());
            if (fieldObject == null) {
                record_object.add(sf.getAlias(), (JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (sf.isNumeric().booleanValue()) {
                record_object.addProperty(sf.getAlias(), (Number)fieldObject);
                continue;
            }
            if (sf.isBoolean().booleanValue()) {
                record_object.addProperty(sf.getAlias(), sf.parseBoolean(fieldObject));
                continue;
            }
            record_object.addProperty(sf.getAlias(), sf.getFieldString(resultset.getObject(sf.getAlias())));
        }
    }

    public void processSelectedArrayRecord(RecordProcessor record_processor, ResultSet resultset, JsonArray record_list, List<ServiceField> service_field_list) throws Exception {
        int i;
        for (i = 0; i < record_processor.request.select_list.size(); ++i) {
            String field_alias = record_processor.request.select_list.get(i);
            Field f = this.getAliasedField(field_alias);
            if (f.isIgnoredFor(Field.SELECT).booleanValue()) continue;
            Object fieldObject = f.getPostProcessedValue(Field.SELECT, resultset.getObject(f.getAlias()), record_processor.error_list);
            if (fieldObject == null) {
                record_list.add((JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (f.isNumeric().booleanValue()) {
                record_list.add((Number)fieldObject);
                continue;
            }
            if (f.isBoolean().booleanValue()) {
                record_list.add(f.parseBoolean(fieldObject));
                continue;
            }
            record_list.add(f.getFieldString(fieldObject));
        }
        for (i = 0; i < service_field_list.size(); ++i) {
            ServiceField service_field = service_field_list.get(i);
            Object fieldObject = resultset.getObject(service_field.getAlias());
            if (fieldObject == null) {
                record_list.add((JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (service_field.isNumeric().booleanValue()) {
                record_list.add((Number)fieldObject);
                continue;
            }
            if (service_field.isBoolean().booleanValue()) {
                record_list.add(service_field.parseBoolean(fieldObject));
                continue;
            }
            record_list.add(service_field.getFieldString(resultset.getObject(service_field.getAlias())));
        }
    }

    public void prepareSelectStatement(Gson gson, RecordProcessor record_processor, RecordHandler record_handler) throws Exception {
        this.validateCommand(record_processor);
        if (record_processor.hasErrors().booleanValue()) {
            return;
        }
        if (!record_handler.selectInject(record_processor).booleanValue()) {
            return;
        }
        Request reuest = record_processor.getTableRequest();
        this.validateSelectStatement(record_processor);
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.addError("ERROR: validateSelectStatement.selectGson.validateSelectStatement");
            return;
        }
        JsonArray record_key_list = gson.toJsonTree(record_processor.request.select_list, new TypeToken<List<String>>(this){}.getType()).getAsJsonArray();
        record_processor.mergeJsonElement("fields", (JsonElement)record_key_list);
    }

    public void executeSelect(Gson gson, Connection connection, RecordProcessor record_processor, RecordHandler record_handler) throws Exception {
        record_processor.query.t2 = Instant.now();
        if (!record_handler.selectPreLogic(record_processor, connection).booleanValue()) {
            return;
        }
        try (PreparedStatement prepared_statement = connection.prepareStatement(record_processor.query.sql);){
            int idx = 0;
            for (Argument argument : record_processor.query.having_argument_list) {
                for (String sv : argument.getValues()) {
                    prepared_statement.setObject(++idx, sv);
                }
            }
            for (Argument argument : record_processor.query.where_argument_list) {
                for (String sv : argument.getValues()) {
                    prepared_statement.setObject(++idx, sv);
                }
            }
            JsonArray view = null;
            Boolean empty_set = true;
            record_processor.beginArray();
            try (ResultSet resultset = prepared_statement.executeQuery();){
                empty_set = !resultset.isBeforeFirst();
                record_processor.query.t3 = Instant.now();
                JsonObject record_object = new JsonObject();
                while (resultset.next()) {
                    record_processor.beginArray();
                    this.processSelectedObjectRecord(record_processor, resultset, record_object, record_processor.query.service_field_list);
                    if (!record_handler.selectPerRecordLogic(record_processor, resultset, record_object).booleanValue()) {
                        // empty if block
                    }
                    this.saveTablePrimaryRecord(record_processor, record_object);
                    JsonArray record_value_list = record_processor.extractJsonObjectValueList(record_object);
                    record_processor.addJsonElement((JsonElement)record_value_list);
                    if (this.child_table_list != null && this.child_table_list.size() > 0) {
                        for (int i = 0; i < this.child_table_list.size(); ++i) {
                            Table child_table = this.child_table_list.get(i);
                            child_table.executeSelect(gson, connection, record_processor.getChildTableRecordProcessor(child_table.request_table.table_alias), record_handler);
                        }
                    }
                    record_processor.endArray();
                }
            }
            if (!record_handler.selectPostLogic(record_processor, connection, view).booleanValue() || !record_handler.selectEject(record_processor).booleanValue()) {
                return;
            }
            record_processor.query.t4 = Instant.now();
            if (record_processor.hasErrors().booleanValue()) {
                throw new Exception("SELECT PROGRAM INTERNAL SEQUENCE ERROR");
            }
            record_processor.endArray();
        }
    }

    private void saveTablePrimaryRecord(RecordProcessor record_processor, JsonObject record_object) {
        if (record_processor.request.child_list == null || record_processor.request.child_list.size() == 0) {
            return;
        }
        HashMap<String, Object> record_stack_frame = new HashMap<String, Object>();
        record_processor.addRecordStackFrame(record_stack_frame);
    }

    public String validateInsertSetStatement(JsonObject json) throws Exception {
        StringBuilder sql = new StringBuilder(this.insert_set_statement);
        JsonObject set = json.get("set").getAsJsonObject();
        Set keys = set.keySet();
        for (String field_alias : keys) {
            Field f = this.getAliasedField(field_alias);
            String value = set.get(field_alias).getAsString();
            Integer index = sql.indexOf("?" + field_alias);
            sql.delete(index, index + field_alias.length() + 1);
            sql.insert((int)index, f.getQuotable(value));
        }
        return sql.toString();
    }

    public int insertValues(Connection con, PreparedStatement prepared_statement, JsonArray values, Map<String, String> variables, Returns returns) throws Exception {
        int affected_rows = 0;
        for (int oo = 0; oo < values.size(); ++oo) {
            String fieldValue;
            JsonElement fje;
            Field field;
            int i;
            JsonObject o = values.get(oo).getAsJsonObject();
            int idx = 0;
            for (i = 0; i < this.insert_fields.size(); ++i) {
                field = this.insert_fields.get(i);
                if (field.isPrimaryKeyAI().booleanValue() || field.isPrimaryKeyMI().booleanValue()) continue;
                fje = o.get(this.insert_fields.get(i).getAlias());
                fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                prepared_statement.setObject(++idx, field.getFieldObject(fieldValue));
            }
            if (this.hasPrimaryKeyMI().booleanValue()) {
                for (i = 0; i < this.primary_keys.size(); ++i) {
                    field = this.primary_keys.get(i);
                    if (field.isPrimaryKeyMI().booleanValue()) continue;
                    fje = o.get(field.getAlias());
                    fieldValue = fje.isJsonNull() ? null : fje.getAsString();
                    prepared_statement.setObject(++idx, field.getFieldObject(fieldValue));
                }
            }
            prepared_statement.addBatch();
        }
        int[] affectRows = prepared_statement.executeBatch();
        for (int i = 0; i < affectRows.length; ++i) {
            affected_rows += affectRows[i];
        }
        returns.Returns("t3", Long.valueOf(System.nanoTime()));
        if (affected_rows > 0 && this.hasPrimaryKeyMI().booleanValue()) {
            for (int oo = 0; oo < values.size(); ++oo) {
                JsonObject o = values.get(oo).getAsJsonObject();
                if (this.insert_statement_select == null) {
                    if (variables == null) {
                        throw new Exception("Variables are Null");
                    }
                    this.createRuntimeInsertStatementSelect(variables);
                }
                try (PreparedStatement preparedInsertedSelectStmt = con.prepareStatement(this.insert_statement_select);){
                    int idx = 0;
                    for (int i = 0; i < this.insert_fields.size(); ++i) {
                        Field f = this.insert_fields.get(i);
                        if (f.isPrimaryKeyMI().booleanValue()) continue;
                        JsonElement fje = o.get(this.insert_fields.get(i).getAlias());
                        String fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                        preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                    }
                    try (ResultSet resultset = preparedInsertedSelectStmt.executeQuery();){
                        while (resultset.next()) {
                            for (int i = 0; i < this.primary_keys_manual_increment_fields.size(); ++i) {
                                Field f = this.primary_keys_manual_increment_fields.get(i);
                                o.addProperty(f.getAlias(), (Number)resultset.getBigDecimal(f.getAlias()));
                            }
                        }
                        resultset.close();
                    }
                    preparedInsertedSelectStmt.close();
                    continue;
                }
            }
        } else if (affected_rows > 0 && this.hasPrimaryKeyAI().booleanValue()) {
            try (ResultSet generatedKeys = prepared_statement.getGeneratedKeys();){
                int x = 0;
                while (generatedKeys.next()) {
                    JsonObject o = values.get(x++).getAsJsonObject();
                    int count = generatedKeys.getMetaData().getColumnCount();
                    for (int i = 0; i < count; ++i) {
                        o.addProperty(this.primary_keys.get(i).getAlias(), (Number)generatedKeys.getInt(i + 1));
                    }
                }
                generatedKeys.close();
            }
        }
        return affected_rows;
    }

    public String getInsertStatement() {
        return this.insert_statement;
    }

    public ArrayList<Field> getInsertFields() {
        return this.insert_fields;
    }

    private String getInsertSetStatement() {
        return this.insert_set_statement;
    }

    public String validateUpdateWhereStatement(RecordProcessor record_processor, String c, JsonArray v, JsonArray wff, JsonArray wvv, ArrayList<Field> uf, ArrayList<ArrayList<Object>> ufv, ArrayList<Argument> wa, ArrayList<Argument> ha) throws Exception {
        ArrayList<String> vv = wvv == null ? null : new ArrayList<String>(Arrays.asList(JsonUtil.javaStringArray((JsonArray)wvv.getAsJsonArray())));
        ArrayList<String> ff = wff == null ? null : new ArrayList<String>(Arrays.asList(JsonUtil.javaStringArray((JsonArray)wff.getAsJsonArray())));
        ArrayList<Field> wf = new ArrayList<Field>();
        StringBuilder uu = new StringBuilder();
        StringBuilder ww = new StringBuilder();
        StringBuilder hh = new StringBuilder();
        StringBuilder query = new StringBuilder(this.update_statement);
        if (!this.areValidUpdateFieldsValues(record_processor, this.getNamedFieldMap(), v, ff, this.update_fields, record_processor.error_list)) {
            record_processor.addError("ERROR: validateUpdateWhereStatement.areValidUpdateFieldsValues");
            return null;
        }
        if (c == null || c.length() == 0 || ff == null && vv == null || !Table.isValidClause(record_processor, Field.UPDATE, c, this.getNamedFieldMap(), wf, vv, ww, hh, wa, ha).booleanValue()) {
            record_processor.addError("ERROR: validateUpdateWhereStatement.isValidClause");
            return null;
        }
        JsonObject job = null;
        for (int i = 0; i < v.size(); ++i) {
            String ue;
            Field f;
            int x;
            ArrayList<Object> r = new ArrayList<Object>();
            JsonObject jsonObject = v.get(i).getAsJsonObject();
            if (jsonObject == null) {
                record_processor.addError("Null Json Object on group [" + i + "]");
            } else if (jsonObject.size() == 0) {
                record_processor.addError("Empty Json Object on group [" + i + "]");
            } else if (job != null && jsonObject.size() != job.size()) {
                record_processor.addError("Json Object has different elements count on group [" + i + "]");
            }
            job = jsonObject;
            if (record_processor.hasErrors().booleanValue()) {
                record_processor.addError("ERROR: validateUpdateWhereStatement.Fields");
                return null;
            }
            if (uf.size() == 0) {
                Boolean nonPrimaryKeysExists = false;
                for (String fn : jsonObject.keySet()) {
                    Field f2 = this.getAliasedField(fn);
                    if (this.primary_keys != null && this.primary_keys.contains(fn)) continue;
                    if (f2 == null && ff != null && !ff.contains(fn)) {
                        record_processor.addError("Field '" + fn + "' is unknowen to where field_list");
                        continue;
                    }
                    if (f2 == null && ff != null && ff.contains(fn)) continue;
                    if (f2 == null) {
                        record_processor.addError("Field '" + fn + "' is not a valid field name");
                        continue;
                    }
                    if (f2.isPrimaryKey().booleanValue()) continue;
                    nonPrimaryKeysExists = true;
                    uf.add(f2);
                    if (f2.isUpdateFormulaDefined().booleanValue()) {
                        uu.append(f2.getSQLName()).append("=").append(f2.getUpdateFormulaDefined()).append(",");
                        continue;
                    }
                    uu.append(f2.getSQLName()).append("=?, ");
                }
                if (!nonPrimaryKeysExists.booleanValue()) {
                    record_processor.addError("Update abortred, no update can be performed over primary keys only record");
                } else {
                    uu.delete(uu.length() - 2, uu.length());
                }
                if (record_processor.hasErrors().booleanValue()) {
                    record_processor.addError("ERROR: validateUpdateWhereStatement.UPDATE_ABORTED");
                    return null;
                }
            }
            StringBuilder er = new StringBuilder();
            for (x = 0; x < uf.size(); ++x) {
                f = uf.get(x);
                if (!f.isValid(Field.UPDATE, ue = JsonUtil.getJsonString((JsonObject)jsonObject, (String)f.getAlias(), (Boolean)false), er).booleanValue()) {
                    record_processor.error_list.add(er.toString() + ", check in group index[" + (i + 1) + "]");
                    continue;
                }
                String preProcessedValue = f.getPreProcessedValue(Field.UPDATE, ue, record_processor.error_list);
                if (record_processor.hasErrors().booleanValue()) {
                    record_processor.addError("ERROR: validateUpdateWhereStatement.PRE_PROCESS");
                    return null;
                }
                r.add(f.getFieldObject(preProcessedValue));
            }
            if (record_processor.hasErrors().booleanValue()) continue;
            for (x = jsonObject.size(); x < wf.size() + jsonObject.size(); ++x) {
                f = wf.get(x - jsonObject.size());
                ue = null;
                ue = ff == null ? JsonUtil.getJsonString((JsonArray)wvv, (Integer)(x - jsonObject.size()), (Boolean)false) : JsonUtil.getJsonString((JsonObject)jsonObject, (String)wff.get(x - jsonObject.size()).getAsString(), (Boolean)false);
                if (!f.isValid(Field.UPDATE, ue, er).booleanValue()) {
                    record_processor.addError(er.toString());
                    continue;
                }
                r.add(f.getFieldObject(ue));
            }
            ufv.add(r);
        }
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.addError("ERROR: validateUpdateWhereStatement.FIELD_VALIDATION");
            return null;
        }
        int idx = query.indexOf("$UPDATE$");
        query.replace(idx, idx + 8, "");
        if (uu != null && uu.length() > 0) {
            query.insert(idx, uu);
        }
        idx = query.indexOf("$WHERE$");
        query.replace(idx, idx + 7, "");
        if (ww != null && ww.length() > 0) {
            query.insert(idx, ww.length() == 0 ? "" : " WHERE ");
            query.insert(idx + 7, ww);
        }
        if (hh != null && hh.length() > 0) {
            query.insert(idx, hh.length() == 0 ? "" : " WHERE ");
            query.insert(idx + 7, hh);
        }
        return query.toString();
    }

    public String validateDeleteWhereStatement(RecordProcessor record_processor, String c, JsonArray v, JsonArray wff, JsonArray wvv, ArrayList<Field> uf, ArrayList<ArrayList<Object>> ufv, ArrayList<Argument> wa, ArrayList<Argument> ha) throws Exception {
        StringBuilder w;
        ArrayList<String> vv = wvv == null ? null : new ArrayList<String>(Arrays.asList(JsonUtil.javaStringArray((JsonArray)wvv.getAsJsonArray())));
        ArrayList<String> ff = wff == null ? null : new ArrayList<String>(Arrays.asList(JsonUtil.javaStringArray((JsonArray)wff.getAsJsonArray())));
        ArrayList<Field> wf = new ArrayList<Field>();
        StringBuilder uu = new StringBuilder();
        StringBuilder ww = new StringBuilder();
        StringBuilder hh = new StringBuilder();
        StringBuilder query = new StringBuilder(this.delete_statement);
        if (c == null || c.length() == 0 || ff == null && vv == null || !Table.isValidClause(record_processor, Field.INSERT, c, this.getNamedFieldMap(), wf, vv, ww, hh, wa, ha).booleanValue()) {
            record_processor.addError("ERROR: validateDeleteWhereStatement.validateDeleteWhereStatement.isValidClause");
            return null;
        }
        JsonObject job = null;
        for (int i = 0; i < v.size(); ++i) {
            Field f;
            ArrayList<Object> r = new ArrayList<Object>();
            JsonObject jsonObject = v.get(i).getAsJsonObject();
            if (jsonObject == null) {
                record_processor.addError("Null Json Object on group [" + i + "]");
            } else if (jsonObject.size() == 0) {
                record_processor.addError("Empty Json Object on group [" + i + "]");
            } else if (job != null && jsonObject.size() != job.size()) {
                record_processor.addError("Json Object has different elements count on group [" + i + "]");
            }
            job = jsonObject;
            if (record_processor.hasErrors().booleanValue()) {
                record_processor.addError("ERROR: validateDeleteWhereStatement.validateDeleteWhereStatement.Fields");
                return null;
            }
            if (uf.size() == 0) {
                for (String field_alias : jsonObject.keySet()) {
                    f = this.getAliasedField(field_alias);
                    if (f == null && ff != null && !ff.contains(field_alias)) {
                        record_processor.addError("Field '" + field_alias + "' is unknowen to where field_list");
                        continue;
                    }
                    if (f == null && ff != null && ff.contains(field_alias)) continue;
                    if (f == null) {
                        record_processor.addError("Field '" + field_alias + "' is not a valid field name");
                        continue;
                    }
                    uf.add(f);
                }
                if (record_processor.hasErrors().booleanValue()) {
                    record_processor.addError("ERROR: validateDeleteWhereStatement.validateDeleteWhereStatement.PRE_PROCESS");
                    return null;
                }
            }
            StringBuilder er = new StringBuilder();
            for (int x = jsonObject.size(); x < wf.size() + jsonObject.size(); ++x) {
                f = wf.get(x - jsonObject.size());
                String ue = null;
                ue = ff == null ? JsonUtil.getJsonString((JsonArray)wvv, (Integer)(x - jsonObject.size()), (Boolean)false) : JsonUtil.getJsonString((JsonObject)jsonObject, (String)wff.get(x - jsonObject.size()).getAsString(), (Boolean)false);
                if (!f.isValid(Field.DELETE, ue, er).booleanValue()) {
                    record_processor.addError(er.toString());
                    continue;
                }
                r.add(f.getFieldObject(ue));
            }
            ufv.add(r);
        }
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.addError("ERROR: validateDeleteWhereStatement.validateDeleteWhereStatement.FIELD_VALIDATION");
            return null;
        }
        int idx = -1;
        idx = query.indexOf("$WHERE$");
        query.replace(idx, idx + 7, "");
        StringBuilder stringBuilder = w = ww != null && ww.length() > 0 ? ww : hh;
        if (w != null) {
            query.insert(idx, w.length() == 0 ? "" : " WHERE ");
            query.insert(idx + 7, w);
        }
        return query.toString();
    }

    public static void loadDataModel(String secret_key, JDBCSource model_jdbc_source, JDBCSource data_jdbc_source, Integer model_id, HashMap<String, Class> interface_implementation, JsonArray error_list, Boolean foreing_key_must_link_to_primary_key) throws Exception {
        ModelDefinition data_model_definition;
        DataLookup data_lookup;
        DataClass.LoadMethod loadMethod;
        Integer model_instance_id;
        block45: {
            model_instance_id = 1;
            loadMethod = DataClass.LoadMethod.REFLECTION;
            data_lookup = null;
            data_model_definition = null;
            try (Connection data_connection = model_jdbc_source.getConnection(Boolean.valueOf(false));){
                String select_model = "SELECT `model_id`, `model_instance_sequence_type_id`, `model_instance_sequence_last_value`, `model_name`, `model_version`, `model_class_path`, `model_data_lookup_category`, `modeled_database_url`, `modeled_database_url_user_name`, CAST(AES_DECRYPT(FROM_BASE64(`modeled_database_url_user_password`), ?) AS CHAR) AS `modeled_database_url_user_password`, `modeled_database_schem`, `modeled_database_name`, `modeled_database_field_open_quote`, `modeled_database_field_close_quote` FROM `" + model_jdbc_source.getDatabaseName() + "`.`model` WHERE `model_id`=?";
                try (PreparedStatement stmt = data_connection.prepareStatement(select_model);){
                    stmt.setString(1, secret_key);
                    stmt.setInt(2, model_id);
                    try (ResultSet resultset = stmt.executeQuery();){
                        ArrayList data_model_definition_list = JsonResultset.resultset((ResultSet)resultset, ModelDefinition.class);
                        if (data_model_definition_list == null || data_model_definition_list.size() == 0) {
                            error_list.add("Data Model ID '" + model_id + "' is not exist");
                        } else {
                            data_model_definition = (ModelDefinition)data_model_definition_list.get(0);
                        }
                        resultset.close();
                    }
                    stmt.close();
                }
                if (data_model_definition == null) break block45;
                String sql = "SELECT `enum_name`, `enum_element_id`, `enum_element_code`, `enum_element_java_datatype`, `enum_element_typescript_datatype` FROM `" + model_jdbc_source.getDatabaseName() + "`.`lookup_enum` INNER JOIN `" + model_jdbc_source.getDatabaseName() + "`.`lookup_enum_element` ON `lookup_enum`.`enum_id` = `lookup_enum_element`.`enum_id` WHERE `lookup_enum`.`enum_name`=? ORDER BY `enum_name`, `enum_element_code`";
                try (PreparedStatement stmt = data_connection.prepareStatement(sql);){
                    stmt.setString(1, data_model_definition.model_data_lookup_category);
                    try (ResultSet resultset = stmt.executeQuery();){
                        data_lookup = new DataLookup(resultset, data_model_definition.model_data_lookup_category, "enum_name", "enum_element_id", "enum_element_code", "enum_element_java_datatype", "enum_element_typescript_datatype");
                        resultset.close();
                    }
                }
            }
        }
        if (data_model_definition != null) {
            DataProcessor dataProcessor = new DataProcessor(EnterpriseModel.class, Enterprise.class, model_jdbc_source, data_model_definition, data_lookup, interface_implementation, foreing_key_must_link_to_primary_key);
            EnterpriseModel enterprise_model = (EnterpriseModel)dataProcessor.loadModelFromDatabase(model_id, model_instance_id, loadMethod);
            ((Enterprise)enterprise_model.getInstance()).init();
            data_model_map.put(model_id, enterprise_model);
        }
    }

    private void initializeTable(Integer model_id, JsonArray table_error_list) throws Exception {
        EnterpriseModel<Enterprise> enterprise_model = data_model_map.get(model_id);
        net.reyadeyat.api.relational.model.Table database_table = ((Enterprise)enterprise_model.getInstance()).getDatabase(this.data_database_name).getTable(this.request_table.table_name);
        for (RequestField request_field : this.request_table.request_field_list) {
            net.reyadeyat.api.relational.model.Field table_field = database_table.field_map.get(request_field.field_name);
            if (table_field == null) {
                table_error_list.add("Request Field '" + request_field.field_name + "' not found in Table '" + this.request_table.table_name + "'");
            }
            FieldType field_type = FieldType.getClassFieldType(table_field.getTypeJavaClass());
            Boolean nullable = table_field.nullable;
            Boolean group_by = false;
            Field field = this.addField(this.request_table.table_name, this.request_table.table_alias, request_field.field_name, request_field.field_alias, nullable, group_by, field_type, table_error_list);
            if (table_field.getTypeJavaClass().equals(String.class)) {
                field.setTexLengthRange(0, table_field.size);
                continue;
            }
            if (!table_field.getTypeJavaClass().equals(Number.class)) continue;
            field.setNumberRange(0, table_field.size);
        }
        if (this.request_table.parent_request_table != null) {
            ArrayList<net.reyadeyat.api.relational.model.ForeignKey> foreign_key_list = database_table.foreign_key_list;
            Integer foreign_key_counter = 0;
            while (foreign_key_counter < foreign_key_list.size()) {
                net.reyadeyat.api.relational.model.ForeignKey foreign_key = foreign_key_list.get(foreign_key_counter);
                for (ForeignKeyField foreign_key_field : foreign_key.foreign_key_field_list) {
                    if (!foreign_key.referenced_key_table_name.equals(this.request_table.parent_request_table.table_name)) {
                        throw new Exception("request_table.parent_request_table.table_name '" + this.request_table.parent_request_table.table_name + "' is not equal to foreign_key.table.name");
                    }
                    RequestField foreign_request_field = this.request_table.parent_request_table.request_field_alias_map.get(this.parent_table.field_name_alias.get(foreign_key_field.name));
                    String foreign_table_alias = this.request_table.parent_request_table.table_alias;
                    RequestField request_field = this.request_table.request_field_name_map.get(foreign_key_field.name);
                    this.addForeignKey("FK_" + foreign_key.name, request_field.field_alias, this.request_table.parent_request_table.table_name, this.request_table.parent_request_table.table_alias, foreign_request_field.field_alias, table_error_list);
                    this.addJoinKey("JK_" + foreign_key.name, this.request_table.parent_request_table.table_name, foreign_table_alias, JoinKey.JoinType.INNER_JOIN);
                    this.addJoinField("JK_" + foreign_key.name, foreign_key.table.name, foreign_table_alias, foreign_key_field.name, foreign_request_field.field_name, JoinKey.JoinType.INNER_JOIN, table_error_list);
                }
                Integer n = foreign_key_counter;
                foreign_key_counter = foreign_key_counter + 1;
            }
        }
    }

    private void validateCommand(RecordProcessor record_processor) throws Exception {
        Request request = record_processor.getTableRequest();
        if (!(record_processor.is_select().booleanValue() || request.value_map != null && request.value_map.size() != 0 || request.insert_field_map != null || request.update_field_map != null || request.delete_field_map != null)) {
            record_processor.addError(record_processor.getCommand() + " command misses 'values' array");
        }
        if (record_processor.is_select().booleanValue()) {
            String response = record_processor.getResponseView();
            if (!(response.equalsIgnoreCase("tabular") || response.equalsIgnoreCase("tree") || response.equalsIgnoreCase("process"))) {
                record_processor.addError("Unknown response type '" + response + "' define ['tabular', 'tree', 'process']");
            } else if (request.where == null) {
                record_processor.addError("Select command misses 'where' compound object");
            } else if (request.where.clause == null) {
                record_processor.addError("Select command misses 'where.clause' property");
            } else if (request.where.values == null) {
                record_processor.addError("Select command misses 'where.values' array");
            } else if (request.order_by_list == null) {
                record_processor.addError("Select command misses 'order_by_list' array");
            }
        }
    }

    public void process(Gson gson, RecordProcessor record_processor, RecordHandler record_handler) throws Exception {
        record_processor.beginObject();
        record_processor.name("header");
        this.prepareProcess(gson, record_processor, record_handler);
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.endObject();
            return;
        }
        this.executeProcess(gson, record_processor, record_handler);
        if (record_processor.hasErrors().booleanValue()) {
            record_processor.endObject();
            return;
        }
        record_processor.name("stats");
        this.statProcess(gson, record_processor);
        record_processor.endObject();
        record_processor.flush();
    }

    private void prepareProcess(Gson gson, RecordProcessor record_processor, RecordHandler record_handler) throws Exception {
        record_processor.beginObject();
        record_processor.name("table_alias");
        record_processor.value(record_processor.request.table_alias);
        if (record_processor.is_select().booleanValue()) {
            record_processor.query.t1 = Instant.now();
            this.prepareSelectStatement(gson, record_processor, record_handler);
        } else if (record_processor.is_update().booleanValue() || record_processor.is_insert().booleanValue() || record_processor.is_delete().booleanValue()) {
            // empty if block
        }
        if (record_processor.hasErrors().booleanValue()) {
            return;
        }
        if (this.child_table_map == null || this.child_table_map.size() == 0) {
            record_processor.endObject();
            return;
        }
        record_processor.name("children");
        record_processor.beginArray();
        for (int i = 0; i < record_processor.child_list.size(); ++i) {
            RecordProcessor child_record_processor = record_processor.child_list.get(i);
            Table child_table = this.child_table_map.get(child_record_processor.request.table_alias);
            if (child_table == null) {
                record_processor.addError("Child Table aliased '" + child_record_processor.request.table_alias + "' is null of Parent Table aliased '" + this.request_table.table_alias + "'");
            }
            child_table.prepareProcess(gson, child_record_processor, record_handler);
        }
        record_processor.endArray();
        record_processor.endObject();
    }

    private void executeProcess(Gson gson, RecordProcessor record_processor, RecordHandler record_handler) throws Exception {
        try (Connection connection = record_handler.getDatabaseConnection(this.data_datasource_name);){
            if (record_processor.is_select().booleanValue()) {
                record_processor.name("resultset");
                record_processor.beginArray();
                this.executeSelect(gson, connection, record_processor, record_handler);
                record_processor.endArray();
            } else if (record_processor.is_update().booleanValue() || record_processor.is_insert().booleanValue() || record_processor.is_delete().booleanValue()) {
                // empty if block
            }
            if (record_processor.hasErrors().booleanValue()) {
                return;
            }
            record_processor.flush();
        }
    }

    public void statProcess(Gson gson, RecordProcessor record_processor) throws Exception {
        record_processor.beginObject();
        record_processor.name(record_processor.request.table_alias);
        record_processor.beginObject();
        record_processor.query_stats();
        if (this.child_table_map == null || this.child_table_map.size() == 0) {
            record_processor.endObject();
            record_processor.endObject();
            return;
        }
        record_processor.name("children");
        record_processor.beginArray();
        for (int i = 0; i < record_processor.child_list.size(); ++i) {
            RecordProcessor child_record_processor = record_processor.child_list.get(i);
            Table child_table = this.child_table_map.get(child_record_processor.request.table_alias);
            if (child_table == null) {
                record_processor.addError("Child Table aliased '" + child_record_processor.request.table_alias + "' is null of Parent Table aliased '" + this.request_table.table_alias + "'");
            }
            child_table.statProcess(gson, child_record_processor);
        }
        record_processor.endArray();
        record_processor.endObject();
        record_processor.endObject();
    }
}

