/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.reyadeyat.api.relational.database.Field;

public class UpdateKey {
    private String database_name;
    private String update_table;
    private ArrayList<Field> field_list;
    private HashMap<Field, String> updateFields;
    private String updating_validation_statement;

    public UpdateKey(String database_name, String update_table) {
        this.database_name = database_name;
        this.update_table = update_table;
    }

    public void addUpdateField(Field field, String updateField) {
        this.updateFields.put(field, updateField);
    }

    public String getUpdateField(Field field) {
        return this.updateFields.get(field);
    }

    public void prepareUpdatingStatement() {
        StringBuilder sb = new StringBuilder();
        this.field_list = new ArrayList<Field>(this.updateFields.keySet());
        Collections.sort(this.field_list);
        sb.append("SELECT * FROM ").append("`").append(this.database_name).append("`.`").append(this.update_table).append("` WHERE ");
        for (int i = 0; i < this.field_list.size(); ++i) {
            Field field = this.field_list.get(i);
            String updateFieldName = this.updateFields.get(field);
            sb.append("`").append(this.update_table).append("`.`").append(updateFieldName).append("`=?").append(i + 1 == this.field_list.size() ? "" : " AND ");
        }
        this.updating_validation_statement = sb.toString();
    }

    public String getUpdateValidationStatement() {
        return this.updating_validation_statement;
    }
}

