/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.api.relational.data.DataSet;
import net.reyadeyat.api.relational.model.Enterprise;
import net.reyadeyat.api.relational.model.Field;
import net.reyadeyat.api.relational.model.ForeignKey;
import net.reyadeyat.api.relational.model.ForeignKeyField;
import net.reyadeyat.api.relational.model.ReferencedKeyField;
import net.reyadeyat.api.relational.model.Table;

public class Database {
    public String name;
    public String engine;
    public ArrayList<Table> table_list = new ArrayList();
    public String java_package_name;
    public transient Boolean case_sensitive_sql;
    public transient Enterprise enterprise;
    public transient HashMap<String, Table> table_map = new HashMap();

    public Database() {
    }

    public void init() {
        for (Table table : this.table_list) {
            table.init();
            this.table_map.put(table.name, table);
        }
    }

    public Database(String name, String engine, Boolean case_sensitive_sql, String java_package_name) {
        this();
        this.name = name;
        this.engine = engine;
        this.case_sensitive_sql = case_sensitive_sql;
        this.java_package_name = java_package_name;
    }

    public void addTable(Table table) {
        table.database = this;
        this.table_list.add(table);
        this.table_map.put(table.name, table);
    }

    public Table getTable(String table_name) {
        return this.table_map.get(table_name);
    }

    public void extractTableLogic(Boolean is_building_model) throws Exception {
        for (Table table : this.table_list) {
            this.table_map.put(table.name, table);
            ArrayList<Table> tablesPath = new ArrayList<Table>();
            ArrayList<ArrayList<Table>> tablesPathReturned = new ArrayList<ArrayList<Table>>();
            table.compileTablePaths(tablesPath, tablesPathReturned, is_building_model);
        }
    }

    public String pathToString(ArrayList<Table> tablesPath) throws Exception {
        if (tablesPath == null) {
            throw new Exception("tablePath is null");
        }
        StringBuilder b = new StringBuilder();
        for (int x = 0; x < tablesPath.size(); ++x) {
            Table tt = tablesPath.get(x);
            b.append(tt.name).append(".");
        }
        if (tablesPath.size() > 0) {
            b.delete(b.length() - 1, b.length());
        }
        return b.toString();
    }

    public ArrayList<Table> findPath(String path) throws Exception {
        String[] stringArray;
        if (path == null) {
            throw new Exception("path is null");
        }
        ArrayList<Table> tablePath = new ArrayList<Table>();
        if (path.indexOf(".") == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path;
        } else {
            stringArray = path.split("\\.");
        }
        String[] table_list = stringArray;
        Table parentTable = null;
        for (int i = 0; i < table_list.length; ++i) {
            String tableName = table_list[i];
            Table table = this.table_map.get(tableName);
            if (table != null) {
                if (parentTable != null && !parentTable.hasChild(table).booleanValue()) {
                    throw new Exception("Table '" + tableName + "' in Path '" + path + "' is not child to Table '' no ForeignKey defined");
                }
            } else {
                throw new Exception("Table '" + tableName + "' in Path '" + path + "' is not valid");
            }
            tablePath.add(table);
            parentTable = table;
        }
        return tablePath;
    }

    public JsonElement getInnerJoinedSelect(String path) throws Exception {
        return this.getInnerJoinedSelect(null, path, null, "", "", "");
    }

    public JsonElement getInnerJoinedSelectMySQL(String path) throws Exception {
        return this.getInnerJoinedSelect(null, path, null, "", "`", "`");
    }

    public JsonElement getInnerJoinedSelectSQLServer(String path) throws Exception {
        return this.getInnerJoinedSelect(null, path, null, "", "[", "]");
    }

    public JsonElement getInnerJoinedSelect(String path, String databaseFieldOpenQuote, String databaseFieldCloseQuote) throws Exception {
        return this.getInnerJoinedSelect(null, path, null, "", databaseFieldOpenQuote, databaseFieldCloseQuote);
    }

    public JsonElement getInnerJoinedSelect(String path, String databaseSchem, String databaseFieldOpenQuote, String databaseFieldCloseQuote) throws Exception {
        return this.getInnerJoinedSelect(null, path, null, databaseSchem, databaseFieldOpenQuote, databaseFieldCloseQuote);
    }

    public JsonElement getInnerJoinedSelect(Connection connection, String path, String whereClause, String databaseSchem, String databaseFieldOpenQuote, String databaseFieldCloseQuote) throws Exception {
        String[] stringArray;
        if (path == null) {
            throw new Exception("path is null");
        }
        ArrayList<Table> tablePath = new ArrayList<Table>();
        if (path.indexOf(".") == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path;
        } else {
            stringArray = path.split("\\.");
        }
        String[] table_list = stringArray;
        Table parentTable = null;
        for (int i = 0; i < table_list.length; ++i) {
            String tableName = table_list[i];
            Table table = this.table_map.get(tableName);
            if (table != null) {
                if (parentTable != null && !parentTable.hasChild(table).booleanValue()) {
                    throw new Exception("Table '" + tableName + "' in Path '" + path + "' is not child to Table '' no ForeignKey defined");
                }
            } else {
                throw new Exception("Table '" + tableName + "' in Path '" + path + "' is not valid");
            }
            tablePath.add(table);
            parentTable = table;
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{128}).create();
        int tableRandom = 1000;
        int fieldRandom = 100;
        Table oldTable = null;
        String oldTableAlias = null;
        DataSet dataSet = new DataSet(path);
        StringBuilder select = new StringBuilder();
        StringBuilder from = new StringBuilder();
        select.append("SELECT ");
        from.append("FROM ");
        if (databaseSchem == null || !((String)databaseSchem).isEmpty()) {
            databaseSchem = "." + databaseFieldOpenQuote + (String)databaseSchem + databaseFieldCloseQuote;
        }
        for (int i = 0; i < tablePath.size(); ++i) {
            int x;
            Table table = (Table)tablePath.get(i);
            String tableAlias = table.name + "_" + ++tableRandom;
            dataSet.addTable(tableAlias, table.name);
            if (oldTable != null) {
                from.append(" INNER JOIN ");
            }
            from.append(databaseFieldOpenQuote).append(this.name).append(databaseFieldCloseQuote).append((String)databaseSchem).append(".").append(databaseFieldOpenQuote).append(table.name).append(databaseFieldCloseQuote).append(" AS ").append(databaseFieldOpenQuote).append(tableAlias).append(databaseFieldCloseQuote);
            if (oldTable != null) {
                from.append(" ON ");
                for (x = 0; x < table.foreign_key_list.size(); ++x) {
                    ForeignKey foreignKey = table.foreign_key_list.get(x);
                    if (!foreignKey.referenced_key_table_name.equalsIgnoreCase(oldTable.name)) continue;
                    String foreign_key_table_name = foreignKey.foreign_key_table_name;
                    String referenced_key_table_name = foreignKey.referenced_key_table_name;
                    for (int f = 0; f < foreignKey.foreign_key_field_list.size(); ++f) {
                        ForeignKeyField foreignKeyField = foreignKey.foreign_key_field_list.get(f);
                        ReferencedKeyField referenced_key_field = foreignKey.referenced_key_field_list.get(f);
                        from.append(databaseFieldOpenQuote).append(oldTableAlias).append(databaseFieldCloseQuote).append(".").append(databaseFieldOpenQuote).append(foreignKeyField.name).append(databaseFieldCloseQuote).append("=").append(databaseFieldOpenQuote).append(tableAlias).append(databaseFieldCloseQuote).append(".").append(databaseFieldOpenQuote).append(referenced_key_field.name).append(databaseFieldCloseQuote).append(" AND ");
                    }
                }
                from.delete(from.length() - 5, from.length());
            }
            for (x = 0; x < table.field_list.size(); ++x) {
                Field field = table.field_list.get(x);
                String fieldAlias = field.name + "_" + ++fieldRandom;
                dataSet.addField(tableAlias, fieldAlias, field.name, field.getTypeJavaClassPath());
                select.append(databaseFieldOpenQuote).append(tableAlias).append(databaseFieldCloseQuote).append(".").append(databaseFieldOpenQuote).append(field.name).append(databaseFieldCloseQuote).append(" AS ").append(databaseFieldOpenQuote).append(fieldAlias).append(databaseFieldCloseQuote).append(",");
            }
            oldTable = table;
            oldTableAlias = tableAlias;
        }
        select.delete(select.length() - 1, select.length());
        select.append(" ").append((CharSequence)from);
        String sql = select.toString();
        dataSet.setSQL(sql);
        if (connection != null && whereClause != null) {
            dataSet.addRecords(connection, whereClause);
        }
        return gson.toJsonTree((Object)dataSet);
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        try {
            this.toString(appendable, 0, 4);
            return appendable.toString();
        }
        catch (Exception exception) {
            appendable.delete(0, appendable.length());
            appendable.append("Database: ").append(this.name).append(" Tables [").append(this.table_list.size()).append("]").toString();
            appendable.append("toString '").append(this.name).append("' error").append(exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
            return appendable.toString();
        }
    }

    public void toString(Appendable appendable, Integer level, Integer shift) throws Exception {
        int i;
        int i2;
        appendable.append("\n");
        for (i2 = 0; i2 < level * shift; ++i2) {
            appendable.append(" ");
        }
        appendable.append("|");
        for (i2 = 0; i2 < shift - 1; ++i2) {
            appendable.append(".");
        }
        appendable.append("Database: ").append(this.name).append(" Tables [").append(String.valueOf(this.table_list.size())).append("]");
        for (Table table : this.table_list) {
            table.toString(appendable, level + 1, shift);
        }
        appendable.append("\n=====================================================================================================\n");
        appendable.append("\n");
        for (i = 0; i < level * shift; ++i) {
            appendable.append(" ");
        }
        appendable.append("|");
        for (i = 0; i < shift - 1; ++i) {
            appendable.append(".");
        }
        appendable.append("Table Logic Tree: Database[").append(this.name).append("] Tables Count [").append(String.valueOf(this.table_list.size())).append("]");
        for (Table table : this.table_list) {
            ArrayList<Table> tablesPath = new ArrayList<Table>();
            tablesPath.add(table);
            table.toStringTableTree(appendable, level + 1, shift, tablesPath);
        }
    }
}

