/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.model;

import com.google.gson.JsonElement;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import net.reyadeyat.api.relational.annotation.MetadataAnnotation;
import net.reyadeyat.api.relational.data.DataLookup;
import net.reyadeyat.api.relational.model.Table;

public class Field {
    public String name;
    @MetadataAnnotation(lookup=true)
    public String data_type_name;
    public Boolean primary_key;
    public Boolean nullable;
    public Boolean auto_increment;
    public Boolean foreign_reference;
    @MetadataAnnotation(field=true, nullable=true)
    public String default_value;
    public Integer list_order;
    public Integer size;
    public Integer decimal_digits;
    public transient Boolean case_sensitive_sql;
    public transient Table table;

    public Field() {
    }

    public Field(Table table, String name, String data_type_name, String dataTypeCode, Boolean nullable, Boolean auto_increment, String default_value, Integer list_order, Integer size, Integer decimal_digits, Boolean case_sensitive_sql, DataLookup dataLookup) throws Exception {
        this.table = table;
        this.name = name;
        this.data_type_name = data_type_name.trim();
        if (dataLookup.lookupID(this.data_type_name) == null) {
            throw new Exception("Data Type '" + this.data_type_name + "' is not defined in Lookup Category '" + dataLookup.getDataLookupCategory() + "'");
        }
        this.primary_key = false;
        this.nullable = nullable;
        this.auto_increment = auto_increment;
        this.foreign_reference = false;
        this.default_value = default_value;
        this.list_order = list_order;
        this.size = size;
        this.decimal_digits = decimal_digits;
        this.case_sensitive_sql = case_sensitive_sql;
    }

    public void init() {
    }

    public void setPrimaryKey() {
        this.primary_key = true;
    }

    public void setForeignReference() {
        this.foreign_reference = true;
    }

    public String toString(Integer level, Integer shift) {
        int i;
        StringBuilder b = new StringBuilder();
        b.append("\n");
        for (i = 0; i < level * shift; ++i) {
            b.append(" ");
        }
        b.append("|");
        for (i = 0; i < shift - 1; ++i) {
            b.append(".");
        }
        b.append("Field: ").append("[").append(this.list_order).append("] `").append(this.name).append("` ").append(this.data_type_name).append("(").append(this.size).append((String)(this.decimal_digits > 0 ? "," + this.decimal_digits : "")).append(")").append(this.nullable == true ? " NULL" : "").append(this.auto_increment == true ? " AUTOINCREMENT" : "").append((String)(this.default_value == null ? "" : " DEFAULT '" + this.default_value + "'"));
        return b.toString();
    }

    public String toString() {
        return "Field: " + "[" + this.list_order + "] `" + this.name + "` " + this.data_type_name + "(" + this.size + (String)(this.decimal_digits > 0 ? "," + this.decimal_digits : "") + ")" + (this.nullable == true ? " NULL" : "") + (this.auto_increment == true ? " AUTOINCREMENT" : "") + (String)(this.default_value == null ? "" : " '" + this.default_value + "'");
    }

    public String getTypeJavaClassPath() throws Exception {
        if (this.data_type_name.equalsIgnoreCase("BIT") || this.data_type_name.equalsIgnoreCase("TINYINT") || this.data_type_name.equalsIgnoreCase("TINYINT UNSIGNED") && this.size == 1 || this.data_type_name.equalsIgnoreCase("BOOLEAN")) {
            return Boolean.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("TINYINT") || this.data_type_name.equalsIgnoreCase("TINYINT UNSIGNED")) {
            return Byte.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("SMALLINT") || this.data_type_name.equalsIgnoreCase("SMALLINT UNSIGNED")) {
            return Short.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("MEDIUMINT") || this.data_type_name.equalsIgnoreCase("INT") || this.data_type_name.equalsIgnoreCase("INTEGER") || this.data_type_name.equalsIgnoreCase("MEDIUMINT UNSIGNED") || this.data_type_name.equalsIgnoreCase("INT UNSIGNED") || this.data_type_name.equalsIgnoreCase("INTEGER UNSIGNED") || this.data_type_name.equalsIgnoreCase("BIT") || this.data_type_name.equalsIgnoreCase("BIT UNSIGNED") || this.data_type_name.equalsIgnoreCase("INT IDENTITY") || this.data_type_name.equalsIgnoreCase("SERIAL")) {
            return Integer.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("BIGINT") || this.data_type_name.equalsIgnoreCase("BIGINT UNSIGNED") || this.data_type_name.equalsIgnoreCase("BIGINT IDENTITY") || this.data_type_name.equalsIgnoreCase("SERIAL8") || this.data_type_name.equalsIgnoreCase("INT8") || this.data_type_name.equalsIgnoreCase("BIGSERIAL")) {
            return Long.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("FLOAT") || this.data_type_name.equalsIgnoreCase("FLOAT UNSIGNED")) {
            return Float.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("DOUBLE") || this.data_type_name.equalsIgnoreCase("DOUBLE UNSIGNED")) {
            return Double.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("NUMERIC") || this.data_type_name.equalsIgnoreCase("DECIMAL") || this.data_type_name.equalsIgnoreCase("NUMERIC UNSIGNED") || this.data_type_name.equalsIgnoreCase("DECIMAL UNSIGNED") || this.data_type_name.equalsIgnoreCase("UNIQUEIDENTIFIER") || this.data_type_name.equalsIgnoreCase("MONEY") || this.data_type_name.equalsIgnoreCase("numeric() identity")) {
            if (this.decimal_digits == 0) {
                return Long.class.getCanonicalName();
            }
            return Double.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("YEAR") || this.data_type_name.equalsIgnoreCase("DATE")) {
            return Date.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("TIME")) {
            return Time.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("DATETIME") || this.data_type_name.equalsIgnoreCase("TIMESTAMP") || this.data_type_name.equalsIgnoreCase("SMALLDATETIME") || this.data_type_name.toLowerCase().startsWith("datetime")) {
            return Timestamp.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("CHAR") || this.data_type_name.equalsIgnoreCase("ENUM") || this.data_type_name.equalsIgnoreCase("SET") || this.data_type_name.equalsIgnoreCase("VARCHAR") || this.data_type_name.equalsIgnoreCase("TINYTEXT") || this.data_type_name.equalsIgnoreCase("TEXT") || this.data_type_name.equalsIgnoreCase("MEDIUMTEXT") || this.data_type_name.equalsIgnoreCase("LONGTEXT") || this.data_type_name.equalsIgnoreCase("NVARCHAR") || this.data_type_name.equalsIgnoreCase("NTEXT") || this.data_type_name.equalsIgnoreCase("NCHAR") || this.data_type_name.equalsIgnoreCase("SYSNAME") || this.data_type_name.equalsIgnoreCase("GEOGRAPHY") || this.data_type_name.equalsIgnoreCase("LVARCHAR")) {
            return String.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("BINARY") || this.data_type_name.equalsIgnoreCase("VARBINARY") || this.data_type_name.equalsIgnoreCase("TINYBLOB") || this.data_type_name.equalsIgnoreCase("BLOB") || this.data_type_name.equalsIgnoreCase("CLOB") || this.data_type_name.equalsIgnoreCase("MEDIUMBLOB") || this.data_type_name.equalsIgnoreCase("LONGBLOB") || this.data_type_name.equalsIgnoreCase("IMAGE")) {
            return Object.class.getCanonicalName();
        }
        if (this.data_type_name.equalsIgnoreCase("JSON")) {
            return JsonElement.class.getCanonicalName();
        }
        throw new Exception("Field data type '" + this.data_type_name + "' is not implemented yet");
    }

    public Class getTypeJavaClass() throws Exception {
        if (this.data_type_name.equalsIgnoreCase("BIT") || this.data_type_name.equalsIgnoreCase("TINYINT") || this.data_type_name.equalsIgnoreCase("TINYINT UNSIGNED") && this.size == 1 || this.data_type_name.equalsIgnoreCase("BOOLEAN")) {
            return Boolean.class;
        }
        if (this.data_type_name.equalsIgnoreCase("TINYINT") || this.data_type_name.equalsIgnoreCase("TINYINT UNSIGNED")) {
            return Byte.class;
        }
        if (this.data_type_name.equalsIgnoreCase("SMALLINT") || this.data_type_name.equalsIgnoreCase("SMALLINT UNSIGNED")) {
            return Short.class;
        }
        if (this.data_type_name.equalsIgnoreCase("MEDIUMINT") || this.data_type_name.equalsIgnoreCase("INT") || this.data_type_name.equalsIgnoreCase("INTEGER") || this.data_type_name.equalsIgnoreCase("MEDIUMINT UNSIGNED") || this.data_type_name.equalsIgnoreCase("INT UNSIGNED") || this.data_type_name.equalsIgnoreCase("INTEGER UNSIGNED") || this.data_type_name.equalsIgnoreCase("BIT") || this.data_type_name.equalsIgnoreCase("BIT UNSIGNED") || this.data_type_name.equalsIgnoreCase("INT IDENTITY") || this.data_type_name.equalsIgnoreCase("SERIAL")) {
            return Integer.class;
        }
        if (this.data_type_name.equalsIgnoreCase("BIGINT") || this.data_type_name.equalsIgnoreCase("BIGINT UNSIGNED") || this.data_type_name.equalsIgnoreCase("BIGINT IDENTITY") || this.data_type_name.equalsIgnoreCase("SERIAL8") || this.data_type_name.equalsIgnoreCase("INT8") || this.data_type_name.equalsIgnoreCase("BIGSERIAL")) {
            return Long.class;
        }
        if (this.data_type_name.equalsIgnoreCase("FLOAT") || this.data_type_name.equalsIgnoreCase("FLOAT UNSIGNED")) {
            return Float.class;
        }
        if (this.data_type_name.equalsIgnoreCase("DOUBLE") || this.data_type_name.equalsIgnoreCase("DOUBLE UNSIGNED")) {
            return Double.class;
        }
        if (this.data_type_name.equalsIgnoreCase("NUMERIC") || this.data_type_name.equalsIgnoreCase("DECIMAL") || this.data_type_name.equalsIgnoreCase("NUMERIC UNSIGNED") || this.data_type_name.equalsIgnoreCase("DECIMAL UNSIGNED") || this.data_type_name.equalsIgnoreCase("UNIQUEIDENTIFIER") || this.data_type_name.equalsIgnoreCase("MONEY") || this.data_type_name.equalsIgnoreCase("numeric() identity")) {
            if (this.decimal_digits == 0) {
                return Long.class;
            }
            return Double.class;
        }
        if (this.data_type_name.equalsIgnoreCase("YEAR") || this.data_type_name.equalsIgnoreCase("DATE")) {
            return Date.class;
        }
        if (this.data_type_name.equalsIgnoreCase("TIME")) {
            return Time.class;
        }
        if (this.data_type_name.equalsIgnoreCase("DATETIME") || this.data_type_name.equalsIgnoreCase("TIMESTAMP") || this.data_type_name.equalsIgnoreCase("SMALLDATETIME") || this.data_type_name.toLowerCase().startsWith("datetime")) {
            return Timestamp.class;
        }
        if (this.data_type_name.equalsIgnoreCase("CHAR") || this.data_type_name.equalsIgnoreCase("ENUM") || this.data_type_name.equalsIgnoreCase("SET") || this.data_type_name.equalsIgnoreCase("VARCHAR") || this.data_type_name.equalsIgnoreCase("TINYTEXT") || this.data_type_name.equalsIgnoreCase("TEXT") || this.data_type_name.equalsIgnoreCase("MEDIUMTEXT") || this.data_type_name.equalsIgnoreCase("LONGTEXT") || this.data_type_name.equalsIgnoreCase("NVARCHAR") || this.data_type_name.equalsIgnoreCase("NTEXT") || this.data_type_name.equalsIgnoreCase("NCHAR") || this.data_type_name.equalsIgnoreCase("SYSNAME") || this.data_type_name.equalsIgnoreCase("GEOGRAPHY") || this.data_type_name.equalsIgnoreCase("LVARCHAR")) {
            return String.class;
        }
        if (this.data_type_name.equalsIgnoreCase("BINARY") || this.data_type_name.equalsIgnoreCase("VARBINARY") || this.data_type_name.equalsIgnoreCase("TINYBLOB") || this.data_type_name.equalsIgnoreCase("BLOB") || this.data_type_name.equalsIgnoreCase("CLOB") || this.data_type_name.equalsIgnoreCase("MEDIUMBLOB") || this.data_type_name.equalsIgnoreCase("LONGBLOB") || this.data_type_name.equalsIgnoreCase("IMAGE")) {
            return Object.class;
        }
        if (this.data_type_name.equalsIgnoreCase("JSON")) {
            return JsonElement.class;
        }
        throw new Exception("Field data type '" + this.data_type_name + "' is not implemented yet");
    }
}

