/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.stream.JsonWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.reyadeyat.api.library.jdbc.JDBCSource;
import net.reyadeyat.api.library.json.JsonResultset;
import net.reyadeyat.api.library.json.JsonZonedDateTimeAdapter;
import net.reyadeyat.api.relational.data.DataClass;
import net.reyadeyat.api.relational.data.DataLookup;
import net.reyadeyat.api.relational.data.DataModel;
import net.reyadeyat.api.relational.data.DataProcessor;
import net.reyadeyat.api.relational.data.ModelDefinition;
import net.reyadeyat.api.relational.model.DataStructure;
import net.reyadeyat.api.relational.model.Database;
import net.reyadeyat.api.relational.model.Enterprise;
import net.reyadeyat.api.relational.model.EnterpriseModel;
import net.reyadeyat.api.relational.model.Field;
import net.reyadeyat.api.relational.model.ForeignKey;
import net.reyadeyat.api.relational.model.ForeignKeyField;
import net.reyadeyat.api.relational.model.PrimaryKey;
import net.reyadeyat.api.relational.model.PrimaryKeyField;
import net.reyadeyat.api.relational.model.ReferencedKeyField;
import net.reyadeyat.api.relational.model.Table;
import net.reyadeyat.api.relational.model.TableInterfaceImplementationDataStructures;

public class MetadataMiner {
    private Integer model_id;
    private String model_name;
    private String model_description;
    private DataLookup data_lookup;
    private String java_package_name;
    private JDBCSource model_jdbc_source;
    private JDBCSource data_jdbc_source;
    private ModelDefinition model_definition;
    private String model_secret_key;
    private Map<String, Class> interface_implementation;
    private List<String> table_list;
    private Boolean foreing_key_must_link_to_primary_key;
    private static String nl = "\n";
    private static String section_separator = "\n-------------------------------------------------------------------------------\n";
    private static String data_separator = "  -------------------------  ";

    public MetadataMiner(Integer model_id, String java_package_name, JDBCSource model_jdbc_source, JDBCSource data_jdbc_source, List<String> table_list, ModelDefinition model_definition, String model_secret_key, Map<String, Class> interface_implementation, Boolean foreing_key_must_link_to_primary_key) throws Exception {
        this.model_id = model_id == null ? -1 : model_id;
        this.java_package_name = java_package_name;
        this.model_jdbc_source = model_jdbc_source;
        this.data_jdbc_source = data_jdbc_source;
        this.table_list = table_list;
        this.model_definition = model_definition;
        this.model_secret_key = model_secret_key;
        this.interface_implementation = interface_implementation;
        this.foreing_key_must_link_to_primary_key = foreing_key_must_link_to_primary_key;
    }

    public Integer generateModel(PrintWriter writer, JsonArray generating_time_elements, TableInterfaceImplementationDataStructures table_interface_implementation_data_structures) throws Exception {
        int shift;
        long t1;
        ArrayList<String> models = new ArrayList<String>(Arrays.asList(this.data_jdbc_source.getDatabaseName()));
        Boolean write_output = true;
        if (writer == null) {
            writer = new PrintWriter(PrintWriter.nullWriter());
            write_output = false;
        }
        try (Connection model_connection = this.model_jdbc_source.getConnection(Boolean.valueOf(false));
             Statement st = model_connection.createStatement();){
            String sql = "SELECT `enum_name`, `enum_element_id`, `enum_element_code`, `enum_element_java_datatype`, `enum_element_typescript_datatype` FROM `model`.`lookup_enum` INNER JOIN `model`.`lookup_enum_element` ON `lookup_enum`.`enum_id` = `lookup_enum_element`.`enum_id` WHERE `lookup_enum`.`enum_name`='" + this.model_definition.model_data_lookup_category + "' ORDER BY `enum_name`, `enum_element_code`";
            try (ResultSet rs = st.executeQuery(sql);){
                this.data_lookup = new DataLookup(rs, this.model_definition.model_data_lookup_category, "enum_name", "enum_element_id", "enum_element_code", "enum_element_java_datatype", "enum_element_typescript_datatype");
                rs.close();
            }
            st.close();
        }
        DatabaseMetaData databaseMetaData = null;
        String databaseEngine = null;
        String databaseURL = null;
        Boolean case_sensitive_sql = true;
        String source_url = null;
        String model_url = null;
        Enterprise model_enterprise = null;
        try (Connection data_database_connection = this.data_jdbc_source.getConnection(Boolean.valueOf(false));){
            ResultSetMetaData rsmd;
            ResultSet rs;
            t1 = System.nanoTime();
            databaseMetaData = data_database_connection.getMetaData();
            databaseEngine = databaseMetaData.getDatabaseProductName();
            databaseURL = databaseMetaData.getURL();
            source_url = databaseMetaData.getURL();
            model_url = databaseMetaData.getURL();
            if (databaseEngine.toLowerCase().contains("mysql")) {
                data_database_connection.createStatement().execute("USE " + this.data_jdbc_source.getDatabaseOpenQuote() + this.data_jdbc_source.getDatabaseName() + this.data_jdbc_source.getDatabaseCloseQuote());
                databaseEngine = "mysql";
            } else if (databaseEngine.toLowerCase().contains("sql server")) {
                data_database_connection.createStatement().execute("USE " + this.data_jdbc_source.getDatabaseOpenQuote() + this.data_jdbc_source.getDatabaseName() + this.data_jdbc_source.getDatabaseCloseQuote());
                databaseEngine = "sql server";
            } else if (databaseEngine.toLowerCase().contains("informix")) {
                data_database_connection.createStatement().execute("DATABASE " + this.data_jdbc_source.getDatabaseOpenQuote() + this.data_jdbc_source.getDatabaseName() + this.data_jdbc_source.getDatabaseCloseQuote());
                databaseEngine = "informix";
            } else {
                throw new Exception("Database '" + databaseEngine + "' is not implemented yet");
            }
            model_enterprise = new Enterprise(this.data_jdbc_source.getDatabaseName(), databaseEngine, databaseURL, case_sensitive_sql);
            ResultSet dbrs = databaseMetaData.getCatalogs();
            ResultSetMetaData dbrsmd = dbrs.getMetaData();
            int dbfeilds_count = dbrsmd.getColumnCount();
            while (dbrs.next()) {
                Iterator<Object> dbName = dbrs.getString("TABLE_CAT");
                for (String model : models) {
                    if ((!case_sensitive_sql.booleanValue() || !model.equals(dbName)) && (case_sensitive_sql.booleanValue() || !model.equalsIgnoreCase((String)((Object)dbName)))) continue;
                    Database tModelDatabase = new Database((String)((Object)dbName), databaseEngine, case_sensitive_sql, this.java_package_name);
                    model_enterprise.addDatabase(tModelDatabase);
                }
            }
            dbrs.close();
            for (Database tModelDatabase : model_enterprise.database_list) {
                int tbfeilds_count = 0;
                ResultSet tbrs = databaseMetaData.getTables(tModelDatabase.name, null, null, new String[]{"TABLE"});
                Iterator<Table> tbrsmd = tbrs.getMetaData();
                tbfeilds_count = tbrsmd.getColumnCount();
                while (tbrs.next()) {
                    String tableName = tbrs.getString("TABLE_NAME");
                    String tableSchem = tbrs.getString("TABLE_SCHEM");
                    if (this.table_list != null && this.table_list.size() > 0 && !this.table_list.contains(tableName) || this.data_jdbc_source.getDatabaseSchema() != null && tableSchem != null && this.data_jdbc_source.getDatabaseSchema().length() > 0 && !tableSchem.equalsIgnoreCase(this.data_jdbc_source.getDatabaseSchema())) continue;
                    Integer rows = 0;
                    Table table = new Table(tableName, case_sensitive_sql, rows, this.data_lookup, table_interface_implementation_data_structures);
                    tModelDatabase.addTable(table);
                }
                tbrs.close();
            }
            for (Database tModelDatabase : model_enterprise.database_list) {
                for (Table table : tModelDatabase.table_list) {
                    rs = databaseMetaData.getColumns(tModelDatabase.name, null, table.name, null);
                    rsmd = rs.getMetaData();
                    int feilds_count = rsmd.getColumnCount();
                    while (rs.next()) {
                        String name = rs.getString("COLUMN_NAME");
                        String dataTypeName = rs.getString("TYPE_NAME");
                        String dataTypeCode = rs.getString("DATA_TYPE");
                        Boolean nullable = rs.getString("IS_NULLABLE").equalsIgnoreCase("YES");
                        Boolean autoIncrment = rs.getString("IS_AUTOINCREMENT").equalsIgnoreCase("YES");
                        String defaultValue = rs.getString("COLUMN_DEF");
                        Integer list_order = rs.getInt("ORDINAL_POSITION");
                        Integer size = rs.getInt("COLUMN_SIZE");
                        Integer decimalDigits = rs.getObject("DECIMAL_DIGITS") == null ? 0 : rs.getInt("DECIMAL_DIGITS");
                        Field modelField = new Field(table, name, dataTypeName, dataTypeCode, nullable, autoIncrment, defaultValue, list_order, size, decimalDigits, case_sensitive_sql, this.data_lookup);
                        table.addField(modelField);
                    }
                    rs.close();
                }
            }
            for (Database tModelDatabase : model_enterprise.database_list) {
                for (Table table : tModelDatabase.table_list) {
                    rs = databaseMetaData.getPrimaryKeys(tModelDatabase.name, null, table.name);
                    rsmd = rs.getMetaData();
                    int feilds_count = rsmd.getColumnCount();
                    String currentPrimaryKeyName = "";
                    PrimaryKey modelPrimaryKey = null;
                    while (rs.next()) {
                        String primaryKeyName = rs.getString("PK_NAME");
                        if (modelPrimaryKey == null || !case_sensitive_sql.booleanValue() && !primaryKeyName.equals(currentPrimaryKeyName) || case_sensitive_sql.booleanValue() && !primaryKeyName.equalsIgnoreCase(currentPrimaryKeyName)) {
                            modelPrimaryKey = new PrimaryKey(table, primaryKeyName, case_sensitive_sql);
                        }
                        PrimaryKeyField primary_key_field = new PrimaryKeyField(rs.getString("COLUMN_NAME"), case_sensitive_sql);
                        modelPrimaryKey.addField(primary_key_field);
                        currentPrimaryKeyName = primaryKeyName;
                    }
                    rs.close();
                    if (modelPrimaryKey == null) continue;
                    table.addPrimaryKey(modelPrimaryKey);
                }
            }
            for (Database tModelDatabase : model_enterprise.database_list) {
                for (Table table : tModelDatabase.table_list) {
                    rs = databaseMetaData.getImportedKeys(tModelDatabase.name, null, table.name);
                    rsmd = rs.getMetaData();
                    int feilds_count = rsmd.getColumnCount();
                    String currentForeignKeyName = "";
                    ForeignKey modelForeignKey = null;
                    while (rs.next()) {
                        String foreignKeyName = rs.getString("FK_NAME");
                        String table_name = rs.getString("FKTABLE_NAME");
                        String referenced_key_table_name = rs.getString("PKTABLE_NAME");
                        Table parentTable = tModelDatabase.table_list.stream().filter(o -> o.name.equals(referenced_key_table_name)).findAny().orElse(null);
                        if (parentTable == null) {
                            writer.append("------------Warning - Foreign Key inconsitency detected - referenced table '" + referenced_key_table_name + "' for FOREIGN KEY " + foreignKeyName + " in table '" + table_name + "'-------------").append("\n");
                            continue;
                        }
                        if (modelForeignKey == null || case_sensitive_sql.booleanValue() && !foreignKeyName.equals(currentForeignKeyName) || !case_sensitive_sql.booleanValue() && !foreignKeyName.equalsIgnoreCase(currentForeignKeyName)) {
                            modelForeignKey = new ForeignKey(table, rs.getString("FK_NAME"), rs.getString("PK_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("FKTABLE_NAME"), rs.getInt("KEY_SEQ"), rs.getString("UPDATE_RULE"), rs.getString("DELETE_RULE"), rs.getString("DEFERRABILITY"), case_sensitive_sql);
                            table.addForeignKey(modelForeignKey);
                        }
                        String foreign_key_referenced_field_name = rs.getString("FKCOLUMN_NAME");
                        Boolean is_primary_key_field = parentTable.isFieldPrimaryKey(foreign_key_referenced_field_name);
                        ReferencedKeyField referenced_key_field = new ReferencedKeyField(foreign_key_referenced_field_name, case_sensitive_sql, is_primary_key_field);
                        ForeignKeyField foreignKeyField = new ForeignKeyField(rs.getString("PKCOLUMN_NAME"), case_sensitive_sql);
                        if (foreignKeyName.equalsIgnoreCase("pur_tender_analysis_fin_items_spec_pur_tender_items_financial_fk")) {
                            // empty if block
                        }
                        modelForeignKey.addForeignFieldReferencedField(foreignKeyField, referenced_key_field);
                        currentForeignKeyName = foreignKeyName;
                    }
                    rs.close();
                }
            }
        }
        long t2 = System.nanoTime();
        generating_time_elements.add("01- Analyze Database Schema Metadata = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        model_enterprise.toString(writer, 0, 4);
        writer.flush();
        t1 = System.nanoTime();
        for (Database database : model_enterprise.database_list) {
            boolean level = false;
            shift = 4;
            database.extractTableLogic(true);
        }
        if (write_output.booleanValue()) {
            writer.append("\n");
            for (Database database : model_enterprise.database_list) {
                int level = 0;
                shift = 4;
                database.extractTableLogic(true);
                for (Table table : database.table_list) {
                    Table tt;
                    ArrayList<Table> tablesPath;
                    int i;
                    writer.append("Table [");
                    writer.append(table.name);
                    writer.append("][Parent Paths]\n");
                    for (i = 0; i < table.parent_path_list.size(); ++i) {
                        int x;
                        tablesPath = table.parent_path_list.get(i);
                        for (x = 0; x < level * shift; ++x) {
                            writer.append(" ");
                        }
                        writer.append("|");
                        for (x = 0; x < shift - 1; ++x) {
                            writer.append(".");
                        }
                        for (x = 0; x < tablesPath.size(); ++x) {
                            tt = tablesPath.get(x);
                            writer.append(tt.name);
                            writer.append(".");
                        }
                        if (tablesPath.size() > 0) {
                            // empty if block
                        }
                        writer.append("\n");
                    }
                    writer.append("Table [");
                    writer.append(table.name);
                    writer.append("][All Paths]\n");
                    for (i = 0; i < table.path_list.size(); ++i) {
                        int x;
                        tablesPath = table.path_list.get(i);
                        for (x = 0; x < level * shift; ++x) {
                            writer.append(" ");
                        }
                        writer.append("|");
                        for (x = 0; x < shift - 1; ++x) {
                            writer.append(".");
                        }
                        for (x = 0; x < tablesPath.size(); ++x) {
                            tt = tablesPath.get(x);
                            writer.append(tt.name);
                            writer.append(".");
                        }
                        if (tablesPath.size() > 0) {
                            // empty if block
                        }
                        writer.append("\n");
                    }
                    if (table.cyclic_reference_paths.size() > 0) {
                        writer.append("Table [");
                        writer.append(table.name);
                        writer.append("][Cyclic Reference Paths]\n");
                        for (i = 0; i < table.cyclic_reference_paths.size(); ++i) {
                            int x;
                            tablesPath = table.cyclic_reference_paths.get(i);
                            for (x = 0; x < level * shift; ++x) {
                                writer.append(" ");
                            }
                            writer.append("|");
                            for (x = 0; x < shift - 1; ++x) {
                                writer.append(".");
                            }
                            for (x = 0; x < tablesPath.size(); ++x) {
                                tt = tablesPath.get(x);
                                writer.append(tt.name);
                                writer.append(".");
                            }
                            if (tablesPath.size() > 0) {
                                // empty if block
                            }
                            writer.append("\n");
                        }
                    }
                    writer.append("Table [");
                    writer.append(table.name);
                    writer.append("][All Paths Inner Joined]\n");
                    for (i = 0; i < table.path_list.size(); ++i) {
                        tablesPath = table.path_list.get(i);
                        String pathString = database.pathToString(tablesPath);
                        writer.append(pathString);
                        writer.append("\n");
                        ArrayList<Table> foundTablesPath = database.findPath(pathString);
                        String foundTablesPathString = database.pathToString(foundTablesPath);
                        writer.append(foundTablesPathString);
                        writer.append("\n");
                        String datasetJSON = database.getInnerJoinedSelect(foundTablesPathString, this.data_jdbc_source.getDatabaseSchema(), this.data_jdbc_source.getDatabaseOpenQuote(), this.data_jdbc_source.getDatabaseCloseQuote()).toString();
                        writer.append(datasetJSON);
                        writer.append("\n");
                        writer.append("\n");
                    }
                }
            }
        }
        t2 = System.nanoTime();
        generating_time_elements.add("02- Extract Schema Table Logic = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        t1 = System.nanoTime();
        Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{128}).create();
        gson.toJson((Object)model_enterprise, Enterprise.class, new JsonWriter((Writer)writer));
        t2 = System.nanoTime();
        generating_time_elements.add("03- Printing Json To Writer = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        Integer instance_sequence_type_id = 1;
        String instance_sequence_last_value = "0";
        String model_name = this.data_jdbc_source.getDatabaseName() + " - Enterprise Model";
        String model_description = this.data_jdbc_source.getDatabaseName() + " - Database Enterprise Model";
        t1 = System.nanoTime();
        DataProcessor<Enterprise> dataProcessor = new DataProcessor<Enterprise>(EnterpriseModel.class, Enterprise.class, this.model_jdbc_source, this.model_definition, this.data_lookup, this.interface_implementation, this.foreing_key_must_link_to_primary_key);
        t1 = System.nanoTime();
        this.model_id = dataProcessor.generateModel(this.model_jdbc_source, this.data_jdbc_source, this.model_id, instance_sequence_type_id, instance_sequence_last_value, this.model_secret_key, table_interface_implementation_data_structures.getClass().getName());
        t2 = System.nanoTime();
        generating_time_elements.add("04- Create Model ID [" + this.model_id + "] Data Class in Database = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        EnterpriseModel<Enterprise> enterprise_model = new EnterpriseModel<Enterprise>(model_enterprise, this.model_definition);
        dataProcessor.toString(writer, enterprise_model);
        writer.flush();
        t1 = System.nanoTime();
        String data_mysql_database_field_open_quote = "`";
        String data_mysql_database_field_close_quote = "`";
        DataModel<Enterprise> savedModel = dataProcessor.saveModelToDatabase(writer, this.data_jdbc_source, enterprise_model, data_mysql_database_field_open_quote, data_mysql_database_field_close_quote);
        t2 = System.nanoTime();
        generating_time_elements.add("05- Save Schema To Database = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        t1 = System.nanoTime();
        writer.append("Saved Model").append("\n");
        savedModel.getInstance().toString(writer);
        writer.flush();
        t2 = System.nanoTime();
        generating_time_elements.add("06- Saved Model Schema print out = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        return this.model_id;
    }

    public void loadModel(JDBCSource model_jdbc_source, PrintWriter writer) throws Exception {
        Object timeText = "";
        writer.append("Loaded Models").append("\n");
        long t1 = System.nanoTime();
        DataProcessor dataProcessor = new DataProcessor(EnterpriseModel.class, Enterprise.class, model_jdbc_source, this.model_definition, this.data_lookup, this.interface_implementation, this.foreing_key_must_link_to_primary_key);
        ArrayList<Integer> model_instance_ids = dataProcessor.selectModelInstanceIDsFromDatabase(this.model_definition.modeled_database_name);
        long t2 = System.nanoTime();
        StringBuilder ids = new StringBuilder();
        for (Integer id : model_instance_ids) {
            ids.append(id).append(",");
        }
        ids = ids.length() == 0 ? ids : ids.delete(ids.length() - 1, ids.length());
        timeText = (String)timeText + "Select Model Instance IDs [" + ids.toString() + "] From Database = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms\n";
        for (Integer model_instance_id : model_instance_ids) {
            t1 = System.nanoTime();
            DataClass.LoadMethod loadMethod = DataClass.LoadMethod.REFLECTION;
            EnterpriseModel newEnterpriseModel = (EnterpriseModel)dataProcessor.loadModelFromDatabase(this.model_id, model_instance_id, loadMethod);
            Object loadedEnterprise = newEnterpriseModel.getInstance();
            t2 = System.nanoTime();
            timeText = (String)timeText + "Load [" + this.model_name + "-" + this.model_definition.model_version + "-" + this.data_jdbc_source.getDatabaseName() + "] DataInstance [" + model_instance_id + "] From Database = " + (double)(t2 - t1) / 1000000.0 + "\n";
            t1 = System.nanoTime();
            writer.append("Loaded Model [");
            ((Enterprise)newEnterpriseModel.getInstance()).toString(writer, 0, 4);
            writer.append("]\n");
            writer.flush();
            Gson gsonLoaded = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ZonedDateTime.class, (Object)new JsonZonedDateTimeAdapter()).create();
            String jsonTextLoaded = gsonLoaded.toJson(loadedEnterprise);
            writer.append(jsonTextLoaded).append("\n");
        }
        writer.append("---------------- Time -------------------").append("\n");
        writer.append((CharSequence)timeText).append("\n");
    }

    Object createReportObject(Object object, Class<?> clss) throws Exception {
        Constructor<?> ctor = clss.getConstructor(new Class[0]);
        return ctor.newInstance(new Object[0]);
    }

    void setObjectProperty(Object object, String property, Object value) throws Exception {
        java.lang.reflect.Field declaredField = object.getClass().getDeclaredField(property);
        declaredField.setAccessible(true);
        declaredField.set(object, value);
    }

    public static void deleteDataModel(JDBCSource model_jdbc_source, ModelDefinition model_definition) throws Exception {
        try (Connection model_database_connection = model_jdbc_source.getConnection(Boolean.valueOf(false));){
            Object delete_sql = "DELETE FROM `model`.`referenced_key_field_list` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.`foreign_key_field_list` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.`foreign_key_list` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.`primary_key_field_list` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.`primary_key_list` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.`field_list` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.`child_table_list` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            String table_interface_implementation_data_structures_name = "table_interface_implementation_data_structures";
            delete_sql = "DELETE FROM `model`.`" + table_interface_implementation_data_structures_name + "` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.`table_list` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.`database_list` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.`enterprise` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.model_sequence WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.model_instance WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            delete_sql = "DELETE FROM `model`.`model` WHERE `model_id`=?";
            MetadataMiner.deleteDataModel(model_database_connection, (String)delete_sql, model_definition.model_id);
            model_database_connection.commit();
        }
    }

    public static void deleteDataModelInstance(JDBCSource model_jdbc_source, ModelDefinition model_definition) throws Exception {
        try (Connection model_database_connection = model_jdbc_source.getConnection(Boolean.valueOf(false));){
            Integer instance_id = Integer.valueOf(model_definition.model_instance_sequence_last_value);
            Object delete_sql = "DELETE FROM `model`.`referenced_key_field_list` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.`foreign_key_field_list` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.`foreign_key_list` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.`primary_key_field_list` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.`primary_key_list` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.`field_list` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.`child_table_list` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            String table_interface_implementation_data_structures_name = "table_interface_implementation_data_structures";
            delete_sql = "DELETE FROM `model`.`" + table_interface_implementation_data_structures_name + "` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.`table_list` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.`database_list` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.`enterprise` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.model_sequence WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.model_instance WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            delete_sql = "DELETE FROM `model`.`model` WHERE `model_id`=? AND `model_instance_id`=?";
            MetadataMiner.deleteDataModelInstance(model_database_connection, (String)delete_sql, model_definition.model_id, instance_id);
            model_database_connection.commit();
        }
    }

    public static void deleteDataModelInstance(Connection model_jdbc_source_connection, String delete_sql, Integer model_id, Integer model_instance_id) throws Exception {
        try (PreparedStatement delete_stmt = model_jdbc_source_connection.prepareStatement(delete_sql);){
            delete_stmt.setInt(1, model_id);
            delete_stmt.setInt(2, model_instance_id);
            delete_stmt.executeUpdate();
        }
    }

    public static void deleteDataModel(Connection model_jdbc_source_connection, String delete_sql, Integer model_id, Integer model_instance_id) throws Exception {
        try (PreparedStatement delete_stmt = model_jdbc_source_connection.prepareStatement(delete_sql);){
            delete_stmt.setInt(1, model_id);
            delete_stmt.setInt(2, model_instance_id);
            delete_stmt.executeUpdate();
        }
    }

    public static void deleteDataModel(Connection model_jdbc_source_connection, String delete_sql, Integer model_id) throws Exception {
        try (PreparedStatement delete_stmt = model_jdbc_source_connection.prepareStatement(delete_sql);){
            delete_stmt.setInt(1, model_id);
            delete_stmt.executeUpdate();
        }
    }

    public static void printModelDataStructures(JDBCSource model_jdbc_source, Integer model_id, Integer model_instance_id, PrintWriter writer, Integer print_styel) throws Exception {
        String select_model_instance = "SELECT `table_interface_implementation_data_structures`.* FROM `model`.`table_list` INNER JOIN `model`.`table_interface_implementation_data_structures` ON `table_list`.`model_id`=`table_interface_implementation_data_structures`.`model_id` AND `table_list`.`model_instance_id`=`table_interface_implementation_data_structures`.`model_instance_id` AND `table_list`.`child_id`=`table_interface_implementation_data_structures`.`parent_id` WHERE `table_list`.`model_id` = ? AND `table_list`.`model_instance_id` = ?";
        ArrayList data_structure_list = null;
        try (Connection model_database_connection = model_jdbc_source.getConnection(Boolean.valueOf(false));
             PreparedStatement select_model_instance_stmt = model_database_connection.prepareStatement(select_model_instance);){
            select_model_instance_stmt.setInt(1, model_id);
            select_model_instance_stmt.setInt(2, model_instance_id);
            ResultSet rs = select_model_instance_stmt.executeQuery();
            data_structure_list = JsonResultset.resultset((ResultSet)rs, DataStructure.class);
        }
        if (data_structure_list == null) {
            throw new Exception("Data Model id '" + model_id + "' instance '" + model_instance_id + "' is not exist!");
        }
        if (print_styel == 1) {
            StringBuilder database_servlet_uri = new StringBuilder();
            StringBuilder java_data_structure_class = new StringBuilder();
            StringBuilder database_servlet_class = new StringBuilder();
            StringBuilder typescript_data_structure_class = new StringBuilder();
            StringBuilder typescript_request_send_response = new StringBuilder();
            StringBuilder typescript_form_component_ts = new StringBuilder();
            StringBuilder typescript_form_component_html = new StringBuilder();
            StringBuilder typescript_table_component_ts = new StringBuilder();
            StringBuilder typescript_table_component_html = new StringBuilder();
            StringBuilder http_requests = new StringBuilder();
            for (DataStructure data_structure : data_structure_list) {
                java_data_structure_class.append(nl).append(data_structure.java_data_structure_class).append(nl);
                typescript_data_structure_class.append(nl).append(data_structure.typescript_data_structure_class).append(nl);
                typescript_request_send_response.append(nl).append(data_structure.typescript_request_send_response).append(nl);
                typescript_form_component_ts.append(nl).append(data_structure.typescript_form_component_ts).append(nl);
                typescript_form_component_html.append(nl).append(data_structure.typescript_form_component_html).append(nl);
                typescript_table_component_ts.append(nl).append(data_structure.typescript_table_component_ts).append(nl);
                typescript_table_component_html.append(nl).append(data_structure.typescript_table_component_html).append(nl);
                database_servlet_class.append(nl).append(data_structure.database_servlet_class).append(nl);
                http_requests.append(nl).append(data_separator).append(data_structure.name).append(" - ").append((CharSequence)database_servlet_uri).append(" - HTTP Request").append(data_separator).append(nl).append(nl).append(data_separator).append("http requests").append(data_separator).append(nl).append(data_structure.http_requests).append(nl);
            }
            writer.append("\n\n ***** Java Data Structure Class ******\n\n");
            writer.append(java_data_structure_class);
            writer.append("\n\n ***** Database Servlet Class ******\n\n");
            writer.append(database_servlet_class);
            writer.append("\n\n ***** Typescript Data Structure Class ******\n\n");
            writer.append(typescript_data_structure_class);
            writer.append("\n\n ***** Typescript Request Send Respnonse ******\n\n");
            writer.append(typescript_request_send_response);
            writer.append("\n\n ***** Typescript Form Component .ts ******\n\n");
            writer.append(typescript_form_component_ts);
            writer.append("\n\n ***** Typescript Form Component .html ******\n\n");
            writer.append(typescript_form_component_html);
            writer.append("\n\n ***** Typescript MAT Table Component .ts ******\n\n");
            writer.append(typescript_table_component_ts);
            writer.append("\n\n ***** Typescript MAT Table Component .html ******\n\n");
            writer.append(typescript_table_component_html);
            writer.append("\n\n ***** Http Request ******\n\n");
            writer.append(http_requests);
        } else if (print_styel == 2) {
            for (DataStructure data_structure : data_structure_list) {
                StringBuilder java_data_structure_class = new StringBuilder();
                StringBuilder typescript_data_structure_class = new StringBuilder();
                StringBuilder typescript_request_send_response = new StringBuilder();
                StringBuilder typescript_form_component_ts = new StringBuilder();
                StringBuilder typescript_form_component_html = new StringBuilder();
                StringBuilder typescript_table_component_ts = new StringBuilder();
                StringBuilder typescript_table_component_html = new StringBuilder();
                StringBuilder database_servlet_class = new StringBuilder();
                StringBuilder database_servlet_uri = new StringBuilder();
                StringBuilder http_requests = new StringBuilder();
                java_data_structure_class.append(nl).append(data_structure.java_data_structure_class).append(nl);
                typescript_data_structure_class.append(nl).append(data_structure.typescript_data_structure_class).append(nl);
                typescript_request_send_response.append(nl).append(data_structure.typescript_request_send_response).append(nl);
                typescript_form_component_ts.append(nl).append(data_structure.typescript_form_component_ts).append(nl);
                typescript_form_component_html.append(nl).append(data_structure.typescript_form_component_html).append(nl);
                typescript_table_component_ts.append(nl).append(data_structure.typescript_table_component_ts).append(nl);
                typescript_table_component_html.append(nl).append(data_structure.typescript_table_component_html).append(nl);
                database_servlet_class.append(nl).append(data_structure.database_servlet_class).append(nl);
                http_requests.append(nl).append(data_separator).append("Insert http request").append(data_separator).append(nl).append(data_structure.http_requests).append(nl);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Java Class ******\n\n");
                writer.append(java_data_structure_class);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - ").append(database_servlet_uri).append(" DatabaseServlet Class ******\n\n");
                writer.append(database_servlet_class);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript Class ******\n\n");
                writer.append(typescript_data_structure_class);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript Request Send Respnonse ******\n\n");
                writer.append(typescript_request_send_response);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript Form Component .ts ******\n\n");
                writer.append(typescript_form_component_ts);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript Form Component .html ******\n\n");
                writer.append(typescript_form_component_html);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript MAT Table Component .ts ******\n\n");
                writer.append(typescript_table_component_ts);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript MAT Table Component .html ******\n\n");
                writer.append(typescript_table_component_html);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - ").append(database_servlet_uri).append(" - HTTP Request ******\n\n");
                writer.append(http_requests);
            }
        }
        writer.append("\n\n ***** Data Structure Print Completed Successfully ***** \n\n");
    }
}

