/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.api.relational.annotation.DontJsonAnnotation;
import net.reyadeyat.api.relational.data.DataLookup;
import net.reyadeyat.api.relational.model.ChildTable;
import net.reyadeyat.api.relational.model.Database;
import net.reyadeyat.api.relational.model.Field;
import net.reyadeyat.api.relational.model.ForeignKey;
import net.reyadeyat.api.relational.model.PrimaryKey;
import net.reyadeyat.api.relational.model.PrimaryKeyField;
import net.reyadeyat.api.relational.model.TableInterfaceImplementationDataStructures;

public class Table {
    public String name;
    public Integer rows;
    @DontJsonAnnotation
    public transient TableInterfaceImplementationDataStructures table_interface_implementation_data_structures;
    public ArrayList<Field> field_list = new ArrayList();
    public ArrayList<PrimaryKey> primary_key_list = new ArrayList();
    public ArrayList<ForeignKey> foreign_key_list = new ArrayList();
    public ArrayList<ChildTable> child_table_list = new ArrayList();
    public transient Boolean case_sensitive_sql;
    public transient Database database;
    public transient ArrayList<ArrayList<Table>> path_list = new ArrayList();
    public transient ArrayList<ArrayList<Table>> parent_path_list = new ArrayList();
    public transient ArrayList<ArrayList<Table>> cyclic_reference_paths = new ArrayList();
    public transient TreeMap<String, Field> field_map = new TreeMap();
    public transient DataLookup data_lookup;
    private static transient ArrayList<String> lang_suffix_list = new ArrayList<String>(Arrays.asList("_ar", "_en"));
    private static transient String nl = "\n";

    public Table() {
    }

    public Table(TableInterfaceImplementationDataStructures table_interface_implementation_data_structures) {
        this();
        this.table_interface_implementation_data_structures = table_interface_implementation_data_structures;
    }

    public Table(String name, Boolean case_sensitive_sql, Integer rows, DataLookup data_lookup, TableInterfaceImplementationDataStructures table_interface_implementation_data_structures) {
        this(table_interface_implementation_data_structures);
        this.name = name;
        this.rows = rows;
        this.case_sensitive_sql = case_sensitive_sql;
        this.data_lookup = data_lookup;
    }

    public void init() {
        for (Field field : this.field_list) {
            field.init();
            this.field_map.put(field.name, field);
        }
    }

    public void addField(Field field) throws Exception {
        field.table = this;
        this.field_list.add(field);
    }

    public void addPrimaryKey(PrimaryKey primary_key) throws Exception {
        primary_key.table = this;
        this.primary_key_list.add(primary_key);
        for (Field field : this.field_list) {
            for (PrimaryKeyField primary_key_field : primary_key.primary_key_field_list) {
                if (!field.name.equalsIgnoreCase(primary_key_field.name)) continue;
                field.setPrimaryKey();
            }
        }
    }

    public void addForeignKey(ForeignKey foreignKey) throws Exception {
        foreignKey.table = this;
        this.foreign_key_list.add(foreignKey);
        String referenced_key_table_name = new String(foreignKey.referenced_key_table_name);
        Table parentTable = this.database.table_list.stream().filter(o -> o.name.equals(referenced_key_table_name)).findAny().orElse(null);
        ChildTable child_table = new ChildTable(parentTable, this, foreignKey, parentTable.name, this.name, foreignKey.name, this.case_sensitive_sql);
        parentTable.addChildTable(child_table);
    }

    public void addChildTable(ChildTable child_table) {
        child_table.parentTable = this;
        this.child_table_list.add(child_table);
    }

    public void generateModelDataStructures() throws Exception {
        this.table_interface_implementation_data_structures.generateModelDataStructures(this);
    }

    public boolean isFieldPrimaryKey(String field_name) {
        for (PrimaryKey primary_key : this.primary_key_list) {
            if (!primary_key.isFieldPrimaryKey(field_name)) continue;
            return true;
        }
        return false;
    }

    public Boolean hasParent(Table table) throws Exception {
        if (table == null) {
            throw new Exception("table cann not be null");
        }
        for (ChildTable child_table : table.child_table_list) {
            if ((!this.case_sensitive_sql.booleanValue() || !this.name.equals(child_table.table_name)) && (this.case_sensitive_sql.booleanValue() || !this.name.equalsIgnoreCase(child_table.table_name))) continue;
            return true;
        }
        return false;
    }

    public Boolean hasChild(Table table) throws Exception {
        if (table == null) {
            throw new Exception("table cann not be null");
        }
        for (ChildTable child_table : this.child_table_list) {
            if ((!this.case_sensitive_sql.booleanValue() || !table.name.equals(child_table.table_name)) && (this.case_sensitive_sql.booleanValue() || !table.name.equalsIgnoreCase(child_table.table_name))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        try {
            this.toString(appendable, 0, 4);
            return appendable.toString();
        }
        catch (Exception exception) {
            appendable.delete(0, appendable.length());
            appendable.append("Table: ").append(this.name).append(" Rows [").append(this.rows).append("] Fields [").append(this.field_list.size()).append("] Primary Keys [").append("] Foerign Keys [").append("]").append("] Child Tables [").append(this.child_table_list.size()).append("]").toString();
            appendable.append("toString '").append(this.name).append("' error").append(exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
            return appendable.toString();
        }
    }

    public void toString(Appendable appendable, Integer level, Integer shift) throws Exception {
        int i;
        appendable.append("\n");
        for (i = 0; i < level * shift; ++i) {
            appendable.append(" ");
        }
        appendable.append("|");
        for (i = 0; i < shift - 1; ++i) {
            appendable.append(".");
        }
        appendable.append("Table: ").append(this.name).append(" Rows [").append(String.valueOf(this.rows)).append("] Fields [").append(String.valueOf(this.field_list.size())).append("] Primary Keys [").append(String.valueOf(this.primary_key_list.size())).append("] Foerign Keys [").append(String.valueOf(String.valueOf(this.foreign_key_list.size()))).append("]").append("] Child Tables [").append(String.valueOf(String.valueOf(this.child_table_list.size()))).append("]");
        for (Field field : this.field_list) {
            appendable.append(field.toString(level + 1, shift));
        }
        for (PrimaryKey primary_key : this.primary_key_list) {
            appendable.append(primary_key.toString(level + 1, shift));
        }
        for (ForeignKey foreignKey : this.foreign_key_list) {
            foreignKey.toString(appendable, level + 1, shift);
        }
        for (ChildTable child_table : this.child_table_list) {
            appendable.append(child_table.toString(level + 1, shift));
        }
    }

    public void toStringTableTree(Appendable appendable, Integer level, Integer shift, ArrayList<Table> table_path_list) throws Exception {
        int i;
        appendable.append("\n");
        for (i = 0; i < level * shift; ++i) {
            appendable.append(" ");
        }
        appendable.append("|");
        for (i = 0; i < shift - 1; ++i) {
            appendable.append(".");
        }
        appendable.append("[").append(String.valueOf(table_path_list.size())).append("]:[");
        for (i = 0; i < table_path_list.size(); ++i) {
            Table t = table_path_list.get(i);
            appendable.append(t.name);
            appendable.append(".");
        }
        appendable.append("]:[").append(String.valueOf(this.child_table_list.size())).append("]");
        for (ChildTable child_table : this.child_table_list) {
            if (table_path_list.contains(child_table.table)) {
                appendable.append(" [Cyclic Child `" + child_table.parentTable.name + "` To Parent `" + child_table.table.name + "` Reference] - Stop Tree Traversing");
                continue;
            }
            ArrayList<Table> table_path_list_copy = new ArrayList<Table>(table_path_list);
            table_path_list_copy.add(child_table.table);
            child_table.table.toStringTableTree(appendable, level + 1, shift, table_path_list_copy);
        }
    }

    public void compileTablePaths(ArrayList<Table> table_path_list, ArrayList<ArrayList<Table>> returnedTablesPaths, Boolean is_building_model) throws Exception {
        if (table_path_list.size() > 0) {
            this.parent_path_list.add(new ArrayList<Table>(table_path_list));
        }
        table_path_list.add(this);
        returnedTablesPaths.add(table_path_list);
        for (ChildTable child_table : this.child_table_list) {
            if (table_path_list.contains(child_table.table)) {
                this.cyclic_reference_paths.add(new ArrayList<Table>(table_path_list));
                continue;
            }
            ArrayList<Table> tables_path_list_copy = new ArrayList<Table>(table_path_list);
            child_table.table.compileTablePaths(tables_path_list_copy, returnedTablesPaths, is_building_model);
        }
        for (int i = 0; i < returnedTablesPaths.size(); ++i) {
            ArrayList<Table> returned_path = returnedTablesPaths.get(i);
            if (!returned_path.contains(this)) continue;
            this.path_list.add(returned_path);
        }
        if (is_building_model.booleanValue()) {
            this.generateModelDataStructures();
        }
    }

    private void replace(StringBuilder string, String replace, String with) {
        Integer replace_position = string.indexOf(replace);
        string.replace(replace_position, replace_position + replace.length(), with);
    }

    private void insertBefore(StringBuilder string, String find, String insert) {
        Integer find_position = string.indexOf(find);
        string.insert((int)find_position, insert);
    }

    private void delete(StringBuilder string, String find) {
        this.replace(string, find, "");
    }
}

