/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.test;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.reyadeyat.api.library.jdbc.JDBCSource;
import net.reyadeyat.api.library.json.JsonUtil;
import net.reyadeyat.api.relational.model.TableInterfaceImplementationDataStructures;
import net.reyadeyat.api.relational.modeler.ModelingRequest;
import net.reyadeyat.api.relational.request.Response;
import net.reyadeyat.api.relational.test.CompositObject;
import net.reyadeyat.api.relational.test.TestRelationalRequest;
import net.reyadeyat.api.relational.test.UserDefinedTableInterfaceImplementationDataStructures;

public class TestModelingRequest
extends ModelingRequest {
    private static String data_database = "parental";
    private static String data_database_server = "127.0.0.1:33060";
    private static String data_database_user = "remote";
    private static String data_database_password = "123456";
    private static String model_database = "model";
    private static String model_database_server = "127.0.0.1:33060";
    private static String model_database_user = "remote";
    private static String model_database_password = "123456";
    private static String model_service_build_request_json_text = "{\n    \"transaction\": \"build\",\n    \"service_name\": \"parental_service\",\n    \"default_datasource_name\": \"%s\",\n    \"database_name\": \"%s\",\n    \"model_id\": \"600\",\n    \"model_datasource_name\": \"model\",\n    \"data_datasource_name\": \"%s\",\n    \"secret_key\": \"1234567890\",\n\n    \"model_id\": 600,\n    \"model_instance_sequence_type_id\": 1,\n    \"model_name\": \"parental\",\n    \"model_version\": 0.0.000001\",\n    \"model_instance_sequence_last_value\": \"0\",\n    \"model_class_path\": \"net.reyadeyat.api.relational.model.Enterprise\",\n    \"model_data_lookup_category\": \"MySQL Data Type\",\n    \"modeled_database_url\": \"jdbc:mysql://127.0.0.1:33060/parental\",\n    \"modeled_database_url_user_name\": \"remote\",\n    \"modeled_database_url_user_password\": \"123456\",\n    \"modeled_database_schem\": \"\",\n    \"modeled_database_name\": \"%s\",\n    \"modeled_database_field_open_quote\": \"`\",\n    \"modeled_database_field_close_quote\": \"`\",\n\n    \"modeled_table_interface_implementation_data_structures_class\": \"net.reyadeyat.relational.test.api.UserDefinedTableDataStructures\",\n\n    \"table_tree\": [\n        {\n          \"table_name\": \"table_a\",\n          \"children\": [\n            {\n              \"table_name\": \"table_a_a\",\n              \"children\": []\n            },\n            {\n              \"table_name\": \"table_a_b\",\n              \"children\": [\n                {\n                  \"table_name\": \"table_a_b_a\",\n                  \"children\": []\n                }\n              ]\n            },\n            {\n              \"table_name\": \"table_a_c\",\n              \"children\": []\n            }\n          ]\n        }\n    ]\n}\n".formatted(data_database, data_database, data_database, data_database);
    private static String model_service_print_request_json_text = "{\n    \"transaction\": \"print\",\n    \"print_style\": 1,\n    \"service_name\": \"parental_service\",\n    \"default_datasource_name\": \"%s\",\n    \"database_name\": \"%s\",\n    \"model_id\": \"600\",\n    \"model_datasource_name\": \"model\",\n    \"data_datasource_name\": \"%s\",\n    \"secret_key\": \"1234567890\",\n\n    \"model_id\": 600,\n    \"model_instance_sequence_type_id\": 1,\n    \"model_name\": \"%s\",\n    \"model_version\": 0.0.000001\",\n    \"model_instance_sequence_last_value\": \"0\",\n    \"model_class_path\": \"net.reyadeyat.api.relational.model.Enterprise\",\n    \"model_data_lookup_category\": \"MySQL Data Type\",\n    \"modeled_database_url\": \"jdbc:mysql://127.0.0.1:33060/parental\",\n    \"modeled_database_url_user_name\": \"remote\",\n    \"modeled_database_url_user_password\": \"123456\",\n    \"modeled_database_schem\": \"\",\n    \"modeled_database_name\": \"%s\",\n    \"modeled_database_field_open_quote\": \"`\",\n    \"modeled_database_field_close_quote\": \"`\",\n\n    \"modeled_table_interface_implementation_data_structures_class\": \"net.reyadeyat.relational.test.api.UserDefinedTableDataStructures\",\n\n    \"table_tree\": [\n        {\n          \"table_name\": \"table_a\",\n          \"children\": [\n            {\n              \"table_name\": \"table_a_a\",\n              \"children\": []\n            },\n            {\n              \"table_name\": \"table_a_b\",\n              \"children\": [\n                {\n                  \"table_name\": \"table_a_b_a\",\n                  \"children\": []\n                }\n              ]\n            },\n            {\n              \"table_name\": \"table_a_c\",\n              \"children\": []\n            }\n          ]\n        }\n    ]\n}\n".formatted(data_database, data_database, data_database, data_database, data_database);
    private static String model_service_delete_request_json_text = "{\n    \"transaction\": \"delete\",\n    \"service_name\": \"parental_service\",\n    \"default_datasource_name\": \"%s\",\n    \"database_name\": \"%s\",\n\n    \"model_datasource_name\": \"model\",\n    \"data_datasource_name\": \"%s\",\n    \"secret_key\": \"1234567890\",\n\n    \"model_id\": 600,\n    \"model_instance_sequence_type_id\": 1,\n    \"model_name\": \"%s\",\n    \"model_version\": 0.0.000001\",\n    \"model_instance_sequence_last_value\": \"0\",\n    \"model_class_path\": \"net.reyadeyat.api.relational.model.Enterprise\",\n    \"model_data_lookup_category\": \"MySQL Data Type\",\n    \"modeled_database_url\": \"jdbc:mysql://127.0.0.1:33060/parental\",\n    \"modeled_database_url_user_name\": \"remote\",\n    \"modeled_database_url_user_password\": \"123456\",\n    \"modeled_database_schem\": \"\",\n    \"modeled_database_name\": \"%s\",\n    \"modeled_database_field_open_quote\": \"`\",\n    \"modeled_database_field_close_quote\": \"`\",\n\n    \"modeled_table_interface_implementation_data_structures_class\": \"net.reyadeyat.relational.test.api.UserDefinedTableDataStructures\"\n}\n".formatted(data_database, data_database, data_database, data_database, data_database);
    private static HashMap<String, DataSource> registered_datasource_map = new HashMap();
    private static HashMap<String, JDBCSource> registered_jdbcsource_map = new HashMap();
    private static String model_version = "0.0.0.0001";
    private static JDBCSource data_jdbc_source = new JDBCSource(){
        private static final String data_database_server = data_database_server;
        private static final String data_database_user = data_database_user;
        private static final String data_database_password = data_database_password;
        private static final String data_database_schema = data_database;
        private static final String database_schema = "";
        private static final String mysql_database_field_open_quote = "`";
        private static final String mysql_database_field_close_quote = "`";

        public String getDataSourceName() throws Exception {
            return this.getDatabaseName();
        }

        public Connection getConnection(Boolean auto_commit) throws Exception {
            Connection database_connection = DriverManager.getConnection("jdbc:mysql://" + data_database_server + "/" + data_database_schema, data_database_user, data_database_password);
            database_connection.setAutoCommit(auto_commit);
            return database_connection;
        }

        public String getUserName() throws Exception {
            return data_database_user;
        }

        public String getUserPassword() throws Exception {
            return data_database_password;
        }

        public String getDatabaseEngine() throws Exception {
            return "mysql";
        }

        public String getURL() throws Exception {
            return "jdbc:mysql://" + data_database_server + "/" + data_database_schema;
        }

        public String getDatabaseName() throws Exception {
            return data_database_schema;
        }

        public String getDatabaseServer() throws Exception {
            return data_database_server;
        }

        public String getDatabaseSchema() throws Exception {
            return database_schema;
        }

        public String getDatabaseOpenQuote() throws Exception {
            return "`";
        }

        public String getDatabaseCloseQuote() throws Exception {
            return "`";
        }
    };
    private static JDBCSource model_jdbc_source = new JDBCSource(){
        private static String model_database_server = model_database_server;
        private static String model_database_user = model_database_user;
        private static String model_database_password = model_database_password;
        private static String model_database_schema = model_database;
        private static final String database_schema = "";
        private static final String mysql_database_field_open_quote = "`";
        private static final String mysql_database_field_close_quote = "`";

        public String getDataSourceName() throws Exception {
            return this.getDatabaseName();
        }

        public Connection getConnection(Boolean auto_commit) throws Exception {
            Connection database_connection = DriverManager.getConnection("jdbc:mysql://" + model_database_server + "/" + model_database_schema, model_database_user, model_database_password);
            database_connection.setAutoCommit(auto_commit);
            return database_connection;
        }

        public String getUserName() throws Exception {
            return model_database_user;
        }

        public String getUserPassword() throws Exception {
            return model_database_password;
        }

        public String getDatabaseEngine() throws Exception {
            return "mysql";
        }

        public String getURL() throws Exception {
            return "jdbc:mysql://" + model_database_server + "/" + model_database_schema;
        }

        public String getDatabaseName() throws Exception {
            return model_database_schema;
        }

        public String getDatabaseServer() throws Exception {
            return model_database_server;
        }

        public String getDatabaseSchema() throws Exception {
            return database_schema;
        }

        public String getDatabaseOpenQuote() throws Exception {
            return "`";
        }

        public String getDatabaseCloseQuote() throws Exception {
            return "`";
        }
    };

    public static void main(String[] args) {
        CompositObject c1 = new CompositObject(1, "1");
        CompositObject c2 = new CompositObject(2, "2");
        CompositObject c3 = new CompositObject(3, "3");
        CompositObject c4 = new CompositObject(4, "4");
        CompositObject c5 = new CompositObject(5, "5");
        TreeMap<CompositObject, String> tree = new TreeMap<CompositObject, String>(new Comparator<CompositObject>(){

            @Override
            public int compare(CompositObject o1, CompositObject o2) {
                return CompositObject.compare(o1, o2);
            }
        });
        tree.put(c1, "C1");
        tree.put(c2, "C2");
        tree.put(c3, "C3");
        tree.put(c4, "C4");
        tree.put(c5, "C5");
        CompositObject cx = new CompositObject(3, "3");
        String value = (String)tree.get(cx);
        System.out.println(value);
        try {
            registered_jdbcsource_map.put(model_jdbc_source.getDatabaseName(), model_jdbc_source);
            registered_jdbcsource_map.put(data_jdbc_source.getDatabaseName(), data_jdbc_source);
        }
        catch (Exception ex) {
            Logger.getLogger(TestRelationalRequest.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        try (Connection jdbc_connection = data_jdbc_source.getConnection(Boolean.valueOf(true));){
            Integer security_flag = SECURITY_FLAG_RETURN_NOTHING | SECURITY_FLAG_ASSERT_VALID_FIELD_NAMES | SECURITY_FLAG_RETURN_DESCRIPTIVE_RESPONSE_MESSAGE | SECURITY_FLAG_RETURN_GENERATED_ID;
            Gson gson = JsonUtil.gson();
            JsonArray log_list = new JsonArray();
            ByteArrayOutputStream response_output_stream = args.length == 0 || args[0] == null ? new ByteArrayOutputStream() : new FileOutputStream(new File(args[0]));
            JsonArray error_list = new JsonArray();
            TestModelingRequest modeling_request = new TestModelingRequest();
            HashMap<String, Class> interface_implementation = new HashMap<String, Class>();
            interface_implementation.put("net.reyadeyat.api.relational.model.TableInterfaceImplementationDataStructures", UserDefinedTableInterfaceImplementationDataStructures.class);
            UserDefinedTableInterfaceImplementationDataStructures table_interface_implementation_data_structures = new UserDefinedTableInterfaceImplementationDataStructures();
            JsonObject model_service_delete_json = (JsonObject)gson.fromJson(model_service_delete_request_json_text, JsonObject.class);
            Response delete_response = modeling_request.serviceTransaction(security_flag, model_service_delete_json, (OutputStream)response_output_stream, jdbc_connection, (TableInterfaceImplementationDataStructures)table_interface_implementation_data_structures, interface_implementation, log_list, error_list);
            JsonObject model_service_build_json = (JsonObject)gson.fromJson(model_service_build_request_json_text, JsonObject.class);
            Response build_response = modeling_request.serviceTransaction(security_flag, model_service_build_json, (OutputStream)response_output_stream, jdbc_connection, (TableInterfaceImplementationDataStructures)table_interface_implementation_data_structures, interface_implementation, log_list, error_list);
            JsonObject model_service_print_json = (JsonObject)gson.fromJson(model_service_print_request_json_text, JsonObject.class);
            Response print_response = modeling_request.serviceTransaction(security_flag, model_service_print_json, (OutputStream)response_output_stream, jdbc_connection, (TableInterfaceImplementationDataStructures)table_interface_implementation_data_structures, interface_implementation, log_list, error_list);
            if (args.length == 0 || args[0] == null) {
                String reposnse_string = new String(response_output_stream.toByteArray(), StandardCharsets.UTF_8);
                Logger.getLogger(TestModelingRequest.class.getName()).log(Level.INFO, reposnse_string);
            }
            ((OutputStream)response_output_stream).close();
        }
        catch (Exception ex) {
            Logger.getLogger(TestModelingRequest.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public String getDefaultDatasourceName() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public DataSource getDataSource(String datasource_name) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public JDBCSource getJDBCSource(String datasource_name) throws Exception {
        if (datasource_name.equalsIgnoreCase("model")) {
            return model_jdbc_source;
        }
        if (datasource_name.equalsIgnoreCase(data_database)) {
            return data_jdbc_source;
        }
        throw new Exception("JDBC Source '" + datasource_name + "' is not defined in this service container!!");
    }

    @Override
    public Connection getDataSourceConnection(String datasource_name) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public Connection getJDBCSourceConnection(String datasource_name) throws Exception {
        if (datasource_name.equalsIgnoreCase("model")) {
            return model_jdbc_source.getConnection(Boolean.valueOf(false));
        }
        if (datasource_name.equalsIgnoreCase("data")) {
            return data_jdbc_source.getConnection(Boolean.valueOf(false));
        }
        throw new Exception("JDBC Source '" + datasource_name + "' is not defined in this service container!!");
    }

    @Override
    public Connection getDatabaseConnection(String datasurce_name) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

