/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.relational.test;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.reyadeyat.api.library.jdbc.JDBCSource;
import net.reyadeyat.api.library.json.JsonUtil;
import net.reyadeyat.api.library.security.SecuredPipedReader;
import net.reyadeyat.api.library.security.SecuredPipedWriter;
import net.reyadeyat.api.library.security.Security;
import net.reyadeyat.api.library.security.SecurityAES;
import net.reyadeyat.api.relational.database.RecordProcessor;
import net.reyadeyat.api.relational.request.RelationalRequest;
import net.reyadeyat.api.relational.request.Request;
import net.reyadeyat.api.relational.request.RequestDefinition;
import net.reyadeyat.api.relational.test.UserDefinedTableInterfaceImplementationDataStructures;

public class TestRelationalRequest
extends RelationalRequest {
    private static String data_database = "parental";
    private static String service_request_json_text = "[\n    {\n        \"table\": \"table_a_x\",\n        \"response\": \"tree\",\n        \"select\": [\n          \"id_a_x\",\n          \"name_ar_a_x\",\n          \"name_en_a_x\",\n          \"date_a_x\",\n          \"time_a_x\",\n          \"timestamp_a_x\",\n          \"boolean_a_x\"\n        ],\n        \"where\": {\n          \"clause\": \"id_a_x>?\",\n          \"values\": [\n            0\n          ]\n        },\n        \"order_by\": [\n          \"id_a_x\"\n        ],\n        \"children\": [\n            {\n                \"table\": \"table_a_a_x\",\n                \"response\": \"tree\",\n                \"select\": [\n                    \"id_a_a_x\",\n                    \"name_ar_a_a_x\",\n                    \"name_en_a_a_x\",\n                    \"date_a_a_x\",\n                    \"time_a_a_x\",\n                    \"timestamp_a_a_x\",\n                    \"boolean_a_a_x\"\n                ],\n                \"where\": {\n                    \"clause\": \"id_a_a_x>?\",\n                    \"values\": [\n                        0\n                    ]\n                },\n                \"order_by\": [\n                    \"id_a_a_x\"\n                ]\n            },\n            {\n                \"table\": \"table_a_b_x\",\n                \"response\": \"tree\",\n                \"select\": [\n                    \"id_a_b_x\",\n                    \"name_ar_a_b_x\",\n                    \"name_en_a_b_x\",\n                    \"date_a_b_x\",\n                    \"time_a_b_x\",\n                    \"timestamp_a_b_x\",\n                    \"boolean_a_b_x\"\n                ],\n                \"where\": {\n                    \"clause\": \"id_a_b_x>?\",\n                    \"values\": [\n                        0\n                    ]\n                },\n                \"order_by\": [\n                    \"id_a_b_x\"\n                ],\n                \"children\": [\n                    {\n                        \"table\": \"table_a_b_a_x\",\n                        \"response\": \"tree\",\n                        \"select\": [\n                            \"id_a_b_a_x\",\n                            \"name_ar_a_b_a_x\",\n                            \"name_en_a_b_a_x\",\n                            \"date_a_b_a_x\",\n                            \"time_a_b_a_x\",\n                            \"timestamp_a_b_a_x\",\n                            \"boolean_a_b_a_x\"\n                        ],\n                        \"where\": {\n                            \"clause\": \"id_a_b_a_x>?\",\n                            \"values\": [\n                                0\n                            ]\n                        },\n                        \"order_by\": [\n                            \"id_a_b_a_x\"\n                        ]\n                    }\n                ]\n            },\n            {\n                \"table\": \"table_a_c_x\",\n                \"response\": \"tree\",\n                \"select\": [\n                    \"id_a_c_x\",\n                    \"name_ar_a_c_x\",\n                    \"name_en_a_c_x\",\n                    \"date_a_c_x\",\n                    \"time_a_c_x\",\n                    \"timestamp_a_c_x\",\n                    \"boolean_a_c_x\"\n                ],\n                \"where\": {\n                    \"clause\": \"id_a_c_x>?\",\n                    \"values\": [\n                        0\n                    ]\n                },\n                \"order_by\": [\n                    \"id_a_c_x\"\n                ]\n            }\n        ]\n    }\n]\n";
    private static String service_definition_json_text = "{\n    \"service_name\": \"parental_service\",\n    \"model_id\": \"500\",\n    \"model_datasource_name\": \"model\",\n    \"data_datasource_name\": \"%s\",\n    \"data_database_name\": \"%s\",\n    \"secret_key\": \"1234567890\",\n    \"transaction_type\": [\"insert\",\"select\",\"update\",\"delete\"],\n    \"request_table\": {\n        \"table_name\": \"table_a\",\n        \"table_alias\": \"table_a_x\",\n        \"fields\": [\n            {\"name\": \"id\", \"alias\": \"id_a_x\", \"group_by\": false},\n            {\"name\": \"name_ar\", \"alias\": \"name_ar_a_x\", \"group_by\": false},\n            {\"name\": \"name_en\", \"alias\": \"name_en_a_x\", \"group_by\": false},\n            {\"name\": \"date\", \"alias\": \"date_a_x\", \"group_by\": false},\n            {\"name\": \"time\", \"alias\": \"time_a_x\", \"group_by\": false},\n            {\"name\": \"timestamp\", \"alias\": \"timestamp_a_x\", \"group_by\": false},\n            {\"name\": \"boolean\", \"alias\": \"boolean_a_x\", \"group_by\": false}\n        ],\n        \"children\": [\n            {\n                \"table_name\": \"table_a_a\",\n                \"table_alias\": \"table_a_a_x\",\n                \"fields\": [\n                    {\"name\": \"id\", \"alias\": \"id_a_a_x\", \"group_by\": false},\n                    {\"name\": \"name_ar\", \"alias\": \"name_ar_a_a_x\", \"group_by\": false},\n                    {\"name\": \"name_en\", \"alias\": \"name_en_a_a_x\", \"group_by\": false},\n                    {\"name\": \"date\", \"alias\": \"date_a_a_x\", \"group_by\": false},\n                    {\"name\": \"time\", \"alias\": \"time_a_a_x\", \"group_by\": false},\n                    {\"name\": \"timestamp\", \"alias\": \"timestamp_a_a_x\", \"group_by\": false},\n                    {\"name\": \"boolean\", \"alias\": \"boolean_a_a_x\", \"group_by\": false}\n                ],\n                \"children\": []\n            },\n            {\n                \"table_name\": \"table_a_b\",\n                \"table_alias\": \"table_a_b_x\",\n                \"fields\": [\n                    {\"name\": \"id\", \"alias\": \"id_a_b_x\", \"group_by\": false},\n                    {\"name\": \"name_ar\", \"alias\": \"name_ar_a_b_x\", \"group_by\": false},\n                    {\"name\": \"name_en\", \"alias\": \"name_en_a_b_x\", \"group_by\": false},\n                    {\"name\": \"date\", \"alias\": \"date_a_b_x\", \"group_by\": false},\n                    {\"name\": \"time\", \"alias\": \"time_a_b_x\", \"group_by\": false},\n                    {\"name\": \"timestamp\", \"alias\": \"timestamp_a_b_x\", \"group_by\": false},\n                    {\"name\": \"boolean\", \"alias\": \"boolean_a_b_x\", \"group_by\": false}\n                ],\n                \"children\": [\n                    {\n                        \"table_name\": \"table_a_b_a\",\n                        \"table_alias\": \"table_a_b_a_x\",\n                        \"fields\": [\n                            {\"name\": \"id\", \"alias\": \"id_a_b_a_x\", \"group_by\": false},\n                            {\"name\": \"name_ar\", \"alias\": \"name_ar_a_b_a_x\", \"group_by\": false},\n                            {\"name\": \"name_en\", \"alias\": \"name_en_a_b_a_x\", \"group_by\": false},\n                            {\"name\": \"date\", \"alias\": \"date_a_b_a_x\", \"group_by\": false},\n                            {\"name\": \"time\", \"alias\": \"time_a_b_a_x\", \"group_by\": false},\n                            {\"name\": \"timestamp\", \"alias\": \"timestamp_a_b_a_x\", \"group_by\": false},\n                            {\"name\": \"boolean\", \"alias\": \"boolean_a_b_a_x\", \"group_by\": false}\n                        ],\n                        \"children\": []\n                    }\n                ]\n            },\n            {\n                \"table_name\": \"table_a_c\",\n                \"table_alias\": \"table_a_c_x\",\n                \"fields\": [\n                    {\"name\": \"id\", \"alias\": \"id_a_c_x\", \"group_by\": false},\n                    {\"name\": \"name_ar\", \"alias\": \"name_ar_a_c_x\", \"group_by\": false},\n                    {\"name\": \"name_en\", \"alias\": \"name_en_a_c_x\", \"group_by\": false},\n                    {\"name\": \"date\", \"alias\": \"date_a_c_x\", \"group_by\": false},\n                    {\"name\": \"time\", \"alias\": \"time_a_c_x\", \"group_by\": false},\n                    {\"name\": \"timestamp\", \"alias\": \"timestamp_a_c_x\", \"group_by\": false},\n                    {\"name\": \"boolean\", \"alias\": \"boolean_a_c_x\", \"group_by\": false}\n                ],\n                \"children\": []\n            }\n        ]\n    }\n}\n".formatted(data_database, data_database);
    private static HashMap<String, DataSource> registered_datasource_map = new HashMap();
    private static HashMap<String, JDBCSource> registered_jdbcsource_map = new HashMap();
    private static String model_version = "0.0.0.0001";
    private static JDBCSource model_jdbc_source = new JDBCSource(){
        private static String model_database_server = "127.0.0.1:33060";
        private static String model_database_user_name = "remote";
        private static String model_database_password = "123456";
        private static String model_database_schema = "model";
        private static final String database_schema = "";
        private static final String mysql_database_field_open_quote = "`";
        private static final String mysql_database_field_close_quote = "`";

        public String getDataSourceName() throws Exception {
            return this.getDatabaseName();
        }

        public Connection getConnection(Boolean auto_commit) throws Exception {
            Connection database_connection = DriverManager.getConnection("jdbc:mysql://" + model_database_server + "/" + model_database_schema, model_database_user_name, model_database_password);
            database_connection.setAutoCommit(auto_commit);
            return database_connection;
        }

        public String getUserName() throws Exception {
            return model_database_user_name;
        }

        public String getUserPassword() throws Exception {
            return model_database_password;
        }

        public String getDatabaseEngine() throws Exception {
            return "mysql";
        }

        public String getURL() throws Exception {
            return "jdbc:mysql://" + model_database_server + "/" + model_database_schema;
        }

        public String getDatabaseName() throws Exception {
            return model_database_schema;
        }

        public String getDatabaseServer() throws Exception {
            return model_database_server;
        }

        public String getDatabaseSchema() throws Exception {
            return database_schema;
        }

        public String getDatabaseOpenQuote() throws Exception {
            return "`";
        }

        public String getDatabaseCloseQuote() throws Exception {
            return "`";
        }
    };
    private static JDBCSource data_jdbc_source = new JDBCSource(){
        private static final String data_database_server = "127.0.0.1:33060";
        private static final String data_database_user_name = "remote";
        private static final String data_database_password = "123456";
        private static final String data_database_schema = data_database;
        private static final String database_schema = "";
        private static final String mysql_database_field_open_quote = "`";
        private static final String mysql_database_field_close_quote = "`";

        public String getDataSourceName() throws Exception {
            return this.getDatabaseName();
        }

        public Connection getConnection(Boolean auto_commit) throws Exception {
            Connection database_connection = DriverManager.getConnection("jdbc:mysql://127.0.0.1:33060/" + data_database_schema, data_database_user_name, data_database_password);
            database_connection.setAutoCommit(auto_commit);
            return database_connection;
        }

        public String getUserName() throws Exception {
            return data_database_user_name;
        }

        public String getUserPassword() throws Exception {
            return data_database_password;
        }

        public String getDatabaseEngine() throws Exception {
            return "mysql";
        }

        public String getURL() throws Exception {
            return "jdbc:mysql://127.0.0.1:33060/" + data_database_schema;
        }

        public String getDatabaseName() throws Exception {
            return data_database_schema;
        }

        public String getDatabaseServer() throws Exception {
            return data_database_server;
        }

        public String getDatabaseSchema() throws Exception {
            return database_schema;
        }

        public String getDatabaseOpenQuote() throws Exception {
            return "`";
        }

        public String getDatabaseCloseQuote() throws Exception {
            return "`";
        }
    };

    public TestRelationalRequest(RequestDefinition request_definition, HashMap<String, Class> interface_implementation, Integer security_flag) throws Exception {
        super(request_definition, interface_implementation, security_flag);
    }

    public static void main(String[] args) {
        try {
            registered_jdbcsource_map.put(model_jdbc_source.getDatabaseName(), model_jdbc_source);
            registered_jdbcsource_map.put(data_jdbc_source.getDatabaseName(), data_jdbc_source);
        }
        catch (Exception ex) {
            Logger.getLogger(TestRelationalRequest.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        Logger gsonLogger = Logger.getLogger(Gson.class.getName());
        gsonLogger.setLevel(Level.FINE);
        try (Connection jdbc_connection = data_jdbc_source.getConnection(Boolean.valueOf(true));){
            SecurityAES security = new SecurityAES();
            String separator = "~";
            FileWriter plain_writer = new FileWriter(new File("/linux/reyadeyat/yanobel/open-source/Relational.API/response.txt"));
            SecuredPipedReader plain_reader_pipe = new SecuredPipedReader((Writer)plain_writer, (Security)security, separator);
            SecuredPipedWriter secured_writer = new SecuredPipedWriter((Reader)plain_reader_pipe, (Security)security, separator);
            JsonWriter response_output_writer = new JsonWriter((Writer)secured_writer);
            Gson gson = JsonUtil.gson();
            Integer security_flag = SECURITY_FLAG_RETURN_NOTHING | SECURITY_FLAG_FOREING_KEY_MUST_LINK_TO_PRIMARY_KEY | SECURITY_FLAG_ASSERT_VALID_FIELD_NAMES | SECURITY_FLAG_RETURN_DESCRIPTIVE_RESPONSE_MESSAGE | SECURITY_FLAG_RETURN_GENERATED_ID;
            JsonArray log_list = new JsonArray();
            JsonArray error_list = new JsonArray();
            RequestDefinition request_definition = (RequestDefinition)gson.fromJson(service_definition_json_text, RequestDefinition.class);
            request_definition.init();
            List request_list = (List)gson.fromJson(service_request_json_text, new TypeToken<List<Request>>(){}.getType());
            HashMap<String, Class> interface_implementation = new HashMap<String, Class>();
            interface_implementation.put("net.reyadeyat.api.relational.model.TableDataStructures", UserDefinedTableInterfaceImplementationDataStructures.class);
            TestRelationalRequest relational_request = new TestRelationalRequest(request_definition, interface_implementation, security_flag);
            relational_request.serviceTransaction(security_flag, request_list, response_output_writer, jdbc_connection, log_list, error_list);
            plain_reader_pipe.flush();
            plain_reader_pipe.close();
            plain_writer.close();
        }
        catch (Exception ex) {
            Logger.getLogger(TestRelationalRequest.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public DataSource getDataSource(String datasource_name) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public JDBCSource getJDBCSource(String datasource_name) throws Exception {
        return registered_jdbcsource_map.get(datasource_name);
    }

    @Override
    public Connection getDatabaseConnection(String datasource_name) throws Exception {
        return registered_jdbcsource_map.get(datasource_name).getConnection(Boolean.valueOf(false));
    }

    @Override
    public Boolean insertPreLogic(RecordProcessor record_processor, Connection connection) throws Exception {
        return true;
    }

    @Override
    public Boolean insertPostLogic(RecordProcessor record_processor, Connection connection) throws Exception {
        return true;
    }

    @Override
    public Boolean selectPreLogic(RecordProcessor record_processor, Connection connection) throws Exception {
        return true;
    }

    @Override
    public Boolean selectPerRecordLogic(RecordProcessor record_processor, ResultSet rs, JsonObject record_object) throws Exception {
        return true;
    }

    @Override
    public Boolean selectPerRecordLogic(RecordProcessor record_processor, ResultSet rs, JsonArray record_list) throws Exception {
        return true;
    }

    @Override
    public Boolean selectPostLogic(RecordProcessor record_processor, Connection connection, JsonArray resultset_json) throws Exception {
        return true;
    }

    @Override
    public Boolean updatePreLogic(RecordProcessor record_processor, Connection connection) throws Exception {
        return true;
    }

    @Override
    public Boolean updatePostLogic(RecordProcessor record_processor, Connection connection) throws Exception {
        return true;
    }

    @Override
    public Boolean deletePreLogic(RecordProcessor record_processor, Connection connection) throws Exception {
        return true;
    }

    @Override
    public Boolean deletePostLogic(RecordProcessor record_processor, Connection connection) throws Exception {
        return true;
    }

    @Override
    public Boolean insertInject(RecordProcessor record_processor) throws Exception {
        return true;
    }

    @Override
    public Boolean updateInject(RecordProcessor record_processor) throws Exception {
        return true;
    }

    @Override
    public Boolean selectInject(RecordProcessor record_processor) throws Exception {
        return true;
    }

    @Override
    public Boolean deleteInject(RecordProcessor record_processor) throws Exception {
        return true;
    }

    @Override
    public Boolean insertEject(RecordProcessor record_processor) throws Exception {
        return true;
    }

    @Override
    public Boolean updateEject(RecordProcessor record_processor) throws Exception {
        return true;
    }

    @Override
    public Boolean selectEject(RecordProcessor record_processor) throws Exception {
        return true;
    }

    @Override
    public Boolean deleteEject(RecordProcessor record_processor) throws Exception {
        return true;
    }
}

