/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Field;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.relational.api.data.DataClass;
import net.reyadeyat.relational.api.data.DataLookup;
import net.reyadeyat.relational.api.data.DataProcessor;
import net.reyadeyat.relational.api.json.ZonedDateTimeAdapter;
import net.reyadeyat.relational.api.model.ForeignKey;
import net.reyadeyat.relational.api.model.ForeignKeyField;
import net.reyadeyat.relational.api.model.ReferencedKeyField;
import net.reyadeyat.relational.api.sequence.SequenceNumber;

public class DataInstance {
    private State state;
    DataClass dataClass;
    DataInstance parentDataInstance;
    SequenceNumber<Integer> sequenceNumber;
    Boolean isNull;
    Integer parentID;
    Object instanceObject;
    HashMap<Object, Integer> instancesIDMap;
    ArrayList<Object> instances;
    String runtimePath;
    String databaseName;
    Map<Object, ArrayList<DataInstance>> membersMapList;
    Map<Object, ArrayList<DataInstance>> tablesMapList;
    Map<Object, ArrayList<DataInstance>> fieldsMapList;
    Map<Object, HashMap<String, DataInstance>> membersMapMap;
    Map<Object, HashMap<String, DataInstance>> tablesMapMap;
    Map<Object, HashMap<String, DataInstance>> fieldsMapMap;
    TreeMap<String, HashMap<String, Integer>> listCodeMap;
    public static final Gson gson = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).create();
    public static final ArrayList<String> ignore_field_list = new ArrayList<String>(Arrays.asList("java_package_name", "java_data_structure_class", "typescript_data_structure_class", "typescript_request_send_response", "typescript_form_component_ts", "typescript_form_component_ts", "typescript_form_component_html", "typescript_table_component_ts", "typescript_table_component_html", "database_servlet_class", "database_servlet_uri", "http_requests"));

    public DataInstance(State state, String databaseName, DataClass dataClass, DataInstance parentDataInstance, Object parentInstanceObject, Object instanceObject, SequenceNumber<Integer> sequenceNumber, Boolean traverse) throws Exception {
        this.state = state;
        this.databaseName = databaseName;
        this.dataClass = dataClass;
        if (this.dataClass == null) {
            throw new Exception("DataClass is null !!!");
        }
        if (dataClass.declaredName.equalsIgnoreCase("childTables")) {
            dataClass.declaredName = dataClass.declaredName;
        }
        this.parentDataInstance = parentDataInstance;
        this.sequenceNumber = sequenceNumber;
        this.parentID = parentDataInstance == null ? 0 : parentDataInstance.instancesIDMap.get(parentInstanceObject);
        this.instanceObject = instanceObject;
        if (this.instanceObject == null && this.dataClass.isNotNull()) {
            if (this.dataClass.declaredName.equalsIgnoreCase("referencedKeyname") && dataClass.field.getName().equalsIgnoreCase("referencedKeyname") && parentInstanceObject instanceof ForeignKey) {
                ForeignKey foreign_key = (ForeignKey)parentInstanceObject;
                StringBuilder foreign_key_field_list_strb = new StringBuilder();
                for (ForeignKeyField foreignKeyField : foreign_key.foreignKeyFields) {
                    foreign_key_field_list_strb.append("`").append(foreignKeyField.name).append("`,");
                }
                if (foreign_key.foreignKeyFields.size() > 0) {
                    foreign_key_field_list_strb.delete(foreign_key_field_list_strb.length() - 1, foreign_key_field_list_strb.length());
                }
                StringBuilder referenced_key_field_list_strb = new StringBuilder();
                for (ReferencedKeyField referencedKeyFieldName : foreign_key.referencedKeyFields) {
                    referenced_key_field_list_strb.append("`").append(referencedKeyFieldName.name).append("`,");
                }
                if (foreign_key.referencedKeyFields.size() > 0) {
                    referenced_key_field_list_strb.delete(referenced_key_field_list_strb.length() - 1, referenced_key_field_list_strb.length());
                }
                throw new Exception("Database Foreign Key Constraint sufferes integgrity check failure Table.[Field List} `" + foreign_key.foreignKeyTableName + "`.[" + foreign_key_field_list_strb.toString() + "] has Foreing Key '" + foreign_key.name + "' linked to a none Primary Key Table.[Field List] `" + foreign_key.referencedKeyTableName + "`.[" + referenced_key_field_list_strb.toString() + "], please fix this issue first !!!");
            }
            throw new Exception("Instance Object is null in '" + this.dataClass.name + "'");
        }
        if (parentDataInstance == null && !this.dataClass.clas.isInstance(this.instanceObject)) {
            throw new ClassCastException("DataInstance '" + this.dataClass.clas.getCanonicalName() + "' required class but got instance object of class '" + this.instanceObject.getClass().getCanonicalName() + "'");
        }
        this.instancesIDMap = new HashMap();
        this.isNull = instanceObject == null;
        this.membersMapList = new HashMap<Object, ArrayList<DataInstance>>();
        this.tablesMapList = new HashMap<Object, ArrayList<DataInstance>>();
        this.fieldsMapList = new HashMap<Object, ArrayList<DataInstance>>();
        this.membersMapMap = new HashMap<Object, HashMap<String, DataInstance>>();
        this.tablesMapMap = new HashMap<Object, HashMap<String, DataInstance>>();
        this.fieldsMapMap = new HashMap<Object, HashMap<String, DataInstance>>();
        if (!traverse.booleanValue()) {
            this.instances = new ArrayList();
            return;
        }
        this.instances = this.isList(dataClass.field) != false ? (ArrayList<Object>)this.instanceObject : (this.isArray(dataClass.field) != false ? new ArrayList<Object>(Arrays.asList((Object[])this.instanceObject)) : new ArrayList<Object>(Arrays.asList(this.instanceObject)));
        if (!this.dataClass.clas.getPackage().getName().startsWith(this.dataClass.packageName)) {
            return;
        }
        this.sequenceNumber.createSequence(this.dataClass.clas);
        for (Object instance : this.instances) {
            this.instancesIDMap.put(instance, (Integer)this.sequenceNumber.nextSequence(this.dataClass.clas));
            ArrayList<DataInstance> membersList = new ArrayList<DataInstance>();
            ArrayList<DataInstance> arrayList = new ArrayList<DataInstance>();
            ArrayList<DataInstance> fieldsList = new ArrayList<DataInstance>();
            HashMap<String, DataInstance> membersMap = new HashMap<String, DataInstance>();
            HashMap<String, DataInstance> tablesMap = new HashMap<String, DataInstance>();
            HashMap<String, DataInstance> fieldsMap = new HashMap<String, DataInstance>();
            for (DataClass newDataClass : this.dataClass.membersList) {
                Object newInstanceObject = newDataClass.field.get(instance);
                DataInstance newDataInstance = new DataInstance(this.state, this.databaseName, newDataClass, this, instance, newInstanceObject, this.sequenceNumber, true);
                membersList.add(newDataInstance);
                membersMap.put(newDataInstance.dataClass.name, newDataInstance);
                if (newDataInstance.dataClass.isTable.booleanValue()) {
                    arrayList.add(newDataInstance);
                    tablesMap.put(newDataInstance.dataClass.name, newDataInstance);
                    continue;
                }
                fieldsList.add(newDataInstance);
                fieldsMap.put(newDataInstance.dataClass.name, newDataInstance);
            }
            this.addMemeber(instance, membersList, arrayList, fieldsList, membersMap, tablesMap, fieldsMap);
        }
    }

    public void changeState(State state, Boolean propagateToChildren) throws Exception {
        this.changeState(this, state, propagateToChildren);
    }

    private void changeState(DataInstance dataInstance, State state, Boolean propagateToChildren) throws Exception {
        this.state = state;
        if (dataInstance.isNull.booleanValue()) {
            return;
        }
        for (Object object : dataInstance.instances) {
            if (dataInstance.membersMapList.size() <= 0) continue;
            for (DataInstance memberDataInstance : dataInstance.membersMapList.get(object)) {
                this.changeState(memberDataInstance, state, propagateToChildren);
            }
        }
    }

    public Object getInstanceObject() {
        return this.instanceObject;
    }

    public void addInstanceObject(Object instance, Integer childID) throws Exception {
        this.instances.add(instance);
        this.instancesIDMap.put(instance, childID);
        ArrayList<DataInstance> membersList = new ArrayList<DataInstance>();
        ArrayList<DataInstance> tablesList = new ArrayList<DataInstance>();
        ArrayList<DataInstance> fieldsList = new ArrayList<DataInstance>();
        HashMap<String, DataInstance> membersMap = new HashMap<String, DataInstance>();
        HashMap<String, DataInstance> tablesMap = new HashMap<String, DataInstance>();
        HashMap<String, DataInstance> fieldsMap = new HashMap<String, DataInstance>();
        this.addMemeber(instance, membersList, tablesList, fieldsList, membersMap, tablesMap, fieldsMap);
    }

    public void addChildInstanceObject(State childState, DataClass newDataClass, Object parentInstanceObject, Object newInstanceObject, SequenceNumber<Integer> sequenceNumber, Boolean traverse) throws Exception {
        ArrayList<DataInstance> membersList = this.membersMapList.get(parentInstanceObject);
        ArrayList<DataInstance> tablesList = this.tablesMapList.get(parentInstanceObject);
        ArrayList<DataInstance> fieldsList = this.fieldsMapList.get(parentInstanceObject);
        HashMap<String, DataInstance> membersMap = this.membersMapMap.get(parentInstanceObject);
        HashMap<String, DataInstance> tablesMap = this.tablesMapMap.get(parentInstanceObject);
        HashMap<String, DataInstance> fieldsMap = this.fieldsMapMap.get(parentInstanceObject);
        DataInstance newDataInstance = new DataInstance(childState, this.databaseName, newDataClass, this, parentInstanceObject, newInstanceObject, sequenceNumber, traverse);
        membersList.add(newDataInstance);
        membersMap.put(newDataInstance.dataClass.name, newDataInstance);
        if (newDataInstance.dataClass.isTable.booleanValue()) {
            tablesList.add(newDataInstance);
            tablesMap.put(newDataInstance.dataClass.name, newDataInstance);
        } else {
            fieldsList.add(newDataInstance);
            fieldsMap.put(newDataInstance.dataClass.name, newDataInstance);
        }
    }

    public void addMemeber(Object instance, ArrayList<DataInstance> membersList, ArrayList<DataInstance> tablesList, ArrayList<DataInstance> fieldsList, HashMap<String, DataInstance> membersMap, HashMap<String, DataInstance> tablesMap, HashMap<String, DataInstance> fieldsMap) {
        this.membersMapList.put(instance, membersList);
        this.tablesMapList.put(instance, tablesList);
        this.fieldsMapList.put(instance, fieldsList);
        this.membersMapMap.put(instance, membersMap);
        this.tablesMapMap.put(instance, tablesMap);
        this.fieldsMapMap.put(instance, fieldsMap);
    }

    public void setCodeMap(TreeMap<String, HashMap<String, Integer>> listCodeMap) {
        this.listCodeMap = listCodeMap;
    }

    public Integer getCodeID(String categoryName, String code) {
        return this.listCodeMap.get(categoryName).get(code);
    }

    public Boolean hasParent() {
        return this.parentDataInstance != null;
    }

    public String getParentName() {
        return this.parentDataInstance.dataClass.name;
    }

    private Boolean isList(Field field) throws Exception {
        return Arrays.asList(field.getType().getInterfaces()).contains(List.class);
    }

    private Boolean isArray(Field field) throws Exception {
        return field.getType().isArray();
    }

    private Boolean isArrayType(Class clas, Field field) throws Exception {
        List<Class<?>> list = Arrays.asList(field.getType().getInterfaces());
        if (field.getType().isArray() || field.getType().equals(List.class) || field.getType().equals(ArrayList.class)) {
            return true;
        }
        if (!(field.getType().getCanonicalName().endsWith("boolean") || field.getType().getCanonicalName().endsWith("byte") || field.getType().getCanonicalName().endsWith("char") || field.getType().getCanonicalName().endsWith("short") || field.getType().getCanonicalName().endsWith("int") || field.getType().getCanonicalName().endsWith("long") || field.getType().getCanonicalName().endsWith("float") || field.getType().getCanonicalName().endsWith("double") || !field.getType().getPackage().getName().startsWith("java.util"))) {
            throw new Exception("Only {Array, List, ArrayList} containers are implemented");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getFieldInstanceDatabaseString(DataLookup dataLookup) throws Exception {
        Object string;
        Object theObject = null;
        if (this.dataClass.metadataAnnotation.lookup()) {
            string = this.instances.get(0);
            if (!(string instanceof String)) throw new Exception("Only String fields can be used with metadataAnnotation");
            theObject = dataLookup.lookupID((String)this.instances.get(0));
        } else {
            theObject = this.instances.get(0);
        }
        if (theObject instanceof String) {
            string = new StringBuilder(theObject.toString());
            int pos = 0;
            while ((pos = ((StringBuilder)string).indexOf("\"", pos)) > -1) {
                ((StringBuilder)string).insert(pos, "\\");
                pos += 2;
            }
            ((StringBuilder)string).insert(0, "\"");
            ((StringBuilder)string).append("\"");
            return ((StringBuilder)string).toString();
        }
        if (theObject instanceof Boolean) {
            return String.valueOf((Boolean)theObject);
        }
        if (theObject instanceof Number) {
            return String.valueOf((Number)theObject);
        }
        if (theObject instanceof ZonedDateTime) {
            return "\"" + DataProcessor.zonedDateTimeAdapter.toJDBCDateTime((ZonedDateTime)theObject) + "\"";
        }
        if (theObject != null) throw new Exception("Unsupported Database data type => " + this.instanceObject.getClass().getName());
        throw new Exception("Null value passed for DB field => " + this.dataClass.name + " => " + this.runtimePath);
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        try {
            this.toString(appendable);
            return appendable.toString();
        }
        catch (Exception exception) {
            appendable.delete(0, appendable.length());
            appendable.append("toString error").append(exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
            return appendable.toString();
        }
    }

    public void toString(Appendable appendable) {
        try {
            this.toString(appendable, 0, this);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
        }
    }

    private void toString(Appendable appendable, Integer indentation, DataInstance dataInstance) throws Exception {
        if (this.dataClass.declaredName.equalsIgnoreCase("childTables")) {
            this.dataClass.declaredName = this.dataClass.declaredName;
        }
        if (dataInstance.isNull.booleanValue()) {
            for (int i = 0; i < indentation; ++i) {
                appendable.append(" ");
            }
            if (dataInstance.dataClass.isTable.booleanValue()) {
                appendable.append("T-[").append(dataInstance.dataClass.name).append(" #-0-] (no records)\"\n");
            } else {
                appendable.append("F-[").append(dataInstance.dataClass.name).append("] (null)\"\n");
            }
            return;
        }
        for (Object object : dataInstance.instances) {
            for (int i = 0; i < indentation; ++i) {
                appendable.append(" ");
            }
            if (dataInstance.dataClass.isTable.booleanValue()) {
                appendable.append("T-[").append(dataInstance.dataClass.name).append(" #").append(dataInstance.instancesIDMap.get(object).toString()).append("]\n");
            } else if (!dataInstance.dataClass.isTable.booleanValue()) {
                appendable.append("F-[").append(dataInstance.dataClass.name).append("]-\"").append(ignore_field_list.contains(dataInstance.dataClass.name) ? "..." : object.toString()).append("\"\n");
            }
            if (!object.getClass().getName().startsWith(dataInstance.dataClass.packageName)) continue;
            if (dataInstance.fieldsMapList.size() > 0) {
                for (DataInstance fieldDataInstance : dataInstance.fieldsMapList.get(object)) {
                    this.toString(appendable, indentation + 6, fieldDataInstance);
                }
            } else {
                for (DataClass fieldDataClass : dataInstance.dataClass.fieldsList) {
                    appendable.append("F-[").append(fieldDataClass.name).append("] (null)\n");
                }
            }
            if (dataInstance.tablesMapList.size() > 0) {
                for (DataInstance tableDataInstance : dataInstance.tablesMapList.get(object)) {
                    this.toString(appendable, indentation + 6, tableDataInstance);
                }
                continue;
            }
            for (DataClass tableDataClass : dataInstance.dataClass.tablesList) {
                appendable.append("T-[").append(tableDataClass.name).append(" #-0-] (no records)\"\n");
            }
        }
    }

    public void saveToDatabase(Integer dataModelId, DataLookup dataLookup, Object instanceID, DataInstance dataInstance, ArrayList<String> inserts, String databaseFieldOpenQuote, String databaseFieldCloseQuote) throws Exception {
        if (dataInstance.isNull.booleanValue()) {
            return;
        }
        StringBuilder insert = new StringBuilder();
        for (Object instanceObject : dataInstance.instances) {
            insert.setLength(0);
            if (dataInstance.dataClass.isTable.booleanValue()) {
                insert.append(this.saveToDatabase(dataModelId, dataLookup, instanceID, dataInstance, instanceObject, databaseFieldOpenQuote, databaseFieldCloseQuote));
                inserts.add(insert.toString());
            }
            for (DataInstance tableDataInstance : dataInstance.tablesMapList.get(instanceObject)) {
                this.saveToDatabase(dataModelId, dataLookup, instanceID, tableDataInstance, inserts, databaseFieldOpenQuote, databaseFieldCloseQuote);
            }
        }
    }

    private String saveToDatabase(Integer dataModelId, DataLookup dataLookup, Object instanceID, DataInstance dataInstance, Object instanceObject, String databaseFieldOpenQuote, String databaseFieldCloseQuote) throws Exception {
        if (!dataInstance.dataClass.isTable.booleanValue()) {
            throw new Exception("toSQL takes table element only");
        }
        StringBuilder sql = new StringBuilder();
        String instanceObjectJSON = gson.toJson(instanceObject).replaceAll("\"", "\"\"");
        sql.append("INSERT INTO `").append(this.databaseName).append("`.`").append(dataInstance.dataClass.nameLower).append("`");
        sql.append("(`data_model_id`,`instance_id`,`child_id`,`parent_id`,`declared_field_name`,`class_name`,`json_object`,");
        for (DataInstance fieldDataInstance : dataInstance.fieldsMapList.get(instanceObject)) {
            sql.append(databaseFieldOpenQuote).append(fieldDataInstance.dataClass.nameLower).append(databaseFieldCloseQuote).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(") VALUES (");
        sql.append(dataModelId).append(",");
        if (instanceID instanceof Number) {
            sql.append(instanceID).append(",");
        } else if (instanceID instanceof String) {
            sql.append("'").append(instanceID).append("',");
        }
        sql.append(dataInstance.instancesIDMap.get(instanceObject)).append(",").append(dataInstance.hasParent() == null ? "null" : dataInstance.parentID).append(",'").append(dataInstance.dataClass.declaredName).append("','").append(dataInstance.dataClass.name).append("','").append(instanceObjectJSON).append("',");
        for (DataInstance fieldDataInstance : dataInstance.fieldsMapList.get(instanceObject)) {
            if (fieldDataInstance.isNull.booleanValue()) {
                sql.append("null,");
                continue;
            }
            if (fieldDataInstance.instances.size() == 1) {
                sql.append(fieldDataInstance.getFieldInstanceDatabaseString(dataLookup)).append(",");
                continue;
            }
            throw new Exception("Field must have one instance only per record");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    public static enum State {
        NEW,
        LOADED,
        UPDATED,
        DELETED;

    }
}

