/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.data;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.relational.api.data.DataClass;
import net.reyadeyat.relational.api.data.DataInstance;
import net.reyadeyat.relational.api.data.DataLookup;
import net.reyadeyat.relational.api.data.DataModel;
import net.reyadeyat.relational.api.jdbc.JDBCSource;
import net.reyadeyat.relational.api.json.ZonedDateTimeAdapter;
import net.reyadeyat.relational.api.sequence.SequenceNumber;

public class DataProcessor<Model> {
    Class data_model_class;
    Class model_class;
    DataModel<Model> data_model;
    String data_model_database_name;
    String model_database;
    String data_lookup_category;
    String model_version;
    String model_name;
    String model_description;
    DataLookup data_lookup;
    DataClass data_class;
    HashMap<DataModel<Model>, DataInstance> dataModelDataInstanceMap;
    public static final ZonedDateTimeAdapter zonedDateTimeAdapter = new ZonedDateTimeAdapter();

    public DataProcessor(Class data_model_class, Class model_class, String data_model_database_name, String model_database, String model_version, String model_name, String model_description, String data_lookup_category, DataLookup data_lookup) throws Exception {
        this.data_model_class = data_model_class;
        this.model_class = model_class;
        this.data_model_database_name = data_model_database_name;
        this.model_database = model_database;
        this.model_version = model_version;
        this.model_name = model_name;
        this.model_description = model_description;
        this.data_lookup_category = data_lookup_category;
        this.data_lookup = data_lookup;
        Boolean foundDataModelInterface = false;
        for (Class<?> intrface : this.data_model_class.getInterfaces()) {
            if (!intrface.getCanonicalName().equalsIgnoreCase(DataModel.class.getCanonicalName())) continue;
            foundDataModelInterface = true;
        }
        if (!foundDataModelInterface.booleanValue()) {
            throw new Exception("data_model_class class must implement DataModel class");
        }
        this.data_model = (DataModel)this.data_model_class.getConstructor(model_class, String.class, String.class, String.class).newInstance(null, model_version, model_name, model_description);
        Method methodGetDeclaredField = this.data_model_class.getDeclaredMethod("getDeclaredField", new Class[0]);
        Field modelDeclaredField = (Field)methodGetDeclaredField.invoke(this.data_model, new Object[0]);
        if (!model_class.getCanonicalName().equals(modelDeclaredField.getType().getCanonicalName())) {
            throw new Exception("data_model_class '" + data_model_class.getCanonicalName() + "' declared model field '" + modelDeclaredField.getName() + "' is of type class '" + modelDeclaredField.getType().getCanonicalName() + "' that is not same as model_class '" + model_class.getCanonicalName() + "'");
        }
        this.data_class = new DataClass(null, modelDeclaredField, data_lookup);
        this.dataModelDataInstanceMap = new HashMap();
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        try {
            this.toString(appendable);
            return appendable.toString();
        }
        catch (Exception exception) {
            appendable.delete(0, appendable.length());
            appendable.append("toString '").append(this.data_model.getName()).append("-").append(this.data_model.getDescription()).append("' error").append(exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
            return appendable.toString();
        }
    }

    public void toString(Appendable appendable) throws Exception {
        appendable.append("Model: ").append(this.data_model.getDescription()).append("\n");
        try {
            for (DataModel<Model> tempDataModel : this.dataModelDataInstanceMap.keySet()) {
                DataInstance dataInstance = this.dataModelDataInstanceMap.get(tempDataModel);
                appendable.append(dataInstance.toString());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void toString(Appendable appendable, DataModel<Model> data_model) throws Exception {
        if (!this.data_class.clas.getCanonicalName().equalsIgnoreCase(data_model.getInstance().getClass().getCanonicalName())) {
            throw new Exception("Required model of type '" + this.data_class.clas.getCanonicalName() + "' while found model of type '" + data_model.getInstance().getClass().getCanonicalName() + "'");
        }
        appendable.append("Model: ");
        appendable.append(this.data_model.getDescription());
        appendable.append("\n");
        SequenceNumber<Integer> sequenceNumber = new SequenceNumber<Integer>(0, 1, false);
        DataInstance dataInstance = new DataInstance(DataInstance.State.NEW, this.data_model_database_name, this.data_class, null, null, data_model.getInstance(), sequenceNumber, true);
        dataInstance.toString(appendable);
    }

    public Integer selectModelIdFromDatabase(JDBCSource data_source) throws Exception {
        Integer modelId = -1;
        String select_model_sql = "SELECT `id` FROM `data`.`data_model` WHERE `data_model`.`version`=? AND `data_model`.`database_name`=? AND `data_model`.`name`=? AND `data_model`.`root_class_path`=?";
        try (Connection data_connection = data_source.getConnection(false);
             PreparedStatement data_stmt = data_connection.prepareStatement(select_model_sql);){
            data_stmt.setString(1, this.model_version);
            data_stmt.setString(2, this.model_database);
            data_stmt.setString(3, this.model_name);
            data_stmt.setString(4, this.data_class.clas.getCanonicalName());
            try (ResultSet modelResultset = data_stmt.executeQuery();){
                if (modelResultset.next()) {
                    modelId = modelResultset.getInt("id");
                }
                data_stmt.close();
            }
        }
        return modelId;
    }

    public ArrayList<Integer> selectModelInstanceIDsFromDatabase(JDBCSource data_source) throws Exception {
        return this.selectModelInstanceIDsFromDatabase(data_source, null, null);
    }

    public ArrayList<Integer> selectModelInstanceIDsFromDatabase(JDBCSource data_source, Integer fromId, Integer toId) throws Exception {
        ArrayList<Integer> modelInstanceIds = new ArrayList<Integer>();
        String select_model_sql = "SELECT `instance_id`, `extra_info` FROM `data`.`data_model` INNER JOIN `data`.`data_model_instance` ON `data`.`data_model`.`id`=`data`.`data_model_instance`.`data_model_id` WHERE `data_model`.`version`=? AND `data_model`.`database_name`=? AND `data_model`.`name`=? AND `data_model`.`root_class_path`=? " + (fromId == null || toId == null ? "" : " AND `data_model_instance`.`instance_id` BETWEEN ? AND ?");
        try (Connection data_connection = data_source.getConnection(false);
             PreparedStatement data_stmt = data_connection.prepareStatement(select_model_sql);){
            data_stmt.setString(1, this.model_version);
            data_stmt.setString(2, this.model_database);
            data_stmt.setString(3, this.model_name);
            data_stmt.setString(4, this.data_class.clas.getCanonicalName());
            if (fromId != null && toId != null) {
                data_stmt.setInt(5, fromId);
                data_stmt.setInt(6, toId);
            }
            try (ResultSet modelResultset = data_stmt.executeQuery();){
                while (modelResultset.next()) {
                    modelInstanceIds.add(modelResultset.getInt("instance_id"));
                }
                data_stmt.close();
            }
        }
        return modelInstanceIds;
    }

    public Integer createDatabase(JDBCSource data_model_source, Integer model_id, String source_url, String source_url_user_name, String source_url_user_password, String model_url, Integer instance_sequence_type_id, String instance_sequence_last_value, String model_database_schem, String model_database_field_open_quote, String model_database_field_close_quote, String secret_key) throws Exception {
        ArrayList<String> creates = new ArrayList<String>();
        ArrayList<String> dataClasses = new ArrayList<String>();
        try (Connection data_model_connection = data_model_source.getConnection(false);){
            this.data_class.createDatabaseSchema(data_model_connection, this.data_model_database_name, this.data_class, dataClasses, creates);
            String insert_model_sql = "INSERT INTO `data`.`data_model`(`id`, `version`,`name`,`description`,`database_name`,`data_lookup_category`,`source_url`,`source_url_user_name`,`source_url_user_password`,`model_url`,`instance_sequence_type_id`, `instance_sequence_last_value`,`root_class_path`, `model_database_schem`, `model_database_field_open_quote`, `model_database_field_close_quote`) VALUES (?,?,?,?,?,?,?,?,TO_BASE64(AES_ENCRYPT(?, '" + secret_key + "')),?,?,?,?,?,?,?)";
            try (PreparedStatement data_stmt = data_model_connection.prepareStatement(insert_model_sql, 1);){
                data_stmt.setObject(1, model_id == -1 || model_id == null ? null : model_id);
                data_stmt.setObject(2, this.model_version);
                data_stmt.setObject(3, this.model_name);
                data_stmt.setObject(4, this.model_description);
                data_stmt.setObject(5, this.model_database);
                data_stmt.setObject(6, this.data_lookup_category);
                data_stmt.setObject(7, source_url);
                data_stmt.setObject(8, source_url_user_name);
                data_stmt.setObject(9, source_url_user_password);
                data_stmt.setObject(10, model_url);
                data_stmt.setObject(11, instance_sequence_type_id);
                data_stmt.setObject(12, instance_sequence_last_value);
                data_stmt.setObject(13, this.data_class.clas.getCanonicalName());
                data_stmt.setObject(14, model_database_schem);
                data_stmt.setObject(15, model_database_field_open_quote);
                data_stmt.setObject(16, model_database_field_close_quote);
                data_stmt.executeUpdate();
                StringBuilder b = new StringBuilder();
                try (Statement modelStatement = data_model_connection.createStatement();){
                    for (int i = 0; i < creates.size(); ++i) {
                        modelStatement.addBatch(creates.get(i));
                        b.append(creates.get(i)).append("\n");
                    }
                    int[] rows = modelStatement.executeBatch();
                    if (rows == null || rows.length > 0) {
                        // empty if block
                    }
                    if (!data_model_connection.getAutoCommit()) {
                        data_model_connection.commit();
                    }
                    modelStatement.close();
                }
                catch (Exception sqlx) {
                    b.insert(0, "create database sql statements carshed :\n");
                    System.out.println(b.toString());
                    if (!data_model_connection.getAutoCommit()) {
                        data_model_connection.rollback();
                    }
                    throw sqlx;
                }
                if (!data_model_connection.isClosed() && !data_model_connection.getAutoCommit()) {
                    data_model_connection.commit();
                }
                if (!data_stmt.isClosed()) {
                    data_stmt.close();
                }
            }
            catch (Exception sqlx) {
                if (!data_model_connection.isClosed() && !data_model_connection.getAutoCommit()) {
                    data_model_connection.rollback();
                }
                throw sqlx;
            }
        }
        return model_id;
    }

    public synchronized DataModel<Model> saveNewDataModelToDatabase(Appendable appendable, JDBCSource data_model_source, DataModel<Model> data_model, String database_field_open_quote, String database_field_close_quote) throws Exception {
        Integer instanceID = null;
        Exception exception = null;
        appendable = appendable == null ? new PrintWriter(Writer.nullWriter()) : appendable;
        try (Connection locked_data_model_connection = data_model_source.getConnection(false);){
            String lockTables = "LOCK TABLE data_model WRITE, sequence_type WRITE, data_model_sequence WRITE, data_model_instance WRITE";
            try (Statement lockStatement = locked_data_model_connection.createStatement();){
                lockStatement.execute(lockTables);
            }
            String select_model_sql = "SELECT `data_model`.`id` AS `data_model_id`, `instance_sequence_type_id`, `instance_sequence_last_value`, `sequence_type`.`sequence_name`, `sequence_type`.`sequence_type`, `sequence_type`.`sequence_ordered_chars`, `sequence_type`.`sequence_chars_width`, `sequence_type`.`sequence_padding_char`, `sequence_type`.`sequence_rewind`, `sequence_type`.`sequence_initial_value`, `sequence_type`.`sequence_increment_value` FROM `data`.`data_model` INNER JOIN `data`.`sequence_type` ON `data_model`.`instance_sequence_type_id`=`sequence_type`.`id` WHERE `data_model`.`version`=? AND `data_model`.`database_name`=? AND `data_model`.`name`=? AND `data_model`.`root_class_path`=?";
            try (PreparedStatement data_stmt = locked_data_model_connection.prepareStatement(select_model_sql);){
                data_stmt.setString(1, this.model_version);
                data_stmt.setString(2, this.model_database);
                data_stmt.setString(3, this.model_name);
                data_stmt.setString(4, this.data_class.clas.getCanonicalName());
                try (ResultSet data_model_resultset = data_stmt.executeQuery();){
                    if (!data_model_resultset.next()) {
                        throw new Exception("DataModel '" + this.data_model_class.getCanonicalName() + "' is not defined in Data.DataModel Table");
                    }
                    Integer dataModelId = data_model_resultset.getInt("data_model_id");
                    String sequence_type = data_model_resultset.getString("sequence_type");
                    Integer instance_last_value = data_model_resultset.getInt("instance_sequence_last_value");
                    Integer sequence_initial_value = data_model_resultset.getInt("sequence_initial_value");
                    Integer sequence_increment_value = data_model_resultset.getInt("sequence_increment_value");
                    if (!sequence_type.equalsIgnoreCase("Integer")) {
                        throw new Exception("Sequence Type must be 'Integer' type");
                    }
                    Model instanceObject = data_model.getInstance();
                    SequenceNumber<Integer> sequenceNumber = new SequenceNumber<Integer>(sequence_initial_value, sequence_increment_value, false);
                    sequenceNumber.initSequence(this.data_class.clas, instance_last_value);
                    DataInstance dataInstance = new DataInstance(DataInstance.State.NEW, this.data_model_database_name, this.data_class, null, null, instanceObject, sequenceNumber, true);
                    instanceID = (Integer)sequenceNumber.getSequenceState(this.data_class.clas);
                    String update_model_sql = "UPDATE `data`.`data_model` SET `instance_sequence_last_value` = ? WHERE `id` = ?";
                    try (PreparedStatement modelUpdateStatement = locked_data_model_connection.prepareStatement(update_model_sql);){
                        modelUpdateStatement.setInt(1, instanceID);
                        modelUpdateStatement.setInt(2, dataModelId);
                        int rows = modelUpdateStatement.executeUpdate();
                        if (rows == 0) {
                            throw new Exception("Can not update data model record with last instance id value");
                        }
                    }
                    String instance_id_sql = "INSERT INTO `data`.`data_model_instance` (`instance_id`, `data_model_id`, `extra_info`) VALUES (?,?,?)";
                    try (PreparedStatement instanceIdStatement = locked_data_model_connection.prepareStatement(instance_id_sql);){
                        instanceIdStatement.setInt(1, instanceID);
                        instanceIdStatement.setInt(2, dataModelId);
                        instanceIdStatement.setString(3, "extra_info");
                        int modelInstanceIdRows = instanceIdStatement.executeUpdate();
                        if (modelInstanceIdRows > 0) {
                            ArrayList<String> sequenceInserts = new ArrayList<String>();
                            HashMap<Class, Integer> sequenceNumberState = sequenceNumber.getSequenceState();
                            Iterator<Class> iterator = sequenceNumberState.keySet().iterator();
                            StringBuilder inserts = new StringBuilder();
                            while (iterator.hasNext()) {
                                Class key = iterator.next();
                                Integer sequenceStateValue = sequenceNumberState.get(key);
                                inserts.setLength(0);
                                inserts.append("INSERT INTO `data`.`data_model_sequence`(`data_model_id`, `instance_id`,`class_path`,`instance_sequence_last_value`)VALUES(").append(dataModelId).append(",").append(instanceID).append(",").append("'").append(key.getCanonicalName()).append("',").append(sequenceStateValue).append(") ON DUPLICATE KEY UPDATE `instance_sequence_last_value`=").append(sequenceStateValue);
                                sequenceInserts.add(inserts.toString());
                            }
                            try (Statement sequenceStatement = locked_data_model_connection.createStatement();){
                                appendable.append("Add Inert Batch").append("\n");
                                for (int i = 0; i < sequenceInserts.size(); ++i) {
                                    String batch = (String)sequenceInserts.get(i);
                                    appendable.append(batch).append("\n");
                                    sequenceStatement.addBatch(batch);
                                }
                                int[] sequenceRows = sequenceStatement.executeBatch();
                                if (sequenceRows != null && sequenceRows.length > 0) {
                                    ArrayList<String> modelInserts = new ArrayList<String>();
                                    dataInstance.saveToDatabase(dataModelId, this.data_lookup, (Object)instanceID, dataInstance, modelInserts, database_field_open_quote, database_field_close_quote);
                                    int modelRows = 0;
                                    try (Connection unlocked_data_model_connection = data_model_source.getConnection(false);){
                                        try (Statement modelStatement = unlocked_data_model_connection.createStatement();){
                                            for (int i = 0; i < modelInserts.size(); ++i) {
                                                appendable.append(modelInserts.get(i)).append("\n");
                                                modelStatement.addBatch(modelInserts.get(i));
                                                if (i % 100 != 0) continue;
                                                modelRows += modelStatement.executeBatch().length;
                                            }
                                            if (modelRows != modelInserts.size()) {
                                                modelRows += modelStatement.executeBatch().length;
                                            }
                                            if (modelRows != modelInserts.size()) {
                                                throw new Exception("Inserted Rows = " + modelRows + " while Total Rows = " + modelInserts.size());
                                            }
                                            if (!unlocked_data_model_connection.isClosed() && !unlocked_data_model_connection.getAutoCommit()) {
                                                unlocked_data_model_connection.commit();
                                            }
                                            modelStatement.close();
                                        }
                                        catch (Exception sqlx) {
                                            appendable.append("----------- insert instance data sql statments crashed -----------").append("\n");
                                            if (!unlocked_data_model_connection.isClosed() && !unlocked_data_model_connection.getAutoCommit()) {
                                                unlocked_data_model_connection.rollback();
                                            }
                                            throw sqlx;
                                        }
                                    }
                                }
                                sequenceStatement.close();
                            }
                            catch (Exception sqlx) {
                                if (!locked_data_model_connection.isClosed() && !locked_data_model_connection.getAutoCommit()) {
                                    locked_data_model_connection.rollback();
                                }
                                throw sqlx;
                            }
                            data_model_resultset.close();
                            data_stmt.close();
                            dataInstance.changeState(DataInstance.State.LOADED, true);
                            this.dataModelDataInstanceMap.put(data_model, dataInstance);
                        }
                        if (!locked_data_model_connection.isClosed() && !locked_data_model_connection.getAutoCommit()) {
                            locked_data_model_connection.commit();
                        }
                        instanceIdStatement.close();
                    }
                    catch (Exception sqlx) {
                        if (!locked_data_model_connection.isClosed() && !locked_data_model_connection.getAutoCommit()) {
                            locked_data_model_connection.rollback();
                        }
                        throw sqlx;
                    }
                }
            }
            catch (Exception sqlx) {
                exception = sqlx;
            }
            try (Statement lockStatement = locked_data_model_connection.createStatement();){
                String unlockTables = "UNLOCK TABLES";
                Boolean bl = lockStatement.execute(unlockTables);
            }
            catch (Exception sqlx) {
                exception = sqlx;
            }
            if (exception != null) {
                throw exception;
            }
        }
        return data_model;
    }

    public DataModel<Model> loadDataModelFromDatabase(JDBCSource data_model_source, String instanceID, DataClass.LoadMethod loadMethod) throws Exception {
        throw new Exception("Method not implemented yet!");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public DataModel<Model> loadDataModelFromDatabase(JDBCSource data_model_source, Integer instanceID, DataClass.LoadMethod loadMethod) throws Exception {
        String select_model_sql = "SELECT `data_model`.`id` AS `model_id`, `instance_sequence_type_id`, `instance_sequence_last_value`, `sequence_type`.`sequence_name`, `sequence_type`.`sequence_type`, `sequence_type`.`sequence_ordered_chars`, `sequence_type`.`sequence_chars_width`, `sequence_type`.`sequence_padding_char`, `sequence_type`.`sequence_rewind`, `sequence_type`.`sequence_initial_value`, `sequence_type`.`sequence_increment_value` FROM `data`.`data_model` INNER JOIN `data`.`sequence_type` ON `data_model`.`instance_sequence_type_id`=`sequence_type`.`id` WHERE `data_model`.`version`=? AND `data_model`.`database_name`=? AND `data_model`.`name`=? AND `data_model`.`root_class_path`=?";
        Integer modelID = -1;
        SequenceNumber<Integer> sequenceNumber = null;
        try (Connection data_model_connection = data_model_source.getConnection(false);){
            DataModel dataModel;
            block46: {
                PreparedStatement data_stmt = data_model_connection.prepareStatement(select_model_sql);
                try {
                    data_stmt.setString(1, this.model_version);
                    data_stmt.setString(2, this.model_database);
                    data_stmt.setString(3, this.model_name);
                    data_stmt.setString(4, this.data_class.clas.getCanonicalName());
                    try (ResultSet data_model_resultset = data_stmt.executeQuery();){
                        if (!data_model_resultset.next()) {
                            throw new Exception("DataModel '" + this.data_model_class.getCanonicalName() + "' is not defined in Data.DataModel Table");
                        }
                        modelID = data_model_resultset.getInt("model_id");
                        String sequence_type = data_model_resultset.getString("sequence_type");
                        Integer sequence_initial_value = data_model_resultset.getInt("sequence_initial_value");
                        Integer sequence_increment_value = data_model_resultset.getInt("sequence_increment_value");
                        if (!sequence_type.equalsIgnoreCase("Integer")) {
                            throw new Exception("Sequence Type must be 'Integer' type");
                        }
                        sequenceNumber = new SequenceNumber<Integer>(sequence_initial_value, sequence_increment_value, false);
                        String select_model_sequences_sql = "SELECT `class_path`, `instance_sequence_last_value` FROM `data`.`data_model_sequence` WHERE `data_model_id`=? AND `instance_id`=?";
                        try (PreparedStatement modelSequenceStatement = data_model_connection.prepareStatement(select_model_sequences_sql, 1005, 1008);){
                            modelSequenceStatement.setInt(1, modelID);
                            modelSequenceStatement.setInt(2, instanceID);
                            try (ResultSet sequenceResultset = modelSequenceStatement.executeQuery();){
                                while (sequenceResultset.next()) {
                                    String classPath = sequenceResultset.getString("class_path");
                                    Integer value = Integer.parseInt(sequenceResultset.getString("instance_sequence_last_value"));
                                    sequenceNumber.initSequence(Class.forName(classPath), value);
                                }
                            }
                            modelSequenceStatement.close();
                        }
                    }
                    ArrayList<String> selects = new ArrayList<String>();
                    if (sequenceNumber == null) {
                        throw new Exception("Sequence is not initialized!");
                    }
                    Object instanceObject = this.data_class.loadFromDatabase(data_model_connection, modelID, this.data_model_database_name, this.data_lookup, instanceID, loadMethod, sequenceNumber, selects);
                    DataModel data_model = (DataModel)this.data_model_class.getConstructor(this.model_class, String.class, String.class, String.class).newInstance(null, this.model_version, this.model_name, this.model_description);
                    Method methodGetDeclaredField = this.data_model_class.getDeclaredMethod("getDeclaredField", new Class[0]);
                    Field modelDeclaredField = (Field)methodGetDeclaredField.invoke(this.data_model, new Object[0]);
                    modelDeclaredField.setAccessible(true);
                    modelDeclaredField.set(data_model, instanceObject);
                    data_model.prepareInstance();
                    dataModel = data_model;
                    if (data_stmt == null) break block46;
                }
                catch (Throwable throwable) {
                    if (data_stmt != null) {
                        try {
                            data_stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                data_stmt.close();
            }
            return dataModel;
        }
    }

    public Boolean isDataModelInstanceRegistered(DataModel<Model> data_model) throws Exception {
        if (data_model == null) {
            throw new Exception("DataModel is null");
        }
        if (data_model.getInstance() == null) {
            throw new Exception("DataModel is null");
        }
        if (data_model.getInstance().getClass().getCanonicalName().equals(this.data_class.clas.getCanonicalName())) {
            throw new Exception("DataProcessor handles DataModel of type '" + this.data_class.clas.getCanonicalName() + "' while passed DataModel is of type '" + data_model.getInstance().getClass().getCanonicalName() + "'");
        }
        return this.dataModelDataInstanceMap.containsValue(data_model);
    }

    public DataModel<Model> updateDataModelInstance(DataModel<Model> data_model) throws Exception {
        if (data_model == null) {
            throw new Exception("DataModel is null");
        }
        if (!this.isDataModelInstanceRegistered(data_model).booleanValue()) {
            throw new Exception("DataModel '" + this.data_class.packageName + "' is not registered yer , first call either registerDataModelInstance or loadDataModelFromDatabase ");
        }
        throw new Exception("Method not completed yet");
    }
}

