/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.data;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

public class DataSet {
    String sql;
    String tablesPath;
    ArrayList<Table> tables;
    ArrayList<HashMap<String, Object>> recordSet;

    public DataSet(String tablesPath) {
        this.tablesPath = tablesPath;
        this.tables = new ArrayList();
        this.recordSet = new ArrayList();
    }

    public void addTable(String tableAlias, String tableName) {
        this.tables.add(new Table(this, tableName, tableAlias));
    }

    public void addField(String tableAlias, String fieldAlias, String fieldName, String classPath) throws Exception {
        for (Table table : this.tables) {
            if (!table.alias.equals(tableAlias)) continue;
            table.addField(fieldName, fieldAlias, classPath);
        }
    }

    public void setSQL(String sql) throws Exception {
        if (sql == null) {
            throw new Exception("SQL statement is null!");
        }
        this.sql = sql;
    }

    public void addRecords(Connection connection, String whereClause) throws Exception {
        String sqlStatement = this.sql + (whereClause == null ? "" : whereClause);
        try (PreparedStatement preparedStatement = connection.prepareStatement(sqlStatement);){
            try (ResultSet rs = preparedStatement.executeQuery();){
                while (rs.next()) {
                    HashMap<String, Object> record = new HashMap<String, Object>();
                    for (int i = 0; i < this.tables.size(); ++i) {
                        Table table = this.tables.get(i);
                        for (int x = 0; x < table.fields.size(); ++x) {
                            Table.Field field = table.fields.get(x);
                            record.put(field.alias, rs.getObject(field.alias));
                        }
                    }
                    this.recordSet.add(record);
                }
                rs.close();
            }
            preparedStatement.close();
        }
    }

    class Table {
        String name;
        String alias;
        ArrayList<Field> fields;

        public Table(DataSet this$0, String name, String alias) {
            this.name = name;
            this.alias = alias;
            this.fields = new ArrayList();
        }

        public void addField(String fieldAlias, String fieldName, String classPath) {
            this.fields.add(new Field(this, fieldAlias, fieldName, classPath));
        }

        class Field {
            String name;
            String alias;
            String classPath;

            public Field(Table this$1, String name, String alias, String classPath) {
                this.name = name;
                this.alias = alias;
                this.classPath = classPath;
            }
        }
    }
}

