/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import redis.clients.jedis.Jedis;

public class JsonUtil {
    private static ArrayList<Gson> gson_pool = new ArrayList();
    private static ArrayList<Gson> gson_pool_prety = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gson gson() {
        ArrayList<Gson> arrayList = gson_pool;
        synchronized (arrayList) {
            if (gson_pool.size() > 0) {
                return gson_pool.remove(0);
            }
        }
        return new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).disableHtmlEscaping().create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gson gsonPretty() {
        ArrayList<Gson> arrayList = gson_pool_prety;
        synchronized (arrayList) {
            if (gson_pool_prety.size() > 0) {
                return gson_pool_prety.remove(0);
            }
        }
        return new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).disableHtmlEscaping().setPrettyPrinting().create();
    }

    public static void reclaimGson(Gson gson) {
        if (gson_pool.contains(gson)) {
            return;
        }
        gson_pool.add(gson);
    }

    public static void reclaimGsonPretty(Gson gson) {
        gson_pool_prety.add(gson);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> byte[] serilize(JsonElement json_element, Class<T> class_type) throws Exception {
        Gson gson = JsonUtil.gson();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                Serializable object = (Serializable)gson.fromJson(json_element, class_type);
                JsonUtil.reclaimGson(gson);
                oos.writeObject(object);
                byArray = baos.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        oos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    JsonUtil.reclaimGson(gson);
                    throw ex;
                }
            }
            oos.close();
            return byArray;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T objectize(byte[] json_serialized, Class<T> class_type) throws Exception {
        Gson gson = JsonUtil.gson();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(json_serialized);){
            Serializable serializable;
            ObjectInputStream ois = new ObjectInputStream(bais);
            try {
                Object object = ois.readObject();
                JsonElement json_element = gson.toJsonTree(object, class_type);
                Serializable class_object = (Serializable)gson.fromJson(json_element, class_type);
                JsonUtil.reclaimGson(gson);
                if (!class_type.getName().equalsIgnoreCase(object.getClass().getName())) {
                    throw new ClassCastException("Required '" + class_type.getName() + "' but fetched '" + object.getClass().getName() + "'");
                }
                serializable = class_object;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    JsonUtil.reclaimGson(gson);
                    throw ex;
                }
            }
            ois.close();
            return (T)serializable;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> JsonElement deserilize(byte[] json_serialized, Class<T> class_type) throws Exception {
        Gson gson = JsonUtil.gson();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(json_serialized);){
            JsonElement jsonElement;
            ObjectInputStream ois = new ObjectInputStream(bais);
            try {
                Object object = ois.readObject();
                JsonElement json_element = gson.toJsonTree(object, class_type);
                JsonUtil.reclaimGson(gson);
                jsonElement = json_element;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    JsonUtil.reclaimGson(gson);
                    throw ex;
                }
            }
            ois.close();
            return jsonElement;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static String jsonElementToString(JsonElement json_element) throws Exception {
        Gson gson = JsonUtil.gson();
        try {
            String string = gson.toJson((Object)json_element, JsonElement.class);
            JsonUtil.reclaimGson(gson);
            return string;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static String jsonElementToButifulString(JsonElement json_element) throws Exception {
        Gson gson = JsonUtil.gsonPretty();
        try {
            String string = gson.toJson((Object)json_element, JsonElement.class);
            JsonUtil.reclaimGsonPretty(gson);
            return string;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static JsonElement jsonStringToJsonElelement(String json_stringized) throws Exception {
        Gson gson = JsonUtil.gson();
        try {
            JsonElement json_element = (JsonElement)gson.fromJson(json_stringized, JsonElement.class);
            JsonUtil.reclaimGson(gson);
            return json_element;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static <CustomeType> String objectToJsonString(Object java_object, Class<CustomeType> class_type) throws Exception {
        Gson gson = JsonUtil.gson();
        try {
            String string = gson.toJson(java_object, class_type);
            JsonUtil.reclaimGson(gson);
            return string;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static <CustomeType> CustomeType jsonElementToObject(JsonElement json_element, Class<CustomeType> class_type) throws Exception {
        Gson gson = JsonUtil.gson();
        try {
            Object custome_type = gson.fromJson(json_element, class_type);
            JsonUtil.reclaimGson(gson);
            return (CustomeType)custome_type;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static <CustomeType> CustomeType jsonStringToObject(String json_stringized, Class<CustomeType> class_type) throws Exception {
        Gson gson = JsonUtil.gson();
        try {
            Object custome_type = gson.fromJson(json_stringized, class_type);
            JsonUtil.reclaimGson(gson);
            return (CustomeType)custome_type;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static JsonElement objectToJsonElement(Object java_object, Class<?> class_type) throws Exception {
        Gson gson = JsonUtil.gson();
        try {
            JsonElement json_element = gson.toJsonTree(java_object, class_type);
            JsonUtil.reclaimGson(gson);
            return json_element;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    private static void isNull(JsonObject jsonObject, String jsonProperty, Boolean nullable) throws Exception {
        if (!nullable.booleanValue() && (jsonObject.get(jsonProperty) == null || jsonObject.get(jsonProperty).isJsonNull())) {
            throw new Exception("Json Object property '" + jsonProperty + "' is null");
        }
    }

    private static void isNull(JsonArray jsonArray, int jsonIndex, Boolean nullable) throws Exception {
        if (!nullable.booleanValue() && (jsonArray.get(jsonIndex) == null || jsonArray.get(jsonIndex).isJsonNull())) {
            throw new Exception("Json Array index '" + jsonIndex + "' is null");
        }
    }

    public static JsonObject getJsonObject(JsonObject jsonObject, String jsonProperty, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonObject, jsonProperty, nullable);
        return jsonObject.get(jsonProperty) == null || jsonObject.get(jsonProperty).isJsonNull() ? null : jsonObject.get(jsonProperty).getAsJsonObject();
    }

    public static JsonArray getJsonArray(JsonObject jsonObject, String jsonProperty, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonObject, jsonProperty, nullable);
        return jsonObject.get(jsonProperty) == null || jsonObject.get(jsonProperty).isJsonNull() ? null : jsonObject.get(jsonProperty).getAsJsonArray();
    }

    public static String getJsonString(JsonObject jsonObject, String jsonProperty, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonObject, jsonProperty, nullable);
        return jsonObject.get(jsonProperty) == null || jsonObject.get(jsonProperty).isJsonNull() ? null : jsonObject.get(jsonProperty).getAsString();
    }

    public static Boolean getJsonBoolean(JsonObject jsonObject, String jsonProperty, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonObject, jsonProperty, nullable);
        return jsonObject.get(jsonProperty) == null || jsonObject.get(jsonProperty).isJsonNull() ? null : Boolean.valueOf(jsonObject.get(jsonProperty).getAsBoolean());
    }

    public static Integer getJsonInteger(JsonObject jsonObject, String jsonProperty, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonObject, jsonProperty, nullable);
        return jsonObject.get(jsonProperty) == null || jsonObject.get(jsonProperty).isJsonNull() ? null : Integer.valueOf(jsonObject.get(jsonProperty).getAsInt());
    }

    public static Long getJsonLong(JsonObject jsonObject, String jsonProperty, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonObject, jsonProperty, nullable);
        return jsonObject.get(jsonProperty) == null || jsonObject.get(jsonProperty).isJsonNull() ? null : Long.valueOf(jsonObject.get(jsonProperty).getAsLong());
    }

    public static Double getJsonDouble(JsonObject jsonObject, String jsonProperty, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonObject, jsonProperty, nullable);
        return jsonObject.get(jsonProperty) == null || jsonObject.get(jsonProperty).isJsonNull() ? null : Double.valueOf(jsonObject.get(jsonProperty).getAsDouble());
    }

    private static void isNull(JsonArray jsonArray, Integer index, Boolean nullable) throws Exception {
        if (!nullable.booleanValue() && (jsonArray.size() < index || jsonArray.get(index.intValue()) == null || jsonArray.get(index.intValue()).isJsonNull())) {
            throw new Exception("Json Object index '" + index + "' is null");
        }
    }

    public static JsonObject getJsonObject(JsonArray jsonArray, Integer jsonIndex, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonArray, jsonIndex, nullable);
        return jsonArray.size() < jsonIndex || jsonArray.get(jsonIndex.intValue()) == null || jsonArray.get(jsonIndex.intValue()).isJsonNull() ? null : jsonArray.get(jsonIndex.intValue()).getAsJsonObject();
    }

    public static String getJsonString(JsonArray jsonArray, Integer jsonIndex, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonArray, jsonIndex, nullable);
        return jsonArray.size() < jsonIndex || jsonArray.get(jsonIndex.intValue()) == null || jsonArray.get(jsonIndex.intValue()).isJsonNull() ? null : jsonArray.get(jsonIndex.intValue()).getAsString();
    }

    public static Boolean getJsonBoolean(JsonArray jsonArray, Integer jsonIndex, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonArray, jsonIndex, nullable);
        return jsonArray.size() < jsonIndex || jsonArray.get(jsonIndex.intValue()) == null || jsonArray.get(jsonIndex.intValue()).isJsonNull() ? null : Boolean.valueOf(jsonArray.get(jsonIndex.intValue()).getAsBoolean());
    }

    public static Integer getJsonInteger(JsonArray jsonArray, Integer jsonIndex, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonArray, jsonIndex, nullable);
        return jsonArray.size() < jsonIndex || jsonArray.get(jsonIndex.intValue()) == null || jsonArray.get(jsonIndex.intValue()).isJsonNull() ? null : Integer.valueOf(jsonArray.get(jsonIndex.intValue()).getAsInt());
    }

    public static Long getJsonLong(JsonArray jsonArray, Integer jsonIndex, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonArray, jsonIndex, nullable);
        return jsonArray.size() < jsonIndex || jsonArray.get(jsonIndex.intValue()) == null || jsonArray.get(jsonIndex.intValue()).isJsonNull() ? null : Long.valueOf(jsonArray.get(jsonIndex.intValue()).getAsLong());
    }

    public static Double getJsonDouble(JsonArray jsonArray, Integer jsonIndex, Boolean nullable) throws Exception {
        JsonUtil.isNull(jsonArray, jsonIndex, nullable);
        return jsonArray.size() < jsonIndex || jsonArray.get(jsonIndex.intValue()) == null || jsonArray.get(jsonIndex.intValue()).isJsonNull() ? null : Double.valueOf(jsonArray.get(jsonIndex.intValue()).getAsDouble());
    }

    public static void addJsonOpenObject(StringBuilder string) throws Exception {
        string.append("{");
    }

    public static void addJsonCloseObject(StringBuilder string) throws Exception {
        string.append("}");
    }

    public static void addJsonOpenArray(StringBuilder string) throws Exception {
        string.append("[");
    }

    public static void addJsonCloseArray(StringBuilder string) throws Exception {
        string.append("]");
    }

    public static void addJsonComma(StringBuilder string) throws Exception {
        string.append(",");
    }

    public static void addJsonColon(StringBuilder string) throws Exception {
        string.append(":");
    }

    public static void addJsonTag(StringBuilder string, String tag) throws Exception {
        string.append("\"").append(tag).append("\":");
    }

    public static void addJsonArrayItemNull(StringBuilder string) throws Exception {
        string.append("null");
    }

    public static void addJsonArrayItemString(StringBuilder string, String content) throws Exception {
        string.append("\"").append(content).append("\"");
    }

    public static void addJsonArrayItemNumber(StringBuilder string, String content) throws Exception {
        string.append(content);
    }

    public static void addJsonPropertyNull(StringBuilder string, String tag) throws Exception {
        string.append("\"").append(tag).append("\":null");
    }

    public static void addJsonPropertyString(StringBuilder string, String tag, String content) throws Exception {
        string.append("\"").append(tag).append("\":\"").append(content).append("\"");
    }

    public static void addJsonPropertyNumber(StringBuilder string, String tag, String content) throws Exception {
        string.append("\"").append(tag).append("\":").append(content);
    }

    public static Object[] javaArray(JsonArray jsonArray) throws Exception {
        Object[] javaArray = new String[jsonArray.size()];
        for (int i = 0; i < javaArray.length; ++i) {
            javaArray[i] = jsonArray.get(i).isJsonNull() ? null : jsonArray.get(i).getAsString();
        }
        return javaArray;
    }

    public static ArrayList<String> javaStringArrayList(JsonArray jsonArray) throws Exception {
        ArrayList<String> javaArray = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            javaArray.add(jsonArray.get(i).isJsonNull() ? null : jsonArray.get(i).getAsString());
        }
        return javaArray;
    }

    public static String[] javaStringArray(JsonArray jsonArray) throws Exception {
        String[] javaArray = new String[jsonArray.size()];
        for (int i = 0; i < javaArray.length; ++i) {
            javaArray[i] = jsonArray.get(i).isJsonNull() ? null : jsonArray.get(i).getAsString();
        }
        return javaArray;
    }

    public static Integer[] javaIntegerArray(JsonArray jsonArray) throws Exception {
        Integer[] javaArray = new Integer[jsonArray.size()];
        for (int i = 0; i < javaArray.length; ++i) {
            javaArray[i] = jsonArray.get(i).isJsonNull() ? null : Integer.valueOf(jsonArray.get(i).getAsInt());
        }
        return javaArray;
    }

    public static Long[] javaLongArray(JsonArray jsonArray) throws Exception {
        Long[] javaArray = new Long[jsonArray.size()];
        for (int i = 0; i < javaArray.length; ++i) {
            javaArray[i] = jsonArray.get(i).isJsonNull() ? null : Long.valueOf(jsonArray.get(i).getAsLong());
        }
        return javaArray;
    }

    public static Boolean[] javaBooleanArray(JsonArray jsonArray) throws Exception {
        Boolean[] javaArray = new Boolean[jsonArray.size()];
        for (int i = 0; i < javaArray.length; ++i) {
            javaArray[i] = jsonArray.get(i).isJsonNull() ? null : Boolean.valueOf(jsonArray.get(i).getAsBoolean());
        }
        return javaArray;
    }

    public static <T extends Serializable> void inRedis(Jedis jedis, String key, String field, JsonElement value, Class<T> class_type) throws Exception {
        JsonUtil.inRedis(jedis, key.getBytes(StandardCharsets.UTF_8), field.getBytes(StandardCharsets.UTF_8), value, class_type);
    }

    public static <T extends Serializable> void inRedis(Jedis jedis, byte[] key, byte[] field, JsonElement value, Class<T> class_type) throws Exception {
        byte[] json_serialized = JsonUtil.serilize(value, class_type);
        jedis.hset(key, field, json_serialized);
    }

    public static <T extends Serializable> JsonElement outRedis(Jedis jedis, String key, String field, Class<T> class_type) throws Exception {
        return JsonUtil.outRedis(jedis, key.getBytes(StandardCharsets.UTF_8), field.getBytes(StandardCharsets.UTF_8), class_type);
    }

    public static <T extends Serializable> JsonElement outRedis(Jedis jedis, byte[] key, byte[] field, Class<T> class_type) throws Exception {
        byte[] json_serialized = jedis.hget(key, field);
        if (json_serialized == null) {
            return null;
        }
        return JsonUtil.deserilize(json_serialized, class_type);
    }

    public static <T extends Serializable> T outRedisObject(Jedis jedis, byte[] key, byte[] field, Class<T> class_type) throws Exception {
        byte[] json_serialized = jedis.hget(key, field);
        if (json_serialized == null) {
            return null;
        }
        T object = JsonUtil.objectize(json_serialized, class_type);
        return object;
    }

    public static Long delRedis(Jedis jedis, String key) throws Exception {
        return jedis.del(key.getBytes(StandardCharsets.UTF_8));
    }

    public static Long delRedis(Jedis jedis, String key, String field) throws Exception {
        return jedis.hdel(key.getBytes(StandardCharsets.UTF_8), (byte[][])new byte[][]{field.getBytes(StandardCharsets.UTF_8)});
    }

    public static <T extends Serializable> ArrayList<JsonElement> redisJsonList(Jedis jedis, String key, Class<T> class_type) throws Exception {
        Map key_byte_list = jedis.hgetAll(key.getBytes(StandardCharsets.UTF_8));
        ArrayList<JsonElement> json_element_list = new ArrayList<JsonElement>();
        for (Map.Entry key_entry : key_byte_list.entrySet()) {
            byte[] field_key = (byte[])key_entry.getKey();
            byte[] field_tag = (byte[])key_entry.getValue();
            JsonElement json_element = JsonUtil.outRedis(jedis, field_key, field_tag, class_type);
            json_element_list.add(json_element);
        }
        return json_element_list;
    }

    public static <T extends Serializable> ArrayList<T> redisObjectList(Jedis jedis, String key, Class<T> class_type) throws Exception {
        Map key_byte_list = jedis.hgetAll(key.getBytes(StandardCharsets.UTF_8));
        ArrayList<T> object_list = new ArrayList<T>();
        for (Map.Entry key_entry : key_byte_list.entrySet()) {
            byte[] field_key = (byte[])key_entry.getKey();
            byte[] field_tag = (byte[])key_entry.getValue();
            T object = JsonUtil.objectize(field_tag, class_type);
            object_list.add(object);
        }
        return object_list;
    }

    public static JsonArray jsonStringArray(String[] javaArray) throws Exception {
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < javaArray.length; ++i) {
            jsonArray.add(javaArray[i]);
        }
        return jsonArray;
    }

    public static JsonArray jsonIntegerArray(Integer[] javaArray) throws Exception {
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < javaArray.length; ++i) {
            jsonArray.add((Number)javaArray[i]);
        }
        return jsonArray;
    }

    public static JsonArray jsonLongArray(Long[] javaArray) throws Exception {
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < javaArray.length; ++i) {
            jsonArray.add((Number)javaArray[i]);
        }
        return jsonArray;
    }

    public static JsonArray jsonBooleanArray(Boolean[] javaArray) throws Exception {
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < javaArray.length; ++i) {
            jsonArray.add(javaArray[i]);
        }
        return jsonArray;
    }

    public static JsonArray jsonObjectArray(Object[] javaArray) throws Exception {
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < javaArray.length; ++i) {
            Object java_object = javaArray[i];
            if (java_object instanceof Boolean) {
                jsonArray.add((Boolean)java_object);
                continue;
            }
            if (java_object instanceof Integer) {
                jsonArray.add((Number)((Integer)java_object));
                continue;
            }
            if (java_object instanceof Long) {
                jsonArray.add((Number)((Long)java_object));
                continue;
            }
            if (!(java_object instanceof String)) continue;
            jsonArray.add((String)java_object);
        }
        return jsonArray;
    }

    public static void writeStream(OutputStream output_stream, JsonElement json_element) throws Exception {
        Gson gson = JsonUtil.gson();
        try {
            JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(output_stream));
            gson.toJson(json_element, writer);
            writer.flush();
            writer.close();
            JsonUtil.reclaimGson(gson);
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static void writeFile(String file_path, Boolean overwrite, JsonElement json_element) throws Exception {
        File file = new File(file_path);
        if (file.exists() && !overwrite.booleanValue()) {
            throw new Exception("File Exists and Overwerite = false");
        }
        file.setWritable(true);
        Gson gson = JsonUtil.gson();
        try {
            JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)));
            gson.toJson(json_element, writer);
            writer.flush();
            writer.close();
            JsonUtil.reclaimGson(gson);
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static JsonElement readStream(InputStream input_stream) throws Exception {
        Gson gson = JsonUtil.gson();
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(input_stream));
            JsonElement json_element = (JsonElement)gson.fromJson(reader, JsonElement.class);
            reader.close();
            JsonUtil.reclaimGson(gson);
            return json_element;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static JsonElement readFile(String file_path, Boolean create_if_not_exists) throws Exception {
        File file = new File(file_path);
        if (!file.exists() && !create_if_not_exists.booleanValue()) {
            throw new FileNotFoundException("File not exists and create_if_not_exists = false");
        }
        if (!file.exists() && create_if_not_exists.booleanValue()) {
            file.createNewFile();
        }
        Gson gson = JsonUtil.gson();
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(new FileInputStream(file)));
            JsonElement json_element = (JsonElement)gson.fromJson(reader, JsonElement.class);
            reader.close();
            JsonUtil.reclaimGson(gson);
            return json_element;
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
    }

    public static void deleteFile(String file_path) throws Exception {
        File file = new File(file_path);
        file.delete();
        if (file.exists()) {
            file.getCanonicalFile().delete();
        }
    }

    public static JsonPrimitive getJsonPrimitive(String path, JsonElement json_element) throws Exception {
        JsonElement element = JsonUtil.getJsonElement(path, json_element);
        return element.getAsJsonPrimitive();
    }

    public static JsonObject getJsonObject(String path, JsonElement json_element) throws Exception {
        JsonElement element = JsonUtil.getJsonElement(path, json_element);
        return element.getAsJsonObject();
    }

    public static JsonArray getJsonArray(String path, JsonElement json_element) throws Exception {
        JsonElement element = JsonUtil.getJsonElement(path, json_element);
        return element.getAsJsonArray();
    }

    public static JsonElement getJsonElement(String path, JsonElement json_element) throws Exception {
        String[] tokens = path.split("\\.");
        JsonElement element = json_element;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (element.isJsonObject()) {
                element = element.getAsJsonObject().get(token);
                continue;
            }
            if (element.isJsonArray()) {
                element = element.getAsJsonArray();
                continue;
            }
            if (element.isJsonPrimitive()) {
                element = element.getAsJsonPrimitive();
                continue;
            }
            if (element.isJsonNull()) {
                element = element.getAsJsonNull();
                continue;
            }
            throw new Exception("Undefined json '" + element.toString() + "' object type");
        }
        if (element == null) {
            throw new Exception("Json Properties path '" + path + "' is null");
        }
        return element;
    }
}

