/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.model;

import net.reyadeyat.relational.api.data.DataModel;
import net.reyadeyat.relational.api.model.ChildTable;
import net.reyadeyat.relational.api.model.Database;
import net.reyadeyat.relational.api.model.Enterprise;
import net.reyadeyat.relational.api.model.Field;
import net.reyadeyat.relational.api.model.ForeignKey;
import net.reyadeyat.relational.api.model.ForeignKeyField;
import net.reyadeyat.relational.api.model.PrimaryKey;
import net.reyadeyat.relational.api.model.PrimaryKeyField;
import net.reyadeyat.relational.api.model.ReferencedKeyField;
import net.reyadeyat.relational.api.model.Table;

public class EnterpriseModel<Model extends Enterprise>
implements DataModel<Model> {
    private Model enterprise;
    public String modelVersion;
    public String modelName;
    public String modelDescription;

    private EnterpriseModel() {
    }

    public EnterpriseModel(Model enterprise, String modelVersion, String modelName, String modelDescription) {
        this.enterprise = enterprise;
        this.modelVersion = modelVersion;
        this.modelName = modelName;
        this.modelDescription = modelDescription;
    }

    @Override
    public String getVersion() {
        return this.modelVersion;
    }

    @Override
    public String getName() {
        return this.modelName;
    }

    @Override
    public Model getInstance() {
        return this.enterprise;
    }

    @Override
    public String getDescription() {
        return this.modelDescription;
    }

    @Override
    public java.lang.reflect.Field getDeclaredField() throws NoSuchFieldException {
        return EnterpriseModel.class.getDeclaredField("enterprise");
    }

    @Override
    public void prepareInstance() throws Exception {
        for (Database database : ((Enterprise)this.enterprise).databases) {
            database.enterprise = this.enterprise;
            database.case_sensitive_sql = ((Enterprise)this.enterprise).case_sensitive_sql;
            for (Table table : database.tables) {
                table.database = database;
                table.caseSensitiveSql = database.case_sensitive_sql;
                for (Field field : table.fields) {
                    field.table = table;
                    field.caseSensitiveSql = table.caseSensitiveSql;
                }
                for (PrimaryKey primaryKey : table.primaryKeys) {
                    primaryKey.table = table;
                    primaryKey.caseSensitiveSql = table.caseSensitiveSql;
                    for (PrimaryKeyField primaryKeyField : primaryKey.primaryKeyFields) {
                        primaryKeyField.parentPrimaryKey = primaryKey;
                        primaryKeyField.caseSensitiveSql = primaryKey.caseSensitiveSql;
                    }
                }
                for (ForeignKey foreignKey : table.foreignKeys) {
                    foreignKey.table = table;
                    foreignKey.caseSensitiveSql = table.caseSensitiveSql;
                    for (ForeignKeyField foreignKeyField : foreignKey.foreignKeyFields) {
                        foreignKeyField.foreignKey = foreignKey;
                        foreignKeyField.caseSensitiveSql = foreignKey.caseSensitiveSql;
                    }
                    for (ReferencedKeyField referencedKeyField : foreignKey.referencedKeyFields) {
                        referencedKeyField.foreignKey = foreignKey;
                        referencedKeyField.caseSensitiveSql = foreignKey.caseSensitiveSql;
                    }
                }
                for (ChildTable childTable : table.childTables) {
                    childTable.parentTable = table;
                    childTable.caseSensitiveSql = table.caseSensitiveSql;
                    String tableName = new String(childTable.tableName);
                    childTable.table = database.tables.stream().filter(o -> o.name.equals(tableName)).findAny().orElse(null);
                    String foreigKeyName = new String(childTable.foreigKeyName);
                    childTable.foreignKey = childTable.table.foreignKeys.stream().filter(o -> o.name.equals(foreigKeyName)).findAny().orElse(null);
                }
            }
            database.extractTableLogic(false);
        }
    }
}

