/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.stream.JsonWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.reyadeyat.relational.api.data.DataClass;
import net.reyadeyat.relational.api.data.DataLookup;
import net.reyadeyat.relational.api.data.DataModel;
import net.reyadeyat.relational.api.data.DataProcessor;
import net.reyadeyat.relational.api.jdbc.JDBCSource;
import net.reyadeyat.relational.api.json.JsonResultset;
import net.reyadeyat.relational.api.json.ZonedDateTimeAdapter;
import net.reyadeyat.relational.api.model.DataStructure;
import net.reyadeyat.relational.api.model.Database;
import net.reyadeyat.relational.api.model.Enterprise;
import net.reyadeyat.relational.api.model.EnterpriseModel;
import net.reyadeyat.relational.api.model.Field;
import net.reyadeyat.relational.api.model.ForeignKey;
import net.reyadeyat.relational.api.model.ForeignKeyField;
import net.reyadeyat.relational.api.model.PrimaryKey;
import net.reyadeyat.relational.api.model.PrimaryKeyField;
import net.reyadeyat.relational.api.model.ReferencedKeyField;
import net.reyadeyat.relational.api.model.Table;

public class MetadataMiner {
    private Integer model_id;
    private String secret_key;
    private String model_name;
    private String model_description;
    private DataLookup data_lookup;
    private String java_package_name;
    private JDBCSource data_model_source;
    private JDBCSource model_database_source;
    private ArrayList<String> table_list;
    private String data_lookup_category;
    private String model_version;
    private String model_database_schem;
    private String model_database_field_open_quote;
    private String model_database_field_close_quote;
    private static String nl = "\n";
    private static String section_separator = "\n-------------------------------------------------------------------------------\n";
    private static String data_separator = "  -------------------------  ";

    public MetadataMiner(Integer model_id, String java_package_name, JDBCSource data_model_source, JDBCSource model_database_source, ArrayList<String> table_list, String data_lookup_category, String model_version, String model_database_schem, String model_database_field_open_quote, String model_database_field_close_quote, String secret_key) throws Exception {
        this.model_id = model_id == null ? -1 : model_id;
        this.java_package_name = java_package_name;
        this.data_model_source = data_model_source;
        this.model_database_source = model_database_source;
        this.table_list = table_list;
        this.data_lookup_category = data_lookup_category;
        this.model_version = model_version;
        this.model_database_schem = model_database_schem;
        this.model_database_field_open_quote = model_database_field_open_quote;
        this.model_database_field_close_quote = model_database_field_close_quote;
        this.secret_key = secret_key;
    }

    public Integer generateModel(PrintWriter writer, JsonArray generating_time_elements) throws Exception {
        int shift;
        long t1;
        String model_database = this.model_database_source.getDatabaseName();
        ArrayList<String> models = new ArrayList<String>(Arrays.asList(model_database));
        Boolean write_output = true;
        if (writer == null) {
            writer = new PrintWriter(PrintWriter.nullWriter());
            write_output = false;
        }
        try (Connection data_model_connection = this.data_model_source.getConnection(false);
             Statement st = data_model_connection.createStatement();){
            String sql = "SELECT `enum_name`, `enum_element_id`, `enum_element_code`, `enum_element_java_datatype`, `enum_element_typescript_datatype` FROM `data`.`lookup_enum` INNER JOIN `data`.`lookup_enum_element` ON `lookup_enum`.`enum_id` = `lookup_enum_element`.`enum_id` WHERE `lookup_enum`.`enum_name`='" + this.data_lookup_category + "' ORDER BY `enum_name`, `enum_element_code`";
            try (ResultSet rs = st.executeQuery(sql);){
                this.data_lookup = new DataLookup(rs, this.data_lookup_category, "enum_name", "enum_element_id", "enum_element_code", "enum_element_java_datatype", "enum_element_typescript_datatype");
                rs.close();
            }
            st.close();
        }
        DatabaseMetaData databaseMetaData = null;
        String databaseEngine = null;
        String databaseURL = null;
        Boolean case_sensitive_sql = true;
        String source_url = null;
        String model_url = null;
        Enterprise model_enterprise = null;
        try (Connection model_database_connection = this.model_database_source.getConnection(false);){
            ResultSetMetaData rsmd;
            ResultSet rs;
            t1 = System.nanoTime();
            databaseMetaData = model_database_connection.getMetaData();
            databaseEngine = databaseMetaData.getDatabaseProductName();
            databaseURL = databaseMetaData.getURL();
            source_url = databaseMetaData.getURL();
            model_url = databaseMetaData.getURL();
            if (databaseEngine.toLowerCase().contains("mysql")) {
                model_database_connection.createStatement().execute("USE " + this.model_database_field_open_quote + model_database + this.model_database_field_close_quote);
                databaseEngine = "mysql";
            } else if (databaseEngine.toLowerCase().contains("sql server")) {
                model_database_connection.createStatement().execute("USE " + this.model_database_field_open_quote + model_database + this.model_database_field_close_quote);
                databaseEngine = "sql server";
            } else if (databaseEngine.toLowerCase().contains("informix")) {
                model_database_connection.createStatement().execute("DATABASE " + this.model_database_field_open_quote + model_database + this.model_database_field_close_quote);
                databaseEngine = "informix";
            } else {
                throw new Exception("Database '" + databaseEngine + "' is not implemented yet");
            }
            model_enterprise = new Enterprise(model_database, databaseEngine, databaseURL, case_sensitive_sql);
            ResultSet dbrs = databaseMetaData.getCatalogs();
            ResultSetMetaData dbrsmd = dbrs.getMetaData();
            int dbfeilds_count = dbrsmd.getColumnCount();
            while (dbrs.next()) {
                Iterator<Object> dbName = dbrs.getString("TABLE_CAT");
                for (String model : models) {
                    if ((!case_sensitive_sql.booleanValue() || !model.equals(dbName)) && (case_sensitive_sql.booleanValue() || !model.equalsIgnoreCase((String)((Object)dbName)))) continue;
                    Database tModelDatabase = new Database((String)((Object)dbName), databaseEngine, case_sensitive_sql, this.java_package_name);
                    model_enterprise.addDatabase(tModelDatabase);
                }
            }
            dbrs.close();
            for (Database tModelDatabase : model_enterprise.databases) {
                int tbfeilds_count = 0;
                ResultSet tbrs = databaseMetaData.getTables(tModelDatabase.name, null, null, new String[]{"TABLE"});
                Iterator<Table> tbrsmd = tbrs.getMetaData();
                tbfeilds_count = tbrsmd.getColumnCount();
                while (tbrs.next()) {
                    String tableName = tbrs.getString("TABLE_NAME");
                    String tableSchem = tbrs.getString("TABLE_SCHEM");
                    if (this.table_list != null && this.table_list.size() > 0 && !this.table_list.contains(tableName) || this.model_database_schem != null && tableSchem != null && this.model_database_schem.length() > 0 && !tableSchem.equalsIgnoreCase(this.model_database_schem)) continue;
                    Integer rows = 0;
                    Table table = new Table(tableName, case_sensitive_sql, rows, this.data_lookup);
                    tModelDatabase.addTable(table);
                }
                tbrs.close();
            }
            for (Database tModelDatabase : model_enterprise.databases) {
                for (Table table : tModelDatabase.tables) {
                    rs = databaseMetaData.getColumns(tModelDatabase.name, null, table.name, null);
                    rsmd = rs.getMetaData();
                    int feilds_count = rsmd.getColumnCount();
                    while (rs.next()) {
                        String name = rs.getString("COLUMN_NAME");
                        String dataTypeName = rs.getString("TYPE_NAME");
                        String dataTypeCode = rs.getString("DATA_TYPE");
                        Boolean nullable = rs.getString("IS_NULLABLE").equalsIgnoreCase("YES");
                        Boolean autoIncrment = rs.getString("IS_AUTOINCREMENT").equalsIgnoreCase("YES");
                        String defaultValue = rs.getString("COLUMN_DEF");
                        Integer list_order = rs.getInt("ORDINAL_POSITION");
                        Integer size = rs.getInt("COLUMN_SIZE");
                        Integer decimalDigits = rs.getObject("DECIMAL_DIGITS") == null ? 0 : rs.getInt("DECIMAL_DIGITS");
                        Field modelField = new Field(table, name, dataTypeName, dataTypeCode, nullable, autoIncrment, defaultValue, list_order, size, decimalDigits, case_sensitive_sql, this.data_lookup);
                        table.addField(modelField);
                    }
                    rs.close();
                }
            }
            for (Database tModelDatabase : model_enterprise.databases) {
                for (Table table : tModelDatabase.tables) {
                    rs = databaseMetaData.getPrimaryKeys(tModelDatabase.name, null, table.name);
                    rsmd = rs.getMetaData();
                    int feilds_count = rsmd.getColumnCount();
                    String currentPrimaryKeyName = "";
                    PrimaryKey modelPrimaryKey = null;
                    while (rs.next()) {
                        String primaryKeyName = rs.getString("PK_NAME");
                        if (modelPrimaryKey == null || !case_sensitive_sql.booleanValue() && !primaryKeyName.equals(currentPrimaryKeyName) || case_sensitive_sql.booleanValue() && !primaryKeyName.equalsIgnoreCase(currentPrimaryKeyName)) {
                            modelPrimaryKey = new PrimaryKey(table, primaryKeyName, case_sensitive_sql);
                        }
                        PrimaryKeyField primaryKeyField = new PrimaryKeyField(rs.getString("COLUMN_NAME"), case_sensitive_sql);
                        modelPrimaryKey.addField(primaryKeyField);
                        currentPrimaryKeyName = primaryKeyName;
                    }
                    rs.close();
                    if (modelPrimaryKey == null) continue;
                    table.addPrimaryKey(modelPrimaryKey);
                }
            }
            for (Database tModelDatabase : model_enterprise.databases) {
                for (Table table : tModelDatabase.tables) {
                    rs = databaseMetaData.getImportedKeys(tModelDatabase.name, null, table.name);
                    rsmd = rs.getMetaData();
                    int feilds_count = rsmd.getColumnCount();
                    String currentForeignKeyName = "";
                    ForeignKey modelForeignKey = null;
                    while (rs.next()) {
                        String foreignKeyName = rs.getString("FK_NAME");
                        String table_name = rs.getString("FKTABLE_NAME");
                        String referencedKeyTableName = rs.getString("PKTABLE_NAME");
                        Table parentTable = tModelDatabase.tables.stream().filter(o -> o.name.equals(referencedKeyTableName)).findAny().orElse(null);
                        if (parentTable == null) {
                            writer.append("------------Warning - Foreign Key inconsitency detected - referenced table '" + referencedKeyTableName + "' for FOREIGN KEY " + foreignKeyName + " in table '" + table_name + "'-------------").append("\n");
                            continue;
                        }
                        if (modelForeignKey == null || case_sensitive_sql.booleanValue() && !foreignKeyName.equals(currentForeignKeyName) || !case_sensitive_sql.booleanValue() && !foreignKeyName.equalsIgnoreCase(currentForeignKeyName)) {
                            modelForeignKey = new ForeignKey(table, rs.getString("FK_NAME"), rs.getString("PK_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("FKTABLE_NAME"), rs.getInt("KEY_SEQ"), rs.getString("UPDATE_RULE"), rs.getString("DELETE_RULE"), rs.getString("DEFERRABILITY"), case_sensitive_sql);
                            table.addForeignKey(modelForeignKey);
                        }
                        ReferencedKeyField referencedKeyField = new ReferencedKeyField(rs.getString("FKCOLUMN_NAME"), case_sensitive_sql);
                        ForeignKeyField foreignKeyField = new ForeignKeyField(rs.getString("PKCOLUMN_NAME"), case_sensitive_sql);
                        if (foreignKeyName.equalsIgnoreCase("pur_tender_analysis_fin_items_spec_pur_tender_items_financial_fk")) {
                            // empty if block
                        }
                        modelForeignKey.addForeignFieldReferencedField(foreignKeyField, referencedKeyField);
                        currentForeignKeyName = foreignKeyName;
                    }
                    rs.close();
                }
            }
        }
        long t2 = System.nanoTime();
        generating_time_elements.add("01- Analyze Database Schema Metadata = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        model_enterprise.toString(writer, 0, 4);
        writer.flush();
        t1 = System.nanoTime();
        for (Database database : model_enterprise.databases) {
            boolean level = false;
            shift = 4;
            database.extractTableLogic(true);
        }
        if (write_output.booleanValue()) {
            writer.append("\n");
            for (Database database : model_enterprise.databases) {
                int level = 0;
                shift = 4;
                database.extractTableLogic(true);
                for (Table table : database.tables) {
                    Table tt;
                    ArrayList<Table> tablesPath;
                    int i;
                    writer.append("Table [");
                    writer.append(table.name);
                    writer.append("][Parent Paths]\n");
                    for (i = 0; i < table.parentPaths.size(); ++i) {
                        int x;
                        tablesPath = table.parentPaths.get(i);
                        for (x = 0; x < level * shift; ++x) {
                            writer.append(" ");
                        }
                        writer.append("|");
                        for (x = 0; x < shift - 1; ++x) {
                            writer.append(".");
                        }
                        for (x = 0; x < tablesPath.size(); ++x) {
                            tt = tablesPath.get(x);
                            writer.append(tt.name);
                            writer.append(".");
                        }
                        if (tablesPath.size() > 0) {
                            // empty if block
                        }
                        writer.append("\n");
                    }
                    writer.append("Table [");
                    writer.append(table.name);
                    writer.append("][All Paths]\n");
                    for (i = 0; i < table.paths.size(); ++i) {
                        int x;
                        tablesPath = table.paths.get(i);
                        for (x = 0; x < level * shift; ++x) {
                            writer.append(" ");
                        }
                        writer.append("|");
                        for (x = 0; x < shift - 1; ++x) {
                            writer.append(".");
                        }
                        for (x = 0; x < tablesPath.size(); ++x) {
                            tt = tablesPath.get(x);
                            writer.append(tt.name);
                            writer.append(".");
                        }
                        if (tablesPath.size() > 0) {
                            // empty if block
                        }
                        writer.append("\n");
                    }
                    if (table.cyclicReferencePaths.size() > 0) {
                        writer.append("Table [");
                        writer.append(table.name);
                        writer.append("][Cyclic Reference Paths]\n");
                        for (i = 0; i < table.cyclicReferencePaths.size(); ++i) {
                            int x;
                            tablesPath = table.cyclicReferencePaths.get(i);
                            for (x = 0; x < level * shift; ++x) {
                                writer.append(" ");
                            }
                            writer.append("|");
                            for (x = 0; x < shift - 1; ++x) {
                                writer.append(".");
                            }
                            for (x = 0; x < tablesPath.size(); ++x) {
                                tt = tablesPath.get(x);
                                writer.append(tt.name);
                                writer.append(".");
                            }
                            if (tablesPath.size() > 0) {
                                // empty if block
                            }
                            writer.append("\n");
                        }
                    }
                    writer.append("Table [");
                    writer.append(table.name);
                    writer.append("][All Paths Inner Joined]\n");
                    for (i = 0; i < table.paths.size(); ++i) {
                        tablesPath = table.paths.get(i);
                        String pathString = database.pathToString(tablesPath);
                        writer.append(pathString);
                        writer.append("\n");
                        ArrayList<Table> foundTablesPath = database.findPath(pathString);
                        String foundTablesPathString = database.pathToString(foundTablesPath);
                        writer.append(foundTablesPathString);
                        writer.append("\n");
                        String datasetJSON = database.getInnerJoinedSelect(foundTablesPathString, this.model_database_schem, this.model_database_field_open_quote, this.model_database_field_close_quote).toString();
                        writer.append(datasetJSON);
                        writer.append("\n");
                        writer.append("\n");
                    }
                }
            }
        }
        t2 = System.nanoTime();
        generating_time_elements.add("02- Extract Schema Table Logic = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        t1 = System.nanoTime();
        Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{128}).create();
        gson.toJson((Object)model_enterprise, Enterprise.class, new JsonWriter((Writer)writer));
        t2 = System.nanoTime();
        generating_time_elements.add("03- Printing Json To Writer = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        Integer instance_sequence_type_id = 1;
        String instance_sequence_last_value = "0";
        String model_name = model_database + " - Enterprise Model";
        String model_description = model_database + " - Database Enterprise Model";
        t1 = System.nanoTime();
        DataProcessor<Enterprise> dataProcessor = new DataProcessor<Enterprise>(EnterpriseModel.class, Enterprise.class, this.data_model_source.getDatabaseName(), model_database, this.model_version, model_name, model_description, this.data_lookup_category, this.data_lookup);
        t1 = System.nanoTime();
        this.model_id = dataProcessor.createDatabase(this.data_model_source, this.model_id, source_url, this.model_database_source.getUserName(), this.model_database_source.getUserPassword(), model_url, instance_sequence_type_id, instance_sequence_last_value, this.model_database_schem, this.model_database_field_open_quote, this.model_database_field_close_quote, this.secret_key);
        t2 = System.nanoTime();
        generating_time_elements.add("04- Create Model ID [" + this.model_id + "] Data Class in Database = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        EnterpriseModel<Enterprise> enterprise_model = new EnterpriseModel<Enterprise>(model_enterprise, this.model_version, model_name, model_description);
        dataProcessor.toString(writer, enterprise_model);
        writer.flush();
        t1 = System.nanoTime();
        String data_mysql_database_field_open_quote = "`";
        String data_mysql_database_field_close_quote = "`";
        DataModel<Enterprise> savedModel = dataProcessor.saveNewDataModelToDatabase(writer, this.data_model_source, enterprise_model, data_mysql_database_field_open_quote, data_mysql_database_field_close_quote);
        t2 = System.nanoTime();
        generating_time_elements.add("05- Save Schema To Database = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        t1 = System.nanoTime();
        writer.append("Saved Model").append("\n");
        savedModel.getInstance().toString(writer);
        writer.flush();
        t2 = System.nanoTime();
        generating_time_elements.add("06- Saved Model Schema print out = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms");
        return this.model_id;
    }

    public void loadModel(JDBCSource data_model_source, PrintWriter writer) throws Exception {
        Object timeText = "";
        writer.append("Loaded Models").append("\n");
        long t1 = System.nanoTime();
        DataProcessor dataProcessor = new DataProcessor(EnterpriseModel.class, Enterprise.class, data_model_source.getDatabaseName(), this.model_database_source.getDatabaseName(), this.model_version, this.model_name, this.model_description, this.data_lookup_category, this.data_lookup);
        ArrayList<Integer> modelInstanceIDs = dataProcessor.selectModelInstanceIDsFromDatabase(data_model_source);
        long t2 = System.nanoTime();
        StringBuilder ids = new StringBuilder();
        for (Integer id : modelInstanceIDs) {
            ids.append(id).append(",");
        }
        ids = ids.length() == 0 ? ids : ids.delete(ids.length() - 1, ids.length());
        timeText = (String)timeText + "Select Model Instance IDs [" + ids.toString() + "] From Database = " + TimeUnit.MILLISECONDS.convert(t2 - t1, TimeUnit.NANOSECONDS) + " ms\n";
        for (Integer modelInstanceID : modelInstanceIDs) {
            t1 = System.nanoTime();
            DataClass.LoadMethod loadMethod = DataClass.LoadMethod.REFLECTION;
            EnterpriseModel newEnterpriseModel = (EnterpriseModel)dataProcessor.loadDataModelFromDatabase(data_model_source, modelInstanceID, loadMethod);
            Object loadedEnterprise = newEnterpriseModel.getInstance();
            t2 = System.nanoTime();
            timeText = (String)timeText + "Load [" + this.model_name + "-" + this.model_version + "-" + this.model_database_source.getDatabaseName() + "] DataInstance [" + modelInstanceID + "] From Database = " + (double)(t2 - t1) / 1000000.0 + "\n";
            t1 = System.nanoTime();
            writer.append("Loaded Model [");
            ((Enterprise)newEnterpriseModel.getInstance()).toString(writer, 0, 4);
            writer.append("]\n");
            writer.flush();
            Gson gsonLoaded = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).create();
            String jsonTextLoaded = gsonLoaded.toJson(loadedEnterprise);
            writer.append(jsonTextLoaded).append("\n");
        }
        writer.append("---------------- Time -------------------").append("\n");
        writer.append((CharSequence)timeText).append("\n");
    }

    Object createReportObject(Object object, Class<?> clss) throws Exception {
        Constructor<?> ctor = clss.getConstructor(new Class[0]);
        return ctor.newInstance(new Object[0]);
    }

    void setObjectProperty(Object object, String property, Object value) throws Exception {
        java.lang.reflect.Field declaredField = object.getClass().getDeclaredField(property);
        declaredField.setAccessible(true);
        declaredField.set(object, value);
    }

    public static void deleteDataModel(JDBCSource data_model_source, Integer data_model_id, Integer data_model_instance_id) throws Exception {
        try (Connection data_model_database_connection = data_model_source.getConnection(false);){
            String delete_sql;
            HashMap data_model_instance_map = new HashMap();
            String select_data_model_instance = "SELECT instance_id, data_model_id FROM data_model_instance WHERE data_model_id=?";
            try (PreparedStatement select_data_model_instance_stmt = data_model_database_connection.prepareStatement(select_data_model_instance);){
                select_data_model_instance_stmt.setInt(1, data_model_id);
                ResultSet rs = select_data_model_instance_stmt.executeQuery();
                if (rs.next()) {
                    Integer _data_model_id = rs.getInt("data_model_id");
                    Integer _data_model_instance_id = rs.getInt("instance_id");
                    if (!data_model_instance_map.containsKey(_data_model_id)) {
                        data_model_instance_map.put(_data_model_id, new ArrayList());
                    }
                    ((ArrayList)data_model_instance_map.get(_data_model_id)).add(_data_model_instance_id);
                } else {
                    data_model_instance_map.put(data_model_id, new ArrayList());
                    ((ArrayList)data_model_instance_map.get(data_model_id)).add(0);
                    data_model_instance_id = 0;
                }
            }
            ArrayList<Integer> deleted_instance_list = new ArrayList<Integer>();
            for (Map.Entry data_model_instance_entry : data_model_instance_map.entrySet()) {
                Integer model_id = (Integer)data_model_instance_entry.getKey();
                ArrayList instance_id_list = (ArrayList)data_model_instance_entry.getValue();
                for (Integer instance_id : instance_id_list) {
                    if (!data_model_id.equals(model_id) || !data_model_instance_id.equals(0) && !data_model_instance_id.equals(instance_id)) continue;
                    delete_sql = "DELETE FROM `data`.`referencedkeyfield` WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModelInstance(data_model_database_connection, delete_sql, model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.`foreignkeyfield` WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModelInstance(data_model_database_connection, delete_sql, model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.`foreignkey` WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModelInstance(data_model_database_connection, delete_sql, model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.`primarykeyfield` WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModelInstance(data_model_database_connection, delete_sql, model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.`primarykey` WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModelInstance(data_model_database_connection, delete_sql, model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.`field` WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModelInstance(data_model_database_connection, delete_sql, model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.`childtable` WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModelInstance(data_model_database_connection, delete_sql, model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.`table` WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModelInstance(data_model_database_connection, delete_sql, model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.`database` WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModelInstance(data_model_database_connection, delete_sql, model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.`enterprise` WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModelInstance(data_model_database_connection, delete_sql, model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.data_model_sequence WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModel(data_model_database_connection, delete_sql, data_model_id, instance_id);
                    delete_sql = "DELETE FROM `data`.data_model_instance WHERE data_model_id=? AND instance_id=?";
                    MetadataMiner.deleteDataModel(data_model_database_connection, delete_sql, data_model_id, instance_id);
                    deleted_instance_list.add(instance_id);
                }
            }
            if (data_model_instance_map.size() > 0 && ((ArrayList)data_model_instance_map.get(data_model_id)).size() == deleted_instance_list.size()) {
                delete_sql = "DELETE FROM `data`.data_model WHERE id=?";
                MetadataMiner.deleteDataModel(data_model_database_connection, delete_sql, data_model_id);
            }
            data_model_database_connection.commit();
        }
    }

    public static void deleteDataModelInstance(Connection data_model_source, String delete_sql, Integer data_model_id, Integer data_model_instance_id) throws Exception {
        try (PreparedStatement delete_stmt = data_model_source.prepareStatement(delete_sql);){
            delete_stmt.setInt(1, data_model_id);
            delete_stmt.setInt(2, data_model_instance_id);
            delete_stmt.executeUpdate();
        }
    }

    public static void deleteDataModel(Connection data_source, String delete_sql, Integer data_model_id, Integer data_model_instance_id) throws Exception {
        try (PreparedStatement delete_stmt = data_source.prepareStatement(delete_sql);){
            delete_stmt.setInt(1, data_model_id);
            delete_stmt.setInt(2, data_model_instance_id);
            delete_stmt.executeUpdate();
        }
    }

    public static void deleteDataModel(Connection data_source, String delete_sql, Integer data_model_id) throws Exception {
        try (PreparedStatement delete_stmt = data_source.prepareStatement(delete_sql);){
            delete_stmt.setInt(1, data_model_id);
            delete_stmt.executeUpdate();
        }
    }

    public static void printModelDataStructures(JDBCSource data_model_source, Integer data_model_id, Integer data_model_instance_id, PrintWriter writer, Integer print_styel) throws Exception {
        String select_data_model_instance = "SELECT `name`, `database_servlet_uri`, `java_data_structure_class`, `database_servlet_class`, `typescript_data_structure_class`, `typescript_request_send_response`, `typescript_form_component_ts`, `typescript_form_component_html`, `typescript_table_component_ts`, `typescript_table_component_html`, `http_requests` FROM `data`.`table` WHERE `data_model_id` = ? AND `instance_id` = ?";
        ArrayList<DataStructure> data_structure_list = null;
        try (Connection data_model_database_connection = data_model_source.getConnection(false);
             PreparedStatement select_data_model_instance_stmt = data_model_database_connection.prepareStatement(select_data_model_instance);){
            select_data_model_instance_stmt.setInt(1, data_model_id);
            select_data_model_instance_stmt.setInt(2, data_model_instance_id);
            ResultSet rs = select_data_model_instance_stmt.executeQuery();
            data_structure_list = JsonResultset.resultset(rs, DataStructure.class);
        }
        if (data_structure_list == null) {
            throw new Exception("Data Model id '" + data_model_id + "' instance '" + data_model_instance_id + "' is not exist!");
        }
        if (print_styel == 1) {
            StringBuilder database_servlet_uri = new StringBuilder();
            StringBuilder java_data_structure_class = new StringBuilder();
            StringBuilder database_servlet_class = new StringBuilder();
            StringBuilder typescript_data_structure_class = new StringBuilder();
            StringBuilder typescript_request_send_response = new StringBuilder();
            StringBuilder typescript_form_component_ts = new StringBuilder();
            StringBuilder typescript_form_component_html = new StringBuilder();
            StringBuilder typescript_table_component_ts = new StringBuilder();
            StringBuilder typescript_table_component_html = new StringBuilder();
            StringBuilder http_requests = new StringBuilder();
            for (DataStructure data_structure : data_structure_list) {
                java_data_structure_class.append(nl).append(data_structure.java_data_structure_class).append(nl);
                typescript_data_structure_class.append(nl).append(data_structure.typescript_data_structure_class).append(nl);
                typescript_request_send_response.append(nl).append(data_structure.typescript_request_send_response).append(nl);
                typescript_form_component_ts.append(nl).append(data_structure.typescript_form_component_ts).append(nl);
                typescript_form_component_html.append(nl).append(data_structure.typescript_form_component_html).append(nl);
                typescript_table_component_ts.append(nl).append(data_structure.typescript_table_component_ts).append(nl);
                typescript_table_component_html.append(nl).append(data_structure.typescript_table_component_html).append(nl);
                database_servlet_class.append(nl).append(data_structure.database_servlet_class).append(nl);
                http_requests.append(nl).append(data_separator).append(data_structure.name).append(" - ").append((CharSequence)database_servlet_uri).append(" - HTTP Request").append(data_separator).append(nl).append(nl).append(data_separator).append("http requests").append(data_separator).append(nl).append(data_structure.http_requests).append(nl);
            }
            writer.append("\n\n ***** Java Data Structure Class ******\n\n");
            writer.append(java_data_structure_class);
            writer.append("\n\n ***** Database Servlet Class ******\n\n");
            writer.append(database_servlet_class);
            writer.append("\n\n ***** Typescript Data Structure Class ******\n\n");
            writer.append(typescript_data_structure_class);
            writer.append("\n\n ***** Typescript Request Send Respnonse ******\n\n");
            writer.append(typescript_request_send_response);
            writer.append("\n\n ***** Typescript Form Component .ts ******\n\n");
            writer.append(typescript_form_component_ts);
            writer.append("\n\n ***** Typescript Form Component .html ******\n\n");
            writer.append(typescript_form_component_html);
            writer.append("\n\n ***** Typescript MAT Table Component .ts ******\n\n");
            writer.append(typescript_table_component_ts);
            writer.append("\n\n ***** Typescript MAT Table Component .html ******\n\n");
            writer.append(typescript_table_component_html);
            writer.append("\n\n ***** Http Request ******\n\n");
            writer.append(http_requests);
        } else if (print_styel == 2) {
            for (DataStructure data_structure : data_structure_list) {
                StringBuilder java_data_structure_class = new StringBuilder();
                StringBuilder typescript_data_structure_class = new StringBuilder();
                StringBuilder typescript_request_send_response = new StringBuilder();
                StringBuilder typescript_form_component_ts = new StringBuilder();
                StringBuilder typescript_form_component_html = new StringBuilder();
                StringBuilder typescript_table_component_ts = new StringBuilder();
                StringBuilder typescript_table_component_html = new StringBuilder();
                StringBuilder database_servlet_class = new StringBuilder();
                StringBuilder database_servlet_uri = new StringBuilder();
                StringBuilder http_requests = new StringBuilder();
                java_data_structure_class.append(nl).append(data_structure.java_data_structure_class).append(nl);
                typescript_data_structure_class.append(nl).append(data_structure.typescript_data_structure_class).append(nl);
                typescript_request_send_response.append(nl).append(data_structure.typescript_request_send_response).append(nl);
                typescript_form_component_ts.append(nl).append(data_structure.typescript_form_component_ts).append(nl);
                typescript_form_component_html.append(nl).append(data_structure.typescript_form_component_html).append(nl);
                typescript_table_component_ts.append(nl).append(data_structure.typescript_table_component_ts).append(nl);
                typescript_table_component_html.append(nl).append(data_structure.typescript_table_component_html).append(nl);
                database_servlet_class.append(nl).append(data_structure.database_servlet_class).append(nl);
                http_requests.append(nl).append(data_separator).append("Insert http request").append(data_separator).append(nl).append(data_structure.http_requests).append(nl);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Java Class ******\n\n");
                writer.append(java_data_structure_class);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - ").append(database_servlet_uri).append(" DatabaseServlet Class ******\n\n");
                writer.append(database_servlet_class);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript Class ******\n\n");
                writer.append(typescript_data_structure_class);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript Request Send Respnonse ******\n\n");
                writer.append(typescript_request_send_response);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript Form Component .ts ******\n\n");
                writer.append(typescript_form_component_ts);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript Form Component .html ******\n\n");
                writer.append(typescript_form_component_html);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript MAT Table Component .ts ******\n\n");
                writer.append(typescript_table_component_ts);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - Typescript MAT Table Component .html ******\n\n");
                writer.append(typescript_table_component_html);
                writer.append("\n\n ***** ").append(data_structure.name).append(" - ").append(database_servlet_uri).append(" - HTTP Request ******\n\n");
                writer.append(http_requests);
            }
        }
        writer.append("\n\n ***** Data Structure Print Completed Successfully ***** \n\n");
    }

    public static void main(String[] args) {
        try {
            System.out.println("2019/05/19".matches("((?:19|20)\\d\\d)/(0?[1-9]|1[012])/([12][0-9]|3[01]|0?[1-9])"));
            System.out.println("2019/05/9".matches("((?:19|20)\\d\\d)/(0?[1-9]|1[012])/([12][0-9]|3[01]|0?[1-9])"));
            System.out.println("2019/05/g9".matches("((?:19|20)\\d\\d)/(0?[1-9]|1[012])/([12][0-9]|3[01]|0?[1-9])"));
            System.out.println("2019/05/9g".matches("((?:19|20)\\d\\d)/(0?[1-9]|1[012])/([12][0-9]|3[01]|0?[1-9])"));
            System.out.println("2019/05/g".matches("((?:19|20)\\d\\d)/(0?[1-9]|1[012])/([12][0-9]|3[01]|0?[1-9])"));
            String model_version = "0.0.0.0001";
            String secret_key = "SomeSecretKey";
            final String database_server = "systemhesabat.com:63751";
            final String user_name = "remote";
            final String password = "Z@r#t^o*29l47)y9a4khr0govobiam";
            final String data_model_database = "data";
            final String modelDatabaseServer = "systemhesabat.com:63751";
            final String model_database_user_name = user_name;
            final String model_database_password = password;
            final String model_database = "parental";
            String model_database_schem = "";
            String model_database_field_open_quote = "`";
            String model_database_field_close_quote = "`";
            JDBCSource data_model_source = new JDBCSource(){

                @Override
                public Connection getConnection(Boolean auto_commit) throws Exception {
                    Connection data_model_database_connection = DriverManager.getConnection("jdbc:mysql://" + database_server + "/" + data_model_database, user_name, password);
                    data_model_database_connection.setAutoCommit(auto_commit);
                    return data_model_database_connection;
                }

                @Override
                public String getUserName() throws Exception {
                    return user_name;
                }

                @Override
                public String getUserPassword() throws Exception {
                    return password;
                }

                @Override
                public String getDatabaseEngine() throws Exception {
                    return "mysql";
                }

                @Override
                public String getURL() throws Exception {
                    return "jdbc:mysql://" + database_server + "/" + data_model_database;
                }

                @Override
                public String getDatabaseName() throws Exception {
                    return data_model_database;
                }
            };
            JDBCSource model_database_source = new JDBCSource(){

                @Override
                public Connection getConnection(Boolean auto_commit) throws Exception {
                    Connection model_database_connection = DriverManager.getConnection("jdbc:mysql://" + modelDatabaseServer + "/" + model_database, model_database_user_name, model_database_password);
                    model_database_connection.setAutoCommit(auto_commit);
                    return model_database_connection;
                }

                @Override
                public String getUserName() throws Exception {
                    return user_name;
                }

                @Override
                public String getUserPassword() throws Exception {
                    return password;
                }

                @Override
                public String getDatabaseEngine() throws Exception {
                    return "mysql";
                }

                @Override
                public String getURL() throws Exception {
                    return "jdbc:mysql://" + modelDatabaseServer + "/" + model_database;
                }

                @Override
                public String getDatabaseName() throws Exception {
                    return model_database;
                }
            };
            String java_package_name = "com.systemhesabat.business.process";
            String data_lookup_category = "MySQL Data Type";
            JsonArray generating_time_elements = new JsonArray();
            Integer model_id = 80;
            if (model_id != -1) {
                MetadataMiner.deleteDataModel(data_model_source, model_id, (Integer)0);
            }
            ArrayList<String> table_list = null;
            PrintWriter writer = new PrintWriter(System.out, true, StandardCharsets.UTF_8);
            MetadataMiner databaseMetadata = new MetadataMiner(model_id, java_package_name, data_model_source, model_database_source, table_list, data_lookup_category, model_version, model_database_schem, model_database_field_open_quote, model_database_field_close_quote, secret_key);
            model_id = databaseMetadata.generateModel(writer, generating_time_elements);
            databaseMetadata.loadModel(data_model_source, writer);
            MetadataMiner.printModelDataStructures(data_model_source, model_id, 1, writer, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (Exception exx) {
                exx.printStackTrace();
            }
        }
    }
}

