/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.reyadeyat.relational.api.annotation.DontJsonAnnotation;
import net.reyadeyat.relational.api.data.DataLookup;
import net.reyadeyat.relational.api.json.JsonUtil;
import net.reyadeyat.relational.api.model.ChildTable;
import net.reyadeyat.relational.api.model.Database;
import net.reyadeyat.relational.api.model.Field;
import net.reyadeyat.relational.api.model.ForeignKey;
import net.reyadeyat.relational.api.model.ForeignKeyField;
import net.reyadeyat.relational.api.model.PrimaryKey;
import net.reyadeyat.relational.api.model.PrimaryKeyField;
import net.reyadeyat.relational.api.model.ReferencedKeyField;
import net.reyadeyat.relational.api.util.StringUtil;

public class Table {
    public String name;
    public Integer rows;
    @DontJsonAnnotation
    public transient String java_data_structure_class;
    @DontJsonAnnotation
    public transient String typescript_data_structure_class;
    @DontJsonAnnotation
    public transient String typescript_request_send_response;
    @DontJsonAnnotation
    public transient String typescript_form_component_ts;
    @DontJsonAnnotation
    public transient String typescript_form_component_html;
    @DontJsonAnnotation
    public transient String typescript_table_component_ts;
    @DontJsonAnnotation
    public transient String typescript_table_component_html;
    @DontJsonAnnotation
    public transient String http_requests;
    @DontJsonAnnotation
    public transient String database_servlet_class;
    @DontJsonAnnotation
    public transient String database_servlet_uri;
    public ArrayList<Field> fields = new ArrayList();
    public ArrayList<PrimaryKey> primaryKeys = new ArrayList();
    public ArrayList<ForeignKey> foreignKeys = new ArrayList();
    public ArrayList<ChildTable> childTables = new ArrayList();
    public transient Boolean caseSensitiveSql;
    public transient Database database;
    public transient ArrayList<ArrayList<Table>> paths = new ArrayList();
    public transient ArrayList<ArrayList<Table>> parentPaths = new ArrayList();
    public transient ArrayList<ArrayList<Table>> cyclicReferencePaths = new ArrayList();
    public transient TreeMap<String, Field> field_map = new TreeMap();
    private transient DataLookup data_lookup;
    private static transient ArrayList<String> lang_suffix_list = new ArrayList<String>(Arrays.asList("_ar", "_en"));
    private static transient String nl = "\n";
    private static transient String servlet_class = "package $PACKAGE_NAME;\n\nimport com.systemhesabat.database.FieldType;\nimport com.systemhesabat.servlet.DatabaseServlet;\nimport jakarta.servlet.annotation.WebServlet;\n\n/**\n *\n * @author Mohammad Nabil Mostafa\n * <a href=\"mailto:m.nabil@systemhesabat.net\">m.nabil@systemhesabat.net</a>\n */\n@WebServlet(\"$SERVLET_CONTEXT\")\npublic class $CLASS_NAME extends DatabaseServlet {\n    \n    @Override\n    protected void doInit() throws Exception {\n        defineServlet(\"$CLASS_NAME_SPACED\", \"$DATA_SOURCE_NAME\", \"$DATABASE_NAME\", \"$TABLE_NAME\");//, true, false);\n        defineTransactions(\"insert\", \"select\", \"update\", \"delete\");\n        $FIELDS\n        $FOREIGN_KEYS\n    }\n}";
    private static transient String java_class_header = "package $PACKAGE_NAME;\n\n/**\n *\n * @author Mohammad Nabil Mostafa\n * <a href=\"mailto:m.nabil@systemhesabat.net\">m.nabil@systemhesabat.net</a>\n */\n";
    private static transient String field_method = "addField(\"$FIELD_ALIAS\", FieldType.$FIELD_TYPE, $FIELD_NULLABLE, false, \"$FIELD_NAME\")";
    private static transient String foreign_key_method = "addForeignKey(\"$FOREIGN_KEY_NAME\", \"$TABLE_FIELD_NAME\", \"$REFERENCE_TABLE_NAME\", \"$REFERENCE_TABLE_FIELD_NAME\")";
    private static transient String insert_request = "{\"transaction\": \"insert\",\"values\": [],\"parameters\":[]}";
    private static transient String select_request = "{\"transaction\":\"select\",\"engine\":\"memory\",\"view\":\"object\",\"select\":[],\"where\":{\"clause\":\"\", \"values\":[]},\"orderby\":[]}";
    private static transient String update_request = "{\"transaction\":\"update\",\"values\":[],\"where\":{\"clause\":\"\", \"fields\":[]},\"parameters\":[]}";
    private static transient String delete_request = "{\"transaction\":\"delete\",\"values\":[],\"where\":{\"clause\":\"\", \"fields\":[]}}";
    private static transient String request_send_response = "\tinsert$TABLE_CLASS($TABLE_NAME: $TABLE_CLASS[]) {\n\t\tthis.insert_$TABLE_NAME_record_list.push($TABLE_NAME);\n\t\tlet servlet_url: string = Constants.tariff_url + \"/$TABLE_NAME\";\n\t\tlet http_headers: HttpHeaders = new HttpHeaders();\n\t\thttp_headers.set(\"Content-Type\", \"application/json; charset=UTF-8\");\n\t\tlet http_parameters: HttpParams = new HttpParams();\n\t\t//http_parameters.set(\"\", \"\");\n\t\tconst request: DBInsert = <DBInsert><unknown>{\n\t\t\ttransaction: \"insert\",\n\t\t\tvalues: [\n\t\t\t\t{\n$INSERT_UPDATE_DELETE_FIELDS\n\t\t\t\t}\n\t\t\t],\n\t\t\tparameters: []\n\t\t}\n\t\tthis.sendPost(this, \"insert_$TABLE_NAME\", servlet_url, request, http_headers, http_parameters);\n\t}\n\n\tselect$TABLE_CLASS($TABLE_NAME: $TABLE_CLASS[]) {\n\t\tlet servlet_url: string = Constants.tariff_url + \"/$TABLE_NAME\";\n\t\tlet http_headers: HttpHeaders = new HttpHeaders();\n\t\thttp_headers.set(\"Content-Type\", \"application/json; charset=UTF-8\");\n\t\tlet http_parameters: HttpParams = new HttpParams();\n\t\t//http_parameters.set(\"\", \"\");\n\t\tconst request: DBSelect = {\n\t\t\ttransaction: \"select\",\n\t\t\tengine: \"memory\",\n\t\t\tview: \"object\",\n\t\t\tselect: [\n$SELECT_FIELDS\n\t\t\t],\n\t\t\twhere: {\n\t\t\t\tclause: \"\",\n\t\t\t\tvalues: []\n\t\t\t},\n\t\t\torderby: []\n\t\t}\n\t\tthis.sendPost(this, \"select_$TABLE_NAME\", servlet_url, request, http_headers, http_parameters);\n\t}\n\n\tupdate$TABLE_CLASS($TABLE_NAME: $TABLE_CLASS[]) {\n\t\tlet servlet_url: string = Constants.tariff_url + \"/$TABLE_NAME\";\n\t\tlet http_headers: HttpHeaders = new HttpHeaders();\n\t\thttp_headers.set(\"Content-Type\", \"application/json; charset=UTF-8\");\n\t\tlet http_parameters: HttpParams = new HttpParams();\n\t\t//http_parameters.set(\"\", \"\");\n\t\tconst request: DBUpdate = <DBUpdate><unknown>{\n\t\t\ttransaction: \"update\",\n\t\t\treturns: 'id',\n\t\t\t//variable?: {};\n\t\t\tvalues: [\n\t\t\t\t{\n$INSERT_UPDATE_DELETE_FIELDS\n\t\t\t\t}\n\t\t\t],\n\t\t\twhere: {\n\t\t\t\tclause: \"\",\n\t\t\t\tfields: [\n\t\t\t\t\t\n\t\t\t\t]\n\t\t\t},\n\t\t\tparameters: {}\n\t\t}\n\t\tthis.sendPost(this, \"update_$TABLE_NAME\", servlet_url, request, http_headers, http_parameters);\n\t}\n\n\tdelete$TABLE_CLASS($TABLE_NAME: $TABLE_CLASS[]) {\n\t\tlet servlet_url: string = Constants.tariff_url + \"/$TABLE_NAME\";\n\t\tlet http_headers: HttpHeaders = new HttpHeaders();\n\t\thttp_headers.set(\"Content-Type\", \"application/json; charset=UTF-8\");\n\t\tlet http_parameters: HttpParams = new HttpParams();\n\t\t//http_parameters.set(\"\", \"\");\n\t\tconst request: DBUpdate = <DBUpdate><unknown>{\n\t\t\ttransaction: \"delete\",\n\t\t\tvalues: [\n\t\t\t\t{\n$INSERT_UPDATE_DELETE_FIELDS\n\t\t\t\t}\n\t\t\t],\n\t\t\twhere: {\n\t\t\t  clause: \"\",\n\t\t\t  fields: [\n\t\t\t\t\n\t\t\t  ]\n\t\t\t}\n\t\t}\n\t\tthis.sendPost(this, \"delete_$TABLE_NAME\", servlet_url, request, http_headers, http_parameters);\n\t}\n\n\t$TABLE_NAME_list: $TABLE_CLASS[] = [];\n\tselected_$TABLE_NAME_option: $TABLE_CLASS;\n\tselected_$TABLE_NAME_record: $TABLE_CLASS;\n\n\tinsert_$TABLE_NAME_record_list: $TABLE_CLASS[] = [];\n\tupdate_$TABLE_NAME_record_list: $TABLE_CLASS[] = [];\n\tdelete_$TABLE_NAME_record_list: $TABLE_CLASS[] = [];\n\n\t//selected_$TABLE_NAME_list_icon: any = blank_icon;\n\t\n\t} else if (key === \"insert_$TABLE_NAME\") {\n\t\t//let resultset: any[] = response.resultset;\n\t\t//let resultset: any = response.resultset;\n\t\t//let generated_id: any = response.generated_id;\n\t\tthis.resetForm();\n\t\tfor (let i: number = 0; i < this.insert_$TABLE_NAME_record_list.length; i++) {\n\t\t\tthis.$TABLE_NAME_list.push(this.insert_$TABLE_NAME_record_list[i]);\n\t\t}\n\t\tthis.insert_$TABLE_NAME_record_list = [];\n\t\tthis.$TABLE_NAME_table_data_source.data = this.$TABLE_NAME_list;\n\t\t//this.snackbar.open(this.i18.insert_success, \"x\", {duration: 5 * 1000});\n\t} else if (key === \"select_$TABLE_NAME\") {\n\t\tlet resultset: any[] = response.resultset;\n\t\tthis.$TABLE_NAME_list = [];\n\t\tfor (let i: number = 0; resultset != null && i < resultset.length; i++) {\n\t\t\tthis.$TABLE_NAME_list.push($TABLE_CLASS.fromJSON(resultset[i]));\n\t\t\t//Manipulate.loadImage(this.$TABLE_NAME_list[i].$TABLE_NAME_icon);\n\t\t}\n\n\t\tthis.$TABLE_NAME_table_data_source.data = this.$TABLE_NAME_list;\n\t\t//this.snackbar.open(this.i18.select_success, \"x\", {duration: 5 * 1000});\n\t} else if (key === \"update_$TABLE_NAME\") {\n\t\t//this.snackbar.open(this.i18.update_success, \"x\", {duration: 5 * 1000});\n\t} else if (key === \"delete_$TABLE_NAME\") {\n\t\t//this.snackbar.open(this.i18.delete_success, \"x\", {duration: 5 * 1000});\n\t}\n\n";
    private static transient String typescript_form_field_control_class_members = "$FIELD_NAME_control: FormControl;";
    private static transient String typescript_form_foreign_field_control_class_members = "$FOREIGN_FIELD_NAME_list_control: FormControl;";
    private static transient String typescript_form_foreign_field_array_class_members = "$FOREIGN_FIELD_NAME_array_control: FormArray;";
    private static transient String typescript_form_field_control_definition = "this.$FIELD_NAME_control = new FormControl([]);";
    private static transient String typescript_form_foreign_field_control_definition = "this.$FOREIGN_FIELD_NAME_list_control = new FormControl([]);";
    private static transient String typescript_form_foreign_field_array_definition = "this.$FOREIGN_FIELD_NAME_array_control = new FormArray([]);";
    private static transient String typescript_form_field_control = "$FIELD_NAME: this.$FIELD_NAME_control,";
    private static transient String typescript_form_foreign_field_control = "$FOREIGN_FIELD_NAME_check_list: this.$FOREIGN_FIELD_NAME_array_control,";
    private static transient String form_component_ts = "\t$TABLE_NAME_form: FormGroup;\n$TYPESCRIPT_FORM_FIELD_CONTROL_CLASS_MEMBERS\n\n$TYPESCRIPT_FORM_FOREIGN_FIELD_CONTROL_CLASS_MEMBERS\n\n$TYPESCRIPT_FORM_FOREIGN_FIELD_ARRAY_CLASS_MEMBERS\n\n\tconstructor() {\n\n$TYPESCRIPT_FORM_FIELD_CONTROL_DEFINITION\n$TYPESCRIPT_FORM_FOREIGN_FIELD_CONTROL_DEFINITION\n$TYPESCRIPT_FORM_FOREIGN_FIELD_CONTROL_DEFINITION\n\n$TYPESCRIPT_FORM_FOREIGN_FIELD_ARRAY_DEFINITION\n\n\n\tthis.$TABLE_NAME_form = form_builder.group({\n\t\t$TABLE_NAME_group: form_builder.group({\n$TYPESCRIPT_FORM_FIELD_CONTROL\n$TYPESCRIPT_FORM_FOREIGN_FIELD_CONTROL\n\t\t}),\n\t},\n\t//{ validators: passwordMatchValidator, asyncValidators: otherValidator }\n\t);\n\t}\n\n\tsetSelected$TABLE_CLASSRecord(selected_$TABLE_NAME_record: $TABLE_CLASS) {\n\t\tthis.selected_$TABLE_NAME_record = selected_$TABLE_NAME_record;\n\t}\n\t\n\tngOnChanges(changes: SimpleChanges): void {\n\t\n$TYPESCRIPT_FORM_FOREIGN_FIELD_CHECK_BOX\n\t\n\t}";
    private static transient String typescript_form_foreign_field_check_box = "\t\tthis.$FOREIGN_TABLE_NAME_list.forEach( ($FOREIGN_TABLE_NAME: $FOREIGN_TABLE_CLASS) => {\n\t\t\t$FOREIGN_TABLE_NAME.is_checked = false;\n\t\t\tlet $FOREIGN_TABLE_NAME_control: FormControl = new FormControl($FOREIGN_TABLE_NAME);\n\t\t\t$FOREIGN_TABLE_NAME_control.['option_value'] = $FOREIGN_TABLE_NAME;\n\t\t\t$FOREIGN_TABLE_NAME_control.setValue($FOREIGN_TABLE_NAME_control['option_value']);\n\t\t\tthis.$FOREIGN_TABLE_NAME_array_control.push($FOREIGN_TABLE_NAME_control);\n\t\t});";
    private static transient String form_component_html = "<div class=\"container\">\n    <p class=\"card\">{{i18.$TABLE_NAME.title')}}</p>\n<ng-container *ngIf=\"show_confirmation==false\">\n<form class=\"form yes-mouse\" [formGroup]=\"$TABLE_NAME_form\" [dir]=\"direction\">\n\t<div role=\"group\" formGroupName=\"$TABLE_NAME_group\" [hidden]=\"false\" [dir]=\"direction\">\n\t\t<div class=\"form-group\" [dir]=\"direction\">\n\t\t\n$TYPESCRIPT_FORM_FIELD_HTML_TEXT_BOX_CONTROL\n\t\t\t\n$TYPESCRIPT_FORM_FIELD_HTML_DATE_BOX_CONTROL\n\t\t\n$TYPESCRIPT_FORM_FOREIGN_FIELD_HTML_CHECK_BOX_CONTROL\n\t\t\t\n$TYPESCRIPT_FORM_FOREIGN_FIELD_HTML_LIST_BOX_CONTROL\n\t\t\t\n        </div>\n\t</div>\n</form>\n<div class=\"tool-box\" [dir]=\"direction\">{{'Controls - ' + i18.$TABLE_CLASS.title}}</div>\n<div class=\"form-group yes-mouse\" [dir]=\"direction\">\n<div class=\"tool-box yes-mouse\" [dir]=\"direction\">\n\t<!--{{'Controls - ' + i18.$TABLE_CLASS.title}}-->\n\t<img *ngIf=\"selected_$TABLE_NAME_record.record_state == null\" src=\"{{ICON.blank_icon}}\" (error)=\"ICON.blank_icon\" class=\"icon\" />\n\t<img *ngIf=\"selected_$TABLE_NAME_record.record_state == INSERT\" src=\"{{ICON.insert_record_icon}}\" (error)=\"ICON.blank_icon\" class=\"icon\" />\n\t<img *ngIf=\"selected_$TABLE_NAME_record.record_state == SELECT\" src=\"{{ICON.true_icon}}\" (error)=\"ICON.blank_icon\" class=\"icon\" />\n\t<img *ngIf=\"selected_$TABLE_NAME_record.record_state == UPDATE\" src=\"{{ICON.update_record_icon}}\" (error)=\"ICON.blank_icon\" class=\"icon\" />\n\t<img *ngIf=\"selected_$TABLE_NAME_record.record_state == DELETE\" src=\"{{ICON.delete_record_icon}}\" (error)=\"ICON.blank_icon\" class=\"icon\" />\n\t<button class=\"tool-box-button-pushable yes-mouse\" matTooltip=\"{{i18.first_record}}\" [disabled]=\"cursor == 0\" (click)=\"firstRecord()\">\n\t\t<span class=\"tool-box-button-front\" [dir]=\"direction\">\n\t\t\t{{ i18.first }}\n\t\t</span>\n\t</button>\n\t<button class=\"tool-box-button-pushable yes-mouse\" matTooltip=\"{{i18.previous_record}}\" [disabled]=\"cursor == 0\" (click)=\"previousRecord()\">\n\t\t<span class=\"tool-box-button-front\" [dir]=\"direction\">\n\t\t\t{{ i18.previous }}\n\t\t</span>\n\t</button>\n\t<button class=\"tool-box-button-pushable yes-mouse\" matTooltip=\"{{i18.next_record}}\" [disabled]=\"cursor == this.$TABLE_NAME_list.length-1\" (click)=\"nextRecord()\">\n\t\t<span class=\"tool-box-button-front\" [dir]=\"direction\">\n\t\t\t{{ i18.next }}\n\t\t</span>\n\t</button>\n\t<button class=\"tool-box-button-pushable yes-mouse\" matTooltip=\"{{i18.last_record}}\" [disabled]=\"cursor == this.$TABLE_NAME_list.length-1\" (click)=\"lastRecord()\">\n\t\t<span class=\"tool-box-button-front\" [dir]=\"direction\">\n\t\t\t{{ i18.last }}\n\t\t</span>\n\t</button>\n</div>\n<div class=\"form-group yes-mouse\" [dir]=\"direction\">\n\t<button class=\"pushable-blue\" (click)=\"submitForm()\">\n\t\t<span class=\"front-blue\" [dir]=\"direction\">\n\t\t\t{{ i18.submit }}\n\t\t</span>\n\t</button>\n\t<button class=\"pushable-red\" (click)=\"resetForm()\">\n\t\t<span class=\"front-red\" [dir]=\"direction\">\n\t\t\t{{ i18.reset }}\n\t\t</span>\n\t</button>\n</div></ng-container>\n    <confirmation-component *ngIf=\"show_confirmation==true\" (onConfirmationAcknowledged)=\"confirmationAcknowledged($event)\"></confirmation-component>\n</div>\n";
    private static transient String typescript_form_field_html_text_box_control = "\t\t\t<!-- Text Box $FIELD_NAME -->\n\t\t\t<mat-form-field [appearance]=\"outline\" [dir]=\"direction\">\n\t\t\t\t<input formControlName=\"$FIELD_NAME\" matInput type=\"$FIELD_HTML_TYPE\"\n\t\t\t\t\tplaceholder=\"{{i18.$TABLE_NAME.$FIELD_NAME}}\"\n\t\t\t\t\trequired=\"$FIELD_IS_NOT_NULL\" $PRIMARY_KEY_TEXT_BOX \n\t\t\t\t\t[ngClass]=\"{ 'is-invalid': isValidFieldValue('$TABLE_NAME_group.$FIELD_NAME') === false }\" />\n\t\t\t\t<div *ngIf=\"isModified('$TABLE_NAME_group.$FIELD_NAME') && isValid('$TABLE_NAME_group.$FIELD_NAME') === false\" class=\"alert alert-danger\">\n\t\t\t\t\t<ng-container *ngFor=\"let field_error of getFieldErrors('$TABLE_NAME_group.$FIELD_NAME')\">\n\t\t\t\t\t\t<div class=\"warning\">{{field_error.error_message[lang]}}></div>\n\t\t\t\t\t<ng-container>\n\t\t\t\t</div>\n\t\t\t</mat-form-field>\n";
    private static transient String typescript_form_field_html_date_box_control = "\t\t\t<!-- Date Box $FIELD_NAME -->\n\t\t\t<mat-form-field [appearance]=\"outline\" [dir]=\"direction\">\n\t\t\t\t<mat-label>{{i18.$TABLE_NAME.$FIELD_NAME}}</mat-label>\n\t\t\t\t<input formControlName=\"$FIELD_NAME\" matInput [matDatepicker]=\"datepicker\" placeholder=\"{{ i18.$TABLE_NAME.$FIELD_NAME }}\">\n\t\t\t\t<mat-datepicker-toggle matPrefix [for]=\"datepicker\"></mat-datepicker-toggle>\n\t\t\t\t<mat-datepicker #datepicker></mat-datepicker>\n\t\t\t</mat-form-field>\n";
    private static transient String typescript_form_foreign_field_html_check_box_control = "\t\t\t<!-- $FOREIGN_FIELD_NAME_list -->\n\t\t\t<ng-container formArrayName=\"$FOREIGN_FIELD_NAME_list\">\n\t\t\t  <div>\n\t\t\t\t<span>\n\t\t\t\t  <mat-checkbox [checked]=\"isAllListChecked($FOREIGN_FIELD_NAME_check_list)\" [color]=\"primary\"\n\t\t\t\t\t[indeterminate]=\"isIndeterminate($FOREIGN_FIELD_NAME_list)\"\n\t\t\t\t\t(change)=\"selectAllList($event, $FOREIGN_FIELD_NAME_list)\">\n\t\t\t\t\t<img src=\"{{$FOREIGN_FIELD_NAME_icon}}\" class=\"icon\" />\n\t\t\t\t\t{{ i18.$FOREIGN_FIELD_NAME }}\n\t\t\t\t  </mat-checkbox>\n\t\t\t\t</span>\n\t\t\t  </div>\n\t\t\t  <div *ngFor=\"let $FOREIGN_FIELD_NAME_control of $FOREIGN_FIELD_NAME_array_control.controls; let i=index\">\n\t\t\t\t<span>\n\t\t\t\t  <mat-checkbox class=\"margin\" [formControl]=\"$FOREIGN_FIELD_NAME_control\"\n\t\t\t\t\t[color]=\"primary\" [(ngModel)]=\"$FOREIGN_FIELD_NAME_list[i].is_checked\">\n\t\t\t\t\t<img class=\"icon\" src=\"{{$FOREIGN_FIELD_NAME_list[i].advertising_method_icon}}\" (error)=\"onImageError($event)\">\n\t\t\t\t\t{{$FOREIGN_FIELD_NAME_list[i].advertising_method_name_i18[lang]}}\n\t\t\t\t  </mat-checkbox>\n\t\t\t\t</span>\n\t\t\t  </div>\n\t\t\t</ng-container>\n";
    private static transient String typescript_form_foreign_field_html_list_box_control = "\t\t\t<!-- $FOREIGN_FIELD_NAME List Box -->\n\t\t\t<mat-form-field [appearance]=\"outline\" [dir]=\"direction\">\n\t\t\t\t<mat-label>{{ i18.$FOREIGN_FIELD_NAME }}</mat-label>\n\t\t\t\t\t<span matPrefix [style.display]=\"'flex'\">\n\t\t\t\t\t<img src=\"{{selected_$FOREIGN_TABLE_NAME_list_icon}}\" class=\"icon\" />\n\t\t\t\t</span>\n\t\t\t\t<mat-select formControlName=\"$FOREIGN_FIELD_NAME_list_option\" (selectionChange)=\"onChange$FOREIGN_TABLE_CLASS($event)\">\n\t\t\t\t\t<mat-option *ngFor=\"let option of $FOREIGN_TABLE_NAME_list\" [value]=\"option\">\n\t\t\t\t\t<span><img class=\"icon\" src=\"{{option.$FOREIGN_TABLE_NAME_icon}}\"\n\t\t\t\t\t(error)=\"onImageError($event)\">{{option.$FOREIGN_TABLE_NAME_name_i18[lang]}}</span>\n\t\t\t\t\t</mat-option>\n\t\t\t\t</mat-select>\n\t\t\t</mat-form-field>\n";
    private static transient String table_component_ts = "\t$TABLE_NAME_table_data_source: MatTableDataSource<$TABLE_CLASS>;\n\t$TABLE_NAME_table_columns: string[] = [\n$FIELD_LIST\n$FOREIGN_FIELD_LIST\n\t\t\"select_record\",\n\t\t\"delete_record\"\t];\n\t\n\t\n\tconstructor() {\n\t\tthis.$TABLE_NAME_list = [];\n\t\tthis.$TABLE_NAME_table_data_source = new MatTableDataSource(this.$TABLE_NAME_list);\n\t\tthis.$TABLE_NAME_table_data_source.data = this.$TABLE_NAME_list;\n\t}\n\t\n\t\n";
    private static transient String table_component_html = "<mat-table class=\"just-table mat-elevation-z8\" [dataSource]=\"$TABLE_NAME_table_data_source\" [dir]=\"direction\">\n\n$TYPESCRIPT_TABLE_FIELD_HTML_PRIMARY_KEY_ICON_CONTROL\n\t\n$TYPESCRIPT_TABLE_FIELD_HTML_I18_CONTROL\n\n$TYPESCRIPT_TABLE_FOREIGN_FIELD_HTML_I18_CONTROL\n\t\n\t<!-- extra controls -->\n\t<ng-container matColumnDef=\"select_record\">\n\t\t<mat-header-cell *matHeaderCellDef class=\"table-nice-back-blue\">{{i18.select_record}}</mat-header-cell>\n\t\t\t<mat-cell *matCellDef=\"let $TABLE_NAME_record;\">\n\t\t\t\t<button mat-raised-button color=\"nice-green\" class=\"yes-mouse\" (click)=\"selectRecord($TABLE_NAME_record)\">\n\t\t\t\t\t<mat-icon>content_copy</mat-icon>\n\t\t\t\t</button>\n\t\t</mat-cell>\n\t</ng-container>\n\t<ng-container matColumnDef=\"delete_record\">\n\t\t<mat-header-cell *matHeaderCellDef class=\"table-nice-back-blue\">{{i18.delete_record}}</mat-header-cell>\n\t\t\t<mat-cell *matCellDef=\"let $TABLE_NAME_record;\">\n\t\t\t\t<button mat-raised-button color=\"nice-green\" class=\"yes-mouse\" (click)=\"deleteRecord($TABLE_NAME_record)\">\n\t\t\t\t\t<mat-icon>delete</mat-icon>\n\t\t\t\t</button>\n\t\t</mat-cell>\n\t</ng-container>\n\n\t<mat-header-row *matHeaderRowDef=\"$TABLE_NAME_table_columns\">\n\t</mat-header-row>\n\t<mat-row *matRowDef=\"let $TABLE_NAME_record; columns: $TABLE_NAME_table_columns\"></mat-row>\n</mat-table>";
    private static transient String typescript_table_field_html_primary_key_icon_control = "\t<!-- Table Field $FIELD_NAME with _name_LANG -->\n\t<ng-container matColumnDef=\"$FIELD_NAME\">\n\t\t<mat-header-cell *matHeaderCellDef class=\"table-nice-back-blue\">{{i18.$TABLE_CLASS.$FIELD_NAME}}</mat-header-cell>\n\t\t<mat-cell *matCellDef=\"let $TABLE_NAME_record;\">\n\t\t\t<img src=\"{{$TABLE_NAME_record.$TABLE_NAME_icon}}\" class=\"icon\" />\n\t\t\t{{$TABLE_NAME_record.$TABLE_NAME_name_i18[lang]}}\n\t\t</mat-cell>\n\t</ng-container>\n";
    private static transient String typescript_table_field_html_i18_control = "\t<!-- Table -Field $FIELD_NAME -->\n\t<ng-container matColumnDef=\"$TABLE_NAME_name_i18\">\n\t\t<mat-header-cell *matHeaderCellDef class=\"table-nice-back-blue\">{{i18.$TABLE_CLASS.$TABLE_NAME_name_i18}}</mat-header-cell>\n\t\t<mat-cell *matCellDef=\"let $TABLE_NAME_record;\">\n\t\t\t{{$TABLE_NAME_record.$TABLE_NAME_name_i18[lang]}}\n\t\t</mat-cell>\n\t</ng-container>\n";
    private static transient String typescript_table_foreign_field_html_i18_control = "\t<!-- Table ~Field $FOREIGN_FIELD_NAME with _name_LANG -->\n\t<ng-container matColumnDef=\"$FOREIGN_FIELD_NAME\">\n\t\t<mat-header-cell *matHeaderCellDef class=\"table-nice-back-blue\">{{i18.$FOREIGN_TABLE_CLASS.$FOREIGN_FIELD_NAME}}</mat-header-cell>\n\t\t<mat-cell *matCellDef=\"let $TABLE_NAME_record;\">\n\t\t\t<img src=\"{{$TABLE_NAME_record.$FOREIGN_TABLE_NAME.$FOREIGN_TABLE_NAME_icon}}\" class=\"icon\" />\n\t\t\t{{$TABLE_NAME_record.$FOREIGN_TABLE_NAME.$FOREIGN_TABLE_NAME_name_i18[lang]}}\n\t\t</mat-cell>\n\t</ng-container>\n";

    public Table() {
    }

    public Table(String name, Boolean caseSensitiveSql, Integer rows, DataLookup data_lookup) {
        this();
        this.name = name;
        this.rows = rows;
        this.caseSensitiveSql = caseSensitiveSql;
        this.data_lookup = data_lookup;
    }

    public void init() {
        for (Field field : this.fields) {
            field.init();
            this.field_map.put(field.name, field);
        }
    }

    public void addField(Field field) throws Exception {
        field.table = this;
        this.fields.add(field);
    }

    public void addPrimaryKey(PrimaryKey primaryKey) throws Exception {
        primaryKey.table = this;
        this.primaryKeys.add(primaryKey);
        for (Field field : this.fields) {
            for (PrimaryKeyField primary_key_field : primaryKey.primaryKeyFields) {
                if (!field.name.equalsIgnoreCase(primary_key_field.name)) continue;
                field.setPrimaryKey();
            }
        }
    }

    public void addForeignKey(ForeignKey foreignKey) throws Exception {
        foreignKey.table = this;
        this.foreignKeys.add(foreignKey);
        String referencedKeyTableName = new String(foreignKey.referencedKeyTableName);
        Table parentTable = this.database.tables.stream().filter(o -> o.name.equals(referencedKeyTableName)).findAny().orElse(null);
        ChildTable childTable = new ChildTable(parentTable, this, foreignKey, parentTable.name, this.name, foreignKey.name, this.caseSensitiveSql);
        parentTable.addChildTable(childTable);
    }

    public void addChildTable(ChildTable childTable) {
        childTable.parentTable = this;
        this.childTables.add(childTable);
    }

    public void updateModel() throws Exception {
        StringBuilder java_data_structure_class = new StringBuilder();
        StringBuilder typescript_data_structure_class = new StringBuilder();
        StringBuilder database_servlet_class = new StringBuilder(servlet_class);
        String class_name = this.getModelClassName(this.name, false);
        String class_name_spaced = this.getModelClassName(this.name, true);
        this.generateJavaDataStructureClass(class_name);
        this.generateTypescriptDataStructureClass(class_name);
        this.generateTypescriptFormComponent(class_name);
        this.generateDatabaseServletClass(class_name, class_name_spaced);
        Gson gson = JsonUtil.gsonPretty();
        this.generateHttpRequests(gson);
        JsonUtil.reclaimGsonPretty(gson);
    }

    private void generateJavaDataStructureClass(String class_name) throws Exception {
        StringBuilder java_data_structure_class = new StringBuilder(java_class_header);
        StringBuilder java_data_structure_class_constructor_arguments = new StringBuilder();
        StringBuilder java_data_structure_class_constructor_method = new StringBuilder();
        this.replace(java_data_structure_class, "$PACKAGE_NAME", this.database.java_package_name);
        java_data_structure_class.append("public class ").append(class_name).append(" {\n");
        for (Field field : this.fields) {
            String java_datatype = this.data_lookup.lookupJavaDataType(field.dataTypeName);
            java_data_structure_class.append("    public ").append(java_datatype).append(" ").append(field.name).append(";\n");
            java_data_structure_class_constructor_arguments.append("\n        ").append(java_datatype).append(" ").append(field.name).append(",");
            java_data_structure_class_constructor_method.append("        this.").append(field.name).append(" = ").append(field.name).append(";\n");
        }
        for (ForeignKey foreign_key : this.foreignKeys) {
            for (Map.Entry<ForeignKeyField, ReferencedKeyField> entry : foreign_key.foreign_key_referenced_key_map.entrySet()) {
                ForeignKeyField foreignKeyField = entry.getKey();
                ReferencedKeyField referencedKeyField = entry.getValue();
                String foreign_table_name = foreign_key.referencedKeyTableName;
                String foreign_class_name = this.getModelClassName(foreign_key.referencedKeyTableName, false);
                String var_name = this.getModelClassVariableName(foreign_class_name);
                java_data_structure_class.append("    public ").append(foreign_class_name).append(" ").append(var_name).append(";\n");
                java_data_structure_class_constructor_arguments.append("\n        ").append(foreign_class_name).append(" ").append(var_name).append(",");
                java_data_structure_class_constructor_method.append("        this.").append(var_name).append(" = ").append(var_name).append(";\n");
            }
        }
        java_data_structure_class_constructor_arguments = java_data_structure_class_constructor_arguments.length() > 0 ? java_data_structure_class_constructor_arguments.deleteCharAt(java_data_structure_class_constructor_arguments.length() - 1) : java_data_structure_class_constructor_arguments;
        java_data_structure_class.append("\n    public ").append(class_name).append("(").append((CharSequence)java_data_structure_class_constructor_arguments).append("\n    ) {\n").append((CharSequence)java_data_structure_class_constructor_method).append("    }\n}\n");
        this.java_data_structure_class = java_data_structure_class.toString();
    }

    private void generateTypescriptDataStructureClass(String class_name) throws Exception {
        StringBuilder typescript_data_structure_class = new StringBuilder();
        StringBuilder typescript_data_structure_class_constructor_arguments = new StringBuilder();
        StringBuilder typescript_data_structure_class_constructor_method = new StringBuilder();
        StringBuilder typescript_data_structure_class_equals = new StringBuilder();
        StringBuilder typescript_data_structure_class_equals_body = new StringBuilder();
        StringBuilder typescript_data_structure_class_from_json = new StringBuilder();
        StringBuilder typescript_data_structure_class_from_json_object_list = new StringBuilder();
        StringBuilder typescript_data_structure_class_from_json_object_list_arguments = new StringBuilder();
        StringBuilder typescript_data_structure_class_to_json = new StringBuilder();
        StringBuilder typescript_request_send_response_builder = new StringBuilder(request_send_response);
        StringBuilder typescript_request_send_response_select_fields = new StringBuilder();
        StringBuilder typescript_request_send_response_insert_update_delete_fields = new StringBuilder();
        StringUtil.replaceAll(typescript_request_send_response_builder, "$TABLE_NAME", this.name);
        StringUtil.replaceAll(typescript_request_send_response_builder, "$TABLE_CLASS", class_name);
        typescript_data_structure_class.append("export class ").append(class_name).append(" extends RecordControl {\n");
        typescript_data_structure_class_constructor_method.append("\t\tsuper();\n");
        typescript_data_structure_class_equals.append("    equals(").append(this.name).append(": ").append(class_name).append(") {\n        return ").append(this.name).append(" != null");
        typescript_data_structure_class_from_json.append("    static fromJSON(json: any) : ").append(class_name).append(" {\n").append("        return new ").append(class_name).append("(\n");
        typescript_data_structure_class_from_json_object_list.append(") : ").append(class_name).append(" {\n").append("        return new ").append(class_name).append("(\n");
        typescript_data_structure_class_from_json_object_list_arguments.append("    static fromJSONObjectList(json: any, ");
        typescript_data_structure_class_to_json.append("    toJSON() : any {\n").append("        //return JSON.stringify(this);\n").append("        return {\n\t\t\tis_checked: this.is_checked,\n\t\t\tfree_text: this.free_text,\n");
        HashMap<CallSite, ArrayList<String>> i18n_map = new HashMap<CallSite, ArrayList<String>>();
        for (Field field : this.fields) {
            String java_datatype = this.data_lookup.lookupJavaDataType(field.dataTypeName);
            String typescript_datatype = this.data_lookup.lookupTypescriptDataType(field.dataTypeName);
            typescript_data_structure_class.append("    ").append(field.name).append("?: ").append(typescript_datatype).append(";\n");
            typescript_data_structure_class_constructor_arguments.append("\n        ").append(field.name).append("?: ").append(typescript_datatype).append(",");
            typescript_data_structure_class_constructor_method.append("        this.").append(field.name).append(" = ").append(field.name).append(";\n");
            typescript_request_send_response_select_fields.append("\t\t\t\t\"").append(field.name).append("\",\n");
            typescript_request_send_response_insert_update_delete_fields.append("\t\t\t\t\t").append(field.name).append(": ").append(this.name).append(".").append(field.name).append(",\n");
            if (field.primary_key.booleanValue()) {
                typescript_data_structure_class_equals_body.append("&& this.").append(field.name).append(" == ").append(this.name).append(".").append(field.name).append("\n");
            }
            if (typescript_datatype.equalsIgnoreCase("Date")) {
                if (java_datatype.equalsIgnoreCase("Date") || java_datatype.equalsIgnoreCase("Timestamp")) {
                    typescript_data_structure_class_from_json.append("            new Date(json.").append(field.name).append("),\n");
                    typescript_data_structure_class_from_json_object_list.append("            new Date(json.").append(field.name).append("),\n");
                } else if (java_datatype.equalsIgnoreCase("Time")) {
                    typescript_data_structure_class_from_json.append("            new Date(new Date().toISOString().substring(0,10)+' '+json.").append(field.name).append("),\n");
                    typescript_data_structure_class_from_json_object_list.append("            new Date(new Date().toISOString().substring(0,10)+' '+json.").append(field.name).append("),\n");
                }
            } else {
                typescript_data_structure_class_from_json.append("            json.").append(field.name).append(",\n");
                typescript_data_structure_class_from_json_object_list.append("            json.").append(field.name).append(",\n");
            }
            if (typescript_datatype.equalsIgnoreCase("Date")) {
                typescript_data_structure_class_to_json.append("            ").append(field.name).append(": this.").append(field.name).append(".toISOString(),\n");
            } else {
                typescript_data_structure_class_to_json.append("            ").append(field.name).append(": this.").append(field.name).append(",\n");
            }
            for (String lang_suffix : lang_suffix_list) {
                if (!field.name.endsWith(lang_suffix)) continue;
                String var_name = field.name.substring(0, field.name.length() - 3) + "_i18";
                ArrayList<String> string_i18n_list = (ArrayList<String>)i18n_map.get(var_name);
                if (string_i18n_list == null) {
                    string_i18n_list = new ArrayList<String>();
                    i18n_map.put((CallSite)((Object)var_name), string_i18n_list);
                }
                string_i18n_list.add(field.name);
            }
        }
        typescript_data_structure_class_equals_body = typescript_data_structure_class_equals_body.length() > 0 ? typescript_data_structure_class_equals_body.deleteCharAt(typescript_data_structure_class_equals_body.length() - 1).insert(0, "\n        ").append(";\n") : typescript_data_structure_class_equals_body;
        typescript_data_structure_class_equals.append((CharSequence)typescript_data_structure_class_equals_body);
        typescript_data_structure_class_equals.append("    }\n");
        typescript_request_send_response_select_fields.deleteCharAt(typescript_request_send_response_select_fields.length() - 2);
        typescript_request_send_response_insert_update_delete_fields.deleteCharAt(typescript_request_send_response_insert_update_delete_fields.length() - 2);
        StringUtil.replaceAll(typescript_request_send_response_builder, "$SELECT_FIELDS", typescript_request_send_response_select_fields.toString());
        StringUtil.replaceAll(typescript_request_send_response_builder, "$INSERT_UPDATE_DELETE_FIELDS", typescript_request_send_response_insert_update_delete_fields.toString());
        for (Map.Entry entry : i18n_map.entrySet()) {
            String var_name = (String)entry.getKey();
            ArrayList i18n_var_name_list = (ArrayList)entry.getValue();
            typescript_data_structure_class.append("    ").append(var_name).append("?: ").append("StringI18").append(";\n");
            typescript_data_structure_class_constructor_method.append("        this.").append(var_name).append(" = new StringI18(");
            for (String i18n_var_name : i18n_var_name_list) {
                typescript_data_structure_class_constructor_method.append(i18n_var_name).append(", ");
            }
            typescript_data_structure_class_constructor_method = typescript_data_structure_class_constructor_method.length() > 0 ? typescript_data_structure_class_constructor_method.delete(typescript_data_structure_class_constructor_method.length() - 2, typescript_data_structure_class_constructor_method.length()) : typescript_data_structure_class_constructor_method;
            typescript_data_structure_class_constructor_method.append(");\n");
        }
        for (ForeignKey foreignKey : this.foreignKeys) {
            for (Map.Entry<ForeignKeyField, ReferencedKeyField> entry : foreignKey.foreign_key_referenced_key_map.entrySet()) {
                ForeignKeyField foreignKeyField = entry.getKey();
                ReferencedKeyField referencedKeyField = entry.getValue();
                String foreign_table_name = foreignKey.referencedKeyTableName;
                String foreign_class_type_name = this.getModelClassName(foreignKey.referencedKeyTableName, false);
                String var_name_field = referencedKeyField.name.toLowerCase().endsWith("_id") ? referencedKeyField.name.substring(0, referencedKeyField.name.length() - 3) : referencedKeyField.name;
                String var_name = this.getModelClassVariableName(var_name_field);
                typescript_data_structure_class.append("    ").append(var_name).append("?: ").append(foreign_class_type_name).append(" | null;\n");
                typescript_data_structure_class_constructor_arguments.append("\n        ").append(var_name).append("?: ").append(foreign_class_type_name).append(" | null,");
                typescript_data_structure_class_constructor_method.append("        this.").append(var_name).append(" = ").append(var_name).append(";\n");
                typescript_data_structure_class_from_json.append("            null,\n");
                typescript_data_structure_class_from_json_object_list.append("            ").append(var_name).append(",\n");
                typescript_data_structure_class_from_json_object_list_arguments.append(var_name).append(": ").append(foreign_class_type_name).append(" | null, ");
            }
        }
        typescript_data_structure_class_from_json = typescript_data_structure_class_from_json.length() > 0 ? typescript_data_structure_class_from_json.delete(typescript_data_structure_class_from_json.length() - 2, typescript_data_structure_class_from_json.length()) : typescript_data_structure_class_from_json;
        typescript_data_structure_class_from_json_object_list = typescript_data_structure_class_from_json_object_list.length() > 0 ? typescript_data_structure_class_from_json_object_list.delete(typescript_data_structure_class_from_json_object_list.length() - 2, typescript_data_structure_class_from_json_object_list.length()) : typescript_data_structure_class_from_json_object_list;
        typescript_data_structure_class_from_json_object_list_arguments = typescript_data_structure_class_from_json_object_list_arguments.length() > 0 ? typescript_data_structure_class_from_json_object_list_arguments.delete(typescript_data_structure_class_from_json_object_list_arguments.length() - 2, typescript_data_structure_class_from_json_object_list_arguments.length()) : typescript_data_structure_class_from_json_object_list_arguments;
        typescript_data_structure_class_to_json = typescript_data_structure_class_to_json.length() > 0 ? typescript_data_structure_class_to_json.delete(typescript_data_structure_class_to_json.length() - 2, typescript_data_structure_class_to_json.length()) : typescript_data_structure_class_to_json;
        typescript_data_structure_class_from_json.append("\n        );\n").append("    }\n");
        typescript_data_structure_class_from_json_object_list.append("\n        );\n").append("    }\n");
        typescript_data_structure_class_from_json_object_list = typescript_data_structure_class_from_json_object_list_arguments.append((CharSequence)typescript_data_structure_class_from_json_object_list);
        typescript_data_structure_class_to_json.append("\n        };\n").append("    }\n");
        typescript_data_structure_class_constructor_arguments = typescript_data_structure_class_constructor_arguments.length() > 0 ? typescript_data_structure_class_constructor_arguments.deleteCharAt(typescript_data_structure_class_constructor_arguments.length() - 1) : typescript_data_structure_class_constructor_arguments;
        typescript_data_structure_class.append("\n    constructor(").append((CharSequence)typescript_data_structure_class_constructor_arguments).append("\n    ) {\n").append((CharSequence)typescript_data_structure_class_constructor_method).append("    \n    }\n    \n").append(typescript_data_structure_class_equals_body.length() == 0 ? "" : typescript_data_structure_class_equals).append("    \n").append((CharSequence)typescript_data_structure_class_from_json).append("    \n").append((CharSequence)typescript_data_structure_class_from_json_object_list).append("    \n").append((CharSequence)typescript_data_structure_class_to_json).append("    \n").append("}\n");
        this.typescript_data_structure_class = typescript_data_structure_class.toString();
        this.typescript_request_send_response = typescript_request_send_response_builder.toString();
    }

    private void generateTypescriptFormComponent(String class_name) throws Exception {
        StringBuilder typescript_form_component_ts_builder = new StringBuilder(form_component_ts);
        StringBuilder typescript_form_component_html_builder = new StringBuilder(form_component_html);
        StringBuilder typescript_form_field_control_class_members_builder = new StringBuilder();
        StringBuilder typescript_form_foreign_field_control_class_members_builder = new StringBuilder();
        StringBuilder typescript_form_foreign_field_array_class_members_builder = new StringBuilder();
        StringBuilder typescript_form_field_control_definition_builder = new StringBuilder();
        StringBuilder typescript_form_foreign_field_control_definition_builder = new StringBuilder();
        StringBuilder typescript_form_foreign_field_array_definition_builder = new StringBuilder();
        StringBuilder typescript_form_field_control_builder = new StringBuilder();
        StringBuilder typescript_form_foreign_field_control_builder = new StringBuilder();
        StringBuilder typescript_form_field_html_text_box_control_builder = new StringBuilder();
        StringBuilder typescript_form_field_html_date_box_control_builder = new StringBuilder();
        StringBuilder typescript_form_foreign_field_html_check_box_control_builder = new StringBuilder();
        StringBuilder typescript_form_foreign_field_html_list_box_control_builder = new StringBuilder();
        StringBuilder typescript_form_foreign_field_check_box_builder = new StringBuilder();
        StringBuilder typescript_table_component_ts_builder = new StringBuilder(table_component_ts);
        StringBuilder typescript_table_component_html_builder = new StringBuilder(table_component_html);
        StringBuilder typescript_table_field_list_builder = new StringBuilder();
        StringBuilder typescript_table_foreign_field_list_builder = new StringBuilder();
        StringBuilder typescript_table_field_html_primary_key_icon_control_builder = new StringBuilder();
        StringBuilder typescript_table_field_html_i18_control_builder = new StringBuilder();
        StringBuilder typescript_table_foreign_field_html_i18_control_builder = new StringBuilder();
        HashMap<CallSite, HashMap<String, CallSite>> i18n_map = new HashMap<CallSite, HashMap<String, CallSite>>();
        for (Field field : this.fields) {
            int index;
            String java_datatype = this.data_lookup.lookupJavaDataType(field.dataTypeName);
            String typescript_datatype = this.data_lookup.lookupTypescriptDataType(field.dataTypeName);
            if (field.foreign_reference.booleanValue() && field.primary_key.booleanValue()) {
                typescript_table_field_html_primary_key_icon_control_builder.append(typescript_table_field_html_primary_key_icon_control.replaceAll("\\$FIELD_NAME", field.name).replaceAll("\\$TABLE_NAME", this.name).replaceAll("\\$TABLE_CLASS", class_name)).append(nl);
            }
            Object control_name = field.name;
            if (field.foreign_reference.booleanValue() && !field.primary_key.booleanValue() && (index = field.name.lastIndexOf("_id")) > -1) {
                control_name = ((String)control_name).substring(0, index) + "_list_option";
            }
            typescript_form_field_control_class_members_builder.append("\t").append(typescript_form_field_control_class_members.replaceAll("\\$FIELD_NAME", (String)control_name)).append(nl);
            typescript_form_field_control_definition_builder.append("\t").append(typescript_form_field_control_definition.replaceAll("\\$FIELD_NAME", (String)control_name)).append(nl);
            typescript_form_field_control_builder.append("\t\t\t").append(typescript_form_field_control.replaceAll("\\$FIELD_NAME", (String)control_name)).append(nl);
            typescript_table_field_list_builder.append("\t\t\"").append(field.name).append("\",").append(nl);
            if (typescript_datatype.equalsIgnoreCase("Date")) {
                if (java_datatype.equalsIgnoreCase("Date")) {
                    typescript_form_field_html_date_box_control_builder.append(typescript_form_field_html_date_box_control.replaceAll("\\$TABLE_NAME", this.name).replaceAll("\\$FIELD_NAME", field.name)).append(nl);
                } else if (java_datatype.equalsIgnoreCase("Time") || java_datatype.equalsIgnoreCase("Timestamp")) {
                    typescript_form_field_html_text_box_control_builder.append(typescript_form_field_html_text_box_control.replaceAll("\\$TABLE_NAME", this.name).replaceAll("\\$FIELD_NAME", field.name).replaceAll("\\$FIELD_HTML_TYPE", typescript_datatype).replaceAll("\\$FIELD_IS_NOT_NULL", String.valueOf(field.nullable == false).toLowerCase()).replaceAll("\\$PRIMARY_KEY_TEXT_BOX", "")).append(nl);
                }
            } else if (field.primary_key.booleanValue()) {
                typescript_form_field_html_text_box_control_builder.append(typescript_form_field_html_text_box_control.replaceAll("\\$TABLE_NAME", this.name).replaceAll("\\$FIELD_NAME", field.name).replaceAll("\\$FIELD_HTML_TYPE", typescript_datatype).replaceAll("\\$FIELD_IS_NOT_NULL", String.valueOf(false).toLowerCase()).replaceAll("\\$PRIMARY_KEY_TEXT_BOX", "[readonly]=\"true\" [disabled]=\"true\"")).append(nl);
            } else {
                typescript_form_field_html_text_box_control_builder.append(typescript_form_field_html_text_box_control.replaceAll("\\$TABLE_NAME", this.name).replaceAll("\\$FIELD_NAME", field.name).replaceAll("\\$FIELD_HTML_TYPE", typescript_datatype.equalsIgnoreCase("Boolean") ? "checkbox" : typescript_datatype).replaceAll("\\$FIELD_IS_NOT_NULL", String.valueOf(field.nullable == false).toLowerCase()).replaceAll("\\$PRIMARY_KEY_TEXT_BOX", "")).append(nl);
            }
            for (String lang_suffix : lang_suffix_list) {
                if (!field.name.endsWith(lang_suffix)) continue;
                String field_i18_var_name = field.name.substring(0, field.name.length() - 3) + "_i18";
                HashMap<String, CallSite> string_i18n_map = (HashMap<String, CallSite>)i18n_map.get(field_i18_var_name);
                if (string_i18n_map == null) {
                    string_i18n_map = new HashMap<String, CallSite>();
                    i18n_map.put((CallSite)((Object)field_i18_var_name), string_i18n_map);
                }
                string_i18n_map.put("$FIELD_NAME", (CallSite)((Object)field_i18_var_name));
                string_i18n_map.put("$TABLE_NAME", (CallSite)((Object)this.name));
                string_i18n_map.put("$TABLE_CLASS", (CallSite)((Object)class_name));
            }
        }
        for (Map.Entry entry : i18n_map.entrySet()) {
            String var_name = (String)entry.getKey();
            HashMap string_i18n_map = (HashMap)entry.getValue();
            typescript_table_field_list_builder.append("\t\t\"").append(var_name).append("\",").append(nl);
            typescript_table_field_html_i18_control_builder.append(typescript_table_field_html_i18_control.replaceAll("\\$FIELD_NAME", (String)string_i18n_map.get("$FIELD_NAME")).replaceAll("\\$TABLE_NAME", (String)string_i18n_map.get("$TABLE_NAME")).replaceAll("\\$TABLE_CLASS", (String)string_i18n_map.get("$TABLE_CLASS"))).append(nl);
        }
        for (ForeignKey foreignKey : this.foreignKeys) {
            for (Map.Entry<ForeignKeyField, ReferencedKeyField> entry : foreignKey.foreign_key_referenced_key_map.entrySet()) {
                ForeignKeyField foreignKeyField = entry.getKey();
                ReferencedKeyField referencedKeyField = entry.getValue();
                String foreign_table_name = foreignKey.referencedKeyTableName;
                String foreign_class_type_name = this.getModelClassName(foreignKey.referencedKeyTableName, false);
                String var_name_field = referencedKeyField.name.toLowerCase().endsWith("_id") ? referencedKeyField.name.substring(0, referencedKeyField.name.length() - 3) : referencedKeyField.name;
                String foreign_field_var_name = this.getModelClassVariableName(var_name_field);
                typescript_form_foreign_field_control_class_members_builder.append("\t").append(typescript_form_foreign_field_control_class_members.replaceAll("\\$FOREIGN_FIELD_NAME", foreign_field_var_name)).append(nl);
                typescript_form_foreign_field_array_class_members_builder.append("\t").append(typescript_form_foreign_field_array_class_members.replaceAll("\\$FOREIGN_FIELD_NAME", foreign_field_var_name)).append(nl);
                typescript_form_foreign_field_control_definition_builder.append("\t").append(typescript_form_foreign_field_control_definition.replaceAll("\\$FOREIGN_TABLE_NAME", foreign_table_name).replaceAll("\\$FOREIGN_FIELD_NAME", foreign_field_var_name)).append(nl);
                typescript_form_foreign_field_array_definition_builder.append("\t").append(typescript_form_foreign_field_array_definition.replaceAll("\\$FOREIGN_TABLE_NAME", foreign_table_name).replaceAll("\\$FOREIGN_FIELD_NAME", foreign_field_var_name)).append(nl);
                typescript_form_foreign_field_control_builder.append("\t").append(typescript_form_foreign_field_control.replaceAll("\\$FOREIGN_TABLE_NAME", foreign_table_name).replaceAll("\\$FOREIGN_FIELD_NAME", foreign_field_var_name)).append(nl);
                typescript_form_foreign_field_html_check_box_control_builder.append(typescript_form_foreign_field_html_check_box_control.replaceAll("\\$FOREIGN_TABLE_NAME", foreign_table_name).replaceAll("\\$FOREIGN_FIELD_NAME", foreign_field_var_name)).append(nl);
                typescript_form_foreign_field_html_list_box_control_builder.append(typescript_form_foreign_field_html_list_box_control.replaceAll("\\$FOREIGN_TABLE_NAME", foreign_table_name).replaceAll("\\$FOREIGN_FIELD_NAME", foreign_field_var_name)).append(nl);
                typescript_form_foreign_field_check_box_builder.append(typescript_form_foreign_field_check_box.replaceAll("\\$FOREIGN_TABLE_NAME", foreign_table_name).replaceAll("\\$FOREIGN_TABLE_CLASS", foreign_class_type_name)).append(nl);
                String referenced_key_field_name = referencedKeyField.name.toLowerCase().endsWith("_id") ? referencedKeyField.name.substring(0, referencedKeyField.name.lastIndexOf("_id")) : referencedKeyField.name;
                typescript_table_foreign_field_list_builder.append("\t\t\"").append(referenced_key_field_name).append("\",").append(nl);
                typescript_table_field_list_builder.append("\t\t\"").append(foreign_field_var_name).append("\",").append(nl);
                typescript_table_foreign_field_html_i18_control_builder.append(typescript_table_foreign_field_html_i18_control.replaceAll("\\$TABLE_NAME", this.name).replaceAll("\\$FOREIGN_FIELD_NAME", foreign_field_var_name).replaceAll("\\$FOREIGN_TABLE_NAME", foreign_table_name).replaceAll("\\$FOREIGN_TABLE_CLASS", foreign_class_type_name)).append(nl);
            }
        }
        typescript_table_field_list_builder = typescript_table_field_list_builder.length() > 0 ? typescript_table_field_list_builder.deleteCharAt(typescript_table_field_list_builder.length() - 2) : typescript_table_field_list_builder;
        typescript_table_foreign_field_list_builder = typescript_table_foreign_field_list_builder.length() > 0 ? typescript_table_foreign_field_list_builder.deleteCharAt(typescript_table_foreign_field_list_builder.length() - 2) : typescript_table_foreign_field_list_builder;
        typescript_form_component_ts_builder.insert(0, "\n\n----------- $TABLE_NAME Form Controls ---------------------\n\n");
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TABLE_NAME", this.name);
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TABLE_CLASS", class_name);
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TYPESCRIPT_FORM_FIELD_CONTROL_CLASS_MEMBERS", typescript_form_field_control_class_members_builder.toString());
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TYPESCRIPT_FORM_FOREIGN_FIELD_CONTROL_CLASS_MEMBERS", typescript_form_foreign_field_control_class_members_builder.toString());
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TYPESCRIPT_FORM_FOREIGN_FIELD_ARRAY_CLASS_MEMBERS", typescript_form_foreign_field_array_class_members_builder.toString());
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TYPESCRIPT_FORM_FIELD_CONTROL_DEFINITION", typescript_form_field_control_definition_builder.toString());
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TYPESCRIPT_FORM_FOREIGN_FIELD_CONTROL_DEFINITION", typescript_form_foreign_field_control_definition_builder.toString());
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TYPESCRIPT_FORM_FOREIGN_FIELD_ARRAY_DEFINITION", typescript_form_foreign_field_array_definition_builder.toString());
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TYPESCRIPT_FORM_FOREIGN_FIELD_CONTROL_DEFINITION", typescript_form_foreign_field_control_definition_builder.toString());
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TYPESCRIPT_FORM_FIELD_CONTROL", typescript_form_field_control_builder.toString());
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TYPESCRIPT_FORM_FOREIGN_FIELD_CONTROL", typescript_form_foreign_field_control_builder.toString());
        StringUtil.replaceAll(typescript_form_component_ts_builder, "$TYPESCRIPT_FORM_FOREIGN_FIELD_CHECK_BOX", typescript_form_foreign_field_check_box_builder.toString());
        typescript_form_component_html_builder.append(nl).append("\n\n------------------ $TABLE_NAME Form HTML Controls ---------------\n\n");
        StringUtil.replaceAll(typescript_form_component_html_builder, "$TABLE_NAME", this.name);
        StringUtil.replaceAll(typescript_form_component_html_builder, "$TABLE_CLASS", class_name);
        StringUtil.replaceAll(typescript_form_component_html_builder, "$TYPESCRIPT_FORM_FIELD_HTML_TEXT_BOX_CONTROL", typescript_form_field_html_text_box_control_builder.toString());
        StringUtil.replaceAll(typescript_form_component_html_builder, "$TYPESCRIPT_FORM_FIELD_HTML_DATE_BOX_CONTROL", typescript_form_field_html_date_box_control_builder.toString());
        StringUtil.replaceAll(typescript_form_component_html_builder, "$TYPESCRIPT_FORM_FOREIGN_FIELD_HTML_CHECK_BOX_CONTROL", typescript_form_foreign_field_html_check_box_control_builder.toString());
        StringUtil.replaceAll(typescript_form_component_html_builder, "$TYPESCRIPT_FORM_FOREIGN_FIELD_HTML_LIST_BOX_CONTROL", typescript_form_foreign_field_html_list_box_control_builder.toString());
        this.typescript_form_component_ts = typescript_form_component_ts_builder.toString();
        this.typescript_form_component_html = typescript_form_component_html_builder.toString();
        typescript_table_component_ts_builder.insert(0, "\n\n----------- $TABLE_NAME MAT Table Controls ---------------------\n\n");
        StringUtil.replaceAll(typescript_table_component_ts_builder, "$TABLE_NAME", this.name);
        StringUtil.replaceAll(typescript_table_component_ts_builder, "$TABLE_CLASS", class_name);
        StringUtil.replaceAll(typescript_table_component_ts_builder, "$FIELD_LIST", typescript_table_field_list_builder.toString());
        StringUtil.replaceAll(typescript_table_component_ts_builder, "$FOREIGN_FIELD_LIST", typescript_table_foreign_field_list_builder.toString());
        typescript_table_component_html_builder.append(nl).append("------------------ $TABLE_NAME MAT Table HTML Controls ---------------").append(nl).append(nl);
        StringUtil.replaceAll(typescript_table_component_html_builder, "$TABLE_NAME", this.name);
        StringUtil.replaceAll(typescript_table_component_html_builder, "$TABLE_CLASS", class_name);
        StringUtil.replaceAll(typescript_table_component_html_builder, "$TYPESCRIPT_TABLE_FIELD_HTML_PRIMARY_KEY_ICON_CONTROL", typescript_table_field_html_primary_key_icon_control_builder.toString());
        StringUtil.replaceAll(typescript_table_component_html_builder, "$TYPESCRIPT_TABLE_FIELD_HTML_I18_CONTROL", typescript_table_field_html_i18_control_builder.toString());
        StringUtil.replaceAll(typescript_table_component_html_builder, "$TYPESCRIPT_TABLE_FOREIGN_FIELD_HTML_I18_CONTROL", typescript_table_foreign_field_html_i18_control_builder.toString());
        this.typescript_table_component_ts = typescript_table_component_ts_builder.toString();
        this.typescript_table_component_html = typescript_table_component_html_builder.toString();
    }

    private void generateDatabaseServletClass(String class_name, String class_name_spaced) throws Exception {
        StringBuilder database_servlet_class = new StringBuilder(servlet_class);
        this.database_servlet_uri = "/" + this.name;
        this.replace(database_servlet_class, "$PACKAGE_NAME", this.database.java_package_name);
        this.replace(database_servlet_class, "$SERVLET_CONTEXT", "/" + this.name);
        this.replace(database_servlet_class, "$CLASS_NAME", class_name);
        this.replace(database_servlet_class, "$CLASS_NAME_SPACED", class_name_spaced);
        this.replace(database_servlet_class, "$DATA_SOURCE_NAME", this.database.name);
        this.replace(database_servlet_class, "$DATABASE_NAME", this.database.name);
        this.replace(database_servlet_class, "$TABLE_NAME", this.name);
        for (Field field : this.fields) {
            String java_datatype = this.data_lookup.lookupJavaDataType(field.dataTypeName);
            String typescript_datatype = this.data_lookup.lookupTypescriptDataType(field.dataTypeName);
            StringBuilder field_method = new StringBuilder(Table.field_method);
            this.replace(field_method, "$FIELD_ALIAS", field.name);
            this.replace(field_method, "$FIELD_TYPE", java_datatype);
            this.replace(field_method, "$FIELD_NULLABLE", field.nullable.toString());
            this.replace(field_method, "$FIELD_NAME", field.name);
            if (field.primary_key.booleanValue()) {
                if (field.autoIncrment.booleanValue()) {
                    field_method.append(".setPrimaryKeyAI()");
                } else if (typescript_datatype.equalsIgnoreCase("number")) {
                    field_method.append(".setPrimaryKeyMI()");
                } else {
                    field_method.append(".setPrimaryKey()");
                }
            }
            if (field.dataTypeName.equalsIgnoreCase("VARCHAR")) {
                field_method.append(".setTexLengthRange(4, ").append(field.size).append(")");
            }
            field_method.append(";\n        ");
            this.insertBefore(database_servlet_class, "$FIELDS", field_method.toString());
        }
        for (ForeignKey foreign_key : this.foreignKeys) {
            String var_name = foreign_key.foreignKeyTableName.replaceAll("(.)([A-Z])", "$1_$2").trim().toLowerCase();
            for (Map.Entry<ForeignKeyField, ReferencedKeyField> entry : foreign_key.foreign_key_referenced_key_map.entrySet()) {
                ForeignKeyField foreignKeyField = entry.getKey();
                ReferencedKeyField referencedKeyField = entry.getValue();
                String foreign_table_name = foreign_key.referencedKeyTableName;
                StringBuilder foreign_key_method = new StringBuilder(Table.foreign_key_method);
                this.replace(foreign_key_method, "$FOREIGN_KEY_NAME", foreign_key.name);
                this.replace(foreign_key_method, "$TABLE_FIELD_NAME", referencedKeyField.name);
                this.replace(foreign_key_method, "$REFERENCE_TABLE_NAME", foreign_key.referencedKeyTableName);
                this.replace(foreign_key_method, "$REFERENCE_TABLE_FIELD_NAME", foreignKeyField.name);
                foreign_key_method.append(";\n        ");
                this.insertBefore(database_servlet_class, "$FOREIGN_KEYS", foreign_key_method.toString());
            }
        }
        this.delete(database_servlet_class, "$FIELDS");
        this.delete(database_servlet_class, "$FOREIGN_KEYS");
        this.database_servlet_class = database_servlet_class.toString();
    }

    private void generateHttpRequests(Gson gson) throws Exception {
        StringBuilder http_requests_builder = new StringBuilder();
        JsonObject insert_request_json = (JsonObject)gson.fromJson(insert_request, JsonObject.class);
        JsonArray insert_values = insert_request_json.get("values").getAsJsonArray();
        JsonObject insert_field_list = new JsonObject();
        insert_values.add((JsonElement)insert_field_list);
        JsonObject select_request_json = (JsonObject)gson.fromJson(select_request, JsonObject.class);
        JsonArray select_select = select_request_json.get("select").getAsJsonArray();
        JsonObject select_where = select_request_json.get("where").getAsJsonObject();
        JsonArray select_values = select_where.get("values").getAsJsonArray();
        JsonObject update_request_json = (JsonObject)gson.fromJson(update_request, JsonObject.class);
        JsonArray update_values = update_request_json.get("values").getAsJsonArray();
        JsonObject update_where = update_request_json.get("where").getAsJsonObject();
        JsonArray update_where_fields = update_where.get("fields").getAsJsonArray();
        JsonObject update_field_list = new JsonObject();
        update_values.add((JsonElement)update_field_list);
        JsonObject delete_request_json = (JsonObject)gson.fromJson(delete_request, JsonObject.class);
        JsonArray delete_values = delete_request_json.get("values").getAsJsonArray();
        JsonObject delete_where = delete_request_json.get("where").getAsJsonObject();
        JsonArray delete_where_fields = delete_where.get("fields").getAsJsonArray();
        JsonObject delete_field_list = new JsonObject();
        delete_values.add((JsonElement)delete_field_list);
        for (Field field : this.fields) {
            insert_field_list.addProperty(field.name, field.dataTypeName);
            select_select.add(field.name);
            if (field.primary_key.booleanValue()) {
                select_where.addProperty("clause", field.name + ">?");
                select_values.add(field.dataTypeName);
            }
            update_field_list.addProperty(field.name, field.dataTypeName);
            if (field.primary_key.booleanValue()) {
                update_where.addProperty("clause", field.name + "=?");
                update_where_fields.add(field.name);
            }
            delete_field_list.addProperty(field.name, field.dataTypeName);
            if (!field.primary_key.booleanValue()) continue;
            delete_where.addProperty("clause", field.name + "=?");
            delete_where_fields.add(field.name);
        }
        http_requests_builder.append(gson.toJson((JsonElement)insert_request_json)).append(nl).append(nl);
        http_requests_builder.append(gson.toJson((JsonElement)select_request_json)).append(nl).append(nl);
        http_requests_builder.append(gson.toJson((JsonElement)update_request_json)).append(nl).append(nl);
        http_requests_builder.append(gson.toJson((JsonElement)delete_request_json)).append(nl).append(nl);
        this.http_requests = http_requests_builder.toString();
    }

    public String getModelClassName(String model_class_name, Boolean space) {
        Pattern p = Pattern.compile("(^([a-z])|_([a-zA-Z]))");
        Matcher m = p.matcher(model_class_name);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toUpperCase());
        }
        m.appendTail(sb);
        return sb.toString().replaceAll("_", space == true ? " " : "");
    }

    public String getModelClassVariableName(String model_class_name) {
        return model_class_name.replaceAll("(.)([A-Z])", "$1_$2").trim().toLowerCase();
    }

    public String getJavaDataStructureClass() {
        return this.java_data_structure_class;
    }

    public String getTypescriptDataStructureClass() {
        return this.typescript_data_structure_class;
    }

    public Boolean hasParent(Table table) throws Exception {
        if (table == null) {
            throw new Exception("table cann not be null");
        }
        for (ChildTable childTable : table.childTables) {
            if ((!this.caseSensitiveSql.booleanValue() || !this.name.equals(childTable.tableName)) && (this.caseSensitiveSql.booleanValue() || !this.name.equalsIgnoreCase(childTable.tableName))) continue;
            return true;
        }
        return false;
    }

    public Boolean hasChild(Table table) throws Exception {
        if (table == null) {
            throw new Exception("table cann not be null");
        }
        for (ChildTable childTable : this.childTables) {
            if ((!this.caseSensitiveSql.booleanValue() || !table.name.equals(childTable.tableName)) && (this.caseSensitiveSql.booleanValue() || !table.name.equalsIgnoreCase(childTable.tableName))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        try {
            this.toString(appendable, 0, 4);
            return appendable.toString();
        }
        catch (Exception exception) {
            appendable.delete(0, appendable.length());
            appendable.append("Table: ").append(this.name).append(" Rows [").append(this.rows).append("] Fields [").append(this.fields.size()).append("] Primary Keys [").append("] Foerign Keys [").append("]").append("] Child Tables [").append(this.childTables.size()).append("]").toString();
            appendable.append("toString '").append(this.name).append("' error").append(exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
            return appendable.toString();
        }
    }

    public void toString(Appendable appendable, Integer level, Integer shift) throws Exception {
        int i;
        appendable.append("\n");
        for (i = 0; i < level * shift; ++i) {
            appendable.append(" ");
        }
        appendable.append("|");
        for (i = 0; i < shift - 1; ++i) {
            appendable.append(".");
        }
        appendable.append("Table: ").append(this.name).append(" Rows [").append(String.valueOf(this.rows)).append("] Fields [").append(String.valueOf(this.fields.size())).append("] Primary Keys [").append(String.valueOf(this.primaryKeys.size())).append("] Foerign Keys [").append(String.valueOf(String.valueOf(this.foreignKeys.size()))).append("]").append("] Child Tables [").append(String.valueOf(String.valueOf(this.childTables.size()))).append("]");
        for (Field field : this.fields) {
            appendable.append(field.toString(level + 1, shift));
        }
        for (PrimaryKey primaryKey : this.primaryKeys) {
            appendable.append(primaryKey.toString(level + 1, shift));
        }
        for (ForeignKey foreignKey : this.foreignKeys) {
            foreignKey.toString(appendable, level + 1, shift);
        }
        for (ChildTable childTable : this.childTables) {
            appendable.append(childTable.toString(level + 1, shift));
        }
    }

    public void toStringTableTree(Appendable appendable, Integer level, Integer shift, ArrayList<Table> tablesPath) throws Exception {
        int i;
        appendable.append("\n");
        for (i = 0; i < level * shift; ++i) {
            appendable.append(" ");
        }
        appendable.append("|");
        for (i = 0; i < shift - 1; ++i) {
            appendable.append(".");
        }
        appendable.append("[").append(String.valueOf(tablesPath.size())).append("]:[");
        for (i = 0; i < tablesPath.size(); ++i) {
            Table t = tablesPath.get(i);
            appendable.append(t.name);
            appendable.append(".");
        }
        appendable.append("]:[").append(String.valueOf(this.childTables.size())).append("]");
        for (ChildTable childTable : this.childTables) {
            if (tablesPath.contains(childTable.table)) {
                appendable.append(" [Cyclic Child `" + childTable.parentTable.name + "` To Parent `" + childTable.table.name + "` Reference] - Stop Tree Traversing");
                continue;
            }
            ArrayList tablesPathClone = (ArrayList)tablesPath.clone();
            tablesPathClone.add(childTable.table);
            childTable.table.toStringTableTree(appendable, level + 1, shift, tablesPathClone);
        }
    }

    public void compileTablePaths(ArrayList<Table> tablesPath, ArrayList<ArrayList<Table>> returnedTablesPaths, Boolean is_building_model) throws Exception {
        if (tablesPath.size() > 0) {
            this.parentPaths.add((ArrayList)tablesPath.clone());
        }
        tablesPath.add(this);
        returnedTablesPaths.add(tablesPath);
        for (ChildTable childTable : this.childTables) {
            if (tablesPath.contains(childTable.table)) {
                this.cyclicReferencePaths.add((ArrayList)tablesPath.clone());
                continue;
            }
            ArrayList tablesPathClone = (ArrayList)tablesPath.clone();
            childTable.table.compileTablePaths(tablesPathClone, returnedTablesPaths, is_building_model);
        }
        for (int i = 0; i < returnedTablesPaths.size(); ++i) {
            ArrayList<Table> returnedPath = returnedTablesPaths.get(i);
            if (!returnedPath.contains(this)) continue;
            this.paths.add(returnedPath);
        }
        if (is_building_model.booleanValue()) {
            this.updateModel();
        }
    }

    private void replace(StringBuilder string, String replace, String with) {
        Integer replace_position = string.indexOf(replace);
        string.replace(replace_position, replace_position + replace.length(), with);
    }

    private void insertBefore(StringBuilder string, String find, String insert) {
        Integer find_position = string.indexOf(find);
        string.insert((int)find_position, insert);
    }

    private void delete(StringBuilder string, String find) {
        this.replace(string, find, "");
    }
}

