/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.util;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class UTCTimestamp {
    static final SimpleDateFormat sdf = new SimpleDateFormat("EEE-yyyy-MM-dd-hh_mm_ss.SSSSSS", Locale.US);

    public static String getCurrentTimestamp() {
        Instant verification_instant = Instant.now().truncatedTo(ChronoUnit.MICROS);
        return verification_instant.toString().replace("T", " ").replace("Z", "");
    }

    public static Long getMinutesBetween(Instant instant_1, Instant instant_2) {
        return ChronoUnit.MINUTES.between(instant_1, instant_2);
    }

    public static Instant now(ZoneOffset zone_offset) {
        return Instant.now().atOffset(ZoneOffset.UTC).toInstant();
    }

    public static Instant now(ZoneId zone_id) {
        return Instant.now().atZone(zone_id).toInstant();
    }

    public static Instant now(String zone_code) {
        return Instant.now().atZone(ZoneId.of(zone_code)).toInstant();
    }

    public static String getCurrentTimeString() {
        return UTCTimestamp.getCurrentTimeString(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentTimeString(Locale locale) {
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            if (locale == null) {
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                return sdf.format(Date.from(Instant.now()));
            }
            SimpleDateFormat new_sdf = new SimpleDateFormat("EEE-yyyy-MM-dd-hh_mm_ss.SSSSSS", Locale.US);
            new_sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return new_sdf.format(Date.from(Instant.now()));
        }
    }
}

