/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.relational.api.annotation.DontJsonAnnotation;
import net.reyadeyat.relational.api.annotation.MetadataAnnotation;
import net.reyadeyat.relational.api.annotation.MetadataAnnotationDefault;
import net.reyadeyat.relational.api.data.DataInstance;
import net.reyadeyat.relational.api.data.DataLookup;
import net.reyadeyat.relational.api.sequence.SequenceNumber;

public class DataClass {
    DataClass parentDataClass;
    String packageName;
    Boolean isTable;
    String name;
    String nameLower;
    String declaredName;
    String canonicalPath;
    Field field;
    Class clas;
    Class<?> type;
    MetadataAnnotation metadataAnnotation;
    List<DataClass> membersList;
    List<DataClass> tablesList;
    List<DataClass> fieldsList;
    Map<String, DataClass> membersMap;
    Map<String, DataClass> tablesMap;
    Map<String, DataClass> fieldsMap;
    DataLookup data_lookup;

    public DataClass(DataClass parentDataClass, Field field, DataLookup data_lookup) throws Exception {
        this.field = field;
        this.data_lookup = data_lookup;
        this.declaredName = field.getName();
        this.parentDataClass = parentDataClass;
        this.type = this.field.getType();
        this.field.setAccessible(true);
        List<Class> classes = DataClass.getGenericClasses(this.field);
        if (classes.size() > 1) {
            throw new Exception("Multi Generic Type is not implemented yet");
        }
        this.clas = classes.get(0);
        this.packageName = parentDataClass == null ? this.clas.getPackage().getName() : parentDataClass.packageName;
        this.metadataAnnotation = this.field.getAnnotation(MetadataAnnotation.class);
        MetadataAnnotation metadataAnnotation = this.metadataAnnotation = this.metadataAnnotation != null ? this.metadataAnnotation : new MetadataAnnotationDefault(this.name, DataClass.getCompatibleType(this.clas), this.clas.getTypeName(), "");
        if (this.clas.getPackage().getName().startsWith(this.packageName) || this.metadataAnnotation.table()) {
            this.isTable = true;
            this.name = this.metadataAnnotation.table() && !this.metadataAnnotation.title().isEmpty() ? this.metadataAnnotation.title() : this.clas.getSimpleName();
        } else if (this.isAllowedType().booleanValue()) {
            this.isTable = false;
            this.name = this.field.getName();
        } else {
            throw new Exception("Data Package is '" + this.packageName + "'; can not traverse class " + this.clas.getSimpleName());
        }
        this.nameLower = this.name.toLowerCase();
        this.canonicalPath = this.parentDataClass == null ? this.name : this.parentDataClass.canonicalPath + "." + this.name;
        this.membersList = new ArrayList<DataClass>();
        this.tablesList = new ArrayList<DataClass>();
        this.fieldsList = new ArrayList<DataClass>();
        this.membersMap = new HashMap<String, DataClass>();
        this.tablesMap = new HashMap<String, DataClass>();
        this.fieldsMap = new HashMap<String, DataClass>();
        if (this.clas.getPackage().getName().startsWith(this.packageName)) {
            ArrayList<Field> fields = new ArrayList<Field>();
            this.getFields(this.clas, fields);
            for (Field newDatafield : fields) {
                DataClass newDataClass = new DataClass(this, newDatafield, this.data_lookup);
                this.membersList.add(newDataClass);
                this.membersMap.put(newDataClass.name, newDataClass);
                if (newDataClass.isTable.booleanValue()) {
                    this.tablesList.add(newDataClass);
                    this.tablesMap.put(newDataClass.name, newDataClass);
                    continue;
                }
                this.fieldsList.add(newDataClass);
                this.fieldsMap.put(newDataClass.name, newDataClass);
            }
        }
    }

    private void getFields(Class clas, List<Field> fields) {
        Field[] declaredfields;
        if (!clas.getSuperclass().getName().equalsIgnoreCase("java.lang.Object")) {
            this.getFields(clas.getSuperclass(), fields);
        }
        for (Field field : declaredfields = clas.getDeclaredFields()) {
            if (field.isAnnotationPresent(DontJsonAnnotation.class) && !field.getAnnotation(DontJsonAnnotation.class).dontJson() && Modifier.isTransient(field.getModifiers()) || !field.isAnnotationPresent(DontJsonAnnotation.class) && Modifier.isTransient(field.getModifiers())) continue;
            fields.add(field);
        }
    }

    private DataClass() {
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        try {
            this.toString(appendable, 0, this);
            return appendable.toString();
        }
        catch (Exception exception) {
            appendable.delete(0, appendable.length());
            appendable.append("toString '").append(this.name).append("' error").append(exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
            return appendable.toString();
        }
    }

    public void toString(Appendable appendable) {
        try {
            appendable.append("DataClass [").append(this.name).append("]");
            this.toString(appendable, 0, this);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
        }
    }

    private void toString(Appendable appendable, Integer indentation, DataClass dataClass) throws Exception {
        int i;
        for (i = 0; i < indentation; ++i) {
            appendable.append(" ");
        }
        if (dataClass.isTable.booleanValue()) {
            appendable.append("~T-[").append(dataClass.name).append("]\n");
        } else if (!dataClass.isTable.booleanValue()) {
            appendable.append("~F-[").append(dataClass.name).append("]\n");
        }
        for (i = 0; i < this.fieldsList.size(); ++i) {
            this.toString(appendable, indentation + 6, this.fieldsList.get(i));
        }
        for (i = 0; i < this.tablesList.size(); ++i) {
            this.toString(appendable, indentation + 6, this.tablesList.get(i));
        }
    }

    public boolean isNotNull() {
        return this.metadataAnnotation != null && !this.metadataAnnotation.nullable();
    }

    public Boolean hasParent() {
        return this.parentDataClass != null;
    }

    public String getParentName() {
        return this.parentDataClass.name;
    }

    public String getFieldType() throws Exception {
        return DataClass.getCompatibleType(this.clas);
    }

    private Boolean isList(Field field) throws Exception {
        return Arrays.asList(field.getType().getInterfaces()).contains(List.class);
    }

    private Boolean isArray(Field field) throws Exception {
        return field.getType().isArray();
    }

    private Boolean isAllowedType() {
        if (this.clas.getTypeName().equalsIgnoreCase("java.lang.String") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Boolean") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Byte") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Short") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Integer") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Long") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Float") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Double") || this.clas.getTypeName().equalsIgnoreCase("java.util.Date") || this.clas.getTypeName().equalsIgnoreCase("java.sql.String") || this.clas.getTypeName().equalsIgnoreCase("java.sql.Date") || this.clas.getTypeName().equalsIgnoreCase("java.sql.Time") || this.clas.getTypeName().equalsIgnoreCase("java.lang.Timestamp") || this.clas.getTypeName().equalsIgnoreCase("java.time.ZonedDateTime")) {
            return true;
        }
        return false;
    }

    public static List<Class> getGenericClasses(Field field) {
        ArrayList<Class> classes = new ArrayList<Class>();
        if (field.getGenericType() instanceof ParameterizedType) {
            Type[] types;
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            for (Type type : types = genericType.getActualTypeArguments()) {
                classes.add((Class)type);
            }
        } else if (field.getType().isArray()) {
            classes.add(field.getType().getComponentType());
        } else {
            classes.add(field.getType());
        }
        return classes;
    }

    public static String getCompatibleType(Class clas) {
        if (clas.getTypeName().equalsIgnoreCase("java.lang.String")) {
            return "VARCHAR(256)";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Boolean")) {
            return "TINYINT";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Byte")) {
            return "TINYINT";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Short")) {
            return "SMALLINT";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Integer")) {
            return "INTEGER";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Long")) {
            return "BIGINT";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Float")) {
            return "FLOAT";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.lang.Double")) {
            return "DOUBLE";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.util.Date")) {
            return "DATE";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.sql.Date")) {
            return "DATE";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.sql.Time")) {
            return "TIME";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.sql.Timestamp")) {
            return "TIMESTAMP";
        }
        if (clas.getTypeName().equalsIgnoreCase("java.time.ZonedDateTime")) {
            return "TIMESTAMP";
        }
        return "VARCHAR(256)";
    }

    private DataInstance createDataInstance(Object instanceObject, String databaseName) throws Exception {
        if (this.clas.equals(instanceObject.getClass())) {
            throw new Exception("object class does not equals to data class");
        }
        SequenceNumber<Integer> sequenceNumber = new SequenceNumber<Integer>(1, 1, false);
        DataInstance dataInstance = new DataInstance(DataInstance.State.NEW, databaseName, this, null, null, instanceObject, sequenceNumber, true);
        return dataInstance;
    }

    public void createDatabaseSchema(Connection connection, String databaseName, DataClass dataClass, ArrayList<String> dataClasses, ArrayList<String> creates) throws Exception {
        if (dataClasses.contains(dataClass.clas.getCanonicalName())) {
            throw new Exception("Error: Polymorphic Associations Detected with class '" + dataClass.clas.getCanonicalName() + "', use one to one class composition relation; refactor this class '" + dataClass.clas.getCanonicalName() + "' name into 2 distinct names");
        }
        if (!dataClass.isTable.booleanValue()) {
            throw new Exception("createDatabaseSchema takes table element only");
        }
        dataClasses.add(dataClass.clas.getCanonicalName());
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE IF NOT EXISTS `").append(databaseName).append("`.`").append(dataClass.nameLower).append("` (\n");
        sql.append(" ").append("`model_id` SMALLINT UNSIGNED NOT NULL,\n");
        sql.append(" ").append("`model_instance_id` BIGINT UNSIGNED NOT NULL,\n");
        sql.append(" ").append("`child_id` SMALLINT UNSIGNED NOT NULL,\n");
        sql.append(" ").append("`parent_id` SMALLINT UNSIGNED").append(dataClass.hasParent() != false ? " NOT" : "").append(" NULL,\n");
        sql.append(" ").append("`declared_field_name` VARCHAR(256) NOT NULL,\n");
        sql.append(" ").append("`class_name` VARCHAR(256) NOT NULL,\n");
        sql.append(" ").append("`json_object` LONGTEXT NOT NULL,\n");
        StringBuilder indexes = new StringBuilder();
        for (DataClass dbField : dataClass.fieldsList) {
            sql.append(" `").append(dbField.nameLower).append("` ").append(dbField.getFieldType());
            if (dbField.isNotNull()) {
                sql.append(" NOT NULL");
                if (dbField.metadataAnnotation.indexed()) {
                    if (!dbField.metadataAnnotation.indexed_expresion().isEmpty()) {
                        indexes.append("  INDEX `").append(dbField.nameLower).append("` " + dbField.metadataAnnotation.indexed_expresion() + ",\n");
                    } else {
                        indexes.append("  INDEX(`").append(dbField.nameLower).append("`),\n");
                    }
                }
            }
            sql.append(",\n");
        }
        sql.append((CharSequence)indexes);
        sql.append("  PRIMARY KEY (`model_id`,`model_instance_id`,`child_id`").append(dataClass.hasParent() != false ? ",`parent_id`" : "").append(")");
        sql.append(dataClass.hasParent() != false ? "," : "").append("\n");
        if (dataClass.hasParent().booleanValue()) {
            sql.append("  FOREIGN KEY `fk_").append(dataClass.parentDataClass.nameLower).append("` (`model_id`,`model_instance_id`,`parent_id`)\n");
            sql.append("    REFERENCES `").append(dataClass.parentDataClass.nameLower).append("` (`model_id`,`model_instance_id`,`child_id`)\n");
            sql.append("    ON UPDATE CASCADE\n");
            sql.append("    ON DELETE RESTRICT\n");
        }
        sql.append(") ENGINE=InnoDB CHARACTER SET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;");
        creates.add(sql.toString());
        for (DataClass dbTable : dataClass.tablesList) {
            this.createDatabaseSchema(connection, databaseName, dbTable, dataClasses, creates);
        }
    }

    public Object loadFromDatabase(Connection modelConnection, Integer modelID, String databaseName, DataLookup dataLookup, Object instanceID, LoadMethod loadMethod, SequenceNumber<Integer> sequence, ArrayList<String> selects) throws Exception {
        Object instanceObject = null;
        DataInstance dataInstance = null;
        dataInstance = this.loadFromDatabase(modelConnection, modelID, databaseName, dataLookup, instanceID, loadMethod, selects, dataInstance, instanceObject, 1, sequence);
        return dataInstance.instances.get(0);
    }

    private DataInstance loadFromDatabase(Connection connection, Integer modelID, String databaseName, DataLookup dataLookup, Object instanceID, LoadMethod loadMethod, ArrayList<String> selects, DataInstance parentDataInstance, Object parentInstanceObject, Integer parentID, SequenceNumber<Integer> sequence) throws Exception {
        int i;
        HashMap record;
        if (loadMethod != LoadMethod.JSON && loadMethod != LoadMethod.REFLECTION) {
            throw new Exception("Load Method '" + String.valueOf((Object)loadMethod) + "' is not implemented");
        }
        if (!this.isTable.booleanValue()) {
            throw new Exception("Can't Load DataClass Field '~F-[" + this.name + "]', load only DataClass Table");
        }
        String sql = this.loadFromDatabase(modelID, databaseName, dataLookup, instanceID, loadMethod, parentID);
        selects.add(sql);
        ArrayList<HashMap> dataset = new ArrayList<HashMap>();
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                record = new HashMap();
                if (loadMethod == LoadMethod.JSON) {
                    record.put("model_instance_id", rs.getLong("model_instance_id"));
                    record.put("child_id", rs.getInt("child_id"));
                    record.put("parent_id", rs.getInt("parent_id"));
                    record.put("json_object", rs.getString("json_object").replaceAll("\"\"", "\""));
                } else if (loadMethod == LoadMethod.REFLECTION) {
                    record.put("model_instance_id", rs.getLong("model_instance_id"));
                    record.put("child_id", rs.getInt("child_id"));
                    record.put("parent_id", rs.getInt("parent_id"));
                    record.put("declared_field_name", rs.getString("declared_field_name"));
                    record.put("class_name", rs.getString("class_name"));
                    for (i = 0; i < this.fieldsList.size(); ++i) {
                        DataClass sc = this.fieldsList.get(i);
                        if (sc.clas.getCanonicalName().equalsIgnoreCase("java.lang.Boolean")) {
                            record.put(sc.nameLower, rs.getBoolean(sc.nameLower));
                            continue;
                        }
                        record.put(sc.nameLower, rs.getObject(sc.nameLower));
                    }
                }
                dataset.add(record);
            }
        }
        DataInstance newDataInstance = null;
        if (loadMethod == LoadMethod.JSON) {
            for (int i2 = 0; i2 < dataset.size(); ++i2) {
                record = (HashMap)dataset.get(i2);
                Long instance_id = (Long)record.get("model_instance_id");
                Integer child_id = (Integer)record.get("child_id");
                Integer parent_id = (Integer)record.get("parent_id");
                String json_object = (String)record.get("json_object");
                Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
                Object instanceObject = gson.fromJson(json_object, this.clas);
                newDataInstance = new DataInstance(DataInstance.State.LOADED, databaseName, this, parentDataInstance, parentInstanceObject, instanceObject, sequence, true);
            }
        } else if (loadMethod == LoadMethod.REFLECTION) {
            Object arrayInstanceObject = this.type.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (parentInstanceObject != null) {
                this.field.set(parentInstanceObject, arrayInstanceObject);
            }
            if (this.clas.getSimpleName().equalsIgnoreCase("Database")) {
                this.clas = this.clas;
            }
            DataInstance recordDataInstance = null;
            recordDataInstance = parentInstanceObject == null ? new DataInstance(DataInstance.State.LOADED, databaseName, this, parentDataInstance, parentInstanceObject, this.clas.getConstructor(new Class[0]).newInstance(new Object[0]), sequence, false) : new DataInstance(DataInstance.State.LOADED, databaseName, this, parentDataInstance, parentInstanceObject, arrayInstanceObject, sequence, false);
            recordDataInstance.parentID = parentID;
            for (i = 0; i < dataset.size(); ++i) {
                HashMap record2 = (HashMap)dataset.get(i);
                Long instance_id = (Long)record2.get("model_instance_id");
                Integer child_id = (Integer)record2.get("child_id");
                Integer parent_id = (Integer)record2.get("parent_id");
                String declared_field_name = (String)record2.get("declared_field_name");
                String class_name = (String)record2.get("class_name");
                Object recordInstanceObject = null;
                if (parentInstanceObject == null) {
                    recordInstanceObject = recordDataInstance.getInstanceObject();
                } else {
                    recordInstanceObject = this.clas.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Method add = ArrayList.class.getDeclaredMethod("add", Object.class);
                    add.invoke(arrayInstanceObject, recordInstanceObject);
                }
                recordDataInstance.addInstanceObject(recordInstanceObject, child_id);
                for (int y = 0; y < this.fieldsList.size(); ++y) {
                    DataClass fieldDataClass = this.fieldsList.get(y);
                    Object fieldInstanceObject = null;
                    if (fieldDataClass.metadataAnnotation.lookup()) {
                        fieldInstanceObject = this.data_lookup.lookupCode((Integer)record2.get(fieldDataClass.nameLower));
                        fieldDataClass.field.set(recordInstanceObject, fieldInstanceObject);
                    } else if (fieldDataClass.clas.getCanonicalName().equalsIgnoreCase("java.lang.Boolean")) {
                        fieldInstanceObject = (Boolean)record2.get(fieldDataClass.nameLower);
                        fieldDataClass.field.set(recordInstanceObject, fieldInstanceObject);
                    } else {
                        fieldInstanceObject = record2.get(fieldDataClass.nameLower);
                        fieldDataClass.field.set(recordInstanceObject, fieldInstanceObject);
                    }
                    recordDataInstance.addChildInstanceObject(DataInstance.State.LOADED, fieldDataClass, recordInstanceObject, fieldInstanceObject, sequence, false);
                }
                for (int x = 0; x < this.tablesList.size(); ++x) {
                    DataClass subRecordDataClass = this.tablesList.get(x);
                    subRecordDataClass.loadFromDatabase(connection, modelID, databaseName, dataLookup, instanceID, loadMethod, selects, recordDataInstance, recordInstanceObject, child_id, sequence);
                }
            }
            newDataInstance = recordDataInstance;
        }
        return newDataInstance;
    }

    private String loadFromDatabase(Integer modelID, String databaseName, DataLookup dataLookup, Object instanceID, LoadMethod loadMethod, Integer parentID) throws Exception {
        if (!this.isTable.booleanValue()) {
            throw new Exception("toSQL takes table element only");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT");
        if (loadMethod == LoadMethod.JSON) {
            sql.append(" `").append(this.nameLower).append("`.`model_instance_id`,`").append(this.nameLower).append("`.`child_id`,`").append(this.nameLower).append("`.`parent_id`,`").append(this.nameLower).append("`.`declared_field_name`,`").append(this.nameLower).append("`.`class_name`,`").append(this.nameLower).append("`.`json_object`");
        } else if (loadMethod == LoadMethod.REFLECTION) {
            sql.append(" `").append(this.nameLower).append("`.`model_instance_id`,`").append(this.nameLower).append("`.`child_id`,`").append(this.nameLower).append("`.`parent_id`,`").append(this.nameLower).append("`.`declared_field_name`,`").append(this.nameLower).append("`.`class_name`,");
            for (int i = 0; i < this.fieldsList.size(); ++i) {
                DataClass fieldDataClass = this.fieldsList.get(i);
                sql.append("`").append(this.nameLower).append("`.`").append(fieldDataClass.nameLower).append("`,");
            }
            sql.delete(sql.length() - 1, sql.length());
        }
        sql.append(" FROM `").append(databaseName).append("`.`").append(this.nameLower).append("`");
        if (this.parentDataClass != null) {
            sql.append(" INNER JOIN `").append(databaseName).append("`.`").append(this.parentDataClass.nameLower).append("`");
            sql.append(" ON `").append(this.nameLower).append("`.`model_id`=`").append(this.parentDataClass.nameLower).append("`.`model_id`");
            sql.append(" AND `").append(this.nameLower).append("`.`model_instance_id`=`").append(this.parentDataClass.nameLower).append("`.`model_instance_id`");
            sql.append(" AND `").append(this.nameLower).append("`.`parent_id`=`").append(this.parentDataClass.nameLower).append("`.`child_id`");
        }
        sql.append(" WHERE `").append(this.nameLower).append("`.`model_id`=").append(modelID);
        sql.append(" AND `").append(this.nameLower).append("`.`model_instance_id`=");
        if (instanceID instanceof Number) {
            sql.append(instanceID);
        } else if (instanceID instanceof String) {
            sql.append("'").append(instanceID).append("'");
        }
        if (this.parentDataClass != null) {
            sql.append(" AND `").append(this.nameLower).append("`.`parent_id`=").append(parentID);
        }
        return sql.toString();
    }

    public static enum LoadMethod {
        JSON,
        REFLECTION;

    }
}

