/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.database;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.reyadeyat.relational.api.util.Hunter;

public class DataSources {
    protected String default_jdbc_datasource_name;
    protected Context JDBC_CONTEXT;
    protected String[] SERVER_POOLED_JDBCs;
    protected Boolean isDataSourceUp;
    protected String data_sources_title;

    public DataSources(String data_sources_title) {
        this.data_sources_title = data_sources_title;
        this.default_jdbc_datasource_name = null;
        this.init();
    }

    public DataSources(String data_sources_title, String default_jdbc_datasource_name) {
        this.data_sources_title = data_sources_title;
        this.default_jdbc_datasource_name = default_jdbc_datasource_name;
        this.init();
    }

    private void init() {
        this.isDataSourceUp = false;
        Boolean initerror = false;
        ArrayList<CallSite> initerrormsg = new ArrayList<CallSite>();
        boolean defaultDataSourceContextLoaded = false;
        StringBuilder loaded_data_sources = new StringBuilder();
        try {
            InitialContext context = new InitialContext();
            String jdbcs = (String)context.lookup("java:comp/env/SERVER_POOLED_JDBC");
            if (jdbcs != null && jdbcs.length() > 0) {
                this.JDBC_CONTEXT = (Context)context.lookup("java:comp/env/jdbc/");
                for (String jdbc : this.SERVER_POOLED_JDBCs = jdbcs.split(",")) {
                    Hunter hunter = new Hunter();
                    DataSource dataSource = this.getDataSource(jdbc, hunter);
                    if (dataSource != null) continue;
                    initerror = true;
                    initerrormsg.add((CallSite)((Object)("Error loading JNDI JDBC '" + jdbc + "'; Check JDBC connection 'url' parameter for all 'Context.Resource' paths in application 'Context.xml'; Cause '" + hunter.message() + "'")));
                }
            }
        }
        catch (Exception exception) {
            initerror = true;
            initerrormsg.add((CallSite)((Object)("InitialContext error revise 'Context.xml';" + exception.getMessage())));
        }
        StringBuilder stringBuilder = loaded_data_sources = loaded_data_sources.length() > 0 ? loaded_data_sources.deleteCharAt(loaded_data_sources.length() - 1) : loaded_data_sources;
        if (initerror.booleanValue()) {
            this.isDataSourceUp = false;
            StringBuilder errors = new StringBuilder();
            for (String string : initerrormsg) {
                errors.append(string).append(",");
            }
            errors.delete(errors.length() - 1, errors.length());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Initialization Error, DataSources '" + this.data_sources_title + "', Contact Administrator<br/>\n" + errors.toString(), new Throwable());
        }
        this.isDataSourceUp = true;
    }

    public Boolean isDataSourceUp() {
        return this.isDataSourceUp;
    }

    public Connection getDatabaseConnection() throws Exception {
        return this.getDatabaseConnection(this.default_jdbc_datasource_name);
    }

    public Connection getDatabaseConnection(String jdbc_datasource_name) throws Exception {
        Connection connection;
        if (jdbc_datasource_name == null) {
            throw new Exception("Data Source '" + this.data_sources_title + "' - JDBC Data Source Name is null");
        }
        DataSource dataSource = this.getDataSource(jdbc_datasource_name);
        if (dataSource == null) {
            throw new Exception("JDBC Context '" + jdbc_datasource_name + "' is not exist on this container");
        }
        try {
            connection = dataSource.getConnection();
        }
        catch (Exception ex) {
            throw new Exception("Failed to get connection from '" + jdbc_datasource_name + "' jndi jdbc pool", ex);
        }
        return connection;
    }

    public DataSource getDataSource(String dataSourceName) {
        return this.getDataSource(dataSourceName, null);
    }

    public DataSource getDataSource(String dataSourceName, Hunter hunter) {
        DataSource dataSource = null;
        try {
            dataSource = (DataSource)this.JDBC_CONTEXT.lookup(dataSourceName);
        }
        catch (NamingException exception) {
            if (hunter != null) {
                hunter.hunt(exception);
            }
            dataSource = null;
        }
        return dataSource;
    }

    public DataSource waitForDataSource(long seconds, String dataSourceName) throws Exception {
        DataSource dataSource = null;
        long seconds_part = seconds / 10L;
        long seconds_break = 0L;
        while (dataSource == null && seconds_break < seconds) {
            try {
                dataSource = (DataSource)this.JDBC_CONTEXT.lookup(dataSourceName);
                if (dataSource != null) {
                    continue;
                }
            }
            catch (NamingException exception) {
                dataSource = null;
            }
            seconds_break += seconds_part;
            TimeUnit.SECONDS.sleep(seconds_part);
        }
        return dataSource;
    }

    public DataSource getDataSourceFast(String dataSourceName) {
        DataSource dataSource = null;
        try {
            dataSource = (DataSource)this.JDBC_CONTEXT.lookup(dataSourceName);
        }
        catch (NamingException exception) {
            dataSource = null;
        }
        return dataSource;
    }

    public Connection getDatabaseConnectionFast() throws Exception {
        return this.getDatabaseConnectionFast(this.default_jdbc_datasource_name);
    }

    public Connection getDatabaseConnectionFast(String jdbc_datasource_name) throws Exception {
        if (jdbc_datasource_name == null) {
            throw new Exception("Data Source '" + this.data_sources_title + "' - JDBC Data Source Name is null");
        }
        DataSource dataSource = this.getDataSource(jdbc_datasource_name);
        if (dataSource == null) {
            return null;
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
        }
        catch (Exception ex) {
            return null;
        }
        return connection;
    }
}

