/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.reyadeyat.relational.api.database.Field;

public class DependentKey {
    private String key;
    private String database_name;
    private String dependent_table;
    private ArrayList<Field> fields;
    private HashMap<Field, String> dependentFields;
    private String dependency_validation_statement;

    public DependentKey(String key, String database_name, String dependent_table) {
        this.key = key;
        this.database_name = database_name;
        this.dependent_table = dependent_table;
        this.dependentFields = new HashMap();
    }

    public String getKey() {
        return this.key;
    }

    public void addDependentField(Field field, String dependentField) {
        this.dependentFields.put(field, dependentField);
    }

    public String getDependentField(Field field) {
        return this.dependentFields.get(field);
    }

    public String getDependentTable() {
        return this.dependent_table;
    }

    public ArrayList<Field> getFields() {
        return this.fields;
    }

    public void prepareDependencyValidationStatement() {
        if (this.dependentFields == null) {
            this.dependency_validation_statement = "";
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.fields = new ArrayList<Field>(this.dependentFields.keySet());
        Collections.sort(this.fields);
        sb.append("SELECT * FROM ").append("`").append(this.database_name).append("`.`").append(this.dependent_table).append("` WHERE ");
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            String dependentFieldName = this.dependentFields.get(field);
            sb.append("`").append(this.dependent_table).append("`.`").append(dependentFieldName).append("`=?").append(i + 1 == this.fields.size() ? "" : " AND ");
        }
        this.dependency_validation_statement = sb.toString();
    }

    public String getDependencyValidationStatement() {
        return this.dependency_validation_statement;
    }
}

