/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.database;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import net.reyadeyat.relational.api.database.Field;
import net.reyadeyat.relational.api.database.FieldType;

public class FieldDefaultValue {
    Boolean is_expression;
    Object static_default_value;
    String expression;
    FieldType field_type;

    public FieldDefaultValue(FieldType field_type, Object static_default_value, Boolean is_expression) throws Exception {
        this.is_expression = is_expression;
        this.field_type = field_type;
        if (!is_expression.booleanValue()) {
            this.static_default_value = static_default_value;
            return;
        }
        if (!(static_default_value instanceof String)) {
            throw new Exception("FieldDefaultValue expression must be String object");
        }
        if (field_type == FieldType.String) {
            throw new Exception("FieldDefaultValue expression allowed for Date and Time fields only; Field Type [String]");
        }
        if (field_type == FieldType.Set) {
            throw new Exception("FieldDefaultValue expression allowed for Date and Time fields only; Field Type [Set]");
        }
        if (field_type == FieldType.Long) {
            throw new Exception("FieldDefaultValue expression allowed for Date and Time fields only; Field Type [Long]");
        }
        if (field_type == FieldType.Integer) {
            throw new Exception("FieldDefaultValue expression allowed for Date and Time fields only; Field Type [Integer]");
        }
        if (field_type == FieldType.Double) {
            throw new Exception("FieldDefaultValue expression allowed for Date and Time fields only; Field Type [Double]");
        }
        if (field_type == FieldType.Boolean) {
            throw new Exception("FieldDefaultValue expression allowed for Date and Time fields only; Field Type [Boolean]");
        }
        if (field_type == FieldType.Date) {
            this.expression = (String)static_default_value;
        } else if (field_type == FieldType.Time) {
            this.expression = (String)static_default_value;
        } else if (field_type == FieldType.Timestamp) {
            this.expression = (String)static_default_value;
        } else {
            throw new Exception("FieldDefaultValue passed unhandeled field of type " + field_type.toString());
        }
    }

    public Boolean isExpression() {
        return this.is_expression;
    }

    public Object getValue() throws Exception {
        if (!this.is_expression.booleanValue()) {
            return this.static_default_value;
        }
        if (this.field_type == FieldType.Date) {
            if (this.expression.equalsIgnoreCase("TODAY")) {
                return Date.from(Instant.now());
            }
            throw new Exception("FieldDefaultValue.getValue undefined Expression " + this.expression + " for Field Type [" + this.field_type.toString() + "]");
        }
        if (this.field_type == FieldType.Time) {
            if (this.expression.equalsIgnoreCase("NOW")) {
                return Time.from(Instant.now());
            }
            throw new Exception("FieldDefaultValue.getValue undefined Expression " + this.expression + " for Field Type [" + this.field_type.toString() + "]");
        }
        if (this.field_type == FieldType.Timestamp) {
            if (this.expression.equalsIgnoreCase("NOW") || this.expression.equalsIgnoreCase("CURRENT_TIMESTAMP") || this.expression.equalsIgnoreCase("UTC_TIMESTAMP")) {
                return Timestamp.from(Instant.now());
            }
            throw new Exception("FieldDefaultValue.getValue undefined Expression " + this.expression + " for Field Type [" + this.field_type.toString() + "]");
        }
        throw new Exception("FieldDefaultValue.getValue wrong behaviour is_expression=" + this.is_expression + " expression='" + this.expression + "'");
    }

    public String getSQLValue() throws Exception {
        if (!this.is_expression.booleanValue()) {
            return this.static_default_value == null ? null : this.static_default_value.toString();
        }
        if (this.field_type == FieldType.Date) {
            if (this.expression.equalsIgnoreCase("TODAY")) {
                return Field.getSqlDate(Instant.now());
            }
            throw new Exception("FieldDefaultValue.getValue undefined Expression " + this.expression + " for Field Type [" + this.field_type.toString() + "]");
        }
        if (this.field_type == FieldType.Time) {
            if (this.expression.equalsIgnoreCase("NOW")) {
                return Field.getSqlTime(Instant.now());
            }
            throw new Exception("FieldDefaultValue.getValue undefined Expression " + this.expression + " for Field Type [" + this.field_type.toString() + "]");
        }
        if (this.field_type == FieldType.Timestamp) {
            if (this.expression.equalsIgnoreCase("NOW") || this.expression.equalsIgnoreCase("CURRENT_TIMESTAMP") || this.expression.equalsIgnoreCase("UTC_TIMESTAMP")) {
                return Field.getSqlTimestamp(Instant.now());
            }
            throw new Exception("FieldDefaultValue.getValue undefined Expression " + this.expression + " for Field Type [" + this.field_type.toString() + "]");
        }
        throw new Exception("FieldDefaultValue.getValue wrong behaviour is_expression=" + this.is_expression + " expression='" + this.expression + "'");
    }
}

