/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.database;

import com.google.gson.JsonElement;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public enum FieldType {
    String("String"),
    Boolean("Boolean"),
    Byte("Byte"),
    Short("Short"),
    Long("Long"),
    Integer("Integer"),
    Float("Float"),
    Double("Double"),
    Date("Date"),
    Time("Time"),
    Timestamp("Timestamp"),
    TimeZone("TimeZone"),
    Set("Set"),
    BigInteger("BigInteger"),
    BigDecimal("BigDecimal"),
    Object("Object"),
    Json("Json");

    private String name;

    private FieldType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public Boolean isBoolean() {
        return this == Boolean;
    }

    public Boolean isNumeric() {
        return this == Integer || this == Long || this == Double || this == BigDecimal;
    }

    public Boolean isText() {
        return this == String;
    }

    public Boolean isQuotable() {
        return this == String || this == Date || this == Time || this == Timestamp || this == Set;
    }

    public Boolean isDateTime() {
        return this == Date || this == Time || this == Timestamp;
    }

    public static FieldType getClassFieldType(Class<?> java_class) throws Exception {
        if (java_class.equals(Boolean.class)) {
            return Boolean;
        }
        if (java_class.equals(Byte.class)) {
            return Byte;
        }
        if (java_class.equals(Short.class)) {
            return Short;
        }
        if (java_class.equals(Integer.class)) {
            return Integer;
        }
        if (java_class.equals(Long.class)) {
            return Long;
        }
        if (java_class.equals(Float.class)) {
            return Float;
        }
        if (java_class.equals(Double.class)) {
            return Double;
        }
        if (java_class.equals(Date.class)) {
            return Date;
        }
        if (java_class.equals(Time.class)) {
            return Time;
        }
        if (java_class.equals(Timestamp.class)) {
            return Timestamp;
        }
        if (java_class.equals(String.class)) {
            return String;
        }
        if (java_class.equals(Object.class)) {
            return Object;
        }
        if (java_class.equals(JsonElement.class)) {
            return Json;
        }
        throw new Exception("Field data type getClassFieldType '" + java_class.getCanonicalName() + "' is not implemented yet");
    }
}

