/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.reyadeyat.relational.api.database.Field;

public class ForeignKey {
    private String key;
    private String database_name;
    private String foreign_table;
    private ArrayList<Field> fields;
    private HashMap<Field, String> foreignFields;
    private String foreiness_validation_statement;

    public ForeignKey(String key, String database_name, String foreign_table) {
        this.key = key;
        this.database_name = database_name;
        this.foreign_table = foreign_table;
        this.foreignFields = new HashMap();
    }

    public String getKey() {
        return this.key;
    }

    public void addForeignField(Field field, String foreignField) {
        this.foreignFields.put(field, foreignField);
    }

    public String getForeignField(Field field) {
        return this.foreignFields.get(field);
    }

    public String getForeignTable() {
        return this.foreign_table;
    }

    public ArrayList<Field> getFields() {
        return this.fields;
    }

    public void prepareForeinessValidationStatement() {
        if (this.foreignFields == null) {
            this.foreiness_validation_statement = "";
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.fields = new ArrayList<Field>(this.foreignFields.keySet());
        Collections.sort(this.fields);
        sb.append("SELECT * FROM ").append("`").append(this.database_name).append("`.`").append(this.foreign_table).append("` WHERE ");
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            String foreignFieldName = this.foreignFields.get(field);
            sb.append("`").append(this.foreign_table).append("`.`").append(foreignFieldName).append("`<=>?").append(i + 1 == this.fields.size() ? "" : " AND ");
        }
        this.foreiness_validation_statement = sb.toString();
    }

    public String getForeinessValidationStatement() {
        return this.foreiness_validation_statement;
    }
}

