/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.database;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.systemhesabat.data.structure.ModelDefinition;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.reyadeyat.relational.api.data.DataClass;
import net.reyadeyat.relational.api.data.DataLookup;
import net.reyadeyat.relational.api.data.DataProcessor;
import net.reyadeyat.relational.api.database.Argument;
import net.reyadeyat.relational.api.database.DependentKey;
import net.reyadeyat.relational.api.database.Field;
import net.reyadeyat.relational.api.database.FieldType;
import net.reyadeyat.relational.api.database.ForeignKey;
import net.reyadeyat.relational.api.database.JoinKey;
import net.reyadeyat.relational.api.database.RecordHandler;
import net.reyadeyat.relational.api.database.RecordProcessor;
import net.reyadeyat.relational.api.database.ServiceField;
import net.reyadeyat.relational.api.jdbc.JDBCSource;
import net.reyadeyat.relational.api.json.JsonResultset;
import net.reyadeyat.relational.api.json.JsonUtil;
import net.reyadeyat.relational.api.model.Enterprise;
import net.reyadeyat.relational.api.model.EnterpriseModel;
import net.reyadeyat.relational.api.util.Returns;

public class Table {
    private String database_name;
    private JsonObject table_tree;
    private String table_name;
    private HashMap<String, Field> fieldMap;
    private ArrayList<Field> fields;
    private String selectWhereCondition;
    private ArrayList<Field> selectWhereConditionFields;
    private String updateWhereCondition;
    private ArrayList<Field> updateWhereConditionFields;
    private HashMap<String, ForeignKey> foreignKeys;
    private HashMap<String, DependentKey> dependentKeys;
    private HashMap<String, JoinKey> joinKeys;
    private ArrayList<String> join_sql_list;
    private Boolean hasPrimaryKeyAI;
    private Boolean hasPrimaryKeyMI;
    private Integer countPrimaryKeyAI;
    private Integer countPrimaryKeyMI;
    private ArrayList<String> errors;
    private ArrayList<ForeignKey> foreign_keys_list;
    private ArrayList<DependentKey> dependent_keys_list;
    private String inner_join_statement;
    protected ArrayList<Field> primary_keys;
    protected ArrayList<Field> primary_keys_manual_increment_fields;
    protected ArrayList<Field> primary_keys_auto_increment_fields;
    protected ArrayList<Field> uniqueness_fields_all;
    protected ArrayList<Field> uniqueness_fields_any;
    protected Boolean hasVariable;
    protected ArrayList<Field> insert_fields;
    protected String valid_insert_fields;
    protected String uniqueness_insert_statement;
    protected String insert_statement;
    protected String insert_set_statement;
    protected ArrayList<String> insert_set_statement_fields_name;
    protected ArrayList<String> insert_set_statement_fields_alias;
    protected String insert_statement_select;
    protected ArrayList<Field> select_fields;
    protected String valid_select_fields;
    protected String select_statement;
    protected String select_statement_from;
    protected ArrayList<Field> select_statement_groupby;
    protected ArrayList<Field> select_statement_orderby;
    protected Boolean safe_update;
    protected ArrayList<Field> update_fields;
    protected String valid_update_fields;
    protected String uniqueness_update_statement;
    protected String update_statement;
    protected String delete_statement;
    protected String valid_transaction_type;
    private transient Table parent_table;
    private ArrayList<Table> child_table_list;
    private static HashMap<Integer, EnterpriseModel<Enterprise>> data_model_map = new HashMap();

    public Table(String database_name, String table_name) throws Exception {
        this(database_name, JsonUtil.jsonStringToJsonElelement("\"table_name\":\"" + table_name + "\"}").getAsJsonObject());
    }

    public Table(String database_name, JsonObject table_tree) throws Exception {
        this(null, null, database_name, table_tree);
    }

    public Table(Integer model_id, Table parent_table, String database_name, JsonObject table_tree) throws Exception {
        JsonArray table_children_list;
        this.parent_table = parent_table;
        this.database_name = database_name;
        this.table_tree = table_tree;
        this.fieldMap = new HashMap();
        this.hasPrimaryKeyAI = null;
        this.hasPrimaryKeyMI = null;
        this.fields = new ArrayList();
        this.errors = new ArrayList();
        this.join_sql_list = new ArrayList();
        this.joinKeys = new HashMap();
        this.safe_update = true;
        this.table_name = this.table_tree.get("table_name").getAsString();
        this.initializeTable(model_id);
        this.child_table_list = new ArrayList();
        JsonArray jsonArray = table_children_list = this.table_tree.get("children") == null ? null : this.table_tree.get("children").getAsJsonArray();
        if (table_children_list != null && table_children_list.size() > 0) {
            for (int i = 0; i < table_children_list.size(); ++i) {
                JsonObject child_table_json = table_children_list.get(i).getAsJsonObject();
                Table child_table = new Table(model_id, this, database_name, child_table_json);
                this.child_table_list.add(child_table);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Boolean init(ArrayList<String> transaction_type, ArrayList<String> initerrormsg) throws Exception {
        Boolean initerror = false;
        StringBuilder sb = new StringBuilder();
        this.valid_transaction_type = String.join((CharSequence)",", transaction_type);
        if (this.database_name == null) {
            initerror = true;
            initerrormsg.add("Database name is not defined");
        }
        if (this.table_name == null) {
            initerror = true;
            initerrormsg.add("Table name is not defined");
        }
        this.postInit();
        if (this.hasErrors().booleanValue()) {
            initerror = true;
            ArrayList<String> tableErrors = this.getErrors();
            for (String string : tableErrors) {
                initerrormsg.add(string);
            }
        }
        this.primary_keys = new ArrayList();
        this.primary_keys_manual_increment_fields = new ArrayList();
        this.primary_keys_auto_increment_fields = new ArrayList();
        this.uniqueness_fields_all = new ArrayList();
        this.uniqueness_fields_any = new ArrayList();
        this.insert_fields = new ArrayList();
        this.select_fields = new ArrayList();
        this.update_fields = new ArrayList();
        this.select_statement_groupby = new ArrayList();
        ArrayList<Field> tabel_fields = this.getFields();
        HashMap<Integer, Field> ttorder = new HashMap<Integer, Field>();
        for (Field f : tabel_fields) {
            if (f.isPrimaryKey().booleanValue()) {
                this.primary_keys.add(f);
            }
            if (f.isPrimaryKeyMI().booleanValue()) {
                this.primary_keys_manual_increment_fields.add(f);
            }
            if (f.isPrimaryKeyAI().booleanValue()) {
                this.primary_keys_auto_increment_fields.add(f);
            }
            if (f.isOrderBy().booleanValue()) {
                ttorder.put(f.getOrderByOrder(), f);
            }
            if (f.isAllowedTo(Field.INSERT).booleanValue()) {
                this.insert_fields.add(f);
            }
            if (f.isAllowedTo(Field.SELECT).booleanValue()) {
                this.select_fields.add(f);
            }
            if (f.isAllowedTo(Field.UPDATE).booleanValue()) {
                this.update_fields.add(f);
            }
            if (!f.isGroup().booleanValue()) continue;
            this.select_statement_groupby.add(f);
        }
        this.valid_insert_fields = this.insert_fields.size() == 0 ? null : this.fieldAliasToCsv(this.insert_fields);
        this.valid_select_fields = this.select_fields.size() == 0 ? null : this.fieldAliasToCsv(this.select_fields);
        String string = this.valid_update_fields = this.update_fields.size() == 0 ? null : this.fieldAliasToCsv(this.update_fields);
        if (ttorder != null && ttorder.size() > 0) {
            this.select_statement_orderby = new ArrayList(ttorder.size());
            Set set = ttorder.keySet();
            ArrayList tkeys = new ArrayList(set);
            Collections.sort(tkeys);
            for (Integer i : tkeys) {
                this.select_statement_orderby.add((Field)ttorder.get(i));
            }
        }
        if (this.primary_keys == null) {
            initerror = true;
            initerrormsg.add("Primary Keys are not defined fields tableFields");
        }
        if (transaction_type.contains("insert")) {
            for (Field f : this.insert_fields) {
                if (f.isUniqueAll().booleanValue()) {
                    this.uniqueness_fields_all.add(f);
                }
                if (f.isUniqueAny().booleanValue()) {
                    this.uniqueness_fields_any.add(f);
                }
                if (!f.isVariable().booleanValue()) continue;
                this.hasVariable = true;
            }
            sb.setLength(0);
            if (transaction_type.contains("insert") && this.insert_fields.size() == 0) {
                initerror = true;
                initerrormsg.add("no valid insert fields defined");
            } else if (transaction_type.contains("insert")) {
                void var7_15;
                Field field;
                void var7_13;
                sb.setLength(0);
                sb.append("INSERT INTO `").append(this.database_name).append("`.`").append(this.table_name).append("` (");
                boolean bl = false;
                while (var7_13 < this.insert_fields.size()) {
                    field = this.insert_fields.get((int)var7_13);
                    if (!field.isPrimaryKeyAI().booleanValue()) {
                        sb.append(field.getSQLInsertName()).append(",");
                    }
                    ++var7_13;
                }
                sb.delete(sb.length() - 1, sb.length());
                if (!this.hasPrimaryKeyMI().booleanValue()) {
                    sb.append(") VALUES (");
                } else {
                    sb.append(") SELECT ");
                }
                boolean bl2 = false;
                while (var7_15 < this.insert_fields.size()) {
                    field = this.insert_fields.get((int)var7_15);
                    if (field.isPrimaryKeyMI().booleanValue()) {
                        sb.append("IFNULL(MAX(" + field.getSQLName() + "), 0) + 1,");
                    } else if (field.isInsertFormulaDefined().booleanValue()) {
                        sb.append(field.getInsertFormulaDefined()).append(",");
                    } else {
                        sb.append("?,");
                    }
                    ++var7_15;
                }
                sb.delete(sb.length() - 1, sb.length());
                if (!this.hasPrimaryKeyMI().booleanValue()) {
                    sb.append(")");
                }
                if (this.hasPrimaryKeyMI().booleanValue()) {
                    sb.append(" FROM `").append(this.database_name).append("`.`").append(this.table_name).append("`");
                    Integer n = this.primary_keys.size() - this.countPrimaryKeyMI();
                    if (n > 0) {
                        sb.append(" WHERE");
                    }
                    for (int i2 = 0; i2 < this.primary_keys.size(); ++i2) {
                        Field field2 = this.primary_keys.get(i2);
                        if (field2.isPrimaryKeyMI().booleanValue()) continue;
                        sb.append(" ").append(field2.getSQLName()).append("=?").append(" AND");
                    }
                    if (n > 0) {
                        sb.delete(sb.length() - " AND".length(), sb.length());
                    }
                    sb.append(" FOR UPDATE");
                }
                this.insert_statement = sb.toString();
                if (this.insert_set_statement != null) {
                    void var7_18;
                    sb.setLength(0);
                    sb.append("INSERT INTO `").append(this.database_name).append("`.`").append(this.table_name).append("` (");
                    boolean bl3 = false;
                    while (var7_18 < this.insert_fields.size()) {
                        Field f = this.insert_fields.get((int)var7_18);
                        if (!f.isPrimaryKeyAI().booleanValue()) {
                            sb.append(f.getSQLName()).append(",");
                        }
                        ++var7_18;
                    }
                    sb.delete(sb.length() - 1, sb.length());
                    sb.append(") ");
                    sb.append(this.insert_set_statement);
                    this.insert_set_statement = sb.toString();
                }
                sb.setLength(0);
                if (this.primary_keys.size() > 0 && this.insert_fields.size() > 0) {
                    if (this.hasVariable.booleanValue()) {
                        this.insert_statement_select = null;
                    } else {
                        void var7_22;
                        void var7_20;
                        sb.append("SELECT ");
                        boolean bl4 = false;
                        while (var7_20 < tabel_fields.size()) {
                            Field f = tabel_fields.get((int)var7_20);
                            if (f.getTable().equalsIgnoreCase(this.table_name)) {
                                sb.append(" ").append(f.getSelect(null)).append(",");
                            }
                            ++var7_20;
                        }
                        sb.replace(sb.length() - 1, sb.length(), " ");
                        sb.append("FROM `").append(this.database_name).append("`.`").append(this.table_name).append("` WHERE");
                        boolean bl5 = false;
                        while (var7_22 < this.insert_fields.size()) {
                            Field f = this.insert_fields.get((int)var7_22);
                            if (!f.isPrimaryKeyAI().booleanValue() && !f.isPrimaryKeyMI().booleanValue()) {
                                sb.append(" ").append(f.getSQLName()).append(" ").append(f.isNullable() != false ? "<=>?" : "=?").append(var7_22 + true == this.insert_fields.size() ? "" : " AND");
                            }
                            ++var7_22;
                        }
                        this.insert_statement_select = sb.toString();
                    }
                }
                if (this.primary_keys.size() > 0 || this.uniqueness_fields_all.size() > 0 || this.uniqueness_fields_any.size() > 0) {
                    void var7_29;
                    if (this.hasVariable.booleanValue()) {
                        initerror = true;
                        initerrormsg.add("Uniqueness Statement can't contain variable field");
                    }
                    Boolean bl6 = false;
                    sb.setLength(0);
                    sb.append("SELECT ").append(this.getFieldsFor(Field.INSERT, true));
                    sb.append(" FROM `").append(this.database_name).append("`.`").append(this.table_name).append("` WHERE ");
                    Integer primaryKeyIncrement = 0;
                    if (this.primary_keys.size() > 0) {
                        for (int i5 = 0; i5 < this.primary_keys.size(); ++i5) {
                            Field field3 = this.primary_keys.get(i5);
                            if (field3.isPrimaryKeyAI().booleanValue() || field3.isPrimaryKeyMI().booleanValue()) {
                                Integer n = primaryKeyIncrement;
                                primaryKeyIncrement = primaryKeyIncrement + 1;
                                continue;
                            }
                            Boolean bl7 = true;
                            sb.append(" ").append(this.primary_keys.get(i5).getSQLName()).append("=?").append(i5 + 1 == this.primary_keys.size() ? "" : " AND");
                        }
                    }
                    if (this.uniqueness_fields_all.size() > 0) {
                        Boolean bl8 = true;
                        if (this.primary_keys.size() - primaryKeyIncrement > 0) {
                            sb.append(" AND ");
                        }
                        for (int i6 = 0; i6 < this.uniqueness_fields_all.size(); ++i6) {
                            sb.append(" ").append(this.uniqueness_fields_all.get(i6).getSQLName()).append("=?").append(i6 + 1 == this.uniqueness_fields_all.size() ? "" : " AND");
                        }
                    }
                    if (this.uniqueness_fields_any.size() > 0) {
                        Boolean bl9 = true;
                        if (this.primary_keys.size() - primaryKeyIncrement > 0 || this.uniqueness_fields_all.size() > 0) {
                            sb.append(" AND ");
                        }
                        sb.append("(");
                        for (int i7 = 0; i7 < this.uniqueness_fields_any.size(); ++i7) {
                            sb.append(" ").append(this.uniqueness_fields_any.get(i7).getSQLName()).append("=?").append(i7 + 1 == this.uniqueness_fields_any.size() ? "" : " OR");
                        }
                        sb.append(")");
                    }
                    String string2 = this.uniqueness_insert_statement = !var7_29.booleanValue() ? null : sb.toString();
                }
            }
        }
        if (transaction_type.contains("select")) {
            sb.setLength(0);
            if (transaction_type.contains("select") && this.select_fields.size() == 0) {
                initerror = true;
                initerrormsg.add("no valid select fields defined");
            } else if (transaction_type.contains("select")) {
                sb.setLength(0);
                if (this.select_statement_from == null) {
                    sb.append("`").append(this.database_name).append("`.`").append(this.table_name).append("`");
                    sb.append(this.getInnerJoin());
                    this.select_statement_from = sb.length() == 0 ? null : sb.toString();
                }
                sb.setLength(0);
                if (this.select_statement_from != null) {
                    sb.append("$SELECT$ FROM ").append(this.select_statement_from).append(" $WHERE$ $GROUPBY$ $HAVING$ $ORDERBY$");
                } else {
                    sb.append("$SELECT$ FROM `").append(this.database_name).append("`.`").append(this.table_name).append("` $WHERE$ $GROUPBY$ $HAVING$ $ORDERBY$");
                }
                this.select_statement = sb.toString();
            }
        }
        if (transaction_type.contains("update")) {
            sb.setLength(0);
            if (this.update_fields == null && transaction_type.contains("update")) {
                initerror = true;
                initerrormsg.add("no valid update fields defined");
            } else if (transaction_type.contains("update")) {
                sb.setLength(0);
                sb.append("UPDATE `").append(this.database_name).append("`.`").append(this.table_name).append("` SET $UPDATE$ $WHERE$");
                this.update_statement = sb.toString();
                if (this.uniqueness_fields_all.size() > 0 || this.uniqueness_fields_any.size() > 0) {
                    void var7_36;
                    Boolean bl = false;
                    sb.setLength(0);
                    sb.append("SELECT ").append(this.getFieldsFor(Field.UPDATE, true));
                    sb.append(" FROM `").append(this.database_name).append("`.`").append(this.table_name).append("` WHERE ");
                    if (this.primary_keys != null) {
                        Boolean bl10 = true;
                        for (int i = 0; i < this.primary_keys.size(); ++i) {
                            Field f = this.primary_keys.get(i);
                            sb.append(" ");
                            if (f.isPrimaryKeyAI().booleanValue() || f.isPrimaryKeyMI().booleanValue()) {
                                sb.append(f.getSQLName()).append("<>?");
                            } else {
                                sb.append(f.getSQLName()).append("=?");
                            }
                            sb.append(i + 1 == this.primary_keys.size() ? "" : " AND");
                        }
                    }
                    if (this.uniqueness_fields_all.size() > 0) {
                        Boolean bl11 = true;
                        if (this.primary_keys.size() > 0) {
                            sb.append(" AND ");
                        }
                        for (int i = 0; i < this.uniqueness_fields_all.size(); ++i) {
                            sb.append(" ").append(this.uniqueness_fields_all.get(i).getSQLName()).append("=?").append(i + 1 == this.uniqueness_fields_all.size() ? "" : " AND");
                        }
                    }
                    if (this.uniqueness_fields_any.size() > 0) {
                        Boolean bl12 = true;
                        if (this.primary_keys.size() > 0 || this.uniqueness_fields_all.size() > 0) {
                            sb.append(" AND ");
                        }
                        sb.append("(");
                        for (int i = 0; i < this.uniqueness_fields_any.size(); ++i) {
                            sb.append(" ").append(this.uniqueness_fields_any.get(i).getSQLName()).append("=?").append(i + 1 == this.uniqueness_fields_any.size() ? "" : " OR");
                        }
                        sb.append(")");
                    }
                    String string3 = this.uniqueness_update_statement = !var7_36.booleanValue() ? null : sb.toString();
                }
            }
        }
        if (transaction_type.contains("delete")) {
            sb.setLength(0);
            sb.append("DELETE FROM `").append(this.database_name).append("`.`").append(this.table_name).append("` $WHERE$");
            this.delete_statement = sb.toString();
        }
        ArrayList<Field> arrayList = this.getFields();
        for (Field field2 : arrayList) {
            if (!field2.hasErrors().booleanValue()) continue;
            initerror = true;
            ArrayList<String> errors = field2.getErrors();
            for (String error : errors) {
                initerrormsg.add(error);
            }
        }
        return initerror;
    }

    public void postInit() {
        this.fields = new ArrayList<Field>(this.fieldMap.values());
        Collections.sort(this.fields);
        if (this.joinKeys != null) {
            Set<String> joinKeysSet = this.joinKeys.keySet();
            for (String key : joinKeysSet) {
                JoinKey joinKey = this.joinKeys.get(key);
                joinKey.prepareJoinStatement();
            }
        }
        if (this.foreignKeys != null) {
            Set<String> foreignKeysSet = this.foreignKeys.keySet();
            for (String key : foreignKeysSet) {
                ForeignKey foreignKey = this.foreignKeys.get(key);
                foreignKey.prepareForeinessValidationStatement();
            }
        }
        if (this.dependentKeys != null) {
            Set<String> dependentKeysSet = this.dependentKeys.keySet();
            for (String key : dependentKeysSet) {
                DependentKey dependentKey = this.dependentKeys.get(key);
                dependentKey.prepareDependencyValidationStatement();
            }
        }
    }

    public String getTableName() {
        return this.table_name;
    }

    public Table getTableTree() {
        return this;
    }

    public Field getField(String alias) {
        return this.fieldMap.get(alias);
    }

    public ArrayList<Field> getFields() {
        return this.fields;
    }

    public HashMap<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    public Boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    private void checkDuplicity(Field field) {
        for (Field f : this.fields) {
            if (this.table_name.equalsIgnoreCase(f.getTable()) && !f.isVariable().booleanValue() && !f.hasFormulaDefined().booleanValue() && f.getName().equalsIgnoreCase(field.getName())) {
                this.errors.add("Field name '" + f.getTable() + "'.'" + f.getName() + "' is duplicated");
            }
            if (!this.table_name.equalsIgnoreCase(f.getTable()) || f.isVariable().booleanValue() || f.hasFormulaDefined().booleanValue() || !f.getAlias().equalsIgnoreCase(field.getAlias())) continue;
            this.errors.add("Field alias '" + f.getTable() + "'.'" + f.getAlias() + "' is duplicated");
        }
    }

    public Field addField(Boolean nullable, Boolean group, FieldType fieldType, String name, String alias) {
        return this.addField(nullable, group, fieldType, this.table_name, null, name, alias);
    }

    public Field addField(Boolean nullable, Boolean group, FieldType fieldType, String joinTable, String name, String alias) {
        return this.addField(nullable, group, fieldType, joinTable, null, name, alias);
    }

    public Field addField(Boolean nullable, Boolean group, FieldType fieldType, String joinTable, String joinTableAlias, String name, String alias) {
        Field field = new Field(this.fields.size(), nullable, group, fieldType, joinTable, joinTableAlias, name, alias);
        this.checkDuplicity(field);
        this.fields.add(field);
        this.fieldMap.put(alias, field);
        return field;
    }

    public Boolean hasSelectWhereCondition() {
        return this.selectWhereCondition != null;
    }

    public void addSelectWhereCondition(String[] fieldList, String selectWhereCondition) {
        this.selectWhereCondition = selectWhereCondition;
        this.selectWhereConditionFields = new ArrayList();
        for (String fieldName : fieldList) {
            Field field = this.fieldMap.get(fieldName);
            this.selectWhereConditionFields.add(field);
        }
    }

    public String getSelectWhereCondition() {
        return this.selectWhereCondition;
    }

    public ArrayList<Field> getSelectWhereConditionFields() {
        return this.selectWhereConditionFields;
    }

    public Boolean hasUpdateWhereCondition() {
        return this.updateWhereCondition != null;
    }

    public void addUpdateWhereCondition(String[] fieldList, String updateWhereCondition) {
        this.updateWhereCondition = updateWhereCondition;
        this.updateWhereConditionFields = new ArrayList();
        for (String fieldName : fieldList) {
            Field field = this.fieldMap.get(fieldName);
            this.updateWhereConditionFields.add(field);
        }
    }

    public String getUpdateWhereCondition() {
        return this.updateWhereCondition;
    }

    public ArrayList<Field> getUpdateWhereConditionFields() {
        return this.updateWhereConditionFields;
    }

    private void addForeignKey(String key, String foreign_table) {
        HashMap<Object, Object> hashMap = this.foreignKeys = this.foreignKeys != null ? this.foreignKeys : new HashMap();
        if (this.foreignKeys.get(key) == null) {
            this.foreignKeys.put(key, new ForeignKey(key, this.database_name, foreign_table));
        }
    }

    public void addForeignField(String key, String foreign_table, String field_alias, String foreign_field_alias) {
        if (this.fieldMap.get(field_alias) == null) {
            this.errors.add("Field alias '" + field_alias + "' is not exist in table '" + this.table_name + "'");
            return;
        }
        Field field = this.fieldMap.get(field_alias);
        this.addForeignKey(key, foreign_table);
        ForeignKey foreignKey = this.foreignKeys.get(key);
        foreignKey.addForeignField(field, foreign_field_alias);
    }

    private void addDependentKey(String key, String dependent_table) {
        HashMap<Object, Object> hashMap = this.dependentKeys = this.dependentKeys != null ? this.dependentKeys : new HashMap();
        if (this.dependentKeys.get(key) == null) {
            this.dependentKeys.put(key, new DependentKey(key, this.database_name, dependent_table));
        }
    }

    public void addDependentField(String key, String dependent_table, String field_alias, String dependent_Field_alias) {
        if (this.fieldMap.get(field_alias) == null) {
            this.errors.add("Field alias '" + field_alias + "' is not exist in table '" + this.table_name + "'");
            return;
        }
        Field field = this.fieldMap.get(field_alias);
        this.addDependentKey(key, dependent_table);
        DependentKey dependentKey = this.dependentKeys.get(key);
        dependentKey.addDependentField(field, dependent_Field_alias);
    }

    public void addJoinSQL(String join_sql) {
        this.join_sql_list.add(join_sql);
    }

    private void addJoinKey(String key, String join_table, JoinKey.JoinType join_type) {
        if (this.joinKeys.get(key) == null) {
            this.joinKeys.put(key, new JoinKey(key, this.database_name, this.table_name, join_table, join_type));
        }
    }

    public void addJoinField(String key, String join_table, String field_alias, String join_field_alias) {
        this.addJoinField(key, join_table, field_alias, join_field_alias, JoinKey.JoinType.INNER_JOIN);
    }

    public void addJoinField(String key, String join_table, String field_alias, String join_field_alias, JoinKey.JoinType join_type) {
        if (this.fieldMap.get(field_alias) == null) {
            this.errors.add("Field alias '" + field_alias + "' is not exist in table '" + this.table_name + "'");
            return;
        }
        Field field = this.fieldMap.get(field_alias);
        this.addJoinKey(key, join_table, join_type);
        JoinKey joinKey = this.joinKeys.get(key);
        joinKey.addJoinField(field, join_field_alias);
    }

    private void prepareJoin() {
        if (this.joinKeys == null) {
            this.inner_join_statement = "";
            return;
        }
        StringBuilder fks = new StringBuilder();
        ArrayList<String> joinKeySet = new ArrayList<String>(this.joinKeys.keySet());
        for (int i = 0; i < joinKeySet.size(); ++i) {
            String joinField = joinKeySet.get(i);
            JoinKey joinKey = this.joinKeys.get(joinField);
            fks.append(joinKey.getJoinStatement());
        }
        for (String free_join_sql : this.join_sql_list) {
            fks.append(" ").append(free_join_sql);
        }
        this.inner_join_statement = fks.toString();
    }

    public String getInnerJoin() {
        if (this.inner_join_statement == null) {
            this.prepareJoin();
        }
        return this.inner_join_statement;
    }

    public ArrayList<ForeignKey> getForeignKeys() {
        if (this.foreign_keys_list == null) {
            this.foreign_keys_list = this.foreignKeys == null ? new ArrayList() : new ArrayList<ForeignKey>(this.foreignKeys.values());
        }
        return this.foreign_keys_list;
    }

    public ArrayList<DependentKey> getDepenencyKeys() {
        if (this.dependent_keys_list == null) {
            this.dependent_keys_list = this.dependentKeys == null ? new ArrayList() : new ArrayList<DependentKey>(this.dependentKeys.values());
        }
        return this.dependent_keys_list;
    }

    public Boolean hasPrimaryKeyAI() {
        if (this.hasPrimaryKeyAI == null) {
            this.hasPrimaryKeyAI = false;
            for (Field field : this.fields) {
                if (!field.isPrimaryKeyAI().booleanValue()) continue;
                this.hasPrimaryKeyAI = true;
                break;
            }
        }
        return this.hasPrimaryKeyAI;
    }

    public Integer countPrimaryKeyAI() {
        if (this.countPrimaryKeyAI == null) {
            this.countPrimaryKeyAI = 0;
            for (Field field : this.fields) {
                if (!field.isPrimaryKeyMI().booleanValue()) continue;
                Integer n = this.countPrimaryKeyAI;
                this.countPrimaryKeyAI = this.countPrimaryKeyAI + 1;
            }
        }
        return this.countPrimaryKeyAI;
    }

    public Boolean hasPrimaryKeyMI() {
        if (this.hasPrimaryKeyMI == null) {
            this.hasPrimaryKeyMI = false;
            for (Field field : this.fields) {
                if (!field.isPrimaryKeyMI().booleanValue()) continue;
                this.hasPrimaryKeyMI = true;
                break;
            }
        }
        return this.hasPrimaryKeyMI;
    }

    public Integer countPrimaryKeyMI() {
        if (this.countPrimaryKeyMI == null) {
            this.countPrimaryKeyMI = 0;
            for (Field field : this.fields) {
                if (!field.isPrimaryKeyMI().booleanValue()) continue;
                Integer n = this.countPrimaryKeyMI;
                this.countPrimaryKeyMI = this.countPrimaryKeyMI + 1;
            }
        }
        return this.countPrimaryKeyMI;
    }

    private String createRuntimeInsertStatementSelect(JsonObject variable) throws Exception {
        Field f;
        int i;
        StringBuilder sb = new StringBuilder();
        ArrayList<Field> tabel_fields = this.getFields();
        sb.append("SELECT ");
        for (i = 0; i < tabel_fields.size(); ++i) {
            f = tabel_fields.get(i);
            if (!f.getTable().equalsIgnoreCase(this.table_name)) continue;
            if (!f.isVariable().booleanValue()) {
                sb.append(" ").append(f.getSelect()).append(",");
                continue;
            }
            sb.append(" ").append(f.getSelect(variable)).append(",");
        }
        sb.replace(sb.length() - 1, sb.length(), " ");
        sb.append("FROM `").append(this.database_name).append("`.`").append(this.table_name).append("` WHERE");
        for (i = 0; i < this.insert_fields.size(); ++i) {
            f = this.insert_fields.get(i);
            if (f.isPrimaryKeyAI().booleanValue() || f.isPrimaryKeyMI().booleanValue()) continue;
            sb.append(" ").append(f.getSQLName()).append(" ").append(f.isNullable() != false ? "<=>?" : "=?").append(i + 1 == this.insert_fields.size() ? "" : " AND");
        }
        this.insert_statement_select = null;
        return sb.toString();
    }

    public void validateInserFields(JsonArray errors) {
        if (this.insert_fields == null) {
            errors.add("Internal System Error, Contact Adminstrator, uninitialized 'insert_fields' is null");
        } else if (this.valid_insert_fields == null) {
            errors.add("Internal System Error, Contact Adminstrator, uninitialized 'valid_insert_fields' is null");
        } else if (this.insert_statement == null) {
            errors.add("Internal System Error, Contact Adminstrator, uninitialized 'insert_statement' is null");
        }
    }

    public void validateSelectFields(JsonArray errors) {
        if (this.select_fields == null) {
            errors.add("Internal System Error, Contact Adminstrator, uninitialized 'select_fields' is null");
        } else if (this.valid_select_fields == null) {
            errors.add("Internal System Error, Contact Adminstrator, uninitialized 'valid_select_fields' is null");
        } else if (this.select_statement == null) {
            errors.add("Internal System Error, Contact Adminstrator, uninitialized 'select_statement' is null");
        }
    }

    public void validateUpdateFields(JsonArray errors) {
        if (this.update_fields == null) {
            errors.add("Internal System Error, Contact Adminstrator, uninitialized 'update_fields' is null");
        } else if (this.valid_update_fields == null) {
            errors.add("Internal System Error, Contact Adminstrator, uninitialized 'valid_update_fields' is null");
        } else if (this.update_statement == null) {
            errors.add("Internal System Error, Contact Adminstrator, uninitialized 'update_statement' is null");
        }
    }

    public void validateDeleteFields(JsonArray errors) {
        if (this.delete_statement == null) {
            errors.add("Internal System Error, Contact Adminstrator, uninitialized 'delete_statement' is null");
        }
    }

    protected void defineInsertSet(String insert_set_statement) {
        this.insert_set_statement = insert_set_statement;
        this.insert_set_statement_fields_name = new ArrayList();
        this.insert_set_statement_fields_alias = new ArrayList();
        String b = insert_set_statement.substring(7, insert_set_statement.indexOf("FROM"));
        String[] ff = b.split(",");
        for (int i = 0; i < ff.length; ++i) {
            String[] fff = ff[i].split("AS");
            this.insert_set_statement_fields_name.add(fff[0].trim());
            this.insert_set_statement_fields_alias.add(fff[1].replace("`", "").replace(",", "").trim());
        }
    }

    protected void defineSafeUpdate(Boolean safe_update) {
        this.safe_update = safe_update;
    }

    public Boolean mustSafeUpdate() {
        return this.safe_update;
    }

    protected Field addField(String alias, FieldType fieldType, Boolean nullable, Boolean group, String joinTable, String name) {
        return this.addField(nullable, group, fieldType, joinTable, name, alias);
    }

    protected Field addField(String alias, FieldType fieldType, Boolean nullable, Boolean group, String name) {
        return this.addField(nullable, group, fieldType, name, alias);
    }

    protected void addJoinKey(String key, String fieldAlias, String joinTable, String joinField) {
        this.addJoinField(key, joinTable, fieldAlias, joinField);
    }

    protected void addJoinKey(String key, String fieldAlias, String joinTable, String joinField, JoinKey.JoinType join_type) {
        this.addJoinField(key, joinTable, fieldAlias, joinField, join_type);
    }

    protected void addForeignKey(String key, String fieldAlias, String foreignTable, String foreignField) {
        this.addForeignField(key, foreignTable, fieldAlias, foreignField);
    }

    protected void addDependentKey(String key, String fieldAlias, String dependendTable, String dependendField) {
        this.addDependentField(key, dependendTable, fieldAlias, dependendField);
    }

    protected Table getTable() {
        return this;
    }

    protected Object getFieldObject(String alias, String string) throws Exception {
        return this.getField(alias).getFieldObject(string);
    }

    public Boolean validateInsertUniqueness(Connection con, JsonObject json, JsonArray errors) throws Exception {
        if (this.uniqueness_insert_statement != null) {
            JsonArray values = json.get("values").getAsJsonArray();
            for (int oo = 0; oo < values.size(); ++oo) {
                JsonObject o = values.get(oo).getAsJsonObject();
                try (PreparedStatement preparedInsertedSelectStmt = con.prepareStatement(this.uniqueness_insert_statement);){
                    String fieldValue;
                    JsonElement fje;
                    Field f;
                    int i;
                    int idx = 0;
                    if (this.primary_keys.size() > 0) {
                        for (i = 0; i < this.primary_keys.size(); ++i) {
                            f = this.primary_keys.get(i);
                            if (f.isPrimaryKeyAI().booleanValue() || f.isPrimaryKeyMI().booleanValue()) continue;
                            fje = o.get(this.primary_keys.get(i).getAlias());
                            fieldValue = fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    if (this.uniqueness_fields_all.size() > 0) {
                        for (i = 0; i < this.uniqueness_fields_all.size(); ++i) {
                            f = this.uniqueness_fields_all.get(i);
                            fje = o.get(this.uniqueness_fields_all.get(i).getAlias());
                            fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    if (this.uniqueness_fields_any.size() > 0) {
                        for (i = 0; i < this.uniqueness_fields_any.size(); ++i) {
                            f = this.uniqueness_fields_any.get(i);
                            fje = o.get(this.uniqueness_fields_any.get(i).getAlias());
                            fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    try (ResultSet rs = preparedInsertedSelectStmt.executeQuery();){
                        while (rs.next()) {
                            Field f2;
                            int i2;
                            StringBuilder sb = new StringBuilder();
                            StringBuilder ssb = new StringBuilder();
                            for (i2 = 0; i2 < this.primary_keys.size(); ++i2) {
                                f2 = this.primary_keys.get(i2);
                                ssb.append("'").append(this.primary_keys.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(rs.getString(this.primary_keys.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            if (ssb.length() > 0) {
                                ssb.delete(ssb.length() - 1, ssb.length());
                                errors.add("Record with [Primary Keys] unique values {" + ssb.toString() + "," + sb.toString() + "} already exists");
                            }
                            ssb.setLength(0);
                            sb.setLength(0);
                            for (i2 = 0; i2 < this.uniqueness_fields_all.size(); ++i2) {
                                f2 = this.uniqueness_fields_all.get(i2);
                                sb.append("'").append(this.uniqueness_fields_all.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(rs.getString(this.uniqueness_fields_all.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            if (sb.length() > 0) {
                                sb.delete(sb.length() - 1, sb.length());
                                errors.add("Record with [all] unique values {" + sb.toString() + "} already exists");
                            }
                            sb.setLength(0);
                            for (i2 = 0; i2 < this.uniqueness_fields_any.size(); ++i2) {
                                f2 = this.uniqueness_fields_any.get(i2);
                                sb.append("'").append(this.uniqueness_fields_any.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(rs.getString(this.uniqueness_fields_any.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            if (sb.length() <= 0) continue;
                            sb.delete(sb.length() - 1, sb.length());
                            errors.add("Record with [any] unique values {" + sb.toString() + "} already exists");
                        }
                        rs.close();
                    }
                    preparedInsertedSelectStmt.close();
                    continue;
                }
            }
        }
        return errors.size() == 0;
    }

    public Boolean validateUpdateUniqueness(Connection con, JsonObject json, JsonArray errors) throws Exception {
        if (this.uniqueness_update_statement != null) {
            JsonArray values = json.get("values").getAsJsonArray();
            for (int oo = 0; oo < values.size(); ++oo) {
                JsonObject o = values.get(oo).getAsJsonObject();
                StringBuilder mpk = null;
                JsonObject where = JsonUtil.getJsonObject(json, "where", (Boolean)false);
                JsonArray where_value_list = JsonUtil.getJsonArray(where, "values", true);
                JsonArray where_field_list = JsonUtil.getJsonArray(where, "fields", true);
                if (where_field_list != null) {
                    for (int i = 0; i < this.primary_keys.size(); ++i) {
                        Field field = this.primary_keys.get(i);
                        if (o.get(field.getAlias()) != null) continue;
                        if (mpk == null) {
                            mpk = new StringBuilder();
                            mpk.append("Safe Update can't continue, missing Primary Key {");
                        }
                        mpk.append(field.getAlias()).append(",");
                    }
                }
                if (mpk != null) {
                    mpk.delete(mpk.length() - 1, mpk.length());
                    mpk.append("}, check in group index[").append(oo + 1).append("]");
                    errors.add(mpk.toString());
                    return false;
                }
                try (PreparedStatement preparedInsertedSelectStmt = con.prepareStatement(this.uniqueness_update_statement);){
                    String fieldValue;
                    JsonElement fje;
                    Field f;
                    int i;
                    int idx = 0;
                    if (this.primary_keys.size() > 0) {
                        for (i = 0; i < this.primary_keys.size(); ++i) {
                            f = this.primary_keys.get(i);
                            fje = o.get(this.primary_keys.get(i).getAlias());
                            fieldValue = fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    if (this.uniqueness_fields_all.size() > 0) {
                        for (i = 0; i < this.uniqueness_fields_all.size(); ++i) {
                            f = this.uniqueness_fields_all.get(i);
                            fje = o.get(this.uniqueness_fields_all.get(i).getAlias());
                            fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    if (this.uniqueness_fields_any.size() > 0) {
                        for (i = 0; i < this.uniqueness_fields_any.size(); ++i) {
                            f = this.uniqueness_fields_any.get(i);
                            fje = o.get(this.uniqueness_fields_any.get(i).getAlias());
                            fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        }
                    }
                    try (ResultSet rs = preparedInsertedSelectStmt.executeQuery();){
                        while (rs.next()) {
                            Field f2;
                            int i2;
                            StringBuilder sb = new StringBuilder();
                            StringBuilder ssb = new StringBuilder();
                            for (i2 = 0; i2 < this.primary_keys.size(); ++i2) {
                                f2 = this.primary_keys.get(i2);
                                ssb.append("'").append(this.primary_keys.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(rs.getString(this.primary_keys.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            StringBuilder stringBuilder = ssb = ssb.length() > 1 ? ssb.delete(ssb.length() - 1, ssb.length()) : ssb;
                            if (ssb.length() > 0) {
                                ssb.delete(ssb.length() - 1, ssb.length());
                                errors.add("Record with [Primary Keys] unique values {" + ssb.toString() + "," + sb.toString() + "} already exists");
                            }
                            ssb.setLength(0);
                            sb.setLength(0);
                            for (i2 = 0; i2 < this.uniqueness_fields_all.size(); ++i2) {
                                f2 = this.uniqueness_fields_all.get(i2);
                                sb.append("'").append(this.uniqueness_fields_all.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(rs.getString(this.uniqueness_fields_all.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            if (sb.length() > 0) {
                                sb.delete(sb.length() - 1, sb.length());
                                errors.add("Record with [all] unique values {" + sb.toString() + "} already exists");
                            }
                            sb.setLength(0);
                            for (i2 = 0; i2 < this.uniqueness_fields_any.size(); ++i2) {
                                f2 = this.uniqueness_fields_any.get(i2);
                                sb.append("'").append(this.uniqueness_fields_any.get(i2).getAlias()).append("'=").append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(rs.getString(this.uniqueness_fields_any.get(i2).getAlias())).append(f2.isText() != false || f2.isDateTime() != false ? "'" : "").append(",");
                            }
                            if (sb.length() <= 0) continue;
                            sb.delete(sb.length() - 1, sb.length());
                            errors.add("Record with [any] unique values {" + sb.toString() + "} already exists");
                        }
                        rs.close();
                    }
                    preparedInsertedSelectStmt.close();
                    continue;
                }
            }
        }
        return errors.size() == 0;
    }

    public Boolean validateInsertForeignness(Connection con, JsonObject json, JsonArray errors) throws Exception {
        ArrayList<ForeignKey> foreignKeys = this.getForeignKeys();
        if (foreignKeys.size() == 0) {
            return true;
        }
        JsonArray values = json.get("values").getAsJsonArray();
        for (ForeignKey foreignKey : foreignKeys) {
            JsonObject o;
            int oo;
            ArrayList<Field> fields = foreignKey.getFields();
            ArrayList<Integer> nullableRecords = new ArrayList<Integer>();
            for (oo = 0; oo < values.size(); ++oo) {
                o = values.get(oo).getAsJsonObject();
                Integer nullables = 0;
                for (int i = 0; i < fields.size(); ++i) {
                    String fieldValue;
                    Field f = fields.get(i);
                    JsonElement fje = o.get(f.getAlias());
                    String string = fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                    if (!f.isNullable().booleanValue() || fieldValue != null) continue;
                    Integer n = nullables;
                    nullables = nullables + 1;
                }
                nullableRecords.add(nullables);
                if (nullables <= 0 || nullables.intValue() == fields.size()) continue;
                errors.add("Foreign Key '" + foreignKey.getKey() + "' for Table '" + foreignKey.getForeignTable() + "' has mixed keys {null} values check index [" + oo + "], either or null or all non-null}");
            }
            for (oo = 0; errors.size() == 0 && oo < values.size(); ++oo) {
                if ((Integer)nullableRecords.get(oo) > 0) continue;
                o = values.get(oo).getAsJsonObject();
                String foreignness_statement = foreignKey.getForeinessValidationStatement();
                try (PreparedStatement preparedInsertedSelectStmt = con.prepareStatement(foreignness_statement);){
                    int idx = 0;
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < fields.size(); ++i) {
                        Field f = fields.get(i);
                        JsonElement fje = o.get(f.getAlias());
                        String fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                        preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                        sb.append("`").append(foreignKey.getForeignTable()).append("`.`").append(foreignKey.getForeignField(f)).append("`=").append(fieldValue).append(",");
                    }
                    sb.delete(sb.length() - 1, sb.length());
                    String s = sb.toString();
                    try (ResultSet rs = preparedInsertedSelectStmt.executeQuery();){
                        if (!rs.next()) {
                            errors.add("Table '" + foreignKey.getForeignTable() + "' doesn't have record with {" + s + "}");
                        }
                        rs.close();
                    }
                    preparedInsertedSelectStmt.close();
                    continue;
                }
            }
        }
        return errors.size() == 0;
    }

    public Boolean validateUpdateForeignness(Connection con, JsonObject json, JsonArray errors) throws Exception {
        ArrayList<ForeignKey> foreignKeys = this.getForeignKeys();
        if (foreignKeys.size() > 0) {
            JsonArray values = json.get("values").getAsJsonArray();
            for (ForeignKey foreignKey : foreignKeys) {
                JsonObject o;
                int oo;
                ArrayList<Field> fields = foreignKey.getFields();
                Integer checkForeignKeyUpdate = fields.size();
                StringBuilder sb = new StringBuilder();
                String foreignness_statement = foreignKey.getForeinessValidationStatement();
                Boolean skipForeignKeyCheck = false;
                for (oo = 0; oo < 1; ++oo) {
                    o = values.get(oo).getAsJsonObject();
                    for (int i = 0; i < fields.size(); ++i) {
                        Field f = fields.get(i);
                        JsonElement je = o.get(f.getAlias());
                        if (je == null) {
                            sb.append(f.getAlias()).append(",");
                        }
                        checkForeignKeyUpdate = checkForeignKeyUpdate + (je == null ? 0 : -1);
                    }
                    StringBuilder stringBuilder = sb = sb.length() == 0 ? sb : sb.delete(sb.length() - 1, sb.length());
                    if (checkForeignKeyUpdate.intValue() == fields.size()) {
                        skipForeignKeyCheck = true;
                        continue;
                    }
                    if (checkForeignKeyUpdate == 0) continue;
                    errors.add("Table '" + foreignKey.getForeignTable() + "' missing '" + (fields.size() - checkForeignKeyUpdate) + "' foreign keys '" + foreignKey.getKey() + "' keys {" + sb.toString() + "}");
                    return false;
                }
                if (skipForeignKeyCheck.booleanValue()) continue;
                for (oo = 0; oo < values.size(); ++oo) {
                    o = values.get(oo).getAsJsonObject();
                    try (PreparedStatement preparedInsertedSelectStmt = con.prepareStatement(foreignness_statement);){
                        int idx = 0;
                        sb.setLength(0);
                        for (int i = 0; i < fields.size(); ++i) {
                            Field f = fields.get(i);
                            JsonElement fje = o.get(f.getAlias());
                            String fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                            preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                            sb.append("`").append(foreignKey.getForeignTable()).append("`.`").append(foreignKey.getForeignField(f)).append("`=").append(fieldValue).append(",");
                        }
                        sb.delete(sb.length() - 1, sb.length());
                        String s = sb.toString();
                        try (ResultSet rs = preparedInsertedSelectStmt.executeQuery();){
                            if (!rs.next()) {
                                errors.add("Table '" + foreignKey.getForeignTable() + "' doesn't have record with {" + s + "}");
                            }
                            rs.close();
                        }
                        preparedInsertedSelectStmt.close();
                        continue;
                    }
                }
            }
        }
        return errors.size() == 0;
    }

    protected Boolean getBoolean(ResultSet rs, String field) throws Exception {
        return rs.getObject(field) == null ? null : Boolean.valueOf(rs.getBoolean(field));
    }

    protected Integer getInt(ResultSet rs, String field) throws Exception {
        return rs.getObject(field) == null ? null : Integer.valueOf(rs.getInt(field));
    }

    protected Long getLong(ResultSet rs, String field) throws Exception {
        return rs.getObject(field) == null ? null : Long.valueOf(rs.getLong(field));
    }

    protected Double getDouble(ResultSet rs, String field) throws Exception {
        return rs.getObject(field) == null ? null : Double.valueOf(rs.getDouble(field));
    }

    protected Date getDate(ResultSet rs, String field) throws Exception {
        return rs.getObject(field) == null ? null : rs.getDate(field);
    }

    protected Time getTime(ResultSet rs, String field) throws Exception {
        return rs.getObject(field) == null ? null : rs.getTime(field);
    }

    protected Timestamp getTimestamp(ResultSet rs, String field) throws Exception {
        return rs.getObject(field) == null ? null : rs.getTimestamp(field);
    }

    protected String getString(ResultSet rs, String field) throws Exception {
        return rs.getObject(field) == null ? null : rs.getString(field);
    }

    protected boolean isValid(JsonObject json, String[] parameters, JsonObject errorObject) throws Exception {
        JsonArray errorList = null;
        for (String parameterName : parameters) {
            String parameter;
            JsonElement fje = json.get(parameterName);
            String string = parameter = fje.isJsonNull() ? null : fje.getAsString();
            if (parameter != null && !parameter.isBlank()) continue;
            if (errorList == null) {
                errorList = new JsonArray();
            }
            errorList.add("Parameter '" + parameterName + "' is " + (parameter == null ? "null" : "\"empty\""));
        }
        if (errorList != null) {
            errorObject.addProperty("major_error", "Invalid Field Name");
            errorObject.add("error_messages", errorList);
        }
        return errorObject.size() == 0;
    }

    private ServiceField isValidServiceField(String serviceField, HashMap<String, Field> record, JsonArray errorList) {
        int pos1 = serviceField.indexOf(" AS ");
        if (pos1 == -1) {
            return null;
        }
        int pos2 = serviceField.indexOf(" ", pos1 + 5);
        if (pos2 == -1) {
            return null;
        }
        String formula = serviceField.substring(0, pos1);
        String type = serviceField.substring(pos1 + 4, pos2);
        String alias = serviceField.substring(pos2 + 1);
        if (record.containsKey(alias)) {
            errorList.add("Service Field '" + serviceField + "' has alias '" + alias + "' that is already defined as Table Field");
            return null;
        }
        return new ServiceField(formula, type, alias, errorList);
    }

    protected boolean areValidSelectFields(ArrayList<String> field, ArrayList<ServiceField> serviceFields, HashMap<String, Field> record, ArrayList<Field> fields, JsonArray errorList) {
        Field f;
        int i;
        for (i = 0; i < field.size(); ++i) {
            f = record.get(field.get(i));
            if (f != null && !f.isAllowedTo(Field.SELECT).booleanValue()) {
                errorList.add("Field '" + field.get(i) + "' is not allowed in select operation");
                continue;
            }
            if (f != null && fields.contains(f)) continue;
            ServiceField sf = this.isValidServiceField(field.get(i), record, errorList);
            if (sf != null) {
                serviceFields.add(sf);
                field.remove(i--);
                continue;
            }
            errorList.add("Field '" + field.get(i) + "' is not a valid field name");
        }
        for (i = 0; i < this.select_fields.size(); ++i) {
            f = this.select_fields.get(i);
            if (!f.isMandatoryFor(Field.SELECT).booleanValue()) continue;
            Boolean found = false;
            for (int x = 0; x < field.size(); ++x) {
                if (!f.getAlias().equalsIgnoreCase(field.get(x))) continue;
                found = true;
                break;
            }
            if (found.booleanValue()) continue;
            if (!f.hasDefaultValueFor(Field.SELECT).booleanValue()) {
                errorList.add("Field '" + f.getAlias() + "' is mandatory to be exist in select list");
                continue;
            }
            if (!f.hasDefaultValueFor(Field.SELECT).booleanValue()) continue;
        }
        return errorList.size() == 0;
    }

    protected boolean areValidUpdateFieldsValues(HashMap<String, Field> field_map, JsonArray jsonRecordset, ArrayList<String> conditionalFields, ArrayList<Field> fields, JsonArray errorList) throws Exception {
        StringBuilder error = new StringBuilder();
        for (int i = 0; i < jsonRecordset.size(); ++i) {
            JsonObject record = jsonRecordset.get(i).getAsJsonObject();
            for (String fieldName : record.keySet()) {
                Field f = field_map.get(fieldName);
                if (f != null && !f.isPrimaryKey().booleanValue() && !f.isAllowedTo(Field.UPDATE).booleanValue()) {
                    errorList.add("Field '" + fieldName + "' is not allowed in update operation");
                    continue;
                }
                if (f == null && conditionalFields != null && !conditionalFields.contains(fieldName)) {
                    errorList.add("Field '" + fieldName + "' is not a valid condition field name, check record[" + (i + 1) + "]");
                    continue;
                }
                if (conditionalFields == null && f == null) {
                    errorList.add("Field '" + fieldName + "' is not a valid field name, check record[" + (i + 1) + "]");
                    continue;
                }
                if (conditionalFields == null && !fields.contains(f)) {
                    errorList.add("Field '" + fieldName + "' is not allowed field to be updated, check record[" + (i + 1) + "]");
                    continue;
                }
                if (conditionalFields == null && record.get(fieldName) != null && f != null && !f.isNullable().booleanValue() && record.get(fieldName).isJsonNull()) {
                    errorList.add("Field '" + fieldName + "' doesn't accept null values, check record[" + (i + 1) + "]");
                    continue;
                }
                if (conditionalFields != null || f.isValid(Field.UPDATE, record.get(fieldName) == null || record.get(fieldName).isJsonNull() ? null : record.get(fieldName).getAsString(), error).booleanValue()) continue;
                errorList.add(error.toString() + ", check record[" + (i + 1) + "]");
            }
            for (Field f : field_map.values()) {
                JsonElement fje;
                String field_alias = f.getAlias();
                if (record.has(field_alias) || !f.hasDefaultValueFor(Field.UPDATE).booleanValue() || (fje = record.get(f.getAlias())) != null && !fje.isJsonNull()) continue;
                record.addProperty(f.getAlias(), f.getDefaultSQLValueFor(Field.UPDATE));
            }
            for (int x = 0; conditionalFields != null && x < conditionalFields.size(); ++x) {
                String fieldName;
                fieldName = conditionalFields.get(x);
                if (record.get(fieldName) != null) continue;
                errorList.add("Field '" + fieldName + "', in {where.fields} doesn't exist in values record, check record[" + (i + 1) + "]");
            }
        }
        return errorList.size() == 0;
    }

    public static final Boolean isValidClause(Integer operation, String ii, HashMap<String, Field> r, ArrayList<Field> wf, ArrayList<String> vv, StringBuilder wc, StringBuilder hc, ArrayList<Argument> wa, ArrayList<Argument> ha, JsonArray errorList) throws Exception {
        ArrayList<String> keyword = new ArrayList<String>(Arrays.asList("asc", "desc", "between", "in", "like", "and", "or", "is", "null"));
        String symbol = "/*-+(?)'[]|<=>,;:\\\r\n\t ";
        String ignore = "\r\n\t ";
        Character sc = Character.valueOf('\'');
        Character esc = Character.valueOf('\'');
        Object escr = null;
        StringBuilder b = new StringBuilder();
        StringBuilder e = new StringBuilder();
        ArrayList<String> mm = new ArrayList<String>();
        boolean s = false;
        boolean p = false;
        boolean h = false;
        char nc = '\u0000';
        char pc = '\u0000';
        char c = '\u0000';
        int l = ii.length();
        for (int x = 0; x < l; ++x) {
            c = ii.charAt(x);
            char c2 = nc = x == l - 1 ? (char)'\u0000' : ii.charAt(x + 1);
            if (!s && symbol.indexOf(c) > -1) {
                if (b.length() > 0) {
                    mm.add(b.toString());
                    b.delete(0, b.length());
                }
                if (ignore.indexOf(c) > -1) {
                    b.setLength(0);
                    continue;
                }
                if (symbol.indexOf(c) > -1) {
                    if (b.length() > 0) {
                        mm.add(b.toString());
                        b.setLength(0);
                    }
                    mm.add(String.valueOf(c));
                }
                if (!s && c == sc.charValue()) {
                    s = true;
                }
            } else if (s && c == esc.charValue() && nc == sc.charValue()) {
                if (escr == null) {
                    b.append(esc).append(sc);
                } else {
                    b.append((Object)escr);
                }
                ++x;
            } else if (s && c == sc.charValue()) {
                if (b.length() > 0) {
                    mm.add(b.toString());
                    b.setLength(0);
                }
                mm.add(String.valueOf(c));
                s = false;
            } else {
                b.append(c);
            }
            pc = c;
        }
        if (b.length() > 0) {
            mm.add(b.toString());
            b.delete(0, b.length());
        }
        b.setLength(0);
        int ml = mm.size();
        int vi = -1;
        String sm = "";
        for (int i = 0; i < ml; ++i) {
            sm = (String)mm.get(i);
            if (r.get(sm) != null) {
                Field f = r.get(sm);
                wf.add(f);
                h = f.isGroup();
                (h ? ha : wa).add(new Argument(f));
                (h ? hc : wc).append(h ? f.getHaving() : f.getSQLName()).append(" ");
                sm = (String)mm.get(++i);
                if (sm == null) {
                    errorList.add("Clause statement is incomplete");
                    return false;
                }
                if (sm.length() == 1 && "<=>".indexOf(sm) > -1) {
                    Field fl;
                    if (!((String)mm.get(i - 1)).equals("?") && r.get(mm.get(i - 1)) == null) {
                        errorList.add("Invalid Mathematical operator");
                        return false;
                    }
                    if (sm.equals("<") && "?=>".indexOf((String)mm.get(i + 1)) > -1) {
                        (h ? hc : wc).append(sm);
                        if (((String)mm.get(i + 1)).equals("?")) {
                            if (vv != null && ++vi >= vv.size()) {
                                errorList.add("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                            } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                                errorList.add(e.toString());
                                return false;
                            }
                            if (vv != null) {
                                (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                            }
                            sm = (String)mm.get(++i);
                            (h ? hc : wc).append(sm).append(i + 1 == ml ? "" : ("'(.".indexOf(sm) > -1 || "'.,()".indexOf((String)mm.get(i + 1)) > -1 ? "" : ("<>".indexOf(sm) > -1 && ">=".indexOf((String)mm.get(i + 1)) > -1 ? "" : " ")));
                            continue;
                        }
                        if ("=>".indexOf((String)mm.get(i + 1)) <= -1) continue;
                        if (((String)mm.get(++i + 1)).equals("?")) {
                            ++i;
                            if (vv != null && ++vi >= vv.size()) {
                                errorList.add("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                            } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                                errorList.add(e.toString());
                                return false;
                            }
                            if (vv != null) {
                                (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                            }
                            (h ? hc : wc).append((String)mm.get(i - 1)).append(" ? ");
                            continue;
                        }
                        if (r.get(mm.get(i + 1)) != null) {
                            fl = r.get(mm.get(i + 1));
                            wf.add(fl);
                            h = fl.isGroup();
                            (h ? hc : wc).append(sm).append((String)mm.get(i)).append(h ? fl.getHaving() : fl.getSQLName()).append(" ");
                            ++i;
                            continue;
                        }
                        errorList.add("Invalid Mathematical operator");
                        return false;
                    }
                    if (sm.equals(">") && "?=".indexOf((String)mm.get(i + 1)) > -1) {
                        (h ? hc : wc).append(sm);
                        if (((String)mm.get(i + 1)).equals("?")) {
                            if (vv != null && ++vi >= vv.size()) {
                                errorList.add("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                            } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                                errorList.add(e.toString());
                                return false;
                            }
                            if (vv != null) {
                                (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                            }
                            ++i;
                            (h ? hc : wc).append(f.hasOverwriteWhereCondition() == true ? f.getOverwriteWhereCondition() : "?");
                            continue;
                        }
                        if ("=".indexOf((String)mm.get(i + 1)) <= -1) continue;
                        if (((String)mm.get(++i + 1)).equals("?")) {
                            ++i;
                            if (vv != null && ++vi >= vv.size()) {
                                errorList.add("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                            } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                                errorList.add(e.toString());
                                return false;
                            }
                            if (vv != null) {
                                (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                            }
                            (h ? hc : wc).append("= ? ");
                            continue;
                        }
                        if (r.get(mm.get(i + 1)) != null) {
                            fl = r.get(mm.get(i + 1));
                            wf.add(fl);
                            h = fl.isGroup();
                            ++i;
                            (h ? hc : wc).append(sm).append("=").append(h ? fl.getHaving() : fl.getSQLName()).append(" ");
                            ++i;
                            continue;
                        }
                        errorList.add("Invalid Mathematical operator");
                        return false;
                    }
                    if (!sm.equals("=") || "?".indexOf((String)mm.get(i + 1)) <= -1) continue;
                    ++i;
                    if (vv != null && ++vi >= vv.size()) {
                        errorList.add("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                    } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                        errorList.add(e.toString());
                        return false;
                    }
                    if (vv != null) {
                        (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                    }
                    (h ? hc : wc).append("<=>").append(f.hasOverwriteWhereCondition() == true ? f.getOverwriteWhereCondition() : "?").append(" ");
                    continue;
                }
                if (sm.equalsIgnoreCase("in")) {
                    (h ? hc : wc).append(sm).append(i + 1 == ml ? "" : ("'(.".indexOf(sm) > -1 || "'.,()".indexOf((String)mm.get(i + 1)) > -1 ? "" : ("<>".indexOf(sm) > -1 && ">=".indexOf((String)mm.get(i + 1)) > -1 ? "" : " ")));
                    if (!((String)mm.get(i - 1)).equalsIgnoreCase("not") && r.get(mm.get(i - 1)) == null && !((String)mm.get(i + 1)).equals("(")) {
                        errorList.add("Invalid IN operator");
                        return false;
                    }
                    sm = (String)mm.get(++i);
                    (h ? hc : wc).append(sm).append(i + 1 == ml ? "" : ("'(.".indexOf(sm) > -1 || "'.,()".indexOf((String)mm.get(i + 1)) > -1 ? "" : ("<>".indexOf(sm) > -1 && ">=".indexOf((String)mm.get(i + 1)) > -1 ? "" : " ")));
                    while (!(sm = (String)mm.get(++i)).equals(")")) {
                        Object token = "?";
                        if (!((String)mm.get(i)).equalsIgnoreCase((String)token)) {
                            errorList.add("Invalid IN operator");
                            return false;
                        }
                        if (!((String)mm.get(i + 1)).equals(")")) {
                            token = (String)token + ",";
                        }
                        if (vv != null && ++vi >= vv.size()) {
                            errorList.add("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                        } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                            errorList.add(e.toString());
                            return false;
                        }
                        if (vv != null) {
                            (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                        }
                        (h ? hc : wc).append((String)token).append(i + 1 == ml ? "" : ("'(.".indexOf(sm) > -1 || "'.,()".indexOf((String)mm.get(i + 1)) > -1 ? "" : ("<>".indexOf(sm) > -1 && ">=".indexOf((String)mm.get(i + 1)) > -1 ? "" : " ")));
                        if (((String)mm.get(i + 1)).equals(")")) continue;
                        ++i;
                    }
                    (h ? hc : wc).append(sm).append(i + 1 == ml ? "" : ("'(.".indexOf(sm) > -1 || "'.,()".indexOf((String)mm.get(i + 1)) > -1 ? "" : ("<>".indexOf(sm) > -1 && ">=".indexOf((String)mm.get(i + 1)) > -1 ? "" : " ")));
                    continue;
                }
                if (sm.equalsIgnoreCase("like")) {
                    (h ? hc : wc).append(sm).append(" ");
                    if (((String)mm.get(i + 1)).equals("?")) {
                        ++i;
                        if (vv != null && ++vi >= vv.size()) {
                            errorList.add("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                        }
                        if (vv != null) {
                            (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                        }
                        (h ? hc : wc).append(" ? ");
                        continue;
                    }
                    errorList.add("Invalid Mathematical operator");
                    return false;
                }
                if (sm.equalsIgnoreCase("between")) {
                    (h ? hc : wc).append(sm).append(" ");
                    if (((String)mm.get(i + 1)).equals("?")) {
                        (h ? hc : wc).append(f.hasOverwriteWhereCondition() == true ? f.getOverwriteWhereCondition() : "?").append(" ");
                        ++i;
                        if (vv != null && ++vi >= vv.size()) {
                            errorList.add("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                        } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                            errorList.add(e.toString());
                            return false;
                        }
                        if (!((String)mm.get(i + 1)).equalsIgnoreCase("and") || !((String)mm.get(i + 2)).equals("?")) {
                            errorList.add("Invalid Between operator");
                            return false;
                        }
                        if (vv != null) {
                            (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                        }
                        ++i;
                        if (vv != null && ++vi >= vv.size()) {
                            errorList.add("Caluse Paramerter value index is [" + (vi + 1) + "] while value list is only [" + vv.size() + "] items");
                        } else if (vv != null && !f.isValid(operation, vv.get(vi), e).booleanValue()) {
                            errorList.add(e.toString());
                            return false;
                        }
                        if (vv != null) {
                            (h ? ha : wa).get((h ? ha : wa).size() - 1).addValue(vv.get(vi));
                        }
                        ++i;
                        (h ? hc : wc).append("AND ? ");
                        continue;
                    }
                    errorList.add("Invalid Between operator");
                    return false;
                }
                if (sm.equalsIgnoreCase("is")) {
                    if (((String)mm.get(i + 1)).equalsIgnoreCase("null")) {
                        ++i;
                        (h ? hc : wc).append("IS NULL");
                        continue;
                    }
                    if (((String)mm.get(i + 1)).equalsIgnoreCase("not") && ((String)mm.get(i + 2)).equalsIgnoreCase("null")) {
                        ++i;
                        ++i;
                        (h ? hc : wc).append("IS NOT NULL");
                        continue;
                    }
                    errorList.add("Invalid IS Operator");
                    return false;
                }
                errorList.add("Invalid Where clause");
                return false;
            }
            if (sm.equalsIgnoreCase("and") || sm.equalsIgnoreCase("or") || sm.equals("(") || sm.equals(")") || sm.equalsIgnoreCase("not")) {
                (h ? hc : wc).append(" ").append(sm).append(" ");
                continue;
            }
            if (r.get(sm) == null) {
                errorList.add("Field '" + sm + "' is not a valid field name");
                continue;
            }
            errorList.add("Invalid Where clause '" + sm + "'");
            return false;
        }
        return errorList.size() == 0;
    }

    public boolean areValidInsertValueFields(HashMap<String, Field> record, JsonArray values, ArrayList<Field> fields, JsonArray errorList) throws Exception {
        String fieldValue;
        JsonElement fje;
        JsonObject o;
        int i;
        StringBuilder error = new StringBuilder();
        for (i = 0; i < values.size(); ++i) {
            o = values.get(i).getAsJsonObject();
            for (String fieldName : o.keySet()) {
                if (fieldName.equalsIgnoreCase("tuid")) continue;
                fje = o.get(fieldName);
                fieldValue = fje.isJsonNull() ? null : fje.getAsString();
                Field f = record.get(fieldName);
                if (f != null && !f.isAllowedTo(Field.INSERT).booleanValue()) {
                    errorList.add("Field '" + fieldName + "' is not allowed in insert operation");
                    continue;
                }
                if (f == null || !fields.contains(f)) {
                    errorList.add("Field '" + fieldName + "' is not a valid field name for insert operation");
                    continue;
                }
                if (!f.isAllowedTo(Field.INSERT).booleanValue()) {
                    errorList.add("Field '" + fieldName + "' is not allowed to insert opertation");
                    continue;
                }
                if (f.isValid(Field.INSERT, fieldValue, error).booleanValue()) continue;
                errorList.add(error.toString());
            }
        }
        if (errorList.size() > 0) {
            return false;
        }
        for (i = 0; i < values.size(); ++i) {
            o = values.get(i).getAsJsonObject();
            for (int x = 0; x < fields.size(); ++x) {
                Field f = fields.get(x);
                fje = o.get(fields.get(x).getAlias());
                String string = fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                if (!(f.isPrimaryKeyAI().booleanValue() || f.isPrimaryKeyMI().booleanValue() || !f.isAllowedTo(Field.INSERT).booleanValue() || f.isValid(Field.INSERT, fieldValue, error).booleanValue() || f.hasDefaultValueFor(Field.INSERT).booleanValue())) {
                    errorList.add(error.toString());
                    continue;
                }
                if (fieldValue != null || !f.hasDefaultValueFor(Field.INSERT).booleanValue()) continue;
                o.addProperty(f.getAlias(), f.getDefaultSQLValueFor(Field.INSERT));
            }
        }
        return errorList.size() == 0;
    }

    protected boolean isValid(String[] parameters, JsonObject rcvd) throws Exception {
        for (String parameter : parameters) {
            JsonElement el = rcvd.get(parameter);
            if (el != null && !el.isJsonNull()) continue;
            return false;
        }
        return true;
    }

    protected String getFieldsFor(Integer operation, Boolean include_primary_keys) throws Exception {
        StringBuilder csv = new StringBuilder();
        ArrayList<Field> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Field f = fields.get(i);
            if (!f.isAllowedTo(operation).booleanValue() && (!include_primary_keys.booleanValue() || !f.isPrimaryKey().booleanValue())) continue;
            csv.append(f.getSelect()).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String getFieldsSelect(JsonObject variable) throws Exception {
        StringBuilder csv = new StringBuilder();
        for (int i = 0; i < this.select_fields.size(); ++i) {
            Field f = this.select_fields.get(i);
            if (!f.isVariable().booleanValue()) {
                csv.append(f.getSelect()).append(",");
                continue;
            }
            csv.append(f.getSelect(variable)).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String getFieldsSelect(Boolean hasGroupBy, JsonObject variable, ArrayList<String> field, ArrayList<ServiceField> serviceField, JsonArray errorList) throws Exception {
        int i;
        StringBuilder csv = new StringBuilder();
        if (!hasGroupBy.booleanValue() || field == null || field.size() == 0) {
            for (i = 0; i < this.select_fields.size(); ++i) {
                f = this.select_fields.get(i);
                if (f == null) {
                    errorList.add("Field '" + field.get(i) + "' is not a valid field name");
                    continue;
                }
                if (f.isVariable().booleanValue()) {
                    csv.append(f.getSelect(variable)).append(",");
                    continue;
                }
                csv.append(f.getSelect()).append(",");
            }
        } else {
            for (i = 0; field != null && i < field.size(); ++i) {
                f = this.getField(field.get(i));
                if (f == null) {
                    errorList.add("Field '" + field.get(i) + "' is not a valid field name");
                    continue;
                }
                if (f.isVariable().booleanValue()) {
                    csv.append(f.getSelect(variable)).append(",");
                    continue;
                }
                csv.append(f.getSelect()).append(",");
            }
        }
        for (i = 0; serviceField != null && i < serviceField.size(); ++i) {
            csv.append(serviceField.get(i).getSelectStatement()).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String fieldAliasToCsv(ArrayList<Field> fields) {
        if (fields.size() == 0) {
            return "";
        }
        StringBuilder csv = new StringBuilder();
        for (Field f : fields) {
            csv.append(f.getAlias()).append(",");
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String getFieldsOrderBy(String v, String[] field, JsonArray errorList) {
        StringBuilder csv = new StringBuilder();
        if (field == null || field.length == 0) {
            for (int i = 0; this.select_statement_orderby != null && i < this.select_statement_orderby.size() && v.equalsIgnoreCase("process"); ++i) {
                Field f = this.select_statement_orderby.get(i);
                csv.append(f.getOrderBy()).append(",");
            }
        } else {
            for (int i = 0; i < field.length; ++i) {
                String orderByFieldName = field[i];
                int order = orderByFieldName.charAt(0);
                if (order == 43 || order == 45) {
                    orderByFieldName = orderByFieldName.substring(1);
                } else {
                    order = 43;
                }
                Field f = this.getField(orderByFieldName);
                if (f == null) {
                    errorList.add("Field '" + field[i] + "' is not a valid field name");
                    continue;
                }
                csv.append(f.getOrderBy()).append(order == 43 ? " ASC," : " DESC,");
            }
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String getFieldsGroupBy(String[] field, JsonArray errorList) {
        StringBuilder csv = new StringBuilder();
        for (int i = 0; i < field.length; ++i) {
            Field f = this.getField(field[i]);
            if (f == null) {
                errorList.add("Field '" + field[i] + "' is not a valid field name");
                continue;
            }
            if (!this.select_statement_groupby.contains(f)) {
                errorList.add("Field '" + field[i] + "' is not a valid 'Group By' field name");
                continue;
            }
            csv.append(f.getGroupBy()).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        if (errorList.size() > 0) {
            errorList.add("Fields valid for 'Group By' are [" + csv.toString() + "] is not a valid GROUP BY field name");
        }
        return csv.toString();
    }

    protected String getJsonCSV(JsonArray jsonArray) {
        StringBuilder csv = new StringBuilder();
        for (int i = 0; i < jsonArray.size(); ++i) {
            csv.append(jsonArray.get(i).getAsString()).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    protected String getJsonCSV(JsonObject variable, JsonArray jsonArray, HashMap<String, Field> record) throws Exception {
        StringBuilder csv = new StringBuilder();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Field f = record.get(jsonArray.get(i).getAsString());
            if (!f.isVariable().booleanValue()) {
                csv.append(f.getSelect()).append(",");
                continue;
            }
            csv.append(f.getSelect(variable)).append(",");
        }
        if (csv.length() == 0) {
            return "";
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }

    public String validateSelectStatement(JsonObject json, ArrayList<Field> wf, String vt, ArrayList<String> s, ArrayList<ServiceField> ss, ArrayList<String> wv, ArrayList<Argument> ah, ArrayList<Argument> av, JsonObject w, JsonArray errors) throws Exception {
        String c = w.get("clause").getAsString();
        String[] g = json.get("groupby") == null || json.get("groupby").isJsonNull() ? null : JsonUtil.javaStringArray(json.get("groupby").getAsJsonArray());
        String[] o = json.get("orderby") == null || json.get("orderby").isJsonNull() ? null : JsonUtil.javaStringArray(json.get("orderby").getAsJsonArray());
        JsonObject variable = json.getAsJsonObject("variable");
        StringBuilder ww = new StringBuilder();
        StringBuilder hh = new StringBuilder();
        StringBuilder query = new StringBuilder(this.select_statement);
        if (!this.areValidSelectFields(s, ss, this.getFieldMap(), this.select_fields, errors)) {
            errors.add("ERROR: validateSelectStatement.areValidSelectFields");
            return null;
        }
        if (c.replaceAll("[^?]", "").length() != wv.size()) {
            errors.add("ERROR: validateSelectStatement.escapement");
            return null;
        }
        if (!Table.isValidClause(Field.SELECT, c, this.getFieldMap(), wf, wv, ww, hh, ah, av, errors).booleanValue()) {
            errors.add("ERROR: validateSelectStatement.isValidClause");
            return null;
        }
        String oo = null;
        if (o != null) {
            oo = this.getFieldsOrderBy(vt, o, errors);
            if (errors.size() > 0) {
                errors.add("ERROR: validateSelectStatement.ORDER_BY_VALIDATION");
                return null;
            }
        }
        String gg = null;
        if (g != null) {
            gg = this.getFieldsGroupBy(g, errors);
            if (errors.size() > 0) {
                errors.add("ERROR: validateSelectStatement.GROUP_BY_VALIDATION");
                return null;
            }
        }
        int idx = query.indexOf("$SELECT$");
        query.replace(idx, idx + 8, "");
        query.insert(idx, "SELECT ");
        query.insert(idx + 7, this.getFieldsSelect(gg != null && gg.length() > 0, variable, s, ss, errors));
        if (errors.size() > 0) {
            errors.add("ERROR: validateSelectStatement.SELECT");
            return null;
        }
        idx = query.indexOf("$WHERE$");
        query.replace(idx, idx + 7, "");
        if (ww != null && ww.length() > 0) {
            if (ww.lastIndexOf(" AND ") == ww.length() - 5) {
                ww = ww.delete(ww.lastIndexOf(" AND "), ww.length());
            }
            if (ww.lastIndexOf(" OR ") == ww.length() - 4) {
                ww = hh.delete(ww.lastIndexOf(" OR "), ww.length());
            }
        }
        if (ww != null && ww.length() > 0) {
            query.insert(idx, " WHERE ");
            if (this.hasSelectWhereCondition().booleanValue()) {
                ww.insert(0, this.getSelectWhereCondition() + " AND ");
            }
            query.insert(idx + 7, ww);
        } else if (this.hasSelectWhereCondition().booleanValue()) {
            query.insert(idx, " WHERE ");
            ww.setLength(0);
            ww.append(this.getSelectWhereCondition());
            query.insert(idx + 7, ww);
        }
        if (errors.size() > 0) {
            errors.add("ERROR: validateSelectStatement.WHERE");
            return null;
        }
        idx = query.indexOf("$GROUPBY$");
        query.replace(idx, idx + 9, "");
        if (gg != null && gg.length() > 0) {
            query.insert(idx, "GROUP BY ");
            query.insert(idx + 9, gg);
        }
        if (errors.size() > 0) {
            errors.add("ERROR: validateSelectStatement.GROUP_BY");
            return null;
        }
        idx = query.indexOf("$HAVING$");
        query.replace(idx, idx + 8, "");
        if (hh != null && hh.length() > 0) {
            if (hh.lastIndexOf(" AND ") == hh.length() - 5) {
                hh.delete(hh.lastIndexOf(" AND "), hh.length());
            }
            if (hh.lastIndexOf(" OR ") == hh.length() - 4) {
                hh.delete(hh.lastIndexOf(" OR "), hh.length());
            }
        }
        if (hh != null && hh.length() > 0) {
            query.insert(idx, " HAVING ");
            query.insert(idx + 8, hh);
        }
        if (errors.size() > 0) {
            errors.add("ERROR: validateSelectStatement.HAVING");
            return null;
        }
        idx = query.indexOf("$ORDERBY$");
        query.replace(idx, idx + 9, "");
        if (oo != null && oo.length() > 0) {
            query.insert(idx, "ORDER BY ");
            query.insert(idx + 9, oo);
        }
        if (errors.size() > 0) {
            errors.add("ERROR: validateSelectStatement.ORDER_BY");
            return null;
        }
        return query.toString();
    }

    public void processSelectedRecord(ResultSet rs, JsonObject json, JsonObject record_object, ArrayList<String> s, JsonArray errors) throws Exception {
        for (int i = 0; i < s.size(); ++i) {
            String alias = s.get(i);
            Field f = this.getField(alias);
            if (f.isIgnoredFor(Field.SELECT).booleanValue()) continue;
            Object fieldObject = rs.getObject(f.getAlias());
            if (fieldObject == null) {
                record_object.add(alias, (JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (f.isNumeric().booleanValue()) {
                record_object.addProperty(alias, (Number)fieldObject);
                continue;
            }
            if (f.isBoolean().booleanValue()) {
                record_object.addProperty(alias, f.parseBoolean(fieldObject));
                continue;
            }
            record_object.addProperty(alias, f.getFieldString(rs.getObject(f.getAlias())));
        }
    }

    public void processSelectedObjectRecord(ResultSet rs, JsonObject json, JsonObject record_object, ArrayList<String> s, ArrayList<ServiceField> ss, JsonArray errors) throws Exception {
        int i;
        for (i = 0; i < s.size(); ++i) {
            String alias = s.get(i);
            Field f = this.getField(alias);
            if (f.isIgnoredFor(Field.SELECT).booleanValue()) continue;
            Object fieldObject = f.getPostProcessedValue(Field.SELECT, rs.getObject(f.getAlias()), errors);
            if (fieldObject == null) {
                record_object.add(alias, (JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (f.isNumeric().booleanValue()) {
                record_object.addProperty(alias, (Number)fieldObject);
                continue;
            }
            if (f.isBoolean().booleanValue()) {
                record_object.addProperty(alias, f.parseBoolean(fieldObject));
                continue;
            }
            record_object.addProperty(alias, f.getFieldString(fieldObject));
        }
        for (i = 0; i < ss.size(); ++i) {
            ServiceField sf = ss.get(i);
            Object fieldObject = rs.getObject(sf.getAlias());
            if (fieldObject == null) {
                record_object.add(sf.getAlias(), (JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (sf.isNumeric().booleanValue()) {
                record_object.addProperty(sf.getAlias(), (Number)fieldObject);
                continue;
            }
            if (sf.isBoolean().booleanValue()) {
                record_object.addProperty(sf.getAlias(), sf.parseBoolean(fieldObject));
                continue;
            }
            record_object.addProperty(sf.getAlias(), sf.getFieldString(rs.getObject(sf.getAlias())));
        }
    }

    public void processSelectedArrayRecord(ResultSet rs, JsonObject json, JsonArray record_list, ArrayList<String> s, ArrayList<ServiceField> ss, JsonArray errors) throws Exception {
        int i;
        for (i = 0; i < s.size(); ++i) {
            String alias = s.get(i);
            Field f = this.getField(alias);
            if (f.isIgnoredFor(Field.SELECT).booleanValue()) continue;
            Object fieldObject = f.getPostProcessedValue(Field.SELECT, rs.getObject(f.getAlias()), errors);
            if (fieldObject == null) {
                record_list.add((JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (f.isNumeric().booleanValue()) {
                record_list.add((Number)fieldObject);
                continue;
            }
            if (f.isBoolean().booleanValue()) {
                record_list.add(f.parseBoolean(fieldObject));
                continue;
            }
            record_list.add(f.getFieldString(fieldObject));
        }
        for (i = 0; i < ss.size(); ++i) {
            ServiceField sf = ss.get(i);
            Object fieldObject = rs.getObject(sf.getAlias());
            if (fieldObject == null) {
                record_list.add((JsonElement)JsonNull.INSTANCE);
                continue;
            }
            if (sf.isNumeric().booleanValue()) {
                record_list.add((Number)fieldObject);
                continue;
            }
            if (sf.isBoolean().booleanValue()) {
                record_list.add(sf.parseBoolean(fieldObject));
                continue;
            }
            record_list.add(sf.getFieldString(rs.getObject(sf.getAlias())));
        }
    }

    public void select(RecordProcessor record_processor, RecordHandler record_handler) throws Exception {
        this.validateSelectCommand(record_processor, record_handler);
        if (record_processor.getErrors().size() > 0) {
            return;
        }
        JsonObject database_request = record_processor.getDatabaseRequest();
        if (!record_handler.selectInject(record_processor).booleanValue()) {
            return;
        }
        this.selectGson(record_processor, record_handler);
    }

    /*
     * Loose catch block
     */
    public void selectGson(RecordProcessor record_processor, RecordHandler record_handler) throws Exception {
        long t1 = System.nanoTime();
        JsonObject json = record_processor.getDatabaseRequest();
        JsonArray errors = record_processor.getErrors();
        ArrayList<Field> wf = new ArrayList<Field>();
        ArrayList<ServiceField> ss = new ArrayList<ServiceField>();
        ArrayList<String> s = JsonUtil.javaStringArrayList(JsonUtil.getJsonArray(json, "select", false));
        String vt = json.get("view").getAsString();
        JsonObject w = json.get("where").getAsJsonObject();
        ArrayList<String> v = w.get("values") == null || w.get("values").isJsonNull() ? null : new ArrayList<String>(Arrays.asList(JsonUtil.javaStringArray(w.get("values").getAsJsonArray())));
        ArrayList<Argument> ah = new ArrayList<Argument>();
        ArrayList<Argument> av = new ArrayList<Argument>();
        JsonElement jt = json.get("datasource");
        String default_datasource_name = jt == null ? record_handler.getDefaultDatasourceName() : jt.getAsString();
        String sql = this.validateSelectStatement(json, wf, vt, s, ss, v, ah, av, w, errors);
        if (errors.size() > 0) {
            errors.add("ERROR: validateSelectStatement.selectGson.validateSelectStatement");
            return;
        }
        long t2 = System.nanoTime();
        try (Connection con = record_handler.getDatabaseConnection(default_datasource_name);){
            JsonObject table_view;
            PreparedStatement preparedStmt;
            block47: {
                block48: {
                    if (!record_handler.selectPreLogic(record_processor, con).booleanValue()) {
                        return;
                    }
                    preparedStmt = con.prepareStatement(sql.toString());
                    int idx = 0;
                    for (Argument a : ah) {
                        for (String sv : a.getValues()) {
                            preparedStmt.setObject(++idx, sv);
                        }
                    }
                    for (Argument a : av) {
                        for (String sv : a.getValues()) {
                            preparedStmt.setObject(++idx, sv);
                        }
                    }
                    table_view = new JsonObject();
                    JsonArray view = null;
                    Boolean ne = false;
                    try (ResultSet rs = preparedStmt.executeQuery();){
                        ne = rs.isBeforeFirst();
                        long t3 = System.nanoTime();
                        view = new JsonArray();
                        if (vt.equalsIgnoreCase("process")) {
                            while (rs.next()) {
                                record_object = new JsonObject();
                                this.processSelectedRecord(rs, json, record_object, s, errors);
                                if (!record_handler.selectPerRecordLogic(record_processor, rs, record_object).booleanValue()) {
                                    // empty if block
                                }
                                view.getAsJsonArray().add((JsonElement)record_object);
                            }
                        } else if (vt.equalsIgnoreCase("object")) {
                            while (rs.next()) {
                                record_object = new JsonObject();
                                this.processSelectedObjectRecord(rs, json, record_object, s, ss, errors);
                                if (!record_handler.selectPerRecordLogic(record_processor, rs, record_object).booleanValue()) {
                                    // empty if block
                                }
                                view.getAsJsonArray().add((JsonElement)record_object);
                            }
                        } else if (vt.equalsIgnoreCase("array")) {
                            while (rs.next()) {
                                JsonArray record_list = new JsonArray();
                                this.processSelectedArrayRecord(rs, json, record_list, s, ss, errors);
                                if (!record_handler.selectPerRecordLogic(record_processor, rs, record_list).booleanValue()) {
                                    // empty if block
                                }
                                view.getAsJsonArray().add((JsonElement)record_list);
                            }
                        }
                        table_view.add(this.table_name, (JsonElement)view);
                        JsonArray child_view_list = new JsonArray();
                        table_view.add("children", (JsonElement)child_view_list);
                        for (int i = 0; i < this.child_table_list.size(); ++i) {
                            Table child_table = this.child_table_list.get(i);
                            child_table.selectGson(record_processor.getRecordProcessor(child_table.table_name), record_handler);
                            JsonObject child_view = record_processor.getDatabaseView();
                            child_view_list.add((JsonElement)child_view);
                        }
                    }
                    if (record_handler.selectPostLogic(record_processor, con, json, view).booleanValue() && record_handler.selectEject(record_processor).booleanValue()) break block47;
                    if (preparedStmt == null) break block48;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    preparedStmt.close();
                }
                return;
            }
            try {
                long t4 = System.nanoTime();
                if (errors.size() > 0) {
                    throw new Exception("SELECT PROGRAM INTERNAL SEQUENCE ERROR");
                }
                record_processor.setDatabaseView(table_view);
            }
            finally {
                if (preparedStmt != null) {
                    preparedStmt.close();
                }
            }
        }
    }

    public String validateInsertSetStatement(JsonObject json, JsonArray errorList) throws Exception {
        StringBuilder sql = new StringBuilder(this.insert_set_statement);
        JsonObject set = json.get("set").getAsJsonObject();
        Set keys = set.keySet();
        for (String field : keys) {
            Field f = this.getField(field);
            String value = set.get(field).getAsString();
            Integer index = sql.indexOf("?" + field);
            sql.delete(index, index + field.length() + 1);
            sql.insert((int)index, f.getQuotable(value));
        }
        return sql.toString();
    }

    public int insertValues(Connection con, PreparedStatement prepared_statement, JsonArray values, JsonObject variable, Returns returns) throws Exception {
        int affected_rows = 0;
        for (int oo = 0; oo < values.size(); ++oo) {
            String fieldValue;
            JsonElement fje;
            Field field;
            int i;
            JsonObject o = values.get(oo).getAsJsonObject();
            int idx = 0;
            for (i = 0; i < this.insert_fields.size(); ++i) {
                field = this.insert_fields.get(i);
                if (field.isPrimaryKeyAI().booleanValue() || field.isPrimaryKeyMI().booleanValue()) continue;
                fje = o.get(this.insert_fields.get(i).getAlias());
                fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                prepared_statement.setObject(++idx, field.getFieldObject(fieldValue));
            }
            if (this.hasPrimaryKeyMI().booleanValue()) {
                for (i = 0; i < this.primary_keys.size(); ++i) {
                    field = this.primary_keys.get(i);
                    if (field.isPrimaryKeyMI().booleanValue()) continue;
                    fje = o.get(field.getAlias());
                    fieldValue = fje.isJsonNull() ? null : fje.getAsString();
                    prepared_statement.setObject(++idx, field.getFieldObject(fieldValue));
                }
            }
            prepared_statement.addBatch();
        }
        int[] affectRows = prepared_statement.executeBatch();
        for (int i = 0; i < affectRows.length; ++i) {
            affected_rows += affectRows[i];
        }
        returns.Returns("t3", System.nanoTime());
        if (affected_rows > 0 && this.hasPrimaryKeyMI().booleanValue()) {
            for (int oo = 0; oo < values.size(); ++oo) {
                JsonObject o = values.get(oo).getAsJsonObject();
                if (this.insert_statement_select == null) {
                    if (variable == null) {
                        throw new Exception("Variable is Null");
                    }
                    this.createRuntimeInsertStatementSelect(variable);
                }
                try (PreparedStatement preparedInsertedSelectStmt = con.prepareStatement(this.insert_statement_select);){
                    int idx = 0;
                    for (int i = 0; i < this.insert_fields.size(); ++i) {
                        Field f = this.insert_fields.get(i);
                        if (f.isPrimaryKeyMI().booleanValue()) continue;
                        JsonElement fje = o.get(this.insert_fields.get(i).getAlias());
                        String fieldValue = fje == null || fje.isJsonNull() ? null : fje.getAsString();
                        preparedInsertedSelectStmt.setObject(++idx, f.getFieldObject(fieldValue));
                    }
                    try (ResultSet rs = preparedInsertedSelectStmt.executeQuery();){
                        while (rs.next()) {
                            for (int i = 0; i < this.primary_keys_manual_increment_fields.size(); ++i) {
                                Field f = this.primary_keys_manual_increment_fields.get(i);
                                o.addProperty(f.getAlias(), (Number)rs.getBigDecimal(f.getAlias()));
                            }
                        }
                        rs.close();
                    }
                    preparedInsertedSelectStmt.close();
                    continue;
                }
            }
        } else if (affected_rows > 0 && this.hasPrimaryKeyAI().booleanValue()) {
            try (ResultSet generatedKeys = prepared_statement.getGeneratedKeys();){
                int x = 0;
                while (generatedKeys.next()) {
                    JsonObject o = values.get(x++).getAsJsonObject();
                    int count = generatedKeys.getMetaData().getColumnCount();
                    for (int i = 0; i < count; ++i) {
                        o.addProperty(this.primary_keys.get(i).getAlias(), (Number)generatedKeys.getInt(i + 1));
                    }
                }
                generatedKeys.close();
            }
        }
        return affected_rows;
    }

    public String getInsertStatement() {
        return this.insert_statement;
    }

    public ArrayList<Field> getInsertFields() {
        return this.insert_fields;
    }

    private String getInsertSetStatement() {
        return this.insert_set_statement;
    }

    public String validateUpdateWhereStatement(String c, JsonArray v, JsonArray wff, JsonArray wvv, ArrayList<Field> uf, ArrayList<ArrayList<Object>> ufv, ArrayList<Argument> wa, ArrayList<Argument> ha, JsonArray errors) throws Exception {
        ArrayList<String> vv = wvv == null ? null : new ArrayList<String>(Arrays.asList(JsonUtil.javaStringArray(wvv.getAsJsonArray())));
        ArrayList<String> ff = wff == null ? null : new ArrayList<String>(Arrays.asList(JsonUtil.javaStringArray(wff.getAsJsonArray())));
        ArrayList<Field> wf = new ArrayList<Field>();
        StringBuilder uu = new StringBuilder();
        StringBuilder ww = new StringBuilder();
        StringBuilder hh = new StringBuilder();
        StringBuilder query = new StringBuilder(this.update_statement);
        if (!this.areValidUpdateFieldsValues(this.getFieldMap(), v, ff, this.update_fields, errors)) {
            errors.add("ERROR: validateUpdateWhereStatement.areValidUpdateFieldsValues");
            return null;
        }
        if (c == null || c.length() == 0 || ff == null && vv == null || !Table.isValidClause(Field.UPDATE, c, this.getFieldMap(), wf, vv, ww, hh, wa, ha, errors).booleanValue()) {
            errors.add("ERROR: validateUpdateWhereStatement.isValidClause");
            return null;
        }
        JsonObject job = null;
        for (int i = 0; i < v.size(); ++i) {
            String ue;
            Field f;
            int x;
            ArrayList<Object> r = new ArrayList<Object>();
            JsonObject jsonObject = v.get(i).getAsJsonObject();
            if (jsonObject == null) {
                errors.add("Null Json Object on group [" + i + "]");
            } else if (jsonObject.size() == 0) {
                errors.add("Empty Json Object on group [" + i + "]");
            } else if (job != null && jsonObject.size() != job.size()) {
                errors.add("Json Object has different elements count on group [" + i + "]");
            }
            job = jsonObject;
            if (errors.size() > 0) {
                errors.add("ERROR: validateUpdateWhereStatement.Fields");
                return null;
            }
            if (uf.size() == 0) {
                Boolean nonPrimaryKeysExists = false;
                for (String fn : jsonObject.keySet()) {
                    Field f2 = this.getField(fn);
                    if (this.primary_keys != null && this.primary_keys.contains(fn)) continue;
                    if (f2 == null && ff != null && !ff.contains(fn)) {
                        errors.add("Field '" + fn + "' is unknowen to where fields");
                        continue;
                    }
                    if (f2 == null && ff != null && ff.contains(fn)) continue;
                    if (f2 == null) {
                        errors.add("Field '" + fn + "' is not a valid field name");
                        continue;
                    }
                    if (f2.isPrimaryKey().booleanValue()) continue;
                    nonPrimaryKeysExists = true;
                    uf.add(f2);
                    if (f2.isUpdateFormulaDefined().booleanValue()) {
                        uu.append(f2.getSQLName()).append("=").append(f2.getUpdateFormulaDefined()).append(",");
                        continue;
                    }
                    uu.append(f2.getSQLName()).append("=?, ");
                }
                if (!nonPrimaryKeysExists.booleanValue()) {
                    errors.add("Update abortred, no update can be performed over primary keys only record");
                } else {
                    uu.delete(uu.length() - 2, uu.length());
                }
                if (errors.size() > 0) {
                    errors.add("ERROR: validateUpdateWhereStatement.UPDATE_ABORTED");
                    return null;
                }
            }
            StringBuilder er = new StringBuilder();
            for (x = 0; x < uf.size(); ++x) {
                f = uf.get(x);
                if (!f.isValid(Field.UPDATE, ue = JsonUtil.getJsonString(jsonObject, f.getAlias(), (Boolean)false), er).booleanValue()) {
                    errors.add(er.toString() + ", check in group index[" + (i + 1) + "]");
                    continue;
                }
                String preProcessedValue = f.getPreProcessedValue(Field.UPDATE, ue, errors);
                if (errors.size() > 0) {
                    errors.add("ERROR: validateUpdateWhereStatement.PRE_PROCESS");
                    return null;
                }
                r.add(f.getFieldObject(preProcessedValue));
            }
            if (errors.size() > 0) continue;
            for (x = jsonObject.size(); x < wf.size() + jsonObject.size(); ++x) {
                f = wf.get(x - jsonObject.size());
                ue = null;
                ue = ff == null ? JsonUtil.getJsonString(wvv, x - jsonObject.size(), (Boolean)false) : JsonUtil.getJsonString(jsonObject, wff.get(x - jsonObject.size()).getAsString(), (Boolean)false);
                if (!f.isValid(Field.UPDATE, ue, er).booleanValue()) {
                    errors.add(er.toString());
                    continue;
                }
                r.add(f.getFieldObject(ue));
            }
            ufv.add(r);
        }
        if (errors.size() > 0) {
            errors.add("ERROR: validateUpdateWhereStatement.FIELD_VALIDATION");
            return null;
        }
        int idx = query.indexOf("$UPDATE$");
        query.replace(idx, idx + 8, "");
        if (uu != null && uu.length() > 0) {
            query.insert(idx, uu);
        }
        idx = query.indexOf("$WHERE$");
        query.replace(idx, idx + 7, "");
        if (ww != null && ww.length() > 0) {
            query.insert(idx, ww.length() == 0 ? "" : " WHERE ");
            query.insert(idx + 7, ww);
        }
        if (hh != null && hh.length() > 0) {
            query.insert(idx, hh.length() == 0 ? "" : " WHERE ");
            query.insert(idx + 7, hh);
        }
        return query.toString();
    }

    public String validateDeleteWhereStatement(String c, JsonArray v, JsonArray wff, JsonArray wvv, ArrayList<Field> uf, ArrayList<ArrayList<Object>> ufv, ArrayList<Argument> wa, ArrayList<Argument> ha, JsonArray errors) throws Exception {
        StringBuilder w;
        ArrayList<String> vv = wvv == null ? null : new ArrayList<String>(Arrays.asList(JsonUtil.javaStringArray(wvv.getAsJsonArray())));
        ArrayList<String> ff = wff == null ? null : new ArrayList<String>(Arrays.asList(JsonUtil.javaStringArray(wff.getAsJsonArray())));
        ArrayList<Field> wf = new ArrayList<Field>();
        StringBuilder uu = new StringBuilder();
        StringBuilder ww = new StringBuilder();
        StringBuilder hh = new StringBuilder();
        StringBuilder query = new StringBuilder(this.delete_statement);
        if (c == null || c.length() == 0 || ff == null && vv == null || !Table.isValidClause(Field.INSERT, c, this.getFieldMap(), wf, vv, ww, hh, wa, ha, errors).booleanValue()) {
            errors.add("ERROR: validateUpdateWhereStatement.validateDeleteWhereStatement.isValidClause");
            return null;
        }
        JsonObject job = null;
        for (int i = 0; i < v.size(); ++i) {
            Field f;
            ArrayList<Object> r = new ArrayList<Object>();
            JsonObject jsonObject = v.get(i).getAsJsonObject();
            if (jsonObject == null) {
                errors.add("Null Json Object on group [" + i + "]");
            } else if (jsonObject.size() == 0) {
                errors.add("Empty Json Object on group [" + i + "]");
            } else if (job != null && jsonObject.size() != job.size()) {
                errors.add("Json Object has different elements count on group [" + i + "]");
            }
            job = jsonObject;
            if (errors.size() > 0) {
                errors.add("ERROR: validateUpdateWhereStatement.validateDeleteWhereStatement.Fields");
                return null;
            }
            if (uf.size() == 0) {
                for (String alias : jsonObject.keySet()) {
                    f = this.getField(alias);
                    if (f == null && ff != null && !ff.contains(alias)) {
                        errors.add("Field '" + alias + "' is unknowen to where fields");
                        continue;
                    }
                    if (f == null && ff != null && ff.contains(alias)) continue;
                    if (f == null) {
                        errors.add("Field '" + alias + "' is not a valid field name");
                        continue;
                    }
                    uf.add(f);
                }
                if (errors.size() > 0) {
                    errors.add("ERROR: validateUpdateWhereStatement.validateDeleteWhereStatement.PRE_PROCESS");
                    return null;
                }
            }
            StringBuilder er = new StringBuilder();
            for (int x = jsonObject.size(); x < wf.size() + jsonObject.size(); ++x) {
                f = wf.get(x - jsonObject.size());
                String ue = null;
                ue = ff == null ? JsonUtil.getJsonString(wvv, x - jsonObject.size(), (Boolean)false) : JsonUtil.getJsonString(jsonObject, wff.get(x - jsonObject.size()).getAsString(), (Boolean)false);
                if (!f.isValid(Field.DELETE, ue, er).booleanValue()) {
                    errors.add(er.toString());
                    continue;
                }
                r.add(f.getFieldObject(ue));
            }
            ufv.add(r);
        }
        if (errors.size() > 0) {
            errors.add("ERROR: validateUpdateWhereStatement.validateDeleteWhereStatement.FIELD_VALIDATION");
            return null;
        }
        int idx = -1;
        idx = query.indexOf("$WHERE$");
        query.replace(idx, idx + 7, "");
        StringBuilder stringBuilder = w = ww != null && ww.length() > 0 ? ww : hh;
        if (w != null) {
            query.insert(idx, w.length() == 0 ? "" : " WHERE ");
            query.insert(idx + 7, w);
        }
        return query.toString();
    }

    public static void loadDataModel(JDBCSource model_jdbc_source, JDBCSource data_jdbc_source, Integer model_id, JsonArray errors) throws Exception {
        ModelDefinition data_model_definition;
        DataLookup data_lookup;
        DataClass.LoadMethod loadMethod;
        Integer model_instance_id;
        block45: {
            model_instance_id = 1;
            loadMethod = DataClass.LoadMethod.REFLECTION;
            data_lookup = null;
            data_model_definition = null;
            try (Connection data_connection = model_jdbc_source.getConnection(false);){
                String select_model = "SELECT `id`, `name`, `version`, `description`, `database_name`, `data_lookup_category`, `source_url`, `source_url_user_name`, CAST(AES_DECRYPT(FROM_BASE64(`source_url_user_password`), 'SystemHesabatSecretKey') AS CHAR) AS `source_url_user_password`, `model_url`, `instance_sequence_type_id`, `instance_sequence_last_value`, `root_class_path`, `model_database_schem`, `model_database_field_open_quote`, `model_database_field_close_quote` FROM `" + model_jdbc_source.getDatabaseName() + "`.`model` WHERE `id`=?";
                try (PreparedStatement stmt = data_connection.prepareStatement(select_model);){
                    stmt.setInt(1, model_id);
                    try (ResultSet rs = stmt.executeQuery();){
                        ArrayList<ModelDefinition> data_model_definition_list = JsonResultset.resultset(rs, ModelDefinition.class);
                        if (data_model_definition_list == null || data_model_definition_list.size() == 0) {
                            errors.add("Data Model ID '" + model_id + "' is not exist");
                        } else {
                            data_model_definition = data_model_definition_list.get(0);
                        }
                        rs.close();
                    }
                    stmt.close();
                }
                if (data_model_definition == null) break block45;
                String sql = "SELECT `enum_name`, `enum_element_id`, `enum_element_code`, `enum_element_java_datatype`, `enum_element_typescript_datatype` FROM `" + model_jdbc_source.getDatabaseName() + "`.`lookup_enum` INNER JOIN `" + model_jdbc_source.getDatabaseName() + "`.`lookup_enum_element` ON `lookup_enum`.`enum_id` = `lookup_enum_element`.`enum_id` WHERE `lookup_enum`.`enum_name`=? ORDER BY `enum_name`, `enum_element_code`";
                try (PreparedStatement stmt = data_connection.prepareStatement(sql);){
                    stmt.setString(1, data_model_definition.data_lookup_category);
                    try (ResultSet rs = stmt.executeQuery();){
                        data_lookup = new DataLookup(rs, data_model_definition.data_lookup_category, "enum_name", "enum_element_id", "enum_element_code", "enum_element_java_datatype", "enum_element_typescript_datatype");
                        rs.close();
                    }
                }
            }
        }
        if (data_model_definition != null) {
            DataProcessor dataProcessor = new DataProcessor(EnterpriseModel.class, Enterprise.class, model_jdbc_source, data_jdbc_source, data_model_definition, data_lookup);
            EnterpriseModel enterprise_model = (EnterpriseModel)dataProcessor.loadModelFromDatabase(model_jdbc_source, model_instance_id, loadMethod);
            ((Enterprise)enterprise_model.getInstance()).init();
            data_model_map.put(model_id, enterprise_model);
        }
    }

    private void initializeTable(Integer model_id) throws Exception {
        EnterpriseModel<Enterprise> enterprise_model = data_model_map.get(model_id);
        net.reyadeyat.relational.api.model.Table database_table = ((Enterprise)enterprise_model.getInstance()).getDatabase(this.database_name).getTable(this.table_name);
        for (net.reyadeyat.relational.api.model.Field table_field : database_table.fields) {
            String field_alias = table_field.name;
            FieldType field_type = FieldType.getClassFieldType(table_field.getTypeJavaClass());
            Boolean nullable = table_field.nullable;
            Boolean group = false;
            String field_name = table_field.name;
            Field field = this.addField(field_alias, field_type, nullable, group, field_name);
            if (table_field.getTypeJavaClass().equals(String.class)) {
                field.setTexLengthRange(0, table_field.size);
                continue;
            }
            if (!table_field.getTypeJavaClass().equals(Number.class)) continue;
            field.setNumberRange(0, table_field.size);
        }
    }

    private void validateSelectCommand(RecordProcessor record_processor, RecordHandler record_handler) throws Exception {
        String datasource_name;
        JsonObject database_request = record_processor.getDatabaseRequest();
        if (database_request.get("engine") == null || database_request.get("engine").isJsonNull()) {
            record_processor.addError("Select command misses 'engin' property");
        } else if (database_request.get("view") == null || database_request.get("view").isJsonNull()) {
            record_processor.addError("Select command misses 'view' property");
        } else if (database_request.get("select") == null || database_request.get("select").isJsonNull()) {
            record_processor.addError("Select command misses 'select' array");
        } else if (!database_request.get("select").isJsonArray()) {
            record_processor.addError("Select command has 'select' object while 'select' must be array");
        } else if (database_request.get("where") == null || database_request.get("where").isJsonNull()) {
            record_processor.addError("Select command misses 'where' compound object");
        } else if (database_request.get("where").getAsJsonObject().get("clause") == null || database_request.get("where").getAsJsonObject().get("clause").isJsonNull()) {
            record_processor.addError("Select command misses 'where.clause' property");
        } else if (database_request.get("where").getAsJsonObject().get("values") == null || database_request.get("where").getAsJsonObject().get("values").isJsonNull()) {
            record_processor.addError("Select command misses 'where.values' array");
        } else if (database_request.get("orderby") == null || database_request.get("orderby").isJsonNull()) {
            record_processor.addError("Select command misses 'orderby' array");
        }
        JsonElement jt = database_request.get("engine");
        String engine = jt == null ? null : jt.getAsString();
        jt = database_request.get("view");
        String view = jt == null ? null : jt.getAsString();
        jt = database_request.get("datasource");
        String string = datasource_name = jt == null ? null : jt.getAsString();
        if (datasource_name == null) {
            datasource_name = record_handler.getDefaultDatasourceName();
            database_request.addProperty("datasource", datasource_name);
        }
        if (record_handler.getDataSource(datasource_name) == null) {
            record_processor.addError("Datasource '" + datasource_name + "' not pooled on this container!");
        }
        if (!engine.equalsIgnoreCase("memory") && !engine.equalsIgnoreCase("stream")) {
            record_processor.addError("Undefined engine type '" + engine + "' define ['memory', 'stream']");
        }
        if (!(view.equalsIgnoreCase("object") || view.equalsIgnoreCase("array") || view.equalsIgnoreCase("process"))) {
            record_processor.addError("Undefined view type '" + view + "' define ['object', 'array', 'process']");
        }
        if (!engine.equalsIgnoreCase("memory") && view.equalsIgnoreCase("process")) {
            record_processor.addError("engine 'memory' is required for 'process' view");
        }
    }

    private void validateDeleteCommand(RecordProcessor record_processor) throws Exception {
        JsonObject database_request = record_processor.getDatabaseRequest();
        if (database_request.get("values") == null || database_request.get("values").isJsonNull()) {
            record_processor.addError("Delete command misses 'values' array");
        } else if (!database_request.get("values").isJsonArray()) {
            record_processor.addError("Delete command has 'values' object while 'values' must be array");
        } else if (database_request.get("values").getAsJsonArray().size() == 0) {
            record_processor.addError("Delete command has an empyt 'values' array");
        } else if (database_request.get("where") == null || database_request.get("where").isJsonNull()) {
            record_processor.addError("Delete command misses 'where' compound object");
        } else if (database_request.get("where").getAsJsonObject().get("clause") == null || database_request.get("where").getAsJsonObject().get("clause").isJsonNull()) {
            record_processor.addError("Delete command misses 'where.clause' object");
        } else if ((database_request.get("where").getAsJsonObject().get("values") == null || database_request.get("where").getAsJsonObject().get("values").isJsonNull()) && (database_request.get("where").getAsJsonObject().get("fields") == null || database_request.get("where").getAsJsonObject().get("fields").isJsonNull())) {
            record_processor.addError("Delete command misses but shall have either 'where.values' or 'where.fields' compound object");
        }
    }
}

