/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.reyadeyat.relational.api.database.Field;

public class UpdateKey {
    private String database_name;
    private String update_table;
    private ArrayList<Field> fields;
    private HashMap<Field, String> updateFields;
    private String updating_validation_statement;

    public UpdateKey(String database_name, String update_table) {
        this.database_name = database_name;
        this.update_table = update_table;
    }

    public void addUpdateField(Field field, String updateField) {
        this.updateFields.put(field, updateField);
    }

    public String getUpdateField(Field field) {
        return this.updateFields.get(field);
    }

    public void prepareUpdatingStatement() {
        StringBuilder sb = new StringBuilder();
        this.fields = new ArrayList<Field>(this.updateFields.keySet());
        Collections.sort(this.fields);
        sb.append("SELECT * FROM ").append("`").append(this.database_name).append("`.`").append(this.update_table).append("` WHERE ");
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            String updateFieldName = this.updateFields.get(field);
            sb.append("`").append(this.update_table).append("`.`").append(updateFieldName).append("`=?").append(i + 1 == this.fields.size() ? "" : " AND ");
        }
        this.updating_validation_statement = sb.toString();
    }

    public String getUpdateValidationStatement() {
        return this.updating_validation_statement;
    }
}

