/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.relational.api.model.Field;
import net.reyadeyat.relational.api.model.ForeignKeyField;
import net.reyadeyat.relational.api.model.PrimaryKey;
import net.reyadeyat.relational.api.model.ReferencedKeyField;
import net.reyadeyat.relational.api.model.Table;

public class ForeignKey {
    public String name;
    public String referencedKeyname;
    public String foreignKeyTableName;
    public String referencedKeyTableName;
    public transient HashMap<ForeignKeyField, ReferencedKeyField> foreign_key_referenced_key_map;
    public ArrayList<ForeignKeyField> foreignKeyFields = new ArrayList();
    public ArrayList<ReferencedKeyField> referencedKeyFields = new ArrayList();
    public Integer key_sequence;
    public String update_rule;
    public String delete_rule;
    public String deferrability;
    public transient Boolean caseSensitiveSql;
    public transient Table table;
    public transient PrimaryKey primaryKey;

    public ForeignKey() {
        this.foreign_key_referenced_key_map = new HashMap();
    }

    public ForeignKey(Table table, String name, String referencedKeyname, String referencedKeyTableName, String foreignKeyTableName, Integer key_sequence, String update_rule, String delete_rule, String deferrability, Boolean caseSensitiveSql) throws Exception {
        this();
        this.table = table;
        this.name = name;
        this.referencedKeyname = referencedKeyname;
        this.foreignKeyTableName = foreignKeyTableName;
        this.referencedKeyTableName = referencedKeyTableName;
        this.key_sequence = key_sequence;
        this.update_rule = update_rule;
        this.delete_rule = delete_rule;
        this.deferrability = deferrability;
        this.caseSensitiveSql = caseSensitiveSql;
        switch (Integer.parseInt(this.update_rule)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new Exception("Unhandled Delete Rule ['" + update_rule + "']");
            }
        }
        switch (Integer.parseInt(this.delete_rule)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new Exception("Unhandled Delete Rule ['" + update_rule + "']");
            }
        }
    }

    public void addForeignFieldReferencedField(ForeignKeyField foreignKeyField, ReferencedKeyField referencedKeyField) {
        this.foreign_key_referenced_key_map.put(foreignKeyField, referencedKeyField);
        this.addReferencedField(referencedKeyField);
        this.addForeignField(foreignKeyField);
        for (Field field : this.table.fields) {
            if (!field.name.equalsIgnoreCase(foreignKeyField.name)) continue;
            field.setForeignReference();
        }
    }

    public void addReferencedField(ReferencedKeyField referencedKeyField) {
        this.referencedKeyFields.add(referencedKeyField);
    }

    public void addForeignField(ForeignKeyField foreignKeyField) {
        this.foreignKeyFields.add(foreignKeyField);
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        try {
            this.toString(appendable, 0, 4);
            return appendable.toString();
        }
        catch (Exception exception) {
            appendable.delete(0, appendable.length());
            appendable.append("toString '").append(this.name).append("' error").append(exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
            return appendable.toString();
        }
    }

    public void toString(Appendable appendable, Integer level, Integer shift) throws Exception {
        int i;
        appendable.append("\n");
        for (i = 0; i < level * shift; ++i) {
            appendable.append(" ");
        }
        appendable.append("|");
        for (i = 0; i < shift - 1; ++i) {
            appendable.append(".");
        }
        appendable.append("Foreign Key CONSTRAINT `");
        appendable.append(this.name);
        appendable.append("` FOREIGN KEY ");
        appendable.append("(");
        i = 1;
        for (ForeignKeyField foreignKeyFieldName : this.foreignKeyFields) {
            appendable.append("`");
            appendable.append(foreignKeyFieldName.name);
            if (++i >= this.foreignKeyFields.size()) continue;
            appendable.append("`,");
        }
        appendable.append(") REFERENCES");
        appendable.append(" `");
        appendable.append(this.referencedKeyTableName);
        appendable.append("` (");
        i = 1;
        for (ReferencedKeyField referencedKeyFieldName : this.referencedKeyFields) {
            appendable.append("`");
            appendable.append(referencedKeyFieldName.name);
            if (++i >= this.foreignKeyFields.size()) continue;
            appendable.append("`,");
        }
        appendable.append(") ");
        appendable.append(this.getUpdateRule());
        appendable.append(" ");
        appendable.append(this.getDeleteRule());
    }

    public void toString(Appendable appendable) throws Exception {
        appendable.append("Foreign Key CONSTRAINT `");
        appendable.append(this.name);
        appendable.append("` FOREIGN KEY ");
        appendable.append("(");
        int i = 1;
        for (ForeignKeyField foreignKeyFieldName : this.foreignKeyFields) {
            appendable.append("`");
            appendable.append(foreignKeyFieldName.name);
            if (++i >= this.foreignKeyFields.size()) continue;
            appendable.append("`,");
        }
        appendable.append(") REFERENCES");
        appendable.append(" `");
        appendable.append(this.referencedKeyTableName);
        appendable.append("` (");
        i = 1;
        for (ReferencedKeyField referencedKeyFieldName : this.referencedKeyFields) {
            appendable.append("`");
            appendable.append(referencedKeyFieldName.name);
            if (++i >= this.foreignKeyFields.size()) continue;
            appendable.append("`,");
        }
        appendable.append(") ");
        appendable.append(this.getUpdateRule());
        appendable.append(" ");
        appendable.append(this.getDeleteRule());
    }

    private String getDeleteRule() {
        switch (Integer.parseInt(this.delete_rule)) {
            case 1: {
                return "ON DELETE RESTRICT";
            }
            case 2: {
                return "ON DELETE SET NULL";
            }
            case 3: {
                return "ON DELETE NO ACTION";
            }
        }
        return "ON DELETE CASCADE";
    }

    private String getUpdateRule() {
        switch (Integer.parseInt(this.update_rule)) {
            case 1: {
                return "ON UPDATE RESTRICT";
            }
            case 2: {
                return "ON UPDATE SET NULL";
            }
            case 3: {
                return "ON UPDATE NO ACTION";
            }
        }
        return "ON UPDATE CASCADE";
    }
}

