/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.request;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.reyadeyat.relational.api.database.RecordHandler;
import net.reyadeyat.relational.api.database.RecordProcessor;
import net.reyadeyat.relational.api.database.Table;
import net.reyadeyat.relational.api.json.JsonUtil;

public abstract class RelationalRequest
implements RecordHandler {
    private Table table;

    protected JsonElement serviceContent(InputStream json_request_stream, OutputStream response_output_stream) throws Exception {
        Gson gson = JsonUtil.gson();
        JsonElement json_request = null;
        try (JsonReader json_reader = new JsonReader((Reader)new InputStreamReader(json_request_stream, StandardCharsets.UTF_8));){
            json_request = (JsonElement)gson.fromJson(json_reader, JsonElement.class);
        }
        catch (Exception exception) {
            JsonUtil.reclaimGson(gson);
            throw exception;
        }
        JsonUtil.reclaimGson(gson);
        return json_request;
    }

    public void serviceTransaction(Integer security_flag, Connection jdbc_connection, InputStream json_request_stream, OutputStream response_output_stream, String valid_transaction_type, JsonArray log_list, JsonArray error_list) throws Exception {
        JsonElement json_request = this.serviceContent(json_request_stream, response_output_stream);
        this.serviceTransaction(security_flag, json_request, response_output_stream, jdbc_connection, valid_transaction_type, log_list, error_list);
    }

    public void serviceTransaction(Integer security_flag, JsonElement json_request, OutputStream response_output_stream, Connection jdbc_connection, String valid_transaction_type, JsonArray log_list, JsonArray error_list) throws Exception {
        String transactionType;
        if (json_request == null) {
            error_list.add("Bad Request, Non JSON received => " + json_request.toString());
            return;
        }
        JsonObject jsonObject = json_request.getAsJsonObject();
        String string = transactionType = jsonObject.get("transaction") == null ? null : jsonObject.get("transaction").getAsString();
        if (transactionType == null || !valid_transaction_type.contains(transactionType)) {
            error_list.add("Bad Request, invalid transaction [" + transactionType + "] - valid transactions are [" + valid_transaction_type + "]");
            return;
        }
        if (this.table == null) {
            error_list.add("Internal System Error, Contact Adminstrator, uninitialized 'transaction_type' is null");
            return;
        }
        JsonObject database_request = json_request.getAsJsonObject();
        log_list.add("Start-Process");
        RecordProcessor record_processor = new RecordProcessor(database_request, response_output_stream);
        log_list.add("End-Process");
    }

    protected void defineService(String servlet_name, String default_datasource_name, String database_name, String table_tree_string) throws Exception {
        JsonObject table_tree = JsonUtil.jsonStringToJsonElelement(table_tree_string).getAsJsonObject();
        this.defineService(servlet_name, default_datasource_name, database_name, table_tree);
    }

    protected void defineService(String servlet_name, String default_datasource_name, String database_name, JsonObject table_tree) throws Exception {
        try {
            if (default_datasource_name == null || default_datasource_name.length() == 0) {
                throw new Exception("Default Source Name can not be null");
            }
            String model_data_source_name = JsonUtil.getJsonString(table_tree, "model_data_source_name", (Boolean)false);
            String model_data_database_name = JsonUtil.getJsonString(table_tree, "model_data_database_name", (Boolean)false);
            Integer model_id = JsonUtil.getJsonInteger(table_tree, "model_id", (Boolean)false);
            DataSource model_data_source = this.getDataSource(model_data_source_name);
            JsonArray error_list = new JsonArray();
            if (error_list.size() > 0) {
                // empty if block
            }
            this.table = new Table(model_id, null, database_name, table_tree);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error: defineServlet '" + servlet_name + "'", ex);
            throw ex;
        }
    }
}

