/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.sequence;

import java.util.HashMap;
import net.reyadeyat.relational.api.sequence.Sequence;

public class SequenceNumber<Type extends Number>
implements Sequence<Type> {
    private HashMap<Class, SequenceNumberItem> sequenceClassMap = new HashMap();
    private Boolean synchronize;
    private Type sequence_initial_value;
    private Type sequence_increment;

    public SequenceNumber(Type sequence_initial_value, Type sequence_increment, Boolean synchronize) {
        this.sequence_initial_value = sequence_initial_value;
        this.sequence_increment = sequence_increment;
        this.synchronize = synchronize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSequence(Class clas) throws Exception {
        if (clas == null) {
            throw new Exception("Sequence Class can not be null value");
        }
        if (this.synchronize.booleanValue()) {
            HashMap<Class, SequenceNumberItem> hashMap = this.sequenceClassMap;
            synchronized (hashMap) {
                if (this.sequenceClassMap.containsKey(clas)) {
                    return;
                }
                this.sequenceClassMap.put(clas, new SequenceNumberItem((Number)this.sequence_initial_value, (Number)this.sequence_initial_value, (Number)this.sequence_increment));
                return;
            }
        }
        if (this.sequenceClassMap.containsKey(clas)) {
            return;
        }
        this.sequenceClassMap.put(clas, new SequenceNumberItem((Number)this.sequence_initial_value, (Number)this.sequence_initial_value, (Number)this.sequence_increment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initSequence(Class clas, Type value) throws Exception {
        SequenceNumberItem sni;
        if (clas == null) {
            throw new Exception("Sequence Class can not be null value");
        }
        if (value == null) {
            throw new Exception("Sequence initial value can not be null value");
        }
        if (this.synchronize.booleanValue()) {
            HashMap<Class, SequenceNumberItem> hashMap = this.sequenceClassMap;
            synchronized (hashMap) {
                SequenceNumberItem sni2 = this.sequenceClassMap.get(clas);
                if (sni2 == null) {
                    this.sequenceClassMap.put(clas, new SequenceNumberItem((Number)this.sequence_initial_value, (Number)value, (Number)this.sequence_increment));
                } else {
                    sni2.initSequence(value);
                }
            }
        }
        if ((sni = this.sequenceClassMap.get(clas)) == null) {
            this.sequenceClassMap.put(clas, new SequenceNumberItem((Number)this.sequence_initial_value, (Number)value, (Number)this.sequence_increment));
        } else {
            sni.initSequence(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean hasSequence(Class clas) throws Exception {
        if (clas == null) {
            throw new Exception("Sequence Class can not be null value");
        }
        if (this.synchronize.booleanValue()) {
            HashMap<Class, SequenceNumberItem> hashMap = this.sequenceClassMap;
            synchronized (hashMap) {
                return this.sequenceClassMap.containsKey(clas);
            }
        }
        return this.sequenceClassMap.containsKey(clas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type nextSequence(Class clas) throws Exception {
        if (clas == null) {
            throw new Exception("Sequence Class can not be null value");
        }
        SequenceNumberItem si = this.sequenceClassMap.get(clas);
        if (si == null) {
            throw new NullPointerException("Class '" + String.valueOf(clas) + "' is not defined in this sequence");
        }
        if (this.synchronize.booleanValue()) {
            SequenceNumberItem sequenceNumberItem = si;
            synchronized (sequenceNumberItem) {
                return si.nextSequence();
            }
        }
        return si.nextSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getSequenceState(Class clas) throws Exception {
        SequenceNumberItem si = this.sequenceClassMap.get(clas);
        if (si == null) {
            throw new NullPointerException("Class '" + String.valueOf(clas) + "' is not defined in this sequence");
        }
        if (this.synchronize.booleanValue()) {
            SequenceNumberItem sequenceNumberItem = si;
            synchronized (sequenceNumberItem) {
                return si.getLastSequenceIssued();
            }
        }
        return si.getLastSequenceIssued();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<Class, Type> getSequenceState() throws Exception {
        if (this.synchronize.booleanValue()) {
            HashMap<Class, SequenceNumberItem> hashMap = this.sequenceClassMap;
            synchronized (hashMap) {
                HashMap sequenceClassMapState = new HashMap();
                for (Class key : this.sequenceClassMap.keySet()) {
                    sequenceClassMapState.put(key, this.sequenceClassMap.get(key).getLastSequenceIssued());
                }
                return sequenceClassMapState;
            }
        }
        HashMap sequenceClassMapState = new HashMap();
        for (Class key : this.sequenceClassMap.keySet()) {
            sequenceClassMapState.put(key, this.sequenceClassMap.get(key).getLastSequenceIssued());
        }
        return sequenceClassMapState;
    }

    private class SequenceNumberItem {
        private Number sequence_initial_number;
        private Number sequence_value;
        private Number increment;
        private Boolean rewind;
        private Class type;

        public SequenceNumberItem(Number sequence_initial_number, Number sequence_start_value, Number increment) {
            this.sequence_initial_number = sequence_initial_number;
            this.sequence_value = sequence_start_value;
            this.increment = increment;
            this.type = this.sequence_value.getClass();
        }

        public Type nextSequence() throws Exception {
            if (this.type.equals(Byte.class)) {
                if (((Number)SequenceNumber.this.sequence_initial_value).byteValue() + this.increment.byteValue() >= 127) {
                    if (this.rewind.booleanValue()) {
                        this.sequence_value = this.sequence_initial_number;
                    } else {
                        throw new Exception("Buffer Overflow; Sequence is full Byte[127]; rewind is disabled.");
                    }
                }
                this.sequence_value = this.sequence_value.byteValue() + this.increment.byteValue();
            } else if (this.type.equals(Short.class)) {
                if (((Number)SequenceNumber.this.sequence_initial_value).byteValue() + this.increment.byteValue() >= Short.MAX_VALUE) {
                    if (this.rewind.booleanValue()) {
                        this.sequence_value = this.sequence_initial_number;
                    } else {
                        throw new Exception("Buffer Overflow; Sequence is full Short[32767]; rewind is disabled.");
                    }
                }
                this.sequence_value = this.sequence_value.shortValue() + this.increment.shortValue();
            } else if (this.type.equals(Integer.class)) {
                if (((Number)SequenceNumber.this.sequence_initial_value).byteValue() + this.increment.byteValue() >= Integer.MAX_VALUE) {
                    if (this.rewind.booleanValue()) {
                        this.sequence_value = this.sequence_initial_number;
                    } else {
                        throw new Exception("Buffer Overflow; Sequence is full Integer[2147483647]; rewind is disabled.");
                    }
                }
                this.sequence_value = this.sequence_value.intValue() + this.increment.intValue();
            } else if (this.type.equals(Long.class)) {
                if ((long)(((Number)SequenceNumber.this.sequence_initial_value).byteValue() + this.increment.byteValue()) >= Long.MAX_VALUE) {
                    if (this.rewind.booleanValue()) {
                        this.sequence_value = this.sequence_initial_number;
                    } else {
                        throw new Exception("Buffer Overflow; Sequence is full Long[9223372036854775807]; rewind is disabled.");
                    }
                }
                this.sequence_value = this.sequence_value.longValue() + this.increment.longValue();
            } else if (this.type.equals(Double.class)) {
                if ((double)(((Number)SequenceNumber.this.sequence_initial_value).byteValue() + this.increment.byteValue()) >= Double.MAX_VALUE) {
                    if (this.rewind.booleanValue()) {
                        this.sequence_value = this.sequence_initial_number;
                    } else {
                        throw new Exception("Buffer Overflow; Sequence is full Double[1.7976931348623157E308]; rewind is disabled.");
                    }
                }
                this.sequence_value = this.sequence_value.doubleValue() + this.increment.doubleValue();
            } else if (this.type.equals(Float.class)) {
                if ((float)(((Number)SequenceNumber.this.sequence_initial_value).byteValue() + this.increment.byteValue()) >= Float.MAX_VALUE) {
                    if (this.rewind.booleanValue()) {
                        this.sequence_value = this.sequence_initial_number;
                    } else {
                        throw new Exception("Buffer Overflow; Sequence is full Float[3.4028235E38]; rewind is disabled.");
                    }
                }
                this.sequence_value = Float.valueOf(this.sequence_value.floatValue() + this.increment.floatValue());
            }
            return this.sequence_value;
        }

        public void initSequence(Type value) {
            this.sequence_value = value;
        }

        public Type getLastSequenceIssued() {
            return this.sequence_value;
        }
    }
}

