/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.reyadeyat.relational.api.database.Field;

public class JoinKey {
    private String key;
    private String database_name;
    private String primary_table;
    private String join_table;
    private String join_table_alias;
    private JoinType join_type;
    private HashMap<Field, String> joinFields;
    private String join_statement;

    public JoinKey(String key, String database_name, String primary_table, String join_table, JoinType join_type) {
        this(key, database_name, primary_table, join_table, null, join_type);
    }

    public JoinKey(String key, String database_name, String primary_table, String join_table, String join_table_alias, JoinType join_type) {
        this.key = key;
        this.database_name = database_name;
        this.primary_table = primary_table;
        this.join_table = join_table;
        this.join_table_alias = join_table_alias;
        this.join_type = join_type;
        this.joinFields = new HashMap();
    }

    public String getKey() {
        return this.key;
    }

    public void addJoinField(Field field, String joinField) {
        this.joinFields.put(field, joinField);
    }

    public String getJoinField(Field field) {
        return this.joinFields.get(field);
    }

    public void prepareJoinStatement() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Field> fields = new ArrayList<Field>(this.joinFields.keySet());
        Collections.sort(fields);
        if (this.join_table_alias == null) {
            sb.append(this.join_type == JoinType.INNER_JOIN ? " INNER JOIN " : (this.join_type == JoinType.LEFT_JOIN ? " LEFT JOIN " : "RIGHT JOIN")).append("`").append(this.database_name).append("`.`").append(this.join_table).append("` ON ");
        } else {
            sb.append(this.join_type == JoinType.INNER_JOIN ? " INNER JOIN " : (this.join_type == JoinType.LEFT_JOIN ? " LEFT JOIN " : "RIGHT JOIN")).append("`").append(this.database_name).append("`.`").append(this.join_table).append("` AS `").append(this.join_table_alias).append("` ON ");
        }
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            String joinFieldName = this.joinFields.get(field);
            sb.append("`").append(this.join_table_alias == null ? this.join_table : this.join_table_alias).append("`.`").append(joinFieldName).append("`=`").append(this.primary_table).append("`.`").append(field.getName()).append("`").append(i + 1 == fields.size() ? "" : " AND ");
        }
        this.join_statement = sb.toString();
    }

    public String getJoinStatement() {
        return this.join_statement;
    }

    public static enum JoinType {
        INNER_JOIN,
        LEFT_JOIN,
        RIGHT_JOIN;

    }
}

