/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.database;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.OutputStream;
import net.reyadeyat.relational.api.request.Response;
import net.reyadeyat.relational.api.util.Returns;

public class RecordProcessor {
    public OutputStream response_output_stream;
    public JsonObject database_request;
    public JsonArray errors;
    public int affected_rows;
    public Boolean is_empty_view;
    public JsonObject view;
    public Response response;
    public Returns returns;

    public RecordProcessor(JsonObject database_request, OutputStream response_output_stream) {
        this.response_output_stream = response_output_stream;
        this.database_request = database_request;
        this.errors = new JsonArray();
        this.is_empty_view = true;
        this.affected_rows = 0;
        this.returns = new Returns();
    }

    public RecordProcessor getRecordProcessor(String table_name) {
        JsonObject table_database_request = this.database_request.get(table_name).getAsJsonObject();
        return new RecordProcessor(table_database_request, this.response_output_stream);
    }

    public OutputStream getResponseOutputStream() {
        return this.response_output_stream;
    }

    public JsonObject getDatabaseRequest() {
        return this.database_request;
    }

    public JsonArray addError(String error) {
        this.errors.add(error);
        return this.errors;
    }

    public JsonArray getErrors() {
        return this.errors;
    }

    public void setDatabaseView(JsonObject view) {
        this.view = view;
    }

    public JsonObject getDatabaseView() {
        return this.view;
    }

    public Boolean isEmptyView() {
        return this.view.size() == 0;
    }

    public void setAffectedRows(int affected_rows) {
        this.affected_rows = affected_rows;
    }

    public Integer getAffectedRows() {
        return this.affected_rows;
    }

    public <T> void addReturns(String key, T value) {
        this.returns.Returns(key, value);
    }

    public Returns getReturns() {
        return this.returns;
    }
}

