/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;

public class JsonDateAdapter
extends TypeAdapter<Date> {
    static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public void write(JsonWriter writer, Date date) throws IOException {
        if (date == null) {
            writer.nullValue();
        } else {
            writer.value(sdf.format(date));
        }
    }

    public Date read(JsonReader reader) throws IOException {
        String date_text = null;
        try {
            date_text = reader.nextString();
            if (date_text == null) {
                return null;
            }
            return new Date(sdf.parse(date_text).getTime());
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception: Parsing Json Date '" + date_text + "'", ex);
        }
    }
}

