/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.SimpleDateFormat;

public class JsonTimeAdapter
extends TypeAdapter<Time> {
    static final SimpleDateFormat stf = new SimpleDateFormat("hh:mm:ss");

    public void write(JsonWriter writer, Time time) throws IOException {
        if (time == null) {
            writer.nullValue();
        } else {
            writer.value(stf.format(time));
        }
    }

    public Time read(JsonReader reader) throws IOException {
        String time_text = null;
        try {
            time_text = reader.nextString();
            if (time_text == null) {
                return null;
            }
            return new Time(stf.parse(time_text).getTime());
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception: Parsing Json Date '" + time_text + "'", ex);
        }
    }
}

