/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class JsonTimestampAdapter
extends TypeAdapter<Timestamp> {
    static final SimpleDateFormat stf = new SimpleDateFormat("hh:mm:ss");

    public void write(JsonWriter writer, Timestamp timestamp) throws IOException {
        if (timestamp == null) {
            writer.nullValue();
        } else {
            writer.value(stf.format(timestamp));
        }
    }

    public Timestamp read(JsonReader reader) throws IOException {
        String timestamp_text = null;
        try {
            timestamp_text = reader.nextString();
            if (timestamp_text == null) {
                return null;
            }
            return new Timestamp(stf.parse(timestamp_text).getTime());
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception: Parsing Json Date '" + timestamp_text + "'", ex);
        }
    }
}

