/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.model;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.relational.api.annotation.MetadataAnnotation;
import net.reyadeyat.relational.api.model.Database;

@XmlRootElement(name="Enterprise")
public class Enterprise {
    @MetadataAnnotation(field=true, type="VARCHAR(256)")
    public String name;
    public String database_engine;
    @MetadataAnnotation(field=true, type="LONGTEXT", indexed=false, indexed_expresion="((SUBSTRING(`databaseUrl`, 1, 64)))")
    public String database_url;
    public Boolean case_sensitive_sql;
    public ArrayList<Database> databases = new ArrayList();
    public transient TreeMap<String, Database> database_map = new TreeMap();

    public Enterprise() {
    }

    public Enterprise(String name, String database_engine, String database_url, Boolean case_sensitive_sql) {
        this();
        this.name = name;
        this.database_engine = database_engine;
        this.database_url = database_url;
        this.case_sensitive_sql = case_sensitive_sql;
    }

    public void init() {
        for (Database database : this.databases) {
            database.init();
            this.database_map.put(database.name, database);
        }
    }

    public void addDatabase(Database database) {
        database.enterprise = this;
        this.databases.add(database);
        this.database_map.put(database.name, database);
    }

    public Database getDatabase(String database_name) {
        return this.database_map.get(database_name);
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        try {
            this.toString(appendable, 0, 4);
            return appendable.toString();
        }
        catch (Exception exception) {
            appendable.delete(0, appendable.length());
            appendable.append("Enterprise: ").append(this.name).append(" : Databases [").append(this.databases.size()).append("]");
            appendable.append("toString error").append(exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "toString error", exception);
            return appendable.toString();
        }
    }

    public void toString(Appendable appendable) throws Exception {
        this.toString(appendable, 0, 4);
    }

    public void toString(Appendable appendable, Integer level, Integer shift) throws Exception {
        int i;
        appendable.append("\n");
        for (i = 0; i < level * shift; ++i) {
            appendable.append(" ");
        }
        appendable.append("|");
        for (i = 0; i < shift - 1; ++i) {
            appendable.append(".");
        }
        appendable.append("Enterprise: ").append(this.name).append(" Databases [").append(String.valueOf(this.databases.size())).append("]");
        for (Database database : this.databases) {
            database.toString(appendable, level + 1, shift);
        }
    }
}

