/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.model;

import com.google.gson.JsonElement;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import net.reyadeyat.relational.api.annotation.MetadataAnnotation;
import net.reyadeyat.relational.api.data.DataLookup;
import net.reyadeyat.relational.api.model.Table;

public class Field {
    public String name;
    @MetadataAnnotation(lookup=true)
    public String dataTypeName;
    public Boolean primary_key;
    public Boolean nullable;
    public Boolean autoIncrment;
    public Boolean foreign_reference;
    @MetadataAnnotation(field=true, nullable=true)
    public String defaultValue;
    public Integer list_order;
    public Integer size;
    public Integer decimalDigits;
    public transient Boolean caseSensitiveSql;
    public transient Table table;

    public Field() {
    }

    public Field(Table table, String name, String dataTypeName, String dataTypeCode, Boolean nullable, Boolean autoIncrment, String defaultValue, Integer list_order, Integer size, Integer decimalDigits, Boolean caseSensitiveSql, DataLookup dataLookup) throws Exception {
        this.table = table;
        this.name = name;
        this.dataTypeName = dataTypeName.trim();
        if (dataLookup.lookupID(this.dataTypeName) == null) {
            throw new Exception("Data Type '" + this.dataTypeName + "' is not defined in Lookup Category '" + dataLookup.getDataLookupCategory() + "'");
        }
        this.primary_key = false;
        this.nullable = nullable;
        this.autoIncrment = autoIncrment;
        this.foreign_reference = false;
        this.defaultValue = defaultValue;
        this.list_order = list_order;
        this.size = size;
        this.decimalDigits = decimalDigits;
        this.caseSensitiveSql = caseSensitiveSql;
    }

    public void init() {
    }

    public void setPrimaryKey() {
        this.primary_key = true;
    }

    public void setForeignReference() {
        this.foreign_reference = true;
    }

    public String toString(Integer level, Integer shift) {
        int i;
        StringBuilder b = new StringBuilder();
        b.append("\n");
        for (i = 0; i < level * shift; ++i) {
            b.append(" ");
        }
        b.append("|");
        for (i = 0; i < shift - 1; ++i) {
            b.append(".");
        }
        b.append("Field: ").append("[").append(this.list_order).append("] `").append(this.name).append("` ").append(this.dataTypeName).append("(").append(this.size).append((String)(this.decimalDigits > 0 ? "," + this.decimalDigits : "")).append(")").append(this.nullable == true ? " NULL" : "").append(this.autoIncrment == true ? " AUTOINCREMENT" : "").append((String)(this.defaultValue == null ? "" : " DEFAULT '" + this.defaultValue + "'"));
        return b.toString();
    }

    public String toString() {
        return "Field: " + "[" + this.list_order + "] `" + this.name + "` " + this.dataTypeName + "(" + this.size + (String)(this.decimalDigits > 0 ? "," + this.decimalDigits : "") + ")" + (this.nullable == true ? " NULL" : "") + (this.autoIncrment == true ? " AUTOINCREMENT" : "") + (String)(this.defaultValue == null ? "" : " '" + this.defaultValue + "'");
    }

    public String getTypeJavaClassPath() throws Exception {
        if (this.dataTypeName.equalsIgnoreCase("TINYINT") || this.dataTypeName.equalsIgnoreCase("TINYINT UNSIGNED") && this.size == 1 || this.dataTypeName.equalsIgnoreCase("BOOLEAN")) {
            return Boolean.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("TINYINT") || this.dataTypeName.equalsIgnoreCase("TINYINT UNSIGNED")) {
            return Byte.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("SMALLINT") || this.dataTypeName.equalsIgnoreCase("SMALLINT UNSIGNED")) {
            return Short.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("MEDIUMINT") || this.dataTypeName.equalsIgnoreCase("INT") || this.dataTypeName.equalsIgnoreCase("INTEGER") || this.dataTypeName.equalsIgnoreCase("MEDIUMINT UNSIGNED") || this.dataTypeName.equalsIgnoreCase("INT UNSIGNED") || this.dataTypeName.equalsIgnoreCase("INTEGER UNSIGNED") || this.dataTypeName.equalsIgnoreCase("BIT") || this.dataTypeName.equalsIgnoreCase("BIT UNSIGNED") || this.dataTypeName.equalsIgnoreCase("INT IDENTITY") || this.dataTypeName.equalsIgnoreCase("SERIAL")) {
            return Integer.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("BIGINT") || this.dataTypeName.equalsIgnoreCase("BIGINT UNSIGNED") || this.dataTypeName.equalsIgnoreCase("BIGINT IDENTITY") || this.dataTypeName.equalsIgnoreCase("SERIAL8") || this.dataTypeName.equalsIgnoreCase("INT8") || this.dataTypeName.equalsIgnoreCase("BIGSERIAL")) {
            return Long.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("FLOAT") || this.dataTypeName.equalsIgnoreCase("FLOAT UNSIGNED")) {
            return Float.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("DOUBLE") || this.dataTypeName.equalsIgnoreCase("DOUBLE UNSIGNED")) {
            return Double.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("NUMERIC") || this.dataTypeName.equalsIgnoreCase("DECIMAL") || this.dataTypeName.equalsIgnoreCase("NUMERIC UNSIGNED") || this.dataTypeName.equalsIgnoreCase("DECIMAL UNSIGNED") || this.dataTypeName.equalsIgnoreCase("UNIQUEIDENTIFIER") || this.dataTypeName.equalsIgnoreCase("MONEY") || this.dataTypeName.equalsIgnoreCase("numeric() identity")) {
            if (this.decimalDigits == 0) {
                return Long.class.getCanonicalName();
            }
            return Double.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("YEAR") || this.dataTypeName.equalsIgnoreCase("DATE")) {
            return Date.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("TIME")) {
            return Time.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("DATETIME") || this.dataTypeName.equalsIgnoreCase("TIMESTAMP") || this.dataTypeName.equalsIgnoreCase("SMALLDATETIME") || this.dataTypeName.toLowerCase().startsWith("datetime")) {
            return Timestamp.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("CHAR") || this.dataTypeName.equalsIgnoreCase("ENUM") || this.dataTypeName.equalsIgnoreCase("SET") || this.dataTypeName.equalsIgnoreCase("VARCHAR") || this.dataTypeName.equalsIgnoreCase("TINYTEXT") || this.dataTypeName.equalsIgnoreCase("TEXT") || this.dataTypeName.equalsIgnoreCase("MEDIUMTEXT") || this.dataTypeName.equalsIgnoreCase("LONGTEXT") || this.dataTypeName.equalsIgnoreCase("NVARCHAR") || this.dataTypeName.equalsIgnoreCase("NTEXT") || this.dataTypeName.equalsIgnoreCase("NCHAR") || this.dataTypeName.equalsIgnoreCase("SYSNAME") || this.dataTypeName.equalsIgnoreCase("GEOGRAPHY") || this.dataTypeName.equalsIgnoreCase("LVARCHAR")) {
            return String.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("BINARY") || this.dataTypeName.equalsIgnoreCase("VARBINARY") || this.dataTypeName.equalsIgnoreCase("TINYBLOB") || this.dataTypeName.equalsIgnoreCase("BLOB") || this.dataTypeName.equalsIgnoreCase("CLOB") || this.dataTypeName.equalsIgnoreCase("MEDIUMBLOB") || this.dataTypeName.equalsIgnoreCase("LONGBLOB") || this.dataTypeName.equalsIgnoreCase("IMAGE")) {
            return Object.class.getCanonicalName();
        }
        if (this.dataTypeName.equalsIgnoreCase("JSON")) {
            return JsonElement.class.getCanonicalName();
        }
        throw new Exception("Field data type '" + this.dataTypeName + "' is not implemented yet");
    }

    public Class getTypeJavaClass() throws Exception {
        if (this.dataTypeName.equalsIgnoreCase("TINYINT") || this.dataTypeName.equalsIgnoreCase("TINYINT UNSIGNED") && this.size == 1 || this.dataTypeName.equalsIgnoreCase("BOOLEAN")) {
            return Boolean.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("TINYINT") || this.dataTypeName.equalsIgnoreCase("TINYINT UNSIGNED")) {
            return Byte.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("SMALLINT") || this.dataTypeName.equalsIgnoreCase("SMALLINT UNSIGNED")) {
            return Short.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("MEDIUMINT") || this.dataTypeName.equalsIgnoreCase("INT") || this.dataTypeName.equalsIgnoreCase("INTEGER") || this.dataTypeName.equalsIgnoreCase("MEDIUMINT UNSIGNED") || this.dataTypeName.equalsIgnoreCase("INT UNSIGNED") || this.dataTypeName.equalsIgnoreCase("INTEGER UNSIGNED") || this.dataTypeName.equalsIgnoreCase("BIT") || this.dataTypeName.equalsIgnoreCase("BIT UNSIGNED") || this.dataTypeName.equalsIgnoreCase("INT IDENTITY") || this.dataTypeName.equalsIgnoreCase("SERIAL")) {
            return Integer.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("BIGINT") || this.dataTypeName.equalsIgnoreCase("BIGINT UNSIGNED") || this.dataTypeName.equalsIgnoreCase("BIGINT IDENTITY") || this.dataTypeName.equalsIgnoreCase("SERIAL8") || this.dataTypeName.equalsIgnoreCase("INT8") || this.dataTypeName.equalsIgnoreCase("BIGSERIAL")) {
            return Long.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("FLOAT") || this.dataTypeName.equalsIgnoreCase("FLOAT UNSIGNED")) {
            return Float.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("DOUBLE") || this.dataTypeName.equalsIgnoreCase("DOUBLE UNSIGNED")) {
            return Double.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("NUMERIC") || this.dataTypeName.equalsIgnoreCase("DECIMAL") || this.dataTypeName.equalsIgnoreCase("NUMERIC UNSIGNED") || this.dataTypeName.equalsIgnoreCase("DECIMAL UNSIGNED") || this.dataTypeName.equalsIgnoreCase("UNIQUEIDENTIFIER") || this.dataTypeName.equalsIgnoreCase("MONEY") || this.dataTypeName.equalsIgnoreCase("numeric() identity")) {
            if (this.decimalDigits == 0) {
                return Long.class;
            }
            return Double.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("YEAR") || this.dataTypeName.equalsIgnoreCase("DATE")) {
            return Date.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("TIME")) {
            return Time.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("DATETIME") || this.dataTypeName.equalsIgnoreCase("TIMESTAMP") || this.dataTypeName.equalsIgnoreCase("SMALLDATETIME") || this.dataTypeName.toLowerCase().startsWith("datetime")) {
            return Timestamp.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("CHAR") || this.dataTypeName.equalsIgnoreCase("ENUM") || this.dataTypeName.equalsIgnoreCase("SET") || this.dataTypeName.equalsIgnoreCase("VARCHAR") || this.dataTypeName.equalsIgnoreCase("TINYTEXT") || this.dataTypeName.equalsIgnoreCase("TEXT") || this.dataTypeName.equalsIgnoreCase("MEDIUMTEXT") || this.dataTypeName.equalsIgnoreCase("LONGTEXT") || this.dataTypeName.equalsIgnoreCase("NVARCHAR") || this.dataTypeName.equalsIgnoreCase("NTEXT") || this.dataTypeName.equalsIgnoreCase("NCHAR") || this.dataTypeName.equalsIgnoreCase("SYSNAME") || this.dataTypeName.equalsIgnoreCase("GEOGRAPHY") || this.dataTypeName.equalsIgnoreCase("LVARCHAR")) {
            return String.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("BINARY") || this.dataTypeName.equalsIgnoreCase("VARBINARY") || this.dataTypeName.equalsIgnoreCase("TINYBLOB") || this.dataTypeName.equalsIgnoreCase("BLOB") || this.dataTypeName.equalsIgnoreCase("CLOB") || this.dataTypeName.equalsIgnoreCase("MEDIUMBLOB") || this.dataTypeName.equalsIgnoreCase("LONGBLOB") || this.dataTypeName.equalsIgnoreCase("IMAGE")) {
            return Object.class;
        }
        if (this.dataTypeName.equalsIgnoreCase("JSON")) {
            return JsonElement.class;
        }
        throw new Exception("Field data type '" + this.dataTypeName + "' is not implemented yet");
    }
}

