/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.relational.api.util;

import java.awt.Color;
import java.util.HashMap;

public class NamedColor {
    private static HashMap<String, NamedColor> colorMap = new HashMap<String, NamedColor>(){
        {
            this.put("aliceblue", new NamedColor("AliceBlue", 240, 248, 255));
            this.put("antiquewhite", new NamedColor("AntiqueWhite", 250, 235, 215));
            this.put("aqua", new NamedColor("Aqua", 0, 255, 255));
            this.put("aquamarine", new NamedColor("Aquamarine", 127, 255, 212));
            this.put("azure", new NamedColor("Azure", 240, 255, 255));
            this.put("beige", new NamedColor("Beige", 245, 245, 220));
            this.put("bisque", new NamedColor("Bisque", 255, 228, 196));
            this.put("black", new NamedColor("Black", 0, 0, 0));
            this.put("blanchedalmond", new NamedColor("BlanchedAlmond", 255, 235, 205));
            this.put("blue", new NamedColor("Blue", 0, 0, 255));
            this.put("blueviolet", new NamedColor("BlueViolet", 138, 43, 226));
            this.put("brown", new NamedColor("Brown", 165, 42, 42));
            this.put("burlywood", new NamedColor("BurlyWood", 222, 184, 135));
            this.put("cadetblue", new NamedColor("CadetBlue", 95, 158, 160));
            this.put("chartreuse", new NamedColor("Chartreuse", 127, 255, 0));
            this.put("chocolate", new NamedColor("Chocolate", 210, 105, 30));
            this.put("coral", new NamedColor("Coral", 255, 127, 80));
            this.put("cornflowerblue", new NamedColor("CornflowerBlue", 100, 149, 237));
            this.put("cornsilk", new NamedColor("Cornsilk", 255, 248, 220));
            this.put("crimson", new NamedColor("Crimson", 220, 20, 60));
            this.put("cyan", new NamedColor("Cyan", 0, 255, 255));
            this.put("darkblue", new NamedColor("DarkBlue", 0, 0, 139));
            this.put("darkcyan", new NamedColor("DarkCyan", 0, 139, 139));
            this.put("darkgoldenrod", new NamedColor("DarkGoldenRod", 184, 134, 11));
            this.put("darkgray", new NamedColor("DarkGray", 169, 169, 169));
            this.put("darkgreen", new NamedColor("DarkGreen", 0, 100, 0));
            this.put("darkkhaki", new NamedColor("DarkKhaki", 189, 183, 107));
            this.put("darkmagenta", new NamedColor("DarkMagenta", 139, 0, 139));
            this.put("darkolivegreen", new NamedColor("DarkOliveGreen", 85, 107, 47));
            this.put("darkorange", new NamedColor("DarkOrange", 255, 140, 0));
            this.put("darkorchid", new NamedColor("DarkOrchid", 153, 50, 204));
            this.put("darkred", new NamedColor("DarkRed", 139, 0, 0));
            this.put("darksalmon", new NamedColor("DarkSalmon", 233, 150, 122));
            this.put("darkseagreen", new NamedColor("DarkSeaGreen", 143, 188, 143));
            this.put("darkslateblue", new NamedColor("DarkSlateBlue", 72, 61, 139));
            this.put("darkslategray", new NamedColor("DarkSlateGray", 47, 79, 79));
            this.put("darkturquoise", new NamedColor("DarkTurquoise", 0, 206, 209));
            this.put("darkviolet", new NamedColor("DarkViolet", 148, 0, 211));
            this.put("deeppink", new NamedColor("DeepPink", 255, 20, 147));
            this.put("deepskyblue", new NamedColor("DeepSkyBlue", 0, 191, 255));
            this.put("dimgray", new NamedColor("DimGray", 105, 105, 105));
            this.put("dodgerblue", new NamedColor("DodgerBlue", 30, 144, 255));
            this.put("firebrick", new NamedColor("FireBrick", 178, 34, 34));
            this.put("floralwhite", new NamedColor("FloralWhite", 255, 250, 240));
            this.put("forestgreen", new NamedColor("ForestGreen", 34, 139, 34));
            this.put("fuchsia", new NamedColor("Fuchsia", 255, 0, 255));
            this.put("gainsboro", new NamedColor("Gainsboro", 220, 220, 220));
            this.put("ghostwhite", new NamedColor("GhostWhite", 248, 248, 255));
            this.put("gold", new NamedColor("Gold", 255, 215, 0));
            this.put("goldenrod", new NamedColor("GoldenRod", 218, 165, 32));
            this.put("gray", new NamedColor("Gray", 128, 128, 128));
            this.put("green", new NamedColor("Green", 0, 255, 0));
            this.put("greenyellow", new NamedColor("GreenYellow", 173, 255, 47));
            this.put("honeydew", new NamedColor("HoneyDew", 240, 255, 240));
            this.put("hotpink", new NamedColor("HotPink", 255, 105, 180));
            this.put("indianred", new NamedColor("IndianRed", 205, 92, 92));
            this.put("indigo", new NamedColor("Indigo", 75, 0, 130));
            this.put("ivory", new NamedColor("Ivory", 255, 255, 240));
            this.put("khaki", new NamedColor("Khaki", 240, 230, 140));
            this.put("lavender", new NamedColor("Lavender", 230, 230, 250));
            this.put("lavenderblush", new NamedColor("LavenderBlush", 255, 240, 245));
            this.put("lawngreen", new NamedColor("LawnGreen", 124, 252, 0));
            this.put("lemonchiffon", new NamedColor("LemonChiffon", 255, 250, 205));
            this.put("lightblue", new NamedColor("LightBlue", 173, 216, 230));
            this.put("lightcoral", new NamedColor("LightCoral", 240, 128, 128));
            this.put("lightcyan", new NamedColor("LightCyan", 224, 255, 255));
            this.put("lightgoldenrodyellow", new NamedColor("LightGoldenRodYellow", 250, 250, 210));
            this.put("lightgray", new NamedColor("LightGray", 211, 211, 211));
            this.put("lightgreen", new NamedColor("LightGreen", 144, 238, 144));
            this.put("lightpink", new NamedColor("LightPink", 255, 182, 193));
            this.put("lightsalmon", new NamedColor("LightSalmon", 255, 160, 122));
            this.put("lightseagreen", new NamedColor("LightSeaGreen", 32, 178, 170));
            this.put("lightskyblue", new NamedColor("LightSkyBlue", 135, 206, 250));
            this.put("lightslategray", new NamedColor("LightSlateGray", 119, 136, 153));
            this.put("lightsteelblue", new NamedColor("LightSteelBlue", 176, 196, 222));
            this.put("lightyellow", new NamedColor("LightYellow", 255, 255, 224));
            this.put("lime", new NamedColor("Lime", 0, 255, 0));
            this.put("limegreen", new NamedColor("LimeGreen", 50, 205, 50));
            this.put("linen", new NamedColor("Linen", 250, 240, 230));
            this.put("magenta", new NamedColor("Magenta", 255, 0, 255));
            this.put("maroon", new NamedColor("Maroon", 128, 0, 0));
            this.put("mediumaquamarine", new NamedColor("MediumAquaMarine", 102, 205, 170));
            this.put("mediumblue", new NamedColor("MediumBlue", 0, 0, 205));
            this.put("mediumorchid", new NamedColor("MediumOrchid", 186, 85, 211));
            this.put("mediumpurple", new NamedColor("MediumPurple", 147, 112, 219));
            this.put("mediumseagreen", new NamedColor("MediumSeaGreen", 60, 179, 113));
            this.put("mediumslateblue", new NamedColor("MediumSlateBlue", 123, 104, 238));
            this.put("mediumspringgreen", new NamedColor("MediumSpringGreen", 0, 250, 154));
            this.put("mediumturquoise", new NamedColor("MediumTurquoise", 72, 209, 204));
            this.put("mediumvioletred", new NamedColor("MediumVioletRed", 199, 21, 133));
            this.put("midnightblue", new NamedColor("MidnightBlue", 25, 25, 112));
            this.put("mintcream", new NamedColor("MintCream", 245, 255, 250));
            this.put("mistyrose", new NamedColor("MistyRose", 255, 228, 225));
            this.put("moccasin", new NamedColor("Moccasin", 255, 228, 181));
            this.put("navajowhite", new NamedColor("NavajoWhite", 255, 222, 173));
            this.put("navy", new NamedColor("Navy", 0, 0, 128));
            this.put("oldlace", new NamedColor("OldLace", 253, 245, 230));
            this.put("olive", new NamedColor("Olive", 128, 128, 0));
            this.put("olivedrab", new NamedColor("OliveDrab", 107, 142, 35));
            this.put("orange", new NamedColor("Orange", 255, 165, 0));
            this.put("orangered", new NamedColor("OrangeRed", 255, 69, 0));
            this.put("orchid", new NamedColor("Orchid", 218, 112, 214));
            this.put("palegoldenrod", new NamedColor("PaleGoldenRod", 238, 232, 170));
            this.put("palegreen", new NamedColor("PaleGreen", 152, 251, 152));
            this.put("paleturquoise", new NamedColor("PaleTurquoise", 175, 238, 238));
            this.put("palevioletred", new NamedColor("PaleVioletRed", 219, 112, 147));
            this.put("papayawhip", new NamedColor("PapayaWhip", 255, 239, 213));
            this.put("peachpuff", new NamedColor("PeachPuff", 255, 218, 185));
            this.put("peru", new NamedColor("Peru", 205, 133, 63));
            this.put("pink", new NamedColor("Pink", 255, 192, 203));
            this.put("plum", new NamedColor("Plum", 221, 160, 221));
            this.put("powderblue", new NamedColor("PowderBlue", 176, 224, 230));
            this.put("purple", new NamedColor("Purple", 128, 0, 128));
            this.put("red", new NamedColor("Red", 255, 0, 0));
            this.put("rosybrown", new NamedColor("RosyBrown", 188, 143, 143));
            this.put("royalblue", new NamedColor("RoyalBlue", 65, 105, 225));
            this.put("saddlebrown", new NamedColor("SaddleBrown", 139, 69, 19));
            this.put("salmon", new NamedColor("Salmon", 250, 128, 114));
            this.put("sandybrown", new NamedColor("SandyBrown", 244, 164, 96));
            this.put("seagreen", new NamedColor("SeaGreen", 46, 139, 87));
            this.put("seashell", new NamedColor("SeaShell", 255, 245, 238));
            this.put("sienna", new NamedColor("Sienna", 160, 82, 45));
            this.put("silver", new NamedColor("Silver", 192, 192, 192));
            this.put("skyblue", new NamedColor("SkyBlue", 135, 206, 235));
            this.put("slateblue", new NamedColor("SlateBlue", 106, 90, 205));
            this.put("slategray", new NamedColor("SlateGray", 112, 128, 144));
            this.put("snow", new NamedColor("Snow", 255, 250, 250));
            this.put("springgreen", new NamedColor("SpringGreen", 0, 255, 127));
            this.put("steelblue", new NamedColor("SteelBlue", 70, 130, 180));
            this.put("tan", new NamedColor("Tan", 210, 180, 140));
            this.put("teal", new NamedColor("Teal", 0, 128, 128));
            this.put("thistle", new NamedColor("Thistle", 216, 191, 216));
            this.put("tomato", new NamedColor("Tomato", 255, 99, 71));
            this.put("turquoise", new NamedColor("Turquoise", 64, 224, 208));
            this.put("violet", new NamedColor("Violet", 238, 130, 238));
            this.put("wheat", new NamedColor("Wheat", 245, 222, 179));
            this.put("white", new NamedColor("White", 255, 255, 255));
            this.put("whitesmoke", new NamedColor("WhiteSmoke", 245, 245, 245));
            this.put("yellow", new NamedColor("Yellow", 255, 255, 0));
            this.put("yellowgreen", new NamedColor("YellowGreen", 154, 205, 50));
        }
    };
    public int red;
    public int green;
    public int blue;
    public int color;
    public String name;
    public String nameL;
    public Color newColor;

    public NamedColor(String name, String cssColor) throws Exception {
        if (!cssColor.startsWith("#")) {
            throw new Exception("Invalid CSS color");
        }
        int red = Integer.parseInt(cssColor.substring(1, 3), 16);
        int green = Integer.parseInt(cssColor.substring(3, 5), 16);
        int blue = Integer.parseInt(cssColor.substring(5, 7), 16);
        this.setColor(name, red, green, blue);
    }

    public NamedColor(String name, int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.setColor(name, red, green, blue);
    }

    private void setColor(String name, int red, int green, int blue) {
        this.name = name;
        this.nameL = name.toLowerCase();
        this.color = 0;
        this.color |= red << 16;
        this.color |= green << 8;
        this.color |= blue;
        this.newColor = new Color(red, green, blue);
        if (colorMap != null && !colorMap.containsKey(this.nameL)) {
            colorMap.put(this.nameL, this);
        }
    }

    public static int getRGB(String colorName) {
        String colorname = colorName.toLowerCase();
        if (!colorMap.containsKey(colorname.toLowerCase())) {
            return 0;
        }
        NamedColor namedColor = colorMap.get(colorname.toLowerCase());
        return namedColor.color;
    }

    public static Color getColor(String colorName) {
        String colorname = colorName.toLowerCase();
        if (!colorMap.containsKey(colorname.toLowerCase())) {
            return null;
        }
        NamedColor namedColor = colorMap.get(colorname.toLowerCase());
        return namedColor.newColor;
    }

    public static NamedColor get(String colorName) {
        return colorMap.get(colorName.toLowerCase());
    }

    public Color getColor() {
        return this.newColor;
    }
}

