/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.commons.ip;

import java.math.BigInteger;
import net.ripe.commons.ip.AsnRange;
import net.ripe.commons.ip.RangeUtils;
import net.ripe.commons.ip.SingleInternetResource;
import net.ripe.commons.ip.Validate;

public final class Asn
implements SingleInternetResource<Asn, AsnRange>,
Comparable<Asn> {
    private static final long serialVersionUID = -1L;
    private static final int SIXTEEN = 16;
    private static final int THIRTY_TWO = 32;
    public static final long ASN_MIN_VALUE = 0L;
    public static final long ASN_16_BIT_MAX_VALUE = 65535L;
    public static final long ASN_32_BIT_MAX_VALUE = 0xFFFFFFFFL;
    public static final Asn FIRST_ASN = Asn.of(0L);
    public static final Asn LAST_16_BIT_ASN = Asn.of(65535L);
    public static final Asn LAST_32_BIT_ASN = Asn.of(0xFFFFFFFFL);
    public static final int NUMBER_OF_BITS = 32;
    private final long value;

    public Asn(Long value) {
        this.value = Validate.notNull(value, "value is required");
        RangeUtils.checkRange(this.value, 0L, 0xFFFFFFFFL);
    }

    long value() {
        return this.value;
    }

    public static Asn of(Long value) {
        return new Asn(value);
    }

    public static Asn of(String value) {
        return Asn.parse(value);
    }

    public static Asn parse(String text) {
        try {
            long low;
            String asnString = Validate.notNull(text, "AS Number must not be null").trim().toUpperCase();
            if (asnString.startsWith("AS")) {
                asnString = asnString.substring(2);
            }
            long high = 0L;
            int indexOfDot = asnString.indexOf(46);
            if (indexOfDot != -1) {
                low = RangeUtils.checkRange(Long.valueOf(asnString.substring(indexOfDot + 1)), 0L, 65535L);
                high = RangeUtils.checkRange(Long.valueOf(asnString.substring(0, indexOfDot)), 0L, 65535L);
            } else {
                low = Long.valueOf(asnString);
            }
            return new Asn(high << 16 | low);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid AS number: '" + text + "'. Details: " + ex.getMessage(), ex);
        }
    }

    public boolean is16Bit() {
        return this.compareTo(LAST_16_BIT_ASN) <= 0;
    }

    public boolean is32Bit() {
        return !this.is16Bit();
    }

    @Override
    public int compareTo(Asn other) {
        return this.value > other.value ? 1 : (this.value < other.value ? -1 : 0);
    }

    @Override
    public Asn next() {
        return new Asn(this.value + 1L);
    }

    @Override
    public Asn previous() {
        return new Asn(this.value - 1L);
    }

    @Override
    public boolean hasNext() {
        return this.compareTo(LAST_32_BIT_ASN) < 0;
    }

    @Override
    public boolean hasPrevious() {
        return this.compareTo(FIRST_ASN) > 0;
    }

    public String toString() {
        return "AS" + this.value;
    }

    @Override
    public AsnRange asRange() {
        return new AsnRange(this, this);
    }

    @Override
    public int bitSize() {
        return 32;
    }

    @Override
    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Asn that = (Asn)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

