/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.commons.ip;

import java.math.BigInteger;
import java.util.Collection;
import net.ripe.commons.ip.AbstractRange;
import net.ripe.commons.ip.Ipv6;
import net.ripe.commons.ip.Ipv6Range;
import net.ripe.commons.ip.Optional;
import net.ripe.commons.ip.PrefixFinder;
import net.ripe.commons.ip.PrefixUtils;

public class ConservativePrefixFinder
extends PrefixFinder {
    public static ConservativePrefixFinder newInstance() {
        return new ConservativePrefixFinder();
    }

    private ConservativePrefixFinder() {
        super(new ConservativeStrategy());
    }

    private static class ConservativeStrategy
    implements PrefixFinder.Strategy {
        private ConservativeStrategy() {
        }

        @Override
        public Ipv6Range findPrefixOrNull(int prefixLength, Collection<Ipv6Range> ranges) {
            BigInteger desiredPrefixSize = BigInteger.valueOf(2L).pow(128 - prefixLength);
            AbstractRange foundPrefix = null;
            BigInteger currentSize = null;
            for (Ipv6Range freeBlock : ranges) {
                Optional<Ipv6Range> smallestPrefix;
                if (freeBlock.size().compareTo(desiredPrefixSize) < 0 || !(smallestPrefix = PrefixUtils.findMinimumPrefixForPrefixLength(freeBlock, prefixLength)).isPresent()) continue;
                Ipv6Range candidatePrefix = smallestPrefix.get();
                BigInteger candidateSize = candidatePrefix.size();
                if (foundPrefix != null && candidateSize.compareTo(currentSize) >= 0) continue;
                foundPrefix = candidatePrefix;
                currentSize = candidateSize;
            }
            return foundPrefix == null ? null : Ipv6Range.from((Ipv6)foundPrefix.start()).andPrefixLength(prefixLength);
        }
    }
}

