/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.commons.ip;

import java.math.BigInteger;
import net.ripe.commons.ip.AbstractIp;
import net.ripe.commons.ip.Ipv4Range;
import net.ripe.commons.ip.RangeUtils;
import net.ripe.commons.ip.Validate;

public final class Ipv4
extends AbstractIp<Ipv4, Ipv4Range> {
    private static final long serialVersionUID = -1L;
    public static final int BYTE_MASK = 255;
    public static final int NUMBER_OF_BITS = 32;
    public static final long MINIMUM_VALUE = 0L;
    public static final long MAXIMUM_VALUE = 0xFFFFFFFFL;
    public static final Ipv4 FIRST_IPV4_ADDRESS = Ipv4.of(0L);
    public static final Ipv4 LAST_IPV4_ADDRESS = Ipv4.of(0xFFFFFFFFL);
    private static final int TOTAL_OCTETS = 4;
    private static final int MAX_OCTET_VALUE = 255;
    private static final int MIN_OCTET_VALUE = 0;
    private static final int THREE_OCTETS = 24;
    private static final int TWO_OCTETS = 16;
    private static final int ONE_OCTET = 8;
    private static final String DEFAULT_PARSING_ERROR_MESSAGE = "Invalid IPv4 address: ";
    private final Long value;

    protected Ipv4(Long value) {
        this.value = Validate.notNull(value, "value is required");
        Validate.isTrue(value.compareTo(0L) >= 0, "Value of IPv4 has to be greater than or equal to 0");
        Validate.isTrue(value.compareTo(0xFFFFFFFFL) <= 0, "Value of IPv4 has to be less than or equal to 4294967295");
    }

    long value() {
        return this.value;
    }

    public static Ipv4 of(BigInteger from) {
        if (from == null) {
            throw new IllegalArgumentException("from cannot be null");
        }
        return new Ipv4(from.longValue());
    }

    public static Ipv4 of(Long value) {
        return new Ipv4(value);
    }

    public static Ipv4 of(String value) {
        return Ipv4.parse(value);
    }

    public static Ipv4 parse(String ipv4Address) {
        String ipv4String = Validate.notNull(ipv4Address, DEFAULT_PARSING_ERROR_MESSAGE + ipv4Address).trim();
        Validate.isTrue(!ipv4String.isEmpty() && Character.isDigit(ipv4String.charAt(0)) && Character.isDigit(ipv4String.charAt(ipv4String.length() - 1)), DEFAULT_PARSING_ERROR_MESSAGE + ipv4Address);
        long value = 0L;
        int octet = 0;
        int octetCount = 1;
        for (int i = 0; i < ipv4String.length(); ++i) {
            char ch = ipv4String.charAt(i);
            if (Character.isDigit(ch)) {
                octet = octet * 10 + (ch - 48);
                continue;
            }
            if (ch == '.') {
                Validate.isTrue(octetCount < 4, DEFAULT_PARSING_ERROR_MESSAGE + ipv4String);
                ++octetCount;
                value = Ipv4.addOctet(value, octet);
                octet = 0;
                continue;
            }
            throw new IllegalArgumentException(DEFAULT_PARSING_ERROR_MESSAGE + ipv4String);
        }
        Validate.isTrue(octetCount == 4, DEFAULT_PARSING_ERROR_MESSAGE + ipv4String);
        return new Ipv4(Ipv4.addOctet(value, octet));
    }

    private static long addOctet(long value, int octet) {
        RangeUtils.checkRange(octet, 0, 255);
        return value << 8 | (long)octet;
    }

    @Override
    public int compareTo(Ipv4 other) {
        return this.value.compareTo(other.value);
    }

    public String toString() {
        int a = (int)(this.value >> 24);
        int b = (int)(this.value >> 16) & 0xFF;
        int c = (int)(this.value >> 8) & 0xFF;
        int d = (int)(this.value & 0xFFL);
        return a + "." + b + "." + c + "." + d;
    }

    @Override
    public Ipv4 next() {
        return new Ipv4(this.value + 1L);
    }

    @Override
    public Ipv4 previous() {
        return new Ipv4(this.value - 1L);
    }

    @Override
    public boolean hasNext() {
        return this.compareTo(LAST_IPV4_ADDRESS) < 0;
    }

    @Override
    public boolean hasPrevious() {
        return this.compareTo(FIRST_IPV4_ADDRESS) > 0;
    }

    @Override
    public Ipv4Range asRange() {
        return new Ipv4Range(this, this);
    }

    @Override
    public int bitSize() {
        return 32;
    }

    @Override
    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public Ipv4 lowerBoundForPrefix(int prefixLength) {
        RangeUtils.checkRange(prefixLength, 0, 32);
        long mask = (1L << 32 - prefixLength) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        return new Ipv4(this.value & mask);
    }

    @Override
    public Ipv4 upperBoundForPrefix(int prefixLength) {
        RangeUtils.checkRange(prefixLength, 0, 32);
        long mask = (1L << 32 - prefixLength) - 1L;
        return new Ipv4(this.value | mask);
    }

    @Override
    public int getCommonPrefixLength(Ipv4 other) {
        long temp = this.value ^ other.value;
        return Integer.numberOfLeadingZeros((int)temp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ipv4 that = (Ipv4)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

