/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.commons.ip;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.ripe.commons.ip.AbstractIp;
import net.ripe.commons.ip.AbstractIpRange;
import net.ripe.commons.ip.Ipv6;
import net.ripe.commons.ip.Optional;
import net.ripe.commons.ip.RangeUtils;
import net.ripe.commons.ip.SizeComparator;
import net.ripe.commons.ip.Validate;

public final class PrefixUtils {
    private PrefixUtils() {
    }

    public static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> boolean isLegalPrefix(AbstractIpRange<C, R> range) {
        int prefixLength = ((AbstractIp)range.start()).getCommonPrefixLength((AbstractIp)range.end());
        Object lowerBoundForPrefix = ((AbstractIp)range.start()).lowerBoundForPrefix(prefixLength);
        Object upperBoundForPrefix = ((AbstractIp)range.end()).upperBoundForPrefix(prefixLength);
        return ((AbstractIp)range.start()).equals(lowerBoundForPrefix) && ((AbstractIp)range.end()).equals(upperBoundForPrefix);
    }

    public static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> int getPrefixLength(AbstractIpRange<C, R> range) {
        Validate.isTrue(PrefixUtils.isLegalPrefix(range), range.toStringInRangeNotation() + " is not a legal prefix, cannot get prefix length!");
        return ((AbstractIp)range.start()).getCommonPrefixLength((AbstractIp)range.end());
    }

    public static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> Optional<R> findMinimumPrefixForPrefixLength(R range, int prefixLength) {
        RangeUtils.checkRange(prefixLength, 0, ((AbstractIp)range.start()).bitSize());
        return PrefixUtils.findPrefixForPrefixLength(range, prefixLength, SizeComparator.get());
    }

    public static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> Optional<R> findMaximumPrefixForPrefixLength(R range, int prefixLength) {
        RangeUtils.checkRange(prefixLength, 0, ((AbstractIp)range.start()).bitSize());
        return PrefixUtils.findPrefixForPrefixLength(range, prefixLength, SizeComparator.reverse());
    }

    private static <C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>> Optional<R> findPrefixForPrefixLength(R range, int prefixLength, Comparator<? super R> comparator) {
        List<R> prefixes = range.splitToPrefixes();
        Collections.sort(prefixes, comparator);
        for (AbstractIpRange prefix : prefixes) {
            if (prefixLength < PrefixUtils.getPrefixLength(prefix)) continue;
            return Optional.of(prefix);
        }
        return Optional.absent();
    }

    public static int findMaxPrefixLengthForAddress(Ipv6 address) {
        return PrefixUtils.getMaxValidPrefix(address.value());
    }

    private static int getMaxValidPrefix(BigInteger number) {
        int powerOfTwo;
        int maxPowerOfTwo = powerOfTwo = 0;
        while (powerOfTwo <= 128 && number.divideAndRemainder(BigInteger.ONE.shiftLeft(powerOfTwo))[1].compareTo(BigInteger.ZERO) == 0) {
            maxPowerOfTwo = powerOfTwo++;
        }
        return 128 - maxPowerOfTwo;
    }
}

